/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.locking;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.dbms.locking.LockHolder;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.dbms.locking.WaitForGraph;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\u0016\u0010\u001e\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0012\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130!J\u0014\u0010\"\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013J\u0016\u0010#\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/dbms/locking/Lock;", "T", "", "waitForGraph", "Lorg/vitrivr/cottontail/dbms/locking/WaitForGraph;", "obj", "(Lorg/vitrivr/cottontail/dbms/locking/WaitForGraph;Ljava/lang/Object;)V", "isExclusivelyLocked", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isSharedLocked", "", "()Z", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getObj", "()Ljava/lang/Object;", "Ljava/lang/Object;", "owners", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "Lorg/vitrivr/cottontail/dbms/locking/LockHolder;", "sharedLockCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "waiters", "Ljava/util/concurrent/locks/Condition;", "acquire", "", "txn", "requestedLockMode", "Lorg/vitrivr/cottontail/dbms/locking/LockMode;", "acquireExclusiveLock", "acquireSharedLock", "getMode", "getOwners", "", "release", "upgradeSharedLock", "cottontaildb-dbms"})
public final class Lock<T> {
    @NotNull
    private final WaitForGraph waitForGraph;
    private final T obj;
    @NotNull
    private final ObjectOpenHashSet<LockHolder<T>> owners;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Condition waiters;
    @NotNull
    private final AtomicInteger sharedLockCount;
    @NotNull
    private final AtomicBoolean isExclusivelyLocked;

    public Lock(@NotNull WaitForGraph waitForGraph, T obj) {
        Intrinsics.checkNotNullParameter((Object)waitForGraph, (String)"waitForGraph");
        this.waitForGraph = waitForGraph;
        this.obj = obj;
        this.owners = new ObjectOpenHashSet();
        this.lock = new ReentrantReadWriteLock(true);
        Condition condition = this.lock.writeLock().newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"this.lock.writeLock().newCondition()");
        this.waiters = condition;
        this.sharedLockCount = new AtomicInteger(0);
        this.isExclusivelyLocked = new AtomicBoolean(false);
    }

    public final T getObj() {
        return this.obj;
    }

    private final boolean isSharedLocked() {
        return this.sharedLockCount.get() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void acquire(@NotNull LockHolder<T> txn, @NotNull LockMode requestedLockMode) {
        Intrinsics.checkNotNullParameter(txn, (String)"txn");
        Intrinsics.checkNotNullParameter((Object)((Object)requestedLockMode), (String)"requestedLockMode");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.owners.contains(txn)) {
                if (WhenMappings.$EnumSwitchMapping$0[requestedLockMode.ordinal()] == 1) {
                    this.upgradeSharedLock(txn);
                }
            } else {
                switch (WhenMappings.$EnumSwitchMapping$0[requestedLockMode.ordinal()]) {
                    case 2: {
                        this.acquireSharedLock(txn);
                        break;
                    }
                    case 1: {
                        this.acquireExclusiveLock(txn);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Lock mode of type " + (Object)((Object)requestedLockMode) + " cannot be explicitly acquired!");
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release(@NotNull LockHolder<T> txn) {
        Intrinsics.checkNotNullParameter(txn, (String)"txn");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2++;
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (this.owners.remove(txn)) {
                this.waitForGraph.remove(txn);
                this.sharedLockCount.decrementAndGet();
                this.isExclusivelyLocked.compareAndExchange(true, false);
                txn.removeLock$cottontaildb_dbms(this);
                this.waiters.signalAll();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @NotNull
    public final Set<LockHolder<T>> getOwners() {
        Set<LockHolder<T>> set = Collections.unmodifiableSet((Set)this.owners);
        Intrinsics.checkNotNullExpressionValue(set, (String)"unmodifiableSet(this.owners)");
        return set;
    }

    @NotNull
    public final LockMode getMode() {
        return this.isExclusivelyLocked.get() ? LockMode.EXCLUSIVE : (this.isSharedLocked() ? LockMode.SHARED : LockMode.NO_LOCK);
    }

    /*
     * WARNING - void declaration
     */
    private final void upgradeSharedLock(LockHolder<T> txn) {
        if (this.isExclusivelyLocked.get()) {
            return;
        }
        while (this.sharedLockCount.get() > 1) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)this.owners;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                LockHolder it = (LockHolder)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, txn))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection collection = (List)destination$iv$iv;
            Set ownersWithSelfRemoved = (Set)new ObjectOpenHashSet(collection);
            this.waitForGraph.add(txn, ownersWithSelfRemoved);
            this.waitForGraph.detectDeadlock(txn);
            this.waiters.await();
        }
        if (!this.sharedLockCount.compareAndSet(1, 0)) {
            boolean $i$a$-check-Lock$upgradeSharedLock$32 = false;
            String $i$a$-check-Lock$upgradeSharedLock$32 = "Transaction " + txn.getTxId() + " failed to upgrade lock " + this + ": expected one shared lock (own).";
            throw new IllegalStateException($i$a$-check-Lock$upgradeSharedLock$32.toString());
        }
        if (!this.isExclusivelyLocked.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Transaction " + txn.getTxId() + " failed to upgrade lock " + this + ": non-exclusive lock.";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void acquireSharedLock(LockHolder<T> txn) {
        while (this.isExclusivelyLocked.get() || this.lock.hasWaiters(this.waiters)) {
            this.waitForGraph.add(txn, (Set)this.owners);
            this.waitForGraph.detectDeadlock(txn);
            this.waiters.await();
        }
        this.sharedLockCount.incrementAndGet();
        this.owners.add(txn);
        txn.addLock$cottontaildb_dbms(this);
    }

    private final void acquireExclusiveLock(LockHolder<T> txn) {
        if (this.isExclusivelyLocked.get() || this.isSharedLocked()) {
            while (this.isExclusivelyLocked.get() || this.isSharedLocked()) {
                this.waitForGraph.add(txn, (Set)this.owners);
                this.waitForGraph.detectDeadlock(txn);
                this.waiters.await();
            }
        }
        if (!this.isExclusivelyLocked.compareAndSet(false, true)) {
            boolean bl = false;
            String string = "Transaction " + txn.getTxId() + " failed to acquire lock " + this + ": Lock is being held exclusively.";
            throw new IllegalStateException(string.toString());
        }
        this.owners.add(txn);
        txn.addLock$cottontaildb_dbms(this);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LockMode.values().length];
            nArray[LockMode.EXCLUSIVE.ordinal()] = 1;
            nArray[LockMode.SHARED.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

