/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.columns;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0000H\u0016J\u001f\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0011J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/BooleanVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "Lorg/vitrivr/cottontail/core/values/BooleanVectorValue;", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "(Lorg/vitrivr/cottontail/core/values/types/Types;)V", "numberOfFalseEntries", "", "getNumberOfFalseEntries", "()[J", "numberOfTrueEntries", "getNumberOfTrueEntries", "copy", "delete", "", "deleted", "delete-cmzpXVc", "([Z)V", "insert", "inserted", "insert-cmzpXVc", "reset", "Serializer", "cottontaildb-dbms"})
public final class BooleanVectorValueStatistics
extends ValueStatistics<BooleanVectorValue> {
    @NotNull
    private final long[] numberOfTrueEntries;

    public BooleanVectorValueStatistics(@NotNull Types<BooleanVectorValue> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        super(type);
        this.numberOfTrueEntries = new long[this.getType().getLogicalSize()];
    }

    @NotNull
    public final long[] getNumberOfTrueEntries() {
        return this.numberOfTrueEntries;
    }

    @NotNull
    public final long[] getNumberOfFalseEntries() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        long[] lArray = new long[n2];
        while (n < n2) {
            int n3 = n++;
            lArray[n3] = this.getNumberOfNonNullEntries() - this.numberOfTrueEntries[n3];
        }
        return lArray;
    }

    public void insert-cmzpXVc(@Nullable boolean[] inserted) {
        super.insert(inserted != null ? BooleanVectorValue.box-impl((boolean[])inserted) : null);
        if (inserted != null) {
            boolean[] blArray = inserted;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                boolean d = blArray[i];
                if (!d) continue;
                this.numberOfTrueEntries[i2] = this.numberOfTrueEntries[i2] + 1L;
            }
        }
    }

    public void delete-cmzpXVc(@Nullable boolean[] deleted) {
        super.delete(deleted != null ? BooleanVectorValue.box-impl((boolean[])deleted) : null);
        if (deleted != null) {
            boolean[] blArray = deleted;
            int n = blArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                boolean d = blArray[i];
                if (!d) continue;
                this.numberOfTrueEntries[i2] = this.numberOfTrueEntries[i2] - 1L;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        while (n < n2) {
            int i = n++;
            this.numberOfTrueEntries[i] = 0L;
        }
    }

    @NotNull
    public BooleanVectorValueStatistics copy() {
        BooleanVectorValueStatistics copy = new BooleanVectorValueStatistics((Types<BooleanVectorValue>)this.getType());
        copy.setFresh(this.getFresh());
        copy.setNumberOfNullEntries(this.getNumberOfNullEntries());
        copy.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries());
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        while (n < n2) {
            int i = n++;
            copy.numberOfTrueEntries[i] = this.numberOfTrueEntries[i];
        }
        return copy;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/BooleanVectorValueStatistics$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/BooleanVectorValueStatistics;", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "Lorg/vitrivr/cottontail/core/values/BooleanVectorValue;", "(Lorg/vitrivr/cottontail/core/values/types/Types;)V", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types;", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb-dbms"})
    public static final class Serializer
    implements org.mapdb.Serializer<BooleanVectorValueStatistics> {
        @NotNull
        private final Types<BooleanVectorValue> type;

        public Serializer(@NotNull Types<BooleanVectorValue> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = type;
        }

        @NotNull
        public final Types<BooleanVectorValue> getType() {
            return this.type;
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull BooleanVectorValueStatistics value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            long[] $this$forEach$iv = value.getNumberOfTrueEntries();
            boolean $i$f$forEach = false;
            for (long element$iv : $this$forEach$iv) {
                long it = element$iv;
                boolean bl = false;
                out.writeLong(it);
            }
        }

        @NotNull
        public BooleanVectorValueStatistics deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            BooleanVectorValueStatistics stat = new BooleanVectorValueStatistics(this.type);
            int n = this.type.getLogicalSize();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int it = n3 = n2++;
                boolean bl = false;
                stat.getNumberOfTrueEntries()[it] = input.readLong();
            }
            return stat;
        }
    }
}

