/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.columns;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\u001f\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0015J\b\u0010\u0019\u001a\u00020\u0012H\u0016R\u001a\u0010\u0006\u001a\u00020\u00028F\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\n\u0010\bR\u001c\u0010\f\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\bR\u001c\u0010\u000e\u001a\u00020\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\u000f\u0010\b\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/FloatVectorValueStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "Lorg/vitrivr/cottontail/core/values/FloatVectorValue;", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "(Lorg/vitrivr/cottontail/core/values/types/Types;)V", "avg", "getAvg-JdBqzJc", "()[F", "max", "getMax-JdBqzJc", "[F", "min", "getMin-JdBqzJc", "sum", "getSum-JdBqzJc", "copy", "delete", "", "deleted", "delete-qTmBfow", "([F)V", "insert", "inserted", "insert-qTmBfow", "reset", "Serializer", "cottontaildb-dbms"})
public final class FloatVectorValueStatistics
extends ValueStatistics<FloatVectorValue> {
    @NotNull
    private final float[] min;
    @NotNull
    private final float[] max;
    @NotNull
    private final float[] sum;

    public FloatVectorValueStatistics(@NotNull Types<FloatVectorValue> type) {
        int n;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        super(type);
        int n2 = 0;
        int n3 = this.getType().getLogicalSize();
        float[] fArray = new float[n3];
        FloatVectorValueStatistics floatVectorValueStatistics = this;
        while (n2 < n3) {
            n = n2++;
            fArray[n] = Float.MAX_VALUE;
        }
        floatVectorValueStatistics.min = FloatVectorValue.constructor-impl((float[])fArray);
        n2 = 0;
        n3 = this.getType().getLogicalSize();
        fArray = new float[n3];
        floatVectorValueStatistics = this;
        while (n2 < n3) {
            n = n2++;
            fArray[n] = Float.MIN_VALUE;
        }
        floatVectorValueStatistics.max = FloatVectorValue.constructor-impl((float[])fArray);
        this.sum = FloatVectorValue.constructor-impl((float[])new float[this.getType().getLogicalSize()]);
    }

    @NotNull
    public final float[] getMin-JdBqzJc() {
        return this.min;
    }

    @NotNull
    public final float[] getMax-JdBqzJc() {
        return this.max;
    }

    @NotNull
    public final float[] getSum-JdBqzJc() {
        return this.sum;
    }

    @NotNull
    public final float[] getAvg-JdBqzJc() {
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        float[] fArray = new float[n2];
        while (n < n2) {
            int n3 = n++;
            fArray[n3] = FloatVectorValue.get-PgYoAEc((float[])this.getSum-JdBqzJc(), (int)n3) / (float)this.getNumberOfNonNullEntries();
        }
        return FloatVectorValue.constructor-impl((float[])fArray);
    }

    public void insert-qTmBfow(@Nullable float[] inserted) {
        super.insert(inserted != null ? FloatVectorValue.box-impl((float[])inserted) : null);
        if (inserted != null) {
            float[] fArray = inserted;
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                float d = fArray[i];
                this.getMin-JdBqzJc()[i2] = Float.min(d, this.getMin-JdBqzJc()[i2]);
                this.getMax-JdBqzJc()[i2] = Float.max(d, this.getMax-JdBqzJc()[i2]);
                float[] fArray2 = this.getSum-JdBqzJc();
                fArray2[i2] = fArray2[i2] + d;
            }
        }
    }

    public void delete-qTmBfow(@Nullable float[] deleted) {
        super.delete(deleted != null ? FloatVectorValue.box-impl((float[])deleted) : null);
        if (deleted != null) {
            float[] fArray = deleted;
            int n = 0;
            int n2 = fArray.length;
            while (n < n2) {
                int i = n;
                float d = fArray[n];
                ++n;
                if (this.getMin-JdBqzJc()[i] == d || this.getMax-JdBqzJc()[i] == d) {
                    this.setFresh(false);
                }
                float[] fArray2 = this.getSum-JdBqzJc();
                fArray2[i] = fArray2[i] - d;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        while (n < n2) {
            int i = n++;
            this.getMin-JdBqzJc()[i] = Float.MAX_VALUE;
            this.getMax-JdBqzJc()[i] = Float.MIN_VALUE;
            this.getSum-JdBqzJc()[i] = 0.0f;
        }
    }

    @NotNull
    public FloatVectorValueStatistics copy() {
        FloatVectorValueStatistics copy = new FloatVectorValueStatistics((Types<FloatVectorValue>)this.getType());
        copy.setFresh(this.getFresh());
        copy.setNumberOfNullEntries(this.getNumberOfNullEntries());
        copy.setNumberOfNonNullEntries(this.getNumberOfNonNullEntries());
        int n = 0;
        int n2 = this.getType().getLogicalSize();
        while (n < n2) {
            int i = n++;
            copy.getMin-JdBqzJc()[i] = this.getMin-JdBqzJc()[i];
            copy.getMax-JdBqzJc()[i] = this.getMax-JdBqzJc()[i];
            copy.getSum-JdBqzJc()[i] = this.getSum-JdBqzJc()[i];
        }
        return copy;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/columns/FloatVectorValueStatistics$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/dbms/statistics/columns/FloatVectorValueStatistics;", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "Lorg/vitrivr/cottontail/core/values/FloatVectorValue;", "(Lorg/vitrivr/cottontail/core/values/types/Types;)V", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types;", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb-dbms"})
    public static final class Serializer
    implements org.mapdb.Serializer<FloatVectorValueStatistics> {
        @NotNull
        private final Types<FloatVectorValue> type;

        public Serializer(@NotNull Types<FloatVectorValue> type) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            this.type = type;
        }

        @NotNull
        public final Types<FloatVectorValue> getType() {
            return this.type;
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull FloatVectorValueStatistics value) {
            float it;
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            float[] $this$forEach$iv = value.getMin-JdBqzJc();
            boolean $i$f$forEach = false;
            for (float element$iv : $this$forEach$iv) {
                it = element$iv;
                boolean bl = false;
                out.writeFloat(it);
            }
            $this$forEach$iv = value.getMax-JdBqzJc();
            $i$f$forEach = false;
            for (float element$iv : $this$forEach$iv) {
                it = element$iv;
                boolean bl = false;
                out.writeFloat(it);
            }
            $this$forEach$iv = value.getSum-JdBqzJc();
            $i$f$forEach = false;
            for (float element$iv : $this$forEach$iv) {
                it = element$iv;
                boolean bl = false;
                out.writeFloat(it);
            }
        }

        @NotNull
        public FloatVectorValueStatistics deserialize(@NotNull DataInput2 input, int available) {
            int it;
            int n;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            FloatVectorValueStatistics stat = new FloatVectorValueStatistics(this.type);
            int n2 = this.type.getLogicalSize();
            int n3 = 0;
            while (n3 < n2) {
                it = n = n3++;
                boolean bl = false;
                stat.getMin-JdBqzJc()[it] = input.readFloat();
            }
            n2 = this.type.getLogicalSize();
            n3 = 0;
            while (n3 < n2) {
                it = n = n3++;
                boolean bl = false;
                stat.getMax-JdBqzJc()[it] = input.readFloat();
            }
            n2 = this.type.getLogicalSize();
            n3 = 0;
            while (n3 < n2) {
                it = n = n3++;
                boolean bl = false;
                stat.getSum-JdBqzJc()[it] = input.readFloat();
            }
            return stat;
        }
    }
}

