/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.Atomic;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DB;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueHeader;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1Header;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/legacy/VersionProber;", "", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "isV1", "", "path", "Ljava/nio/file/Path;", "isV2", "probe", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "Companion", "cottontaildb-dbms"})
public final class VersionProber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private static final DBOVersion EXPECTED = DBOVersion.V2_0;

    public VersionProber(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @NotNull
    public final DBOVersion probe(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.isV2(path) ? DBOVersion.V2_0 : (this.isV1(path) ? DBOVersion.V1_0 : DBOVersion.UNDEFINED);
    }

    private final boolean isV1(Path path) {
        CatalogueV1Header catalogueV1Header;
        Object object;
        System.gc();
        try {
            MapDBConfig mapDBConfig = this.config.getMapdb();
            object = path.resolve("catalogue.db");
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"path.resolve(CatalogueV1.FILE_CATALOGUE)");
            object = mapDBConfig.store((Path)object);
        }
        catch (Throwable e) {
            return false;
        }
        Object store = object;
        try {
            Object object2 = store;
            catalogueV1Header = object2 == null ? null : (CatalogueV1Header)((CottontailStoreWAL)object2).get(1L, CatalogueV1Header.Serializer);
        }
        catch (Throwable e) {
            Object object3 = store;
            if (object3 != null) {
                ((CottontailStoreWAL)object3).close();
            }
            return false;
        }
        CatalogueV1Header header = catalogueV1Header;
        Object object4 = store;
        if (object4 != null) {
            ((CottontailStoreWAL)object4).close();
        }
        return header != null;
    }

    private final boolean isV2(Path path) {
        CatalogueHeader catalogueHeader;
        Path path2;
        System.gc();
        try {
            MapDBConfig mapDBConfig = this.config.getMapdb();
            path2 = path.resolve("catalogue.db");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(DefaultCatalogue.FILE_CATALOGUE)");
            path2 = mapDBConfig.db(path2);
        }
        catch (Throwable e) {
            return false;
        }
        Path store = path2;
        try {
            CatalogueHeader catalogueHeader2;
            Path path3 = store;
            if (path3 == null) {
                catalogueHeader2 = null;
            } else {
                DB.AtomicVarMaker atomicVarMaker = path3.atomicVar("cdb_catalogue_header", CatalogueHeader.Serializer);
                if (atomicVarMaker == null) {
                    catalogueHeader2 = null;
                } else {
                    Atomic.Var var = (Atomic.Var)atomicVarMaker.open();
                    catalogueHeader2 = var == null ? null : (CatalogueHeader)var.get();
                }
            }
            catalogueHeader = catalogueHeader2;
        }
        catch (Throwable e) {
            Path path4 = store;
            if (path4 != null) {
                path4.close();
            }
            return false;
        }
        CatalogueHeader header = catalogueHeader;
        Path path5 = store;
        if (path5 != null) {
            path5.close();
        }
        return header != null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/VersionProber$Companion;", "", "()V", "EXPECTED", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getEXPECTED", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DBOVersion getEXPECTED() {
            return EXPECTED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

