/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.catalogue;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.FunctionRegistry;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TxException;
import org.vitrivr.cottontail.dbms.execution.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.general.TxAction;
import org.vitrivr.cottontail.dbms.general.TxSnapshot;
import org.vitrivr.cottontail.dbms.general.TxStatus;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1Header;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u000267B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "functions", "Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "getFunctions", "()Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "header", "Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1Header;", "name", "Lorg/vitrivr/cottontail/core/database/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$RootName;", "parent", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getParent", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "size", "", "getSize", "()I", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class CatalogueV1
implements Catalogue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final Path path;
    @NotNull
    private final Name.RootName name;
    @Nullable
    private final DBO parent;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final CottontailStoreWAL store;
    @NotNull
    private final Map<Name.SchemaName, SchemaV1> registry;
    private volatile boolean closed;
    public static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final String FILE_CATALOGUE = "catalogue.db";

    public CatalogueV1(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.path = this.getConfig().getRoot();
        this.name = Name.RootName.INSTANCE;
        this.closeLock = new StampedLock();
        MapDBConfig mapDBConfig = this.getConfig().getMapdb();
        Object object = this.getPath().resolve(FILE_CATALOGUE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.path.resolve(FILE_CATALOGUE)");
        this.store = mapDBConfig.store((Path)object);
        object = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"synchronizedMap(Object2ObjectOpenHashMap())");
        this.registry = object;
        CatalogueV1Header header = this.getHeader();
        for (long sid : header.getSchemas()) {
            CatalogueV1Header.CatalogueEntry catalogueEntry = (CatalogueV1Header.CatalogueEntry)this.store.get(sid, CatalogueV1Header.CatalogueEntry.Serializer);
            if (catalogueEntry == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open Cottontail DB catalogue entry!");
            }
            CatalogueV1Header.CatalogueEntry schema = catalogueEntry;
            Path path = this.getPath().resolve(Intrinsics.stringPlus((String)"schema_", (Object)schema.getName()));
            if (!Files.exists(path, new LinkOption[0])) {
                throw new DatabaseException.DataCorruptionException("Broken catalogue entry for schema '" + schema.getName() + "'. Path " + path + " does not exist!");
            }
            SchemaV1 s = new SchemaV1(new Name.SchemaName(schema.getName()), this);
            Map<Name.SchemaName, SchemaV1> map2 = this.registry;
            Name.SchemaName schemaName = s.getName();
            map2.put(schemaName, s);
        }
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public FunctionRegistry getFunctions() {
        throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return this.name;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    private final CatalogueV1Header getHeader() {
        CatalogueV1Header catalogueV1Header = (CatalogueV1Header)this.store.get(1L, CatalogueV1Header.Serializer);
        if (catalogueV1Header == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open Cottontail DB catalogue header!");
        }
        return catalogueV1Header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        int n;
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            n = 0;
            n = this.getHeader().getSchemas().length;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return n;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public CatalogueTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-CatalogueV1$close$22 = false;
            Map<Name.SchemaName, SchemaV1> $this$forEach$iv = this.registry;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Name.SchemaName, SchemaV1>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Name.SchemaName, SchemaV1> element$iv;
                Map.Entry<Name.SchemaName, SchemaV1> $dstr$_u24__u24$v = element$iv = iterator.next();
                boolean bl = false;
                SchemaV1 v = $dstr$_u24__u24$v.getValue();
                v.close();
            }
            this.store.close();
            this.closed = true;
            Unit $i$a$-write-CatalogueV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "snapshot", "Lorg/vitrivr/cottontail/dbms/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/dbms/general/TxSnapshot;", "cleanup", "", "createSchema", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "dropSchema", "listSchemas", "", "schemaForName", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements CatalogueTx {
        @NotNull
        private final TxSnapshot snapshot;
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)CatalogueV1.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.snapshot = new TxSnapshot(){
                @NotNull
                private final List<TxAction> actions;
                {
                    this.actions = CollectionsKt.emptyList();
                }

                @NotNull
                public List<TxAction> getActions() {
                    return this.actions;
                }

                @NotNull
                public Void commit() {
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                @NotNull
                public Void rollback() {
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                public boolean record(@NotNull TxAction action) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }
            };
            this.closeStamp = CatalogueV1.this.closeLock.readLock();
        }

        @Override
        @NotNull
        public Catalogue getDbo() {
            return CatalogueV1.this;
        }

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            return this.snapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Schema> listSchemas() {
            void this_$iv;
            AbstractTx abstractTx = this;
            CatalogueV1 catalogueV1 = CatalogueV1.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                List list = CollectionsKt.toList((Iterable)catalogueV1.registry.values());
                return list;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public SchemaV1 schemaForName(@NotNull Name.SchemaName name) {
            SchemaV1 schemaV1;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx abstractTx = this;
            CatalogueV1 catalogueV1 = CatalogueV1.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                SchemaV1 schemaV12 = (SchemaV1)catalogueV1.registry.get(name);
                if (schemaV12 == null) {
                    throw new DatabaseException.SchemaDoesNotExistException(name);
                }
                schemaV1 = schemaV12;
            }
            finally {
                readLock.unlock();
            }
            return schemaV1;
        }

        @Override
        @NotNull
        public Schema createSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        protected void cleanup() {
            CatalogueV1.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

