/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.column;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnEngine;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TxException;
import org.vitrivr.cottontail.dbms.execution.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.general.TxAction;
import org.vitrivr.cottontail.dbms.general.TxSnapshot;
import org.vitrivr.cottontail.dbms.general.TxStatus;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.legacy.v1.column.ColumnV1Header;
import org.vitrivr.cottontail.storage.serializers.ValueSerializerFactory;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u000267B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00028\u0000032\u0006\u00104\u001a\u000205H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020+X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\u00020-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1;", "T", "Lorg/vitrivr/cottontail/core/values/types/Value;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "(Lorg/vitrivr/cottontail/core/database/Name$ColumnName;Lorg/vitrivr/cottontail/dbms/entity/Entity;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "columnDef", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumnDef$annotations", "()V", "getColumnDef", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "engine", "Lorg/vitrivr/cottontail/dbms/column/ColumnEngine;", "getEngine", "()Lorg/vitrivr/cottontail/dbms/column/ColumnEngine;", "header", "Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1Header;", "maxTupleId", "", "getMaxTupleId", "()J", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/entity/Entity;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class ColumnV1<T extends Value>
implements Column<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.ColumnName name;
    @NotNull
    private final Entity parent;
    @NotNull
    private final Path path;
    @NotNull
    private CottontailStoreWAL store;
    @NotNull
    private final ColumnDef<T> columnDef;
    private volatile boolean closed;
    @NotNull
    private final StampedLock closeLock;
    private static final long HEADER_RECORD_ID = 1L;

    /*
     * WARNING - void declaration
     */
    public ColumnV1(@NotNull Name.ColumnName name, @NotNull Entity parent) {
        void it;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        Object object = this.getParent().getPath().resolve("col_" + this.getName().getSimple() + ".db");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parent.path.resolve(\"col_${name.simple}.db\")");
        this.path = object;
        ColumnV1 columnV1 = this;
        try {
            ColumnV1 columnV12 = columnV1;
            object = this.getParent().getParent().getParent().getConfig().getMapdb().store(this.getPath());
        }
        catch (DBException dBException) {
            void e;
            ColumnV1 columnV13 = columnV1;
            throw new DatabaseException("Failed to open column at '" + this.getPath() + "': " + e.getMessage() + '\'', null, 2, null);
        }
        columnV12.store = object;
        ColumnV1Header e = this.getHeader();
        columnV1 = this;
        boolean bl = false;
        columnV1.columnDef = new ColumnDef(this.getName(), it.getType(), it.getNullable(), false, 8, null);
        this.closeLock = new StampedLock();
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Entity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Path getPath() {
        return this.path;
    }

    private final ColumnV1Header getHeader() {
        ColumnV1Header columnV1Header = (ColumnV1Header)this.store.get(1L, ColumnV1Header.Serializer);
        if (columnV1Header == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open header of column '" + this.getName() + "'!'");
        }
        return columnV1Header;
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    public static /* synthetic */ void getColumnDef$annotations() {
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    @NotNull
    public ColumnEngine getEngine() {
        return ColumnEngine.MAPDB;
    }

    @Override
    public long getMaxTupleId() {
        return this.store.getMaxRecid();
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-ColumnV1$close$22 = false;
            this.store.close();
            this.closed = true;
            Unit $i$a$-write-ColumnV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Override
    @NotNull
    public ColumnTx<T> newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1$Companion;", "", "()V", "HEADER_RECORD_ID", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0014J)\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00018\u00002\b\u0010\u001e\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010 \u001a\u00020\u0007H\u0016J\u0017\u0010!\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\"J\u001b\u0010#\u001a\u00060\u0007j\u0002`$2\b\u0010%\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u0017\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\"J\u0012\u0010(\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`$0)H\u0016J\u001a\u0010(\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`$0)2\u0006\u0010*\u001a\u00020+H\u0016J!\u0010,\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010-R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/column/ColumnV1;Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;)V", "closeStamp", "", "columnDef", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumnDef", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getContext", "()Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "dbo", "Lorg/vitrivr/cottontail/dbms/column/Column;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/column/Column;", "serializer", "Lorg/vitrivr/cottontail/storage/serializers/mapdb/MapDBSerializer;", "snapshot", "Lorg/vitrivr/cottontail/dbms/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/dbms/general/TxSnapshot;", "cleanup", "", "compareAndUpdate", "", "tupleId", "value", "expected", "(JLorg/vitrivr/cottontail/core/values/types/Value;Lorg/vitrivr/cottontail/core/values/types/Value;)Z", "count", "delete", "(J)Lorg/vitrivr/cottontail/core/values/types/Value;", "insert", "Lorg/vitrivr/cottontail/core/database/TupleId;", "record", "(Lorg/vitrivr/cottontail/core/values/types/Value;)J", "read", "scan", "", "range", "Lkotlin/ranges/LongRange;", "update", "(JLorg/vitrivr/cottontail/core/values/types/Value;)Lorg/vitrivr/cottontail/core/values/types/Value;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T> {
        @NotNull
        private final TransactionContext context;
        @NotNull
        private final MapDBSerializer<T> serializer;
        private final long closeStamp;
        @NotNull
        private final TxSnapshot snapshot;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)ColumnV1.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.context = context2;
            this.serializer = ValueSerializerFactory.INSTANCE.mapdb(ColumnV1.this.getType());
            this.closeStamp = ColumnV1.this.closeLock.readLock();
            if (ColumnV1.this.getClosed()) {
                ColumnV1.this.closeLock.unlockRead(this.closeStamp);
                throw new TxException.TxDBOClosedException(this.getContext().getTxId(), ColumnV1.this);
            }
            this.snapshot = new TxSnapshot(){
                @NotNull
                private final List<TxAction> actions;
                {
                    this.actions = CollectionsKt.emptyList();
                }

                @NotNull
                public List<TxAction> getActions() {
                    return this.actions;
                }

                @NotNull
                public Void commit() {
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                @NotNull
                public Void rollback() {
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                public boolean record(@NotNull TxAction action) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }
            };
        }

        @Override
        @NotNull
        public TransactionContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnV1.this.getColumnDef();
        }

        @Override
        @NotNull
        public Column<T> getDbo() {
            return ColumnV1.this;
        }

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            return this.snapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public T read(long tupleId) {
            Value value;
            void this_$iv;
            AbstractTx abstractTx = this;
            ColumnV1 columnV1 = ColumnV1.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                value = (Value)columnV1.store.get(tupleId, this.serializer);
            }
            finally {
                readLock.unlock();
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public long count() {
            long l;
            void this_$iv;
            AbstractTx abstractTx = this;
            ColumnV1 columnV1 = ColumnV1.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                l = columnV1.getHeader().getCount();
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        @Override
        @NotNull
        public Iterator<Long> scan() {
            return this.scan(new LongRange(1L, ColumnV1.this.getMaxTupleId()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Iterator<Long> scan(@NotNull LongRange range) {
            Iterator<Long> iterator;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            AbstractTx abstractTx = this;
            ColumnV1 columnV1 = ColumnV1.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                iterator = new Iterator<Long>(columnV1, range){
                    @NotNull
                    private final CottontailStoreWAL.RecordIdIterator wrapped;
                    final /* synthetic */ ColumnV1<T> this$0;
                    final /* synthetic */ LongRange $range;
                    {
                        this.this$0 = $receiver;
                        this.$range = $range;
                        this.wrapped = ColumnV1.access$getStore$p(this.this$0).new CottontailStoreWAL.RecordIdIterator(this.$range);
                    }

                    @NotNull
                    public Long next() {
                        return this.wrapped.next();
                    }

                    public boolean hasNext() {
                        return this.wrapped.hasNext();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                readLock.unlock();
            }
            return iterator;
        }

        @Override
        public long insert(@Nullable T record) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @Nullable
        public T update(long tupleId, @Nullable T value) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public boolean compareAndUpdate(long tupleId, @Nullable T value, @Nullable T expected) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        @Nullable
        public T delete(long tupleId) {
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        protected void cleanup() {
            ColumnV1.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

