/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.legacy.v1.schema;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.CottontailStoreWAL;
import org.mapdb.DBException;
import org.mapdb.Serializer;
import org.vitrivr.cottontail.config.MapDBConfig;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.column.ColumnEngine;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TxException;
import org.vitrivr.cottontail.dbms.execution.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.general.TxAction;
import org.vitrivr.cottontail.dbms.general.TxSnapshot;
import org.vitrivr.cottontail.dbms.general.TxStatus;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;
import org.vitrivr.cottontail.legacy.v1.catalogue.CatalogueV1;
import org.vitrivr.cottontail.legacy.v1.entity.EntityV1;
import org.vitrivr.cottontail.legacy.v1.schema.SchemaV1Header;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006-"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "parent", "Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "(Lorg/vitrivr/cottontail/core/database/Name$SchemaName;Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;)V", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "<set-?>", "", "closed", "getClosed", "()Z", "header", "Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1Header;", "getHeader", "()Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1Header;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "getParent", "()Lorg/vitrivr/cottontail/legacy/v1/catalogue/CatalogueV1;", "path", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getPath", "()Ljava/nio/file/Path;", "registry", "", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "store", "Lorg/mapdb/CottontailStoreWAL;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class SchemaV1
implements Schema {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private final CatalogueV1 parent;
    private final Path path;
    @NotNull
    private final CottontailStoreWAL store;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final Map<Name.EntityName, EntityV1> registry;
    private volatile boolean closed;
    public static final long HEADER_RECORD_ID = 1L;
    @NotNull
    public static final String FILE_CATALOGUE = "index.db";

    /*
     * WARNING - void declaration
     */
    public SchemaV1(@NotNull Name.SchemaName name, @NotNull CatalogueV1 parent) {
        void $this$mapTo$iv$iv;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        this.path = this.getParent().getPath().resolve(Intrinsics.stringPlus((String)"schema_", (Object)this.getName().getSimple()));
        Object object = this;
        try {
            SchemaV1 schemaV1 = object;
            MapDBConfig mapDBConfig = this.getParent().getConfig().getMapdb();
            map2 = this.getPath().resolve(FILE_CATALOGUE);
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"this.path.resolve(FILE_CATALOGUE)");
            map2 = mapDBConfig.store((Path)((Object)map2));
        }
        catch (DBException dBException) {
            void e;
            SchemaV1 schemaV1 = object;
            throw new DatabaseException("Failed to open schema " + this.getName() + " at '" + this.getPath() + "': " + e.getMessage() + '\'', null, 2, null);
        }
        schemaV1.store = map2;
        this.closeLock = new StampedLock();
        map2 = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"synchronizedMap(Object2ObjectOpenHashMap())");
        this.registry = map2;
        long[] $this$map$iv = this.getHeader().getEntities();
        boolean $i$f$map = false;
        long[] lArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var13_14 = item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Name.SchemaName schemaName = this.getName();
            Object object2 = Serializer.STRING;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"STRING");
            Object object3 = (String)this.store.get((long)it, (Serializer)object2);
            if (object3 == null) {
                throw new DatabaseException.DataCorruptionException("Failed to read schema " + this.getName() + " (" + this.getPath() + "): Could not find entity name of ID " + (long)it + '.');
            }
            Name.EntityName name2 = schemaName.entity((String)object3);
            object3 = this.registry;
            object2 = new EntityV1(name2, this);
            object3.put(name2, object2);
            object.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public Name.SchemaName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public CatalogueV1 getParent() {
        return this.parent;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    private final SchemaV1Header getHeader() {
        SchemaV1Header schemaV1Header = (SchemaV1Header)this.store.get(1L, SchemaV1Header.Serializer);
        if (schemaV1Header == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open header of schema " + this.getName() + '!');
        }
        return schemaV1Header;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V1_0;
    }

    @Override
    public boolean getClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public SchemaTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$read$iv = this.closeLock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean $i$a$-read-SchemaV1$close$22 = false;
            if (!this.getClosed()) {
                this.registry.entrySet().removeIf(SchemaV1::close$lambda-2$lambda-1);
                this.store.close();
                this.closed = true;
            }
            Unit $i$a$-read-SchemaV1$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    private static final boolean close$lambda-2$lambda-1(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((EntityV1)it.getValue()).close();
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1$Companion;", "", "()V", "FILE_CATALOGUE", "", "HEADER_RECORD_ID", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0014JI\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001522\u0010\u0016\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001a0\u00180\u0017\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u001a0\u0018H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/schema/SchemaTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/legacy/v1/schema/SchemaV1;Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "snapshot", "Lorg/vitrivr/cottontail/dbms/general/TxSnapshot;", "getSnapshot", "()Lorg/vitrivr/cottontail/dbms/general/TxSnapshot;", "cleanup", "", "createEntity", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "columns", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "Lorg/vitrivr/cottontail/dbms/column/ColumnEngine;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;[Lkotlin/Pair;)Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "dropEntity", "entityForName", "Lorg/vitrivr/cottontail/legacy/v1/entity/EntityV1;", "listEntities", "", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements SchemaTx {
        private final long closeStamp;
        @NotNull
        private final TxSnapshot snapshot;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)SchemaV1.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.closeStamp = SchemaV1.this.closeLock.readLock();
            this.snapshot = new TxSnapshot(){
                @NotNull
                private final List<TxAction> actions;
                {
                    this.actions = CollectionsKt.emptyList();
                }

                @NotNull
                public List<TxAction> getActions() {
                    return this.actions;
                }

                @NotNull
                public Void commit() {
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                @NotNull
                public Void rollback() {
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }

                public boolean record(@NotNull TxAction action) {
                    Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                    throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
                }
            };
        }

        @Override
        @NotNull
        public TxSnapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        @NotNull
        public DBO getDbo() {
            return SchemaV1.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<Entity> listEntities() {
            void this_$iv;
            AbstractTx abstractTx = this;
            SchemaV1 schemaV1 = SchemaV1.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                List list = CollectionsKt.toList((Iterable)schemaV1.registry.values());
                return list;
            }
            finally {
                readLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public EntityV1 entityForName(@NotNull Name.EntityName name) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            AbstractTx abstractTx = this;
            SchemaV1 schemaV1 = SchemaV1.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                EntityV1 entityV1 = (EntityV1)schemaV1.registry.get(name);
                if (entityV1 == null) {
                    throw new DatabaseException.EntityDoesNotExistException(name);
                }
                EntityV1 entityV12 = entityV1;
                return entityV12;
            }
            finally {
                readLock.unlock();
            }
        }

        @Override
        @NotNull
        public DefaultEntity createEntity(@NotNull Name.EntityName name, Pair<? extends ColumnDef<?>, ? extends ColumnEngine> ... columns) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        public void dropEntity(@NotNull Name.EntityName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            throw new UnsupportedOperationException("Operation not supported on legacy DBO.");
        }

        @Override
        protected void cleanup() {
            SchemaV1.this.closeLock.unlockRead(this.closeStamp);
        }
    }
}

