/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc.services;

import com.google.protobuf.Empty;
import io.grpc.StatusException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.execution.TransactionManager;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.operators.system.ExplainQueryOperator;
import org.vitrivr.cottontail.dbms.queries.QueryContext;
import org.vitrivr.cottontail.dbms.queries.binding.GrpcQueryBinder;
import org.vitrivr.cottontail.dbms.queries.operators.OperatorNode;
import org.vitrivr.cottontail.dbms.queries.planning.CottontailQueryPlanner;
import org.vitrivr.cottontail.dbms.queries.planning.rules.RewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.logical.DeferFetchOnFetchRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.logical.DeferFetchOnScanRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.logical.LeftConjunctionOnSubselectRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.logical.LeftConjunctionRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.logical.RightConjunctionOnSubselectRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.logical.RightConjunctionRewriteRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.index.BooleanIndexScanRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.index.FulltextIndexRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.index.NNSIndexScanRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.merge.LimitingSortMergeRule;
import org.vitrivr.cottontail.dbms.queries.planning.rules.physical.pushdown.CountPushdownRule;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.grpc.DQLGrpcKt;
import org.vitrivr.cottontail.server.grpc.services.TransactionalGrpcService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0019\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/server/grpc/services/DQLService;", "Lorg/vitrivr/cottontail/grpc/DQLGrpcKt$DQLCoroutineImplBase;", "Lorg/vitrivr/cottontail/server/grpc/services/TransactionalGrpcService;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "manager", "Lorg/vitrivr/cottontail/dbms/execution/TransactionManager;", "(Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;Lorg/vitrivr/cottontail/dbms/execution/TransactionManager;)V", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "getManager", "()Lorg/vitrivr/cottontail/dbms/execution/TransactionManager;", "planner", "Lorg/vitrivr/cottontail/dbms/queries/planning/CottontailQueryPlanner;", "explain", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryResponseMessage;", "request", "Lorg/vitrivr/cottontail/grpc/CottontailGrpc$QueryMessage;", "ping", "Lcom/google/protobuf/Empty;", "(Lcom/google/protobuf/Empty;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "query", "cottontaildb-dbms"})
@ExperimentalTime
public final class DQLService
extends DQLGrpcKt.DQLCoroutineImplBase
implements TransactionalGrpcService {
    @NotNull
    private final Catalogue catalogue;
    @NotNull
    private final TransactionManager manager;
    @NotNull
    private final CottontailQueryPlanner planner;

    public DQLService(@NotNull Catalogue catalogue, @NotNull TransactionManager manager) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        super(null, 1, null);
        this.catalogue = catalogue;
        this.manager = manager;
        Object[] objectArray = new RewriteRule[]{LeftConjunctionRewriteRule.INSTANCE, RightConjunctionRewriteRule.INSTANCE, LeftConjunctionOnSubselectRewriteRule.INSTANCE, RightConjunctionOnSubselectRewriteRule.INSTANCE, DeferFetchOnScanRewriteRule.INSTANCE, DeferFetchOnFetchRewriteRule.INSTANCE};
        Collection collection = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new RewriteRule[]{BooleanIndexScanRule.INSTANCE, NNSIndexScanRule.INSTANCE, FulltextIndexRule.INSTANCE, CountPushdownRule.INSTANCE, LimitingSortMergeRule.INSTANCE};
        this.planner = new CottontailQueryPlanner(collection, CollectionsKt.listOf((Object[])objectArray), this.getCatalogue().getConfig().getCache().getPlanCacheSize());
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public TransactionManager getManager() {
        return this.manager;
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> query(@NotNull CottontailGrpc.QueryMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.QueryMessage $request;
            final /* synthetic */ DQLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.Query query2 = this.$request.getQuery();
                Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"request.query");
                GrpcQueryBinder.INSTANCE.bind(query2, ctx);
                CottontailQueryPlanner.planAndSelect$default(DQLService.access$getPlanner$p(this.this$0), ctx, false, false, 6, null);
                return ctx.toOperatorTree();
            }
        }));
    }

    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> explain(@NotNull CottontailGrpc.QueryMessage request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CottontailGrpc.Metadata metadata = request.getMetadata();
        Intrinsics.checkNotNullExpressionValue((Object)metadata, (String)"request.metadata");
        return this.prepareAndExecute(metadata, (Function1<? super QueryContext, ? extends Operator>)((Function1)new Function1<QueryContext, Operator>(request, this){
            final /* synthetic */ CottontailGrpc.QueryMessage $request;
            final /* synthetic */ DQLService this$0;
            {
                this.$request = $request;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Operator invoke(@NotNull QueryContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                CottontailGrpc.Query query2 = this.$request.getQuery();
                Intrinsics.checkNotNullExpressionValue((Object)query2, (String)"request.query");
                GrpcQueryBinder.INSTANCE.bind(query2, ctx);
                Collection<OperatorNode.Physical> candidates = DQLService.access$getPlanner$p(this.this$0).plan(ctx);
                return new ExplainQueryOperator(candidates);
            }
        }));
    }

    @Nullable
    public Object ping(@NotNull Empty request, @NotNull Continuation<? super Empty> $completion) {
        Empty empty = Empty.getDefaultInstance();
        Intrinsics.checkNotNullExpressionValue((Object)empty, (String)"getDefaultInstance()");
        return empty;
    }

    @Override
    @Nullable
    public QueryContext queryContextFromMetadata(@NotNull CottontailGrpc.Metadata metadata) {
        return TransactionalGrpcService.DefaultImpls.queryContextFromMetadata(this, metadata);
    }

    @Override
    @NotNull
    public Flow<CottontailGrpc.QueryResponseMessage> prepareAndExecute(@NotNull CottontailGrpc.Metadata metadata, @NotNull Function1<? super QueryContext, ? extends Operator> prepare) {
        return TransactionalGrpcService.DefaultImpls.prepareAndExecute(this, metadata, prepare);
    }

    @Override
    @NotNull
    public StatusException toStatusException(@NotNull QueryContext $this$toStatusException, @NotNull Throwable e, boolean execution) {
        return TransactionalGrpcService.DefaultImpls.toStatusException(this, $this$toStatusException, e, execution);
    }

    public static final /* synthetic */ CottontailQueryPlanner access$getPlanner$p(DQLService $this) {
        return $this.planner;
    }
}

