/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.utilities.selection;

import it.unimi.dsi.fastutil.objects.ObjectBigArrayBigList;
import java.util.Comparator;
import java.util.concurrent.locks.StampedLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0013\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00028\u0000\u00a2\u0006\u0002\u0010!J\r\u0010\"\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004H\u0002J\b\u0010&\u001a\u00020\u001eH\u0002R\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0006j\b\u0012\u0004\u0012\u00028\u0000`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\fR\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lorg/vitrivr/cottontail/utilities/selection/HeapSelection;", "T", "", "k", "", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "(JLjava/util/Comparator;)V", "<set-?>", "added", "getAdded", "()J", "getComparator", "()Ljava/util/Comparator;", "heap", "Lit/unimi/dsi/fastutil/objects/ObjectBigArrayBigList;", "getK", "lock", "Ljava/util/concurrent/locks/StampedLock;", "size", "getSize", "", "sorted", "getSorted", "()Z", "get", "i", "(J)Ljava/lang/Object;", "heapify", "", "offer", "element", "(Ljava/lang/Object;)V", "peek", "()Ljava/lang/Object;", "siftDown", "n", "sort", "cottontaildb-dbms"})
public final class HeapSelection<T> {
    private final long k;
    @NotNull
    private final Comparator<T> comparator;
    @NotNull
    private final ObjectBigArrayBigList<T> heap;
    @NotNull
    private final StampedLock lock;
    private volatile boolean sorted;
    private volatile long added;

    public HeapSelection(long k, @NotNull Comparator<T> comparator) {
        Intrinsics.checkNotNullParameter(comparator, (String)"comparator");
        this.k = k;
        this.comparator = comparator;
        this.heap = new ObjectBigArrayBigList(this.k);
        this.lock = new StampedLock();
        this.sorted = true;
    }

    public final long getK() {
        return this.k;
    }

    @NotNull
    public final Comparator<T> getComparator() {
        return this.comparator;
    }

    public final boolean getSorted() {
        return this.sorted;
    }

    public final long getAdded() {
        return this.added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSize() {
        long $i$a$-read-HeapSelection$size$22;
        StampedLock $this$read$iv = this.lock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean $i$a$-read-HeapSelection$size$22 = false;
            $i$a$-read-HeapSelection$size$22 = this.heap.size64();
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return $i$a$-read-HeapSelection$size$22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void offer(T element) {
        StampedLock $this$write$iv = this.lock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-HeapSelection$offer$22 = false;
            long l = this.getAdded();
            this.added = l + 1L;
            if (l < this.getK()) {
                this.sorted = false;
                this.heap.add(element);
                if (this.getAdded() == this.getK()) {
                    this.heapify();
                }
            } else if (this.getComparator().compare(element, this.heap.get(0L)) < 0) {
                this.heap.set(0L, element);
                this.siftDown(0L, this.getK() - 1L);
            }
            Unit $i$a$-write-HeapSelection$offer$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T peek() {
        Object $i$a$-read-HeapSelection$peek$22;
        StampedLock $this$read$iv = this.lock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean $i$a$-read-HeapSelection$peek$22 = false;
            $i$a$-read-HeapSelection$peek$22 = CollectionsKt.firstOrNull((Iterable)((Iterable)this.heap));
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
        return (T)$i$a$-read-HeapSelection$peek$22;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get(long i) {
        StampedLock $this$read$iv = this.lock;
        boolean $i$f$read = false;
        long stamp$iv = $this$read$iv.readLock();
        try {
            boolean bl = false;
            long maxIdx = this.heap.size64() - 1L;
            if (!(i <= maxIdx)) {
                boolean bl2 = false;
                String string = "Index " + i + " is out of bounds for this HeapSelect.";
                throw new IllegalArgumentException(string.toString());
            }
            if (i == this.getK() - 1L) {
                Object object = this.heap.get(0L);
                return (T)object;
            }
            if (!this.getSorted()) {
                this.sort();
            }
            Object object = this.heap.get(maxIdx - i);
            return (T)object;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$read$iv.unlock(stamp$iv);
        }
    }

    private final void sort() {
        int n;
        long n2 = Math.min(this.k, this.added);
        int inc = 1;
        do {
            inc *= 3;
        } while ((long)(inc = (n = inc) + 1) <= n2);
        do {
            long l = inc /= 3;
            while (l < n2) {
                long i = l++;
                Object v = this.heap.get(i);
                long j = i;
                while (this.comparator.compare(this.heap.get(j - (long)inc), v) < 0) {
                    this.heap.set(j, this.heap.get(j - (long)inc));
                    if ((j -= (long)inc) >= (long)inc) continue;
                }
                this.heap.set(j, v);
            }
        } while (inc > 1);
        this.sorted = true;
    }

    private final void siftDown(long i, long n) {
        long k = i;
        while ((long)2 * k <= n) {
            long j = (long)2 * k;
            if (j < n && this.comparator.compare(this.heap.get(j), this.heap.get(j + 1L)) < 0) {
                long l = j;
                j = l + 1L;
            }
            if (this.comparator.compare(this.heap.get(k), this.heap.get(j)) >= 0) break;
            Object a = this.heap.get(k);
            this.heap.set(k, this.heap.get(j));
            this.heap.set(j, a);
            k = j;
        }
    }

    private final void heapify() {
        long n = this.heap.size64();
        long l = Math.floorDiv(n, 2);
        if (0L <= l) {
            do {
                long i = l;
                this.siftDown(i, n - 1L);
            } while (0L <= (l += -1L));
        }
    }
}

