/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.ExperimentalTime;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.legacy.VersionProber;
import org.vitrivr.cottontail.server.grpc.CottontailGrpcServer;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u001b\u0010\u0007\u001a\u00020\u00012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0002\u00a2\u0006\u0002\u0010\n\u001a\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a\u001b\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tH\u0007\u00a2\u0006\u0002\u0010\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"COTTONTAIL_CONFIG_FILE_ENV_KEY", "", "COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY", "embedded", "Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;", "config", "Lorg/vitrivr/cottontail/config/Config;", "findConfigPathOrdered", "args", "", "([Ljava/lang/String;)Ljava/lang/String;", "loadConfig", "path", "main", "", "([Ljava/lang/String;)V", "standalone", "cottontaildb-dbms"})
public final class CottontailKt {
    @NotNull
    public static final String COTTONTAIL_CONFIG_FILE_ENV_KEY = "COTTONTAIL_CONFIG";
    @NotNull
    public static final String COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY = "org.vitrivr.cottontail.config";

    @ExperimentalTime
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            Config config = CottontailKt.loadConfig(CottontailKt.findConfigPathOrdered(args));
            CottontailKt.standalone(config);
        }
        catch (Throwable e) {
            System.err.println("Failed to start Cottontail DB due to error:");
            e.printStackTrace();
            System.err.println(Unit.INSTANCE);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String findConfigPathOrdered(String[] args) {
        String string;
        String string2;
        if (!(args.length == 0) && !StringsKt.isBlank((CharSequence)args[0])) {
            string2 = args[0];
            return string2;
        }
        if (System.getProperties().containsKey(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY)) {
            string = System.getProperty(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY, "");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\n           \u2026ROPERTY_KEY, \"\"\n        )");
            if (!StringsKt.isBlank((CharSequence)string)) {
                string = System.getProperty(COTTONTAIL_CONFIG_FILE_SYSTEM_PROPERTY_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n        System.getProp\u2026YSTEM_PROPERTY_KEY)\n    }");
                string2 = string;
                return string2;
            }
        }
        if (System.getenv().containsKey(COTTONTAIL_CONFIG_FILE_ENV_KEY)) {
            string = System.getenv(COTTONTAIL_CONFIG_FILE_ENV_KEY);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(\n            COTT\u2026IG_FILE_ENV_KEY\n        )");
            if (!StringsKt.isBlank((CharSequence)string)) {
                string = System.getenv(COTTONTAIL_CONFIG_FILE_ENV_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n        System.getenv(\u2026ONFIG_FILE_ENV_KEY)\n    }");
                string2 = string;
                return string2;
            }
        }
        System.err.println("No CottontailDB Config file specified. Defaulting to ./config.json");
        return "./config.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Config loadConfig(String path) {
        Path configPath = Paths.get(path, new String[0]);
        try {
            Config config;
            if (!Files.isRegularFile(configPath, new LinkOption[0])) {
                System.err.println("No CottontailDB config exists under " + configPath + "; trying to create default config!");
                Config config2 = new Config(null, false, null, null, null, null, null, 127, null);
                Closeable closeable = Files.newBufferedWriter(configPath, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    BufferedWriter it = (BufferedWriter)closeable;
                    boolean bl = false;
                    it.write(Json.Default.encodeToString((SerializationStrategy)Config.Companion.serializer(), (Object)config2));
                    it = Unit.INSTANCE;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return config2;
            }
            Closeable config2 = Files.newBufferedReader(configPath);
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)config2;
                boolean bl = false;
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)Config.Companion.serializer();
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                config = (Config)Json.Default.decodeFromString(deserializationStrategy, TextStreamsKt.readText((Reader)it));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)config2, (Throwable)throwable);
            }
            return config;
        }
        catch (Throwable e) {
            System.err.println("Could not load Cottontail DB configuration file under " + configPath + ". Cottontail DB will shutdown!");
            e.printStackTrace();
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    /*
     * Unable to fully structure code
     */
    @ExperimentalTime
    public static final void standalone(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.getLogConfig() != null && Files.isRegularFile(config.getLogConfig(), new LinkOption[0])) {
            System.getProperties().setProperty("log4j.configurationFile", config.getLogConfig().toString());
        }
        server = CottontailKt.embedded(config);
        System.out.println((Object)("Cottontail DB server is up and running at port " + config.getServer().getPort() + "! Hop along... (catalogue: " + (Object)server.getCatalogue().getVersion() + ", pid: " + ProcessHandle.current().pid() + ')'));
        scanner = new Scanner(System.in);
        block8: while (server.isRunning()) {
            if (!scanner.hasNext() || (var3_3 = scanner.nextLine()) == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var3_3.hashCode()) {
                case 3127582: {
                    if (var3_3.equals("exit")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3540994: {
                    if (var3_3.equals("stop")) {
                        tmp = 1;
                    }
                    break;
                }
                case 3482191: {
                    if (var3_3.equals("quit")) {
                        tmp = 1;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    break block8;
                }
                default: lbl-1000:
                // 2 sources

                {
                    Thread.sleep(250L);
                    continue block8;
                }
            }
        }
        server.stop();
        System.out.println((Object)"Cottontail DB was shut down. Have a binky day!");
    }

    @ExperimentalTime
    @NotNull
    public static final CottontailGrpcServer embedded(@NotNull Config config) {
        DBOVersion detected;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!Files.exists(config.getRoot(), new LinkOption[0])) {
            Files.createDirectories(config.getRoot(), new FileAttribute[0]);
        }
        if ((detected = new VersionProber(config).probe(config.getRoot())) != VersionProber.Companion.getEXPECTED() && detected != DBOVersion.UNDEFINED) {
            throw new DatabaseException.VersionMismatchException(VersionProber.Companion.getEXPECTED(), detected);
        }
        return new CottontailGrpcServer(config);
    }
}

