/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.gg;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.functions.Argument;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.math.VectorDistance;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.types.NumericValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.exceptions.TxException;
import org.vitrivr.cottontail.dbms.execution.TransactionContext;
import org.vitrivr.cottontail.dbms.functions.math.distance.Distances;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.TxStatus;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.gg.GGIndex;
import org.vitrivr.cottontail.dbms.index.gg.GGIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.PQIndex;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.storage.serializers.ValueSerializerFactory;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;
import org.vitrivr.cottontail.utilities.selection.ComparablePair;
import org.vitrivr.cottontail.utilities.selection.MinHeapSelection;
import org.vitrivr.cottontail.utilities.selection.MinSingleSelection;
import org.vitrivr.cottontail.utilities.selection.Selection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 *2\u00020\u0001:\u0002*+B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b$\u0010%J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u0016X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig;", "groupsStore", "Lorg/mapdb/HTreeMap;", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "", "produces", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "cost-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class GGIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final IndexType type;
    @NotNull
    private final GGIndexConfig config;
    @NotNull
    private final HTreeMap<VectorValue<?>, long[]> groupsStore;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    public static final String GG_INDEX_NAME = "cdb_gg_means";
    @NotNull
    private static final Logger LOGGER;

    public GGIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable GGIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        GroupSerializer groupSerializer = new GroupSerializer[]{KnnUtilities.INSTANCE.distanceColumnDef(this.getParent().getName())};
        this.produces = groupSerializer;
        this.type = IndexType.GG;
        DB dB = this.getStore();
        Serializer serializer2 = ValueSerializerFactory.INSTANCE.mapdb(this.getColumns()[0].getType());
        groupSerializer = Serializer.LONG_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"LONG_ARRAY");
        this.groupsStore = dB.hashMap(GG_INDEX_NAME, serializer2, (Serializer)groupSerializer).counterEnable().createOrOpen();
        if (!(this.getColumns().length == 1)) {
            boolean bl = false;
            String string = "GGIndex only supports indexing a single column.";
            throw new IllegalArgumentException(string.toString());
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar(GG_INDEX_NAME, (Serializer)GGIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? config : new GGIndexConfig(50, System.currentTimeMillis(), Distances.L2);
            configOnDisk.set((Object)this.getConfig());
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (GGIndexConfig)object;
        }
        this.getStore().commit();
    }

    public /* synthetic */ GGIndex(Path path, DefaultEntity defaultEntity, GGIndexConfig gGIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            gGIndexConfig = null;
        }
        this(path, defaultEntity, gGIndexConfig);
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public GGIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof ProximityPredicate.NNS && Intrinsics.areEqual((Object)((ProximityPredicate.NNS)predicate).getColumn(), this.getColumns()[0]) && Intrinsics.areEqual((Object)((ProximityPredicate.NNS)predicate).getDistance().getSignature().getName(), (Object)this.getConfig().getDistance().getFunctionName());
    }

    @Override
    @NotNull
    public float[] cost-7eHliGg(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return Cost.Companion.getZERO-7CRCzCo();
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    static {
        Logger logger = LoggerFactory.getLogger(GGIndex.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex$Companion;", "", "()V", "GG_INDEX_NAME", "", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex;Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;)V", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/core/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractIndex.Tx {
        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)GGIndex.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(GGIndex.this, context2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public long count() {
            long l;
            void this_$iv;
            AbstractTx abstractTx = this;
            GGIndex gGIndex = GGIndex.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                l = gGIndex.groupsStore.size();
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            void this_$iv;
            AbstractTx abstractTx = this;
            GGIndex gGIndex = GGIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                PQIndex.Companion.getLOGGER().debug("Rebuilding GG index {}", (Object)gGIndex.getName());
                EntityTx txn = (EntityTx)this.getContext().getTx(this.getDbo().getParent());
                Set remainingTids = new LinkedHashSet();
                boolean $i$f$emptyArray = false;
                Iterator $this$forEach$iv = txn.scan(new ColumnDef[0]);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Record it = (Record)element$iv;
                    boolean bl3 = false;
                    remainingTids.add(it.getTupleId());
                }
                int groupSize = (remainingTids.size() + gGIndex.getConfig().getNumGroups() - 1) / gGIndex.getConfig().getNumGroups();
                Set finishedTIds = new LinkedHashSet();
                SplittableRandom random = new SplittableRandom(gGIndex.getConfig().getSeed());
                gGIndex.groupsStore.clear();
                while (!((Collection)remainingTids).isEmpty()) {
                    long groupSeedTid = ((Number)CollectionsKt.elementAt((Iterable)remainingTids, (int)random.nextInt(remainingTids.size()))).longValue();
                    Value groupSeedValue = txn.read(groupSeedTid, gGIndex.getColumns()).get(gGIndex.getColumns()[0]);
                    if (!(groupSeedValue instanceof VectorValue)) continue;
                    Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed(gGIndex.getColumns()[0].getType()), new Argument.Typed(gGIndex.getColumns()[0].getType())};
                    Signature.Closed signature = new Signature.Closed(gGIndex.getConfig().getDistance().getFunctionName(), typedArray, (Types)Types.Double.INSTANCE);
                    Function function = gGIndex.getParent().getParent().getParent().getFunctions().obtain(signature);
                    if (!(function instanceof VectorDistance)) {
                        boolean $i$a$-check-GGIndex$Tx$rebuild$1$32 = false;
                        String $i$a$-check-GGIndex$Tx$rebuild$1$32 = "GGIndex rebuild failed: Function " + signature + " is not a vector distance function.";
                        throw new IllegalStateException($i$a$-check-GGIndex$Tx$rebuild$1$32.toString());
                    }
                    MinHeapSelection<Comparable> knn = new MinHeapSelection<Comparable>(groupSize);
                    Iterable $this$forEach$iv2 = remainingTids;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        long tid = ((Number)element$iv).longValue();
                        boolean bl4 = false;
                        Record r = txn.read(tid, gGIndex.getColumns());
                        Value queryVector = r.get(gGIndex.getColumns()[0]);
                        if (!(queryVector instanceof VectorValue)) continue;
                        Value[] valueArray = new Value[]{groupSeedValue, queryVector};
                        Value value = ((VectorDistance)function).invoke(valueArray);
                        Intrinsics.checkNotNull((Object)value);
                        double distance = ((DoubleValue)value).unbox-impl();
                        if (knn.getSize() >= groupSize) {
                            Object t = knn.peek();
                            Intrinsics.checkNotNull(t);
                            if (DoubleValue.compareTo-impl((double)((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), (Value)DoubleValue.box-impl((double)distance)) <= 0) continue;
                        }
                        knn.offer(new ComparablePair<Pair, DoubleValue>(new Pair((Object)tid, (Object)queryVector), DoubleValue.box-impl((double)distance)));
                    }
                    VectorValue groupMean = ((VectorValue)groupSeedValue).new();
                    List groupTids = new ArrayList();
                    int n4 = 0;
                    int n5 = knn.getSize();
                    while (n4 < n5) {
                        int i = n4++;
                        Pair element = (Pair)((ComparablePair)knn.get(i)).getFirst();
                        groupMean = groupMean.plus((VectorValue)element.getSecond());
                        groupTids.add(element.getFirst());
                        if (!remainingTids.remove(element.getFirst())) {
                            boolean $i$a$-check-GGIndex$Tx$rebuild$1$62 = false;
                            String $i$a$-check-GGIndex$Tx$rebuild$1$62 = Intrinsics.stringPlus((String)gGIndex.getName().getSimple(), (Object)" processed an element that should have been removed by now.");
                            throw new IllegalStateException($i$a$-check-GGIndex$Tx$rebuild$1$62.toString());
                        }
                        if (finishedTIds.add(element.getFirst())) continue;
                        boolean bl5 = false;
                        String string = Intrinsics.stringPlus((String)gGIndex.getName().getSimple(), (Object)" processed an element that was already processed.");
                        throw new IllegalStateException(string.toString());
                    }
                    groupMean = groupMean.div((NumericValue)DoubleValue.box-impl((double)DoubleValue.constructor-impl((Number)knn.getSize())));
                    Map map2 = (Map)gGIndex.groupsStore;
                    long[] lArray = CollectionsKt.toLongArray((Collection)groupTids);
                    map2.put(groupMean, lArray);
                }
                gGIndex.getDirtyField().compareAndSet(true, false);
                PQIndex.Companion.getLOGGER().debug("Rebuilding GGIndex {} complete.", (Object)gGIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n6 = 0;
                while (n6 < n) {
                    int n7 = n6++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation event) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx abstractTx = this;
            GGIndex gGIndex = GGIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                gGIndex.getDirtyField().compareAndSet(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            void this_$iv;
            AbstractTx abstractTx = this;
            GGIndex gGIndex = GGIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                gGIndex.getDirtyField().compareAndSet(false, true);
                gGIndex.groupsStore.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(predicate, GGIndex.this, this){
                @NotNull
                private final ProximityPredicate.NNS predicate;
                @NotNull
                private final VectorValue<?> vector;
                @NotNull
                private final Lazy resultsQueue$delegate;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ GGIndex this$0;
                final /* synthetic */ Tx this$1;
                {
                    this.$predicate = $predicate;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    if (!(this.$predicate instanceof ProximityPredicate.NNS) || !Intrinsics.areEqual((Object)((ProximityPredicate.NNS)this.$predicate).getDistance().getSignature().getName(), (Object)this.this$0.getConfig().getDistance().getFunctionName())) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + this.this$0.getName() + "' (GGIndex) does not support predicates of type '" + Reflection.getOrCreateKotlinClass(this.$predicate.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (ProximityPredicate.NNS)this.$predicate;
                    this.resultsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayDeque<StandaloneRecord>>(this){
                        final /* synthetic */ filter.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final ArrayDeque<StandaloneRecord> invoke() {
                            return filter.1.access$prepareResults(this.this$0);
                        }
                    }));
                    AbstractTx this_$iv = this.this$1;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
                    readLock.lock();
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    Value value = this.predicate.getQuery().getValue();
                    if (!(value instanceof VectorValue)) {
                        boolean bl = false;
                        Value value2 = value;
                        String string = "Bound value for query vector has wrong type (found = " + (value2 == null ? null : value2.getType()) + ").";
                        throw new IllegalStateException(string.toString());
                    }
                    this.vector = (VectorValue)value;
                }

                private final ArrayDeque<StandaloneRecord> getResultsQueue() {
                    Lazy lazy = this.resultsQueue$delegate;
                    return (ArrayDeque)lazy.getValue();
                }

                public boolean hasNext() {
                    return !((Collection)this.getResultsQueue()).isEmpty();
                }

                @NotNull
                public Record next() {
                    return (Record)this.getResultsQueue().removeFirst();
                }

                private final ArrayDeque<StandaloneRecord> prepareResults() {
                    Object[] objectArray;
                    ArrayDeque queue = new ArrayDeque(this.predicate.getK());
                    int considerNumGroups = (this.this$0.getConfig().getNumGroups() + 9) / 10;
                    EntityTx txn = (EntityTx)this.this$1.getContext().getTx(this.this$0.getParent());
                    Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed(this.this$0.getColumns()[0].getType())};
                    Signature.Closed signature = new Signature.Closed(this.this$0.getConfig().getDistance().getFunctionName(), typedArray, (Types)Types.Double.INSTANCE);
                    Function function = this.this$0.getParent().getParent().getParent().getFunctions().obtain(signature);
                    if (!(function instanceof VectorDistance)) {
                        boolean $i$a$-check-GGIndex$Tx$filter$1$prepareResults$22 = false;
                        String $i$a$-check-GGIndex$Tx$filter$1$prepareResults$22 = "Function " + signature + " is not a vector distance function.";
                        throw new IllegalStateException($i$a$-check-GGIndex$Tx$filter$1$prepareResults$22.toString());
                    }
                    if (!((long)this.predicate.getK() < txn.maxTupleId() / (long)this.this$0.getConfig().getNumGroups() * (long)considerNumGroups)) {
                        boolean $i$a$-require-GGIndex$Tx$filter$1$prepareResults$32 = false;
                        String $i$a$-require-GGIndex$Tx$filter$1$prepareResults$32 = "Value of k is too large for this index considering " + considerNumGroups + " groups.";
                        throw new IllegalArgumentException($i$a$-require-GGIndex$Tx$filter$1$prepareResults$32.toString());
                    }
                    MinHeapSelection<Comparable> groupKnn = new MinHeapSelection<Comparable>(considerNumGroups);
                    GGIndex.Companion.getLOGGER().debug("Scanning group mean signals.");
                    Value value = this.predicate.getQuery().getValue();
                    if (value == null) {
                        return queue;
                    }
                    Value query2 = value;
                    Map $this$forEach$iv = (Map)GGIndex.access$getGroupsStore$p(this.this$0);
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> it = element$iv = iterator.next();
                        boolean bl = false;
                        Object object = it.getValue();
                        Intrinsics.checkNotNullExpressionValue(object, (String)"it.value");
                        V v = object;
                        object = new Value[]{query2, (Value)it.getKey()};
                        Value value2 = ((VectorDistance)function).invoke(object);
                        Intrinsics.checkNotNull((Object)value2);
                        groupKnn.offer(new ComparablePair<V, Comparable>(v, (Comparable)value2));
                    }
                    Selection knn = this.predicate.getK() == 1 ? (Selection)new MinSingleSelection<T>() : (Selection)new MinHeapSelection<T>(this.predicate.getK());
                    GGIndex.Companion.getLOGGER().debug("Scanning group members.");
                    int n = 0;
                    int n2 = groupKnn.getSize();
                    while (n < n2) {
                        int k = n++;
                        objectArray = (long[])((ComparablePair)groupKnn.get(k)).getFirst();
                        int n3 = 0;
                        int n4 = objectArray.length;
                        while (n3 < n4) {
                            long tupleId = objectArray[n3];
                            ++n3;
                            Value probingArgument = txn.read(tupleId, this.this$0.getColumns()).get(this.this$0.getColumns()[0]);
                            if (!(probingArgument instanceof VectorDistance)) continue;
                            Value[] valueArray = new Value[]{query2, probingArgument};
                            Value value3 = ((VectorDistance)function).invoke(valueArray);
                            Intrinsics.checkNotNull((Object)value3);
                            double distance = ((DoubleValue)value3).unbox-impl();
                            if (knn.getSize() >= knn.getK()) {
                                T t = knn.peek();
                                Intrinsics.checkNotNull(t);
                                if (DoubleValue.compareTo-impl((double)((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), (Value)DoubleValue.box-impl((double)distance)) <= 0) continue;
                            }
                            knn.offer((Comparable)new ComparablePair<Long, DoubleValue>(tupleId, DoubleValue.box-impl((double)distance)));
                        }
                    }
                    n = 0;
                    n2 = knn.getSize();
                    while (n < n2) {
                        int i = n++;
                        objectArray = new Value[1];
                        objectArray[0] = (long)((Value)((ComparablePair)knn.get(i)).getSecond());
                        queue.add((Object)new StandaloneRecord(((Number)((ComparablePair)knn.get(i)).getFirst()).longValue(), this.this$0.getProduces(), (Value[])objectArray));
                    }
                    return queue;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }

                public static final /* synthetic */ ArrayDeque access$prepareResults(filter.1 $this) {
                    return $this.prepareResults();
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw new UnsupportedOperationException("The UniqueHashIndex does not support ranged filtering!");
        }
    }
}

