/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lsh.superbit;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.random.RandomGenerator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.values.Complex32VectorValue;
import org.vitrivr.cottontail.core.values.Complex64VectorValue;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.types.ComplexVectorValue;
import org.vitrivr.cottontail.core.values.types.NumericValue;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.lsh.superbit.SamplingMethod;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\nJ\u0012\u0010\u001e\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u001a\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001b\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBit;", "Ljava/io/Serializable;", "N", "", "L", "seed", "", "samplingMethod", "Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SamplingMethod;", "species", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "(IIJLorg/vitrivr/cottontail/dbms/index/lsh/superbit/SamplingMethod;Lorg/vitrivr/cottontail/core/values/types/VectorValue;)V", "getL", "()I", "getN", "_hyperplanes", "", "[Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "d", "getD", "hyperplanes", "getHyperplanes", "()[Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "getSamplingMethod", "()Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SamplingMethod;", "getSeed", "()J", "signature", "", "vector", "signatureComplex", "Lorg/vitrivr/cottontail/core/values/types/ComplexVectorValue;", "cottontaildb-dbms"})
public final class SuperBit
implements Serializable {
    private final int N;
    private final int L;
    private final long seed;
    @NotNull
    private final SamplingMethod samplingMethod;
    private final int d;
    @NotNull
    private final VectorValue<?>[] _hyperplanes;

    public SuperBit(int N, int L, long seed, @NotNull SamplingMethod samplingMethod, @NotNull VectorValue<?> species) {
        VectorValue[] vectorValueArray;
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)((Object)samplingMethod), (String)"samplingMethod");
        Intrinsics.checkNotNullParameter(species, (String)"species");
        this.N = N;
        this.L = L;
        this.seed = seed;
        this.samplingMethod = samplingMethod;
        this.d = species.getLogicalSize();
        if (!(this.d > 0)) {
            boolean $i$a$-require-SuperBit$42 = false;
            String $i$a$-require-SuperBit$42 = "Dimension d must be >= 1";
            throw new IllegalArgumentException($i$a$-require-SuperBit$42.toString());
        }
        if (!(this.N >= 1 && this.N <= this.d)) {
            boolean $i$a$-require-SuperBit$52 = false;
            String $i$a$-require-SuperBit$52 = "Super-Bit depth N must be 1 <= N <= d";
            throw new IllegalArgumentException($i$a$-require-SuperBit$52.toString());
        }
        if (!(this.L >= 1)) {
            boolean $i$a$-require-SuperBit$62 = false;
            String $i$a$-require-SuperBit$62 = "Number of Super-Bits L must be >= 1";
            throw new IllegalArgumentException($i$a$-require-SuperBit$62.toString());
        }
        int K = this.N * this.L;
        switch (WhenMappings.$EnumSwitchMapping$0[this.samplingMethod.ordinal()]) {
            case 1: {
                VectorValue rnd;
                int n3;
                VectorValue[] vectorValueArray2;
                int n4;
                Object[] objectArray;
                int n5;
                int n6;
                VectorValue<?> vectorValue;
                RandomGenerator random = new SplittableRandom(this.seed);
                VectorValue[] vectorValueArray3 = new VectorValue[K];
                for (n2 = 0; n2 < K; ++n2) {
                    DoubleVectorValue doubleVectorValue;
                    int n7;
                    VectorValue[] vectorValueArray4;
                    n = n2;
                    vectorValue = species;
                    if (vectorValue instanceof DoubleVectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize();
                        objectArray = new double[n5];
                        n4 = n;
                        vectorValueArray2 = vectorValueArray3;
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = random.nextDouble() - 0.5;
                        }
                        vectorValueArray4 = vectorValueArray2;
                        n7 = n4;
                        doubleVectorValue = DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])objectArray));
                    } else if (vectorValue instanceof FloatVectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize();
                        objectArray = new float[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = (float)(random.nextDouble() - 0.5);
                        }
                        vectorValueArray4 = vectorValueArray2;
                        n7 = n4;
                        doubleVectorValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((float[])objectArray));
                    } else if (vectorValue instanceof Complex32VectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize() * 2;
                        objectArray = new float[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = (float)(random.nextDouble() - 0.5);
                        }
                        vectorValueArray4 = vectorValueArray2;
                        n7 = n4;
                        doubleVectorValue = Complex32VectorValue.box-impl((float[])Complex32VectorValue.constructor-impl((float[])objectArray));
                    } else if (vectorValue instanceof Complex64VectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize() * 2;
                        objectArray = new double[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = random.nextDouble() - 0.5;
                        }
                        vectorValueArray4 = vectorValueArray2;
                        n7 = n4;
                        doubleVectorValue = Complex64VectorValue.box-impl((double[])Complex64VectorValue.constructor-impl((double[])objectArray));
                    } else {
                        throw new IllegalArgumentException("Unsupported vector type");
                    }
                    rnd = (VectorValue)doubleVectorValue;
                    vectorValueArray4[n7] = rnd.div((NumericValue)rnd.norm2());
                }
                vectorValueArray = vectorValueArray3;
                break;
            }
            case 2: {
                VectorValue rnd;
                int n3;
                VectorValue[] vectorValueArray2;
                int n4;
                Object[] objectArray;
                int n5;
                int n6;
                VectorValue<?> vectorValue;
                RandomGenerator random = new Random(this.seed);
                VectorValue[] vectorValueArray3 = new VectorValue[K];
                for (n2 = 0; n2 < K; ++n2) {
                    DoubleVectorValue doubleVectorValue;
                    int n8;
                    VectorValue[] vectorValueArray5;
                    n = n2;
                    vectorValue = species;
                    if (vectorValue instanceof DoubleVectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize();
                        objectArray = new double[n5];
                        n4 = n;
                        vectorValueArray2 = vectorValueArray3;
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = ((Random)random).nextGaussian();
                        }
                        vectorValueArray5 = vectorValueArray2;
                        n8 = n4;
                        doubleVectorValue = DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])objectArray));
                    } else if (vectorValue instanceof FloatVectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize();
                        objectArray = new float[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = (float)((Random)random).nextGaussian();
                        }
                        vectorValueArray5 = vectorValueArray2;
                        n8 = n4;
                        doubleVectorValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((float[])objectArray));
                    } else if (vectorValue instanceof Complex32VectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize() * 2;
                        objectArray = new float[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = (float)((Random)random).nextGaussian();
                        }
                        vectorValueArray5 = vectorValueArray2;
                        n8 = n4;
                        doubleVectorValue = Complex32VectorValue.box-impl((float[])Complex32VectorValue.constructor-impl((float[])objectArray));
                    } else if (vectorValue instanceof Complex64VectorValue) {
                        n6 = 0;
                        n5 = species.getLogicalSize() * 2;
                        objectArray = new double[n5];
                        while (n6 < n5) {
                            n3 = n6++;
                            objectArray[n3] = ((Random)random).nextGaussian();
                        }
                        vectorValueArray5 = vectorValueArray2;
                        n8 = n4;
                        doubleVectorValue = Complex64VectorValue.box-impl((double[])Complex64VectorValue.constructor-impl((double[])objectArray));
                    } else {
                        throw new IllegalArgumentException("Unsupported vector type");
                    }
                    rnd = (VectorValue)doubleVectorValue;
                    vectorValueArray5[n8] = rnd.div((NumericValue)rnd.norm2());
                }
                vectorValueArray = vectorValueArray3;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        VectorValue[] v = vectorValueArray;
        int n9 = 0;
        VectorValue[] vectorValueArray6 = new VectorValue[K];
        while (n9 < K) {
            n2 = n9++;
            vectorValueArray6[n2] = v[n2];
        }
        VectorValue[] w = vectorValueArray6;
        n9 = 0;
        int n10 = this.L;
        while (n9 < n10) {
            int j;
            int i = n9++;
            int n11 = 1;
            n = this.N;
            if (n11 > n) continue;
            do {
                j = n11++;
                int n12 = 1;
                while (n12 < j) {
                    int k = n12++;
                    w[i * this.N + j - 1] = w[i * this.N + j - 1].minus(w[i * this.N + k - 1].times(w[i * this.N + j - 1].dot(v[i * this.N + k - 1])));
                }
                w[i * this.N + j - 1] = w[i * this.N + j - 1].div((NumericValue)w[i * this.N + j - 1].norm2());
            } while (j != n);
        }
        this._hyperplanes = w;
    }

    public final int getN() {
        return this.N;
    }

    public final int getL() {
        return this.L;
    }

    public final long getSeed() {
        return this.seed;
    }

    @NotNull
    public final SamplingMethod getSamplingMethod() {
        return this.samplingMethod;
    }

    public final int getD() {
        return this.d;
    }

    @NotNull
    public final VectorValue<?>[] getHyperplanes() {
        VectorValue<?>[] vectorValueArray = Arrays.copyOf(this._hyperplanes, this._hyperplanes.length);
        Intrinsics.checkNotNullExpressionValue(vectorValueArray, (String)"copyOf(this, size)");
        return vectorValueArray;
    }

    @NotNull
    public final boolean[] signature(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        boolean[] signature = new boolean[this._hyperplanes.length];
        int n = 0;
        int n2 = this._hyperplanes.length;
        while (n < n2) {
            int i;
            signature[i] = this._hyperplanes[i = n++].dot(vector).asInt-XzlYvWs() >= 0;
        }
        return signature;
    }

    @NotNull
    public final boolean[] signatureComplex(@NotNull ComplexVectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        int n = this._hyperplanes.length;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            blArray[n2] = n2 % 2 == 0 ? this._hyperplanes[n2].dot((VectorValue)vector).getReal().asInt-XzlYvWs() >= 0 : this._hyperplanes[n2].dot((VectorValue)vector).getImaginary().asInt-XzlYvWs() >= 0;
        }
        return blArray;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SamplingMethod.values().length];
            nArray[SamplingMethod.UNIFORM.ordinal()] = 1;
            nArray[SamplingMethod.GAUSSIAN.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

