/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lsh.superbit;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.values.types.ComplexVectorValue;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.lsh.superbit.SamplingMethod;
import org.vitrivr.cottontail.dbms.index.lsh.superbit.SuperBit;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\bJ\u001c\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0002R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSH;", "Ljava/io/Serializable;", "s", "", "b", "seed", "", "species", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "considerImaginary", "", "samplingMethod", "Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SamplingMethod;", "(IIJLorg/vitrivr/cottontail/core/values/types/VectorValue;ZLorg/vitrivr/cottontail/dbms/index/lsh/superbit/SamplingMethod;)V", "N", "k", "superBit", "Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBit;", "getSuperBit", "()Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBit;", "computeSuperBitDepth", "d", "hash", "", "vector", "hashSignature", "signatureReal", "", "signatureComplex", "Companion", "cottontaildb-dbms"})
public final class SuperBitLSH
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int s;
    private final int b;
    private final boolean considerImaginary;
    private final int k;
    private final int N;
    @NotNull
    private final SuperBit superBit;
    public static final long LARGE_PRIME = 433494437L;

    public SuperBitLSH(int s, int b, long seed, @NotNull VectorValue<?> species, boolean considerImaginary, @NotNull SamplingMethod samplingMethod) {
        Intrinsics.checkNotNullParameter(species, (String)"species");
        Intrinsics.checkNotNullParameter((Object)((Object)samplingMethod), (String)"samplingMethod");
        this.s = s;
        this.b = b;
        this.considerImaginary = considerImaginary;
        this.k = this.s * this.b / 2;
        this.N = this.computeSuperBitDepth(species.getLogicalSize(), this.k);
        this.superBit = new SuperBit(this.N, this.k / this.N, seed, samplingMethod, species);
    }

    @NotNull
    public final SuperBit getSuperBit() {
        return this.superBit;
    }

    private final int computeSuperBitDepth(int d, int k) {
        int N = d;
        while (N >= 1 && k % N != 0) {
            int n = N;
            N = n + -1;
        }
        if (!(N != 0)) {
            boolean bl = false;
            String string = "Super-Bit depth must not be 0";
            throw new IllegalArgumentException(string.toString());
        }
        return N;
    }

    @NotNull
    public final int[] hash(@NotNull VectorValue<?> vector) {
        Intrinsics.checkNotNullParameter(vector, (String)"vector");
        return this.considerImaginary && vector instanceof ComplexVectorValue ? SuperBitLSH.hashSignature$default(this, this.superBit.signatureComplex((ComplexVectorValue)vector), null, 2, null) : SuperBitLSH.hashSignature$default(this, this.superBit.signature(vector), null, 2, null);
    }

    private final int[] hashSignature(boolean[] signatureReal, boolean[] signatureComplex) {
        if (!(signatureReal.length == this.k)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long[] acc = new long[this.s];
        int n = 0;
        int n2 = this.s;
        while (n < n2) {
            int i = n++;
            acc[i] = 0L;
        }
        int rows = signatureReal.length / this.s;
        n2 = 0;
        int n3 = signatureReal.length;
        while (n2 < n3) {
            int i = n2++;
            long j = 0L;
            if (signatureReal[i]) {
                j = (long)(i + 1) * 433494437L;
            }
            if (signatureComplex != null && signatureComplex[i]) {
                j += (long)(i + 1) * 433494437L;
            }
            int k = RangesKt.coerceAtMost((int)(i / rows), (int)(this.s - 1));
            acc[k] = (acc[k] + j) % (long)Integer.MAX_VALUE;
        }
        int[] vector = new int[this.s];
        n3 = 0;
        int n4 = this.s;
        while (n3 < n4) {
            int i = n3++;
            vector[i] = (int)acc[i] % this.b;
        }
        return vector;
    }

    static /* synthetic */ int[] hashSignature$default(SuperBitLSH superBitLSH, boolean[] blArray, boolean[] blArray2, int n, Object object) {
        if ((n & 2) != 0) {
            blArray2 = null;
        }
        return superBitLSH.hashSignature(blArray, blArray2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSH$Companion;", "", "()V", "LARGE_PRIME", "", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

