/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lsh.superbit;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.DB;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import org.mapdb.serializer.GroupSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.types.ComplexVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.exceptions.TxException;
import org.vitrivr.cottontail.dbms.execution.TransactionContext;
import org.vitrivr.cottontail.dbms.functions.math.distance.Distances;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.TxStatus;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.lsh.LSHIndex;
import org.vitrivr.cottontail.dbms.index.lsh.superbit.SamplingMethod;
import org.vitrivr.cottontail.dbms.index.lsh.superbit.SuperBitLSH;
import org.vitrivr.cottontail.dbms.index.lsh.superbit.SuperBitLSHIndexConfig;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.dbms.operations.Operation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 '*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0002'(B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006)"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSHIndex;", "T", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSHIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSHIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSHIndexConfig;", "maps", "", "Lorg/mapdb/HTreeMap;", "", "", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "cost-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class SuperBitLSHIndex<T extends VectorValue<?>>
extends LSHIndex<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private final IndexType type;
    @NotNull
    private final SuperBitLSHIndexConfig config;
    @NotNull
    private final List<HTreeMap<Integer, long[]>> maps;
    private static final Logger LOGGER = LoggerFactory.getLogger(SuperBitLSHIndex.class);
    @NotNull
    private static final Name.FunctionName[] SUPPORTED_DISTANCES;

    public SuperBitLSHIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable SuperBitLSHIndexConfig config) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            super(path, parent);
            this.type = IndexType.LSH_SB;
            ColumnDef<?>[] $this$all$iv = this.getColumns();
            boolean $i$f$all = false;
            for (ColumnDef<?> element$iv : $this$all$iv) {
                ColumnDef<?> it = element$iv;
                boolean bl2 = false;
                if (it.getType() instanceof Types.Vector) continue;
                bl = false;
                break block7;
            }
            bl = true;
        }
        if (!bl) {
            throw new DatabaseException.IndexNotSupportedException(this.getName(), "Because only vector columns are supported for SuperBitLSHIndex.");
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar("cdb_index_config", (Serializer)SuperBitLSHIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            if (config != null) {
                this.config = config;
                configOnDisk.set((Object)config);
            } else {
                LOGGER.warn("No config supplied and the config from disk was also empty. Resorting to dummy config. Delete this index ASAP!");
                this.config = new SuperBitLSHIndexConfig(1, 1, 123L, true, SamplingMethod.GAUSSIAN);
            }
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (SuperBitLSHIndexConfig)object;
        }
        int n = this.getConfig().getStages();
        SuperBitLSHIndex superBitLSHIndex = this;
        ArrayList arrayList = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            int it = n4 = (n3 = n2++);
            ArrayList arrayList2 = arrayList;
            boolean bl3 = false;
            DB dB = this.getStore();
            String string = Intrinsics.stringPlus((String)"cdb_lsh_map_stage", (Object)it);
            GroupSerializer groupSerializer = Serializer.INTEGER;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"INTEGER");
            Serializer serializer2 = (Serializer)groupSerializer;
            groupSerializer = Serializer.LONG_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)groupSerializer, (String)"LONG_ARRAY");
            arrayList2.add(dB.hashMap(string, serializer2, (Serializer)groupSerializer).counterEnable().createOrOpen());
        }
        superBitLSHIndex.maps = arrayList;
        this.getStore().commit();
    }

    public /* synthetic */ SuperBitLSHIndex(Path path, DefaultEntity defaultEntity, SuperBitLSHIndexConfig superBitLSHIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            superBitLSHIndexConfig = null;
        }
        this(path, defaultEntity, superBitLSHIndexConfig);
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public SuperBitLSHIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof ProximityPredicate && Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)predicate.getColumns()), this.getColumns()[0]) && ArraysKt.contains((Object[])SUPPORTED_DISTANCES, (Object)((ProximityPredicate)predicate).getDistance().getSignature().getName()) && (!this.getConfig().getConsiderImaginary() || ((ProximityPredicate)predicate).getQuery() instanceof ComplexVectorValue);
    }

    @Override
    @NotNull
    public float[] cost-7eHliGg(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return this.canProcess(predicate) ? Cost.Companion.getZERO-7CRCzCo() : Cost.Companion.getINVALID-7CRCzCo();
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    public static final /* synthetic */ Name.FunctionName[] access$getSUPPORTED_DISTANCES$cp() {
        return SUPPORTED_DISTANCES;
    }

    static {
        Name.FunctionName[] functionNameArray = new Name.FunctionName[]{Distances.COSINE.getFunctionName(), Distances.INNERPRODUCT.getFunctionName()};
        SUPPORTED_DISTANCES = functionNameArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSHIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SUPPORTED_DISTANCES", "", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "[Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSHIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/lsh/superbit/SuperBitLSHIndex;Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;)V", "acquireSpecimen", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "tx", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/core/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractIndex.Tx {
        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)SuperBitLSHIndex.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(SuperBitLSHIndex.this, context2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public long count() {
            long l;
            void this_$iv;
            AbstractTx abstractTx = this;
            SuperBitLSHIndex superBitLSHIndex = SuperBitLSHIndex.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                Iterable $this$map$iv = superBitLSHIndex.maps;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    HTreeMap hTreeMap = (HTreeMap)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(Long.valueOf(((Map)it).size()));
                }
                l = CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            void this_$iv;
            AbstractTx abstractTx = this;
            SuperBitLSHIndex superBitLSHIndex = SuperBitLSHIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                LOGGER.debug("Rebuilding SB-LSH index {}", (Object)superBitLSHIndex.getName());
                EntityTx tx = (EntityTx)this.getContext().getTx(this.getDbo().getParent());
                VectorValue<?> vectorValue = this.acquireSpecimen(tx);
                if (vectorValue == null) {
                    throw new DatabaseException("Could not gather specimen to create index.", null, 2, null);
                }
                VectorValue<?> specimen = vectorValue;
                SuperBitLSH lsh = new SuperBitLSH(superBitLSHIndex.getConfig().getStages(), superBitLSHIndex.getConfig().getBuckets(), superBitLSHIndex.getConfig().getSeed(), specimen, superBitLSHIndex.getConfig().getConsiderImaginary(), superBitLSHIndex.getConfig().getSamplingMethod());
                int n4 = superBitLSHIndex.getConfig().getStages();
                ArrayList<List> arrayList = new ArrayList<List>(n4);
                int n5 = 0;
                while (n5 < n4) {
                    int n6;
                    int n7;
                    int n8 = n7 = (n6 = n5++);
                    ArrayList<List> arrayList2 = arrayList;
                    boolean bl3 = false;
                    int n9 = superBitLSHIndex.getConfig().getBuckets();
                    ArrayList<List> arrayList3 = new ArrayList<List>(n9);
                    int n10 = 0;
                    while (n10 < n9) {
                        int n11;
                        int n12;
                        int n13 = n12 = (n11 = n10++);
                        ArrayList<List> arrayList4 = arrayList3;
                        boolean bl4 = false;
                        arrayList4.add(new ArrayList());
                    }
                    arrayList2.add(arrayList3);
                }
                List local = arrayList;
                Object $this$forEach$iv = tx.scan(superBitLSHIndex.getColumns());
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Value value;
                    Object element$iv = iterator.next();
                    Record it = (Record)element$iv;
                    boolean bl5 = false;
                    if (it.get(this.getDbo().getColumns()[0]) == null) {
                        throw new DatabaseException(Intrinsics.stringPlus((String)"Could not find column for entry in index ", (Object)this), null, 2, null);
                    }
                    if (value instanceof VectorValue) {
                        int[] buckets = lsh.hash((VectorValue)value);
                        Iterable $this$forEach$iv2 = ArraysKt.zip((int[])buckets, (Iterable)local);
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            Pair $dstr$bucket$map = (Pair)element$iv2;
                            boolean bl6 = false;
                            int bucket = ((Number)$dstr$bucket$map.component1()).intValue();
                            List map2 = (List)$dstr$bucket$map.component2();
                            ((List)map2.get(bucket)).add(it.getTupleId());
                        }
                        continue;
                    }
                    throw new DatabaseException(value + " is no vector column!", null, 2, null);
                }
                $this$forEach$iv = CollectionsKt.zip((Iterable)superBitLSHIndex.maps, (Iterable)local);
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Pair $dstr$map$localdata = (Pair)element$iv;
                    boolean bl7 = false;
                    HTreeMap map3 = (HTreeMap)$dstr$map$localdata.component1();
                    List localdata = (List)$dstr$map$localdata.component2();
                    map3.clear();
                    Iterable $this$forEachIndexed$iv = localdata;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void tIds;
                        int n14 = index$iv;
                        index$iv = n14 + 1;
                        if (n14 < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        List bucket = (List)item$iv;
                        int bucket2 = n14;
                        boolean bl8 = false;
                        Map map4 = (Map)map3;
                        Integer n15 = bucket2;
                        long[] lArray = CollectionsKt.toLongArray((Collection)((Collection)tIds));
                        map4.put(n15, lArray);
                    }
                }
                superBitLSHIndex.getDirtyField().compareAndSet(true, false);
                LOGGER.debug("Rebuilding SB-LSH index completed.");
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n16 = 0;
                while (n16 < n) {
                    int n17 = n16++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation event) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx abstractTx = this;
            SuperBitLSHIndex superBitLSHIndex = SuperBitLSHIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                superBitLSHIndex.getDirtyField().compareAndSet(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            void this_$iv;
            AbstractTx abstractTx = this;
            SuperBitLSHIndex superBitLSHIndex = SuperBitLSHIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                superBitLSHIndex.getDirtyField().compareAndSet(false, true);
                Iterable $this$forEach$iv = superBitLSHIndex.maps;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HTreeMap map2 = (HTreeMap)element$iv;
                    boolean bl3 = false;
                    map2.clear();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(predicate, SuperBitLSHIndex.this, this){
                @NotNull
                private final ProximityPredicate predicate;
                @NotNull
                private final LinkedList<Long> tupleIds;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ SuperBitLSHIndex<T> this$0;
                final /* synthetic */ Tx this$1;
                {
                    this.$predicate = $predicate;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    if (!(this.$predicate instanceof ProximityPredicate)) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + this.this$0.getName() + "' (LSH Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass(this.$predicate.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (ProximityPredicate)this.$predicate;
                    if (!Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)this.predicate.getColumns()), this.this$0.getColumns()[0]) || !ArraysKt.contains((Object[])SuperBitLSHIndex.access$getSUPPORTED_DISTANCES$cp(), (Object)this.predicate.getDistance().getSignature().getName())) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + this.this$0.getName() + "' (lsh-index) does not support the provided predicate.");
                    }
                    Value value = this.predicate.getQuery().getValue();
                    if (!(value instanceof VectorValue)) {
                        boolean $i$a$-check-SuperBitLSHIndex$Tx$filter$1$22 = false;
                        Value value2 = value;
                        String $i$a$-check-SuperBitLSHIndex$Tx$filter$1$22 = "Bound value for query vector has wrong type (found = " + (value2 == null ? null : value2.getType()) + ").";
                        throw new IllegalStateException($i$a$-check-SuperBitLSHIndex$Tx$filter$1$22.toString());
                    }
                    AbstractTx this_$iv = this.this$1;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
                    readLock.lock();
                    try {
                        boolean $i$a$-read-AbstractTx$withReadLock$1$iv22 = false;
                        boolean bl = false;
                        Unit $i$a$-read-AbstractTx$withReadLock$1$iv22 = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    SuperBitLSH lsh = new SuperBitLSH(this.this$0.getConfig().getStages(), this.this$0.getConfig().getBuckets(), this.this$0.getConfig().getSeed(), (VectorValue)value, this.this$0.getConfig().getConsiderImaginary(), this.this$0.getConfig().getSamplingMethod());
                    this.tupleIds = new LinkedList<E>();
                    int[] signature = lsh.hash((VectorValue)value);
                    int n = 0;
                    int n2 = signature.length;
                    while (n < n2) {
                        int stage = n++;
                        Object object = MapsKt.getValue((Map)((Map)SuperBitLSHIndex.access$getMaps$p(this.this$0).get(stage)), (Object)signature[stage]);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this@SuperBitLSHIndex.ma\u2026etValue(signature[stage])");
                        for (long tupleId : (long[])object) {
                            this.tupleIds.offer(tupleId);
                        }
                    }
                }

                public boolean hasNext() {
                    return !((Collection)this.tupleIds).isEmpty();
                }

                @NotNull
                public Record next() {
                    Long l = this.tupleIds.removeFirst();
                    Intrinsics.checkNotNullExpressionValue((Object)l, (String)"this.tupleIds.removeFirst()");
                    return (Record)new StandaloneRecord(((Number)l).longValue(), this.this$0.getProduces(), new Value[0]);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            throw new UnsupportedOperationException("The SuperBitLSHIndex does not support ranged filtering!");
        }

        private final VectorValue<?> acquireSpecimen(EntityTx tx) {
            long l = 0L;
            long l2 = tx.maxTupleId();
            while (l < l2) {
                long index;
                Value read;
                if (!((read = tx.read(index = l++, SuperBitLSHIndex.this.getColumns()).get(this.getDbo().getColumns()[0])) instanceof VectorValue)) continue;
                return (VectorValue)read;
            }
            return null;
        }
    }
}

