/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SplittableRandom;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.exceptions.TxException;
import org.vitrivr.cottontail.dbms.execution.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.TxStatus;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.pq.PQ;
import org.vitrivr.cottontail.dbms.index.pq.PQIndex;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexEntry;
import org.vitrivr.cottontail.dbms.index.pq.PQLookupTable;
import org.vitrivr.cottontail.dbms.index.pq.PQSignature;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;
import org.vitrivr.cottontail.utilities.selection.ComparablePair;
import org.vitrivr.cottontail.utilities.selection.MinHeapSelection;
import org.vitrivr.cottontail.utilities.selection.MinSingleSelection;
import org.vitrivr.cottontail.utilities.selection.Selection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0002,-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b&\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006."}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "pqStore", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQ;", "produces", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "signaturesStore", "Lorg/mapdb/IndexTreeList;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexEntry;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "cost-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class PQIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final IndexType type;
    @NotNull
    private final PQIndexConfig config;
    @NotNull
    private final Atomic.Var<PQ> pqStore;
    @NotNull
    private final IndexTreeList<PQIndexEntry> signaturesStore;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private static final String PQ_INDEX_FIELD = "cdb_pq_real";
    @NotNull
    private static final String PQ_INDEX_SIGNATURES_FIELD = "cdb_pq_signatures";
    @NotNull
    private static final Logger LOGGER;

    public PQIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable PQIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        ColumnDef[] columnDefArray = new ColumnDef[]{KnnUtilities.INSTANCE.distanceColumnDef(this.getParent().getName())};
        this.produces = columnDefArray;
        this.type = IndexType.PQ;
        this.pqStore = (Atomic.Var)this.getStore().atomicVar(PQ_INDEX_FIELD, (Serializer)PQ.Serializer.INSTANCE).createOrOpen();
        this.signaturesStore = (IndexTreeList)this.getStore().indexTreeList(PQ_INDEX_SIGNATURES_FIELD, (Serializer)PQIndexEntry.Serializer).createOrOpen();
        if (!(this.getColumns().length == 1)) {
            boolean bl = false;
            String string = "PQIndex only supports indexing a single column.";
            throw new IllegalArgumentException(string.toString());
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar("cdb_index_config", (Serializer)PQIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? (config.getNumSubspaces() == -1 || config.getNumSubspaces() % this.getColumns()[0].getType().getLogicalSize() != 0 ? PQIndexConfig.copy$default(config, Companion.defaultNumberOfSubspaces(this.getColumns()[0].getType().getLogicalSize()), 0, 0, 0L, 14, null) : config) : new PQIndexConfig(10, 500, 5000, System.currentTimeMillis());
            configOnDisk.set((Object)this.getConfig());
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (PQIndexConfig)object;
        }
        this.getStore().commit();
        if (!(this.getConfig().getNumCentroids() > 0)) {
            boolean $i$a$-require-PQIndex$52 = false;
            String $i$a$-require-PQIndex$52 = "PQIndex supports a maximum number of " + this.getConfig().getNumCentroids() + " centroids.";
            throw new IllegalArgumentException($i$a$-require-PQIndex$52.toString());
        }
        if (!(this.getConfig().getNumCentroids() <= Short.MAX_VALUE)) {
            String $i$a$-require-PQIndex$52 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-require-PQIndex$52.toString());
        }
        if (!(this.getConfig().getNumSubspaces() > 0)) {
            boolean $i$a$-require-PQIndex$62 = false;
            String $i$a$-require-PQIndex$62 = "PQIndex requires at least one centroid.";
            throw new IllegalArgumentException($i$a$-require-PQIndex$62.toString());
        }
        if (!(this.getColumns()[0].getType().getLogicalSize() >= this.getConfig().getNumSubspaces())) {
            boolean bl = false;
            String string = "Logical size of the column must be greater or equal than the number of subspaces.";
            throw new IllegalArgumentException(string.toString());
        }
        this.supportsPartitioning = true;
    }

    public /* synthetic */ PQIndex(Path path, DefaultEntity defaultEntity, PQIndexConfig pQIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pQIndexConfig = null;
        }
        this(path, defaultEntity, pQIndexConfig);
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public PQIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof ProximityPredicate && Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn(), this.getColumns()[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public float[] cost-7eHliGg(@NotNull Predicate predicate) {
        int n;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof ProximityPredicate)) {
            return Cost.Companion.getINVALID-7CRCzCo();
        }
        if (!Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn(), this.getColumns()[0])) {
            return Cost.Companion.getINVALID-7CRCzCo();
        }
        ColumnDef<?>[] columnDefArray = this.getProduces();
        int n2 = ((ProximityPredicate)predicate).getK();
        float f = (float)this.signaturesStore.size() * ((float)4 * Cost.getCpu-impl((float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo()) + Cost.getCpu-impl((float[])Cost.Companion.getFLOP-7CRCzCo()));
        float f2 = (float)(this.signaturesStore.size() * this.getConfig().getNumSubspaces()) * Cost.getCpu-impl((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo()) + (float)(((ProximityPredicate)predicate).getK() * ((ProximityPredicate)predicate).getColumn().getType().getLogicalSize()) * Cost.getCpu-impl((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo());
        int n3 = 0;
        for (ColumnDef<?> columnDef : columnDefArray) {
            void it;
            ColumnDef<?> columnDef2 = columnDef;
            n = n3;
            boolean bl = false;
            int n4 = it.getType().getPhysicalSize();
            n3 = n + n4;
        }
        n = n3;
        return Cost.plus-wQ19W7k((float[])Cost.constructor-impl$default((float)f2, (float)f, (float)(n2 * n), (float)0.0f, (int)8, null), (float[])Cost.times-7eHliGg((float[])((ProximityPredicate)predicate).getDistance().getCost-7CRCzCo(), (Number)((ProximityPredicate)predicate).getK()));
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PQIndex.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "PQ_INDEX_FIELD", "", "PQ_INDEX_SIGNATURES_FIELD", "defaultNumberOfSubspaces", "", "d", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public final int defaultNumberOfSubspaces(int d) {
            int start;
            int subspaces = start = d == 1 ? 1 : (d == 2 ? 2 : (d <= 8 ? 4 : (d <= 64 ? 4 : (d <= 256 ? 8 : (d <= 1024 ? 16 : (d <= 4096 ? 32 : 64))))));
            while (subspaces < d && subspaces < 127) {
                if (d % subspaces == 0) {
                    return subspaces;
                }
                int n = subspaces;
                subspaces = n + 1;
            }
            return start;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;)V", "acquireLearningData", "", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "txn", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/core/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractIndex.Tx {
        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)PQIndex.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(PQIndex.this, context2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public long count() {
            long l;
            void this_$iv;
            AbstractTx abstractTx = this;
            PQIndex pQIndex = PQIndex.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                l = pQIndex.signaturesStore.size();
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            void this_$iv;
            AbstractTx abstractTx = this;
            PQIndex pQIndex = PQIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                Companion.getLOGGER().debug("Rebuilding PQ index {}", (Object)pQIndex.getName());
                EntityTx txn = (EntityTx)this.getContext().getTx(this.getDbo().getParent());
                List<VectorValue<?>> data = this.acquireLearningData(txn);
                PQ pq = PQ.Companion.fromData(pQIndex.getConfig(), pQIndex.getColumns()[0], data);
                Object2ObjectOpenHashMap signatureMap = new Object2ObjectOpenHashMap((int)txn.count());
                Iterator $this$forEach$iv = txn.scan(this.getDbo().getColumns());
                boolean $i$f$forEach = false;
                Iterator<Object> iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Record rec = (Record)element$iv;
                    boolean bl3 = false;
                    Value value = rec.get(pQIndex.getColumns()[0]);
                    if (!(value instanceof VectorValue)) continue;
                    PQSignature sig = pq.getSignature((VectorValue)value);
                    signatureMap.compute((Object)sig, (arg_0, arg_1) -> Tx.rebuild$lambda-3$lambda-2$lambda-1(rec, arg_0, arg_1));
                }
                pQIndex.pqStore.set((Object)pq);
                pQIndex.signaturesStore.clear();
                for (Map.Entry entry : (ObjectSet)signatureMap.entrySet()) {
                    IndexTreeList indexTreeList = pQIndex.signaturesStore;
                    iterator = entry.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"entry.key");
                    PQSignature pQSignature = (PQSignature)((Object)iterator);
                    iterator = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"entry.value");
                    indexTreeList.add((Object)new PQIndexEntry(pQSignature, CollectionsKt.toLongArray((Collection)((Collection)((Object)iterator)))));
                }
                pQIndex.getDirtyField().compareAndSet(true, false);
                Companion.getLOGGER().debug("Rebuilding PQIndex {} complete.", (Object)pQIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation event) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx abstractTx = this;
            PQIndex pQIndex = PQIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                pQIndex.getDirtyField().compareAndSet(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            void this_$iv;
            AbstractTx abstractTx = this;
            PQIndex pQIndex = PQIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                pQIndex.getDirtyField().compareAndSet(false, true);
                pQIndex.signaturesStore.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return this.filterRange(predicate, 0, 1);
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(predicate, PQIndex.this, this, partitions, partitionIndex){
                @NotNull
                private final ProximityPredicate predicate;
                private final PQ pq;
                @NotNull
                private final double[][] lookupTable;
                @NotNull
                private final Lazy resultsQueue$delegate;
                @NotNull
                private final IntRange range;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ PQIndex this$0;
                final /* synthetic */ Tx this$1;
                final /* synthetic */ int $partitions;
                final /* synthetic */ int $partitionIndex;
                {
                    this.$predicate = $predicate;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$partitions = $partitions;
                    this.$partitionIndex = $partitionIndex;
                    if (!(this.$predicate instanceof ProximityPredicate)) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + this.this$0.getName() + "' (PQ Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass(this.$predicate.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (ProximityPredicate)this.$predicate;
                    this.pq = (PQ)PQIndex.access$getPqStore$p(this.this$0).get();
                    this.resultsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayDeque<StandaloneRecord>>(this){
                        final /* synthetic */ filterRange.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final ArrayDeque<StandaloneRecord> invoke() {
                            return filterRange.1.access$prepareResults(this.this$0);
                        }
                    }));
                    AbstractTx this_$iv = this.this$1;
                    boolean $i$f$withReadLock = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
                    readLock.lock();
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    Value value = this.predicate.getQuery().getValue();
                    if (!(value instanceof VectorValue)) {
                        boolean bl = false;
                        Value value2 = value;
                        String string = "Bound value for query vector has wrong type (found = " + (value2 == null ? null : value2.getType()) + ").";
                        throw new IllegalStateException(string.toString());
                    }
                    this.lookupTable = this.pq.getLookupTable-MSj3omc((VectorValue)value, this.predicate.getDistance());
                    int pSize = Math.floorDiv(PQIndex.access$getSignaturesStore$p(this.this$0).size(), this.$partitions) + 1;
                    this.range = RangesKt.until((int)(pSize * this.$partitionIndex), (int)Math.min(pSize * (this.$partitionIndex + 1), PQIndex.access$getSignaturesStore$p(this.this$0).size()));
                }

                private final ArrayDeque<StandaloneRecord> getResultsQueue() {
                    Lazy lazy = this.resultsQueue$delegate;
                    return (ArrayDeque)lazy.getValue();
                }

                public boolean hasNext() {
                    return !((Collection)this.getResultsQueue()).isEmpty();
                }

                @NotNull
                public Record next() {
                    return (Record)this.getResultsQueue().removeFirst();
                }

                private final ArrayDeque<StandaloneRecord> prepareResults() {
                    int n;
                    ArrayDeque queue = new ArrayDeque(this.predicate.getK());
                    EntityTx txn = (EntityTx)this.this$1.getContext().getTx(this.this$0.getParent());
                    int preKnnSize = (int)((double)this.predicate.getK() * 1.15);
                    MinHeapSelection<Comparable> preKnn = new MinHeapSelection<Comparable>(preKnnSize);
                    IntRange intRange = this.range;
                    int n2 = intRange.getFirst();
                    if (n2 <= (n = intRange.getLast())) {
                        int i;
                        do {
                            PQIndexEntry entry;
                            i = n2++;
                            PQIndexEntry pQIndexEntry = entry = (PQIndexEntry)PQIndex.access$getSignaturesStore$p(this.this$0).get(i);
                            Intrinsics.checkNotNull((Object)pQIndexEntry);
                            double approximation = PQLookupTable.approximateDistance-impl(this.lookupTable, pQIndexEntry.getSignature());
                            if (preKnn.getSize() >= this.predicate.getK()) {
                                T t = preKnn.peek();
                                Intrinsics.checkNotNull(t);
                                if (!(((Number)((ComparablePair)t).getSecond()).doubleValue() > approximation)) continue;
                            }
                            preKnn.offer(new ComparablePair<long[], Comparable>(entry.getTupleIds(), Double.valueOf(approximation)));
                        } while (i != n);
                    }
                    Value value = this.predicate.getQuery().getValue();
                    if (value == null) {
                        return queue;
                    }
                    Value queryArgument = value;
                    Selection knn = this.predicate.getK() == 1 ? (Selection)new MinSingleSelection<T>() : (Selection)new MinHeapSelection<T>(this.predicate.getK());
                    n = 0;
                    int n3 = preKnn.getSize();
                    while (n < n3) {
                        int j = n++;
                        long[] tupleIds = (long[])((ComparablePair)preKnn.get(j)).getFirst();
                        int n4 = 0;
                        int n5 = tupleIds.length;
                        while (n4 < n5) {
                            long tupleId = tupleIds[n4];
                            ++n4;
                            Value probingArgument = txn.read(tupleId, this.this$0.getColumns()).get(this.this$0.getColumns()[0]);
                            if (!(probingArgument instanceof VectorValue)) continue;
                            Value[] valueArray = new Value[]{queryArgument, probingArgument};
                            Value value2 = this.predicate.getDistance().invoke(valueArray);
                            Intrinsics.checkNotNull((Object)value2);
                            double distance = ((DoubleValue)value2).unbox-impl();
                            if (knn.getSize() >= this.predicate.getK()) {
                                T t = knn.peek();
                                Intrinsics.checkNotNull(t);
                                if (DoubleValue.compareTo-impl((double)((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), (Value)DoubleValue.box-impl((double)distance)) <= 0) continue;
                            }
                            knn.offer((Comparable)new ComparablePair<Long, DoubleValue>(tupleId, DoubleValue.box-impl((double)distance)));
                        }
                    }
                    n = 0;
                    n3 = knn.getSize();
                    while (n < n3) {
                        int i = n++;
                        Value[] valueArray = new Value[]{(Value)((ComparablePair)knn.get(i)).getSecond()};
                        queue.add((Object)new StandaloneRecord(((Number)((ComparablePair)knn.get(i)).getFirst()).longValue(), this.this$0.getProduces(), valueArray));
                    }
                    return queue;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }

                public static final /* synthetic */ ArrayDeque access$prepareResults(filterRange.1 $this) {
                    return $this.prepareResults();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        private final List<VectorValue<?>> acquireLearningData(EntityTx txn) {
            void $this$forEach$iv;
            LinkedList<Value> learningData = new LinkedList<Value>();
            SplittableRandom rng = new SplittableRandom(PQIndex.this.getConfig().getSeed());
            double learningDataFraction = (double)PQIndex.this.getConfig().getSampleSize() / (double)txn.count();
            Iterator iterator = txn.scan(this.getDbo().getColumns());
            PQIndex pQIndex = PQIndex.this;
            boolean $i$f$forEach = false;
            void var9_8 = $this$forEach$iv;
            while (var9_8.hasNext()) {
                Value value;
                Object element$iv = var9_8.next();
                Record it = (Record)element$iv;
                boolean bl = false;
                if (!(rng.nextDouble() <= learningDataFraction) || !((value = it.get(pQIndex.getColumns()[0])) instanceof VectorValue)) continue;
                learningData.add(value);
            }
            return learningData;
        }

        private static final LinkedList rebuild$lambda-3$lambda-2$lambda-1(Record $rec, PQSignature $noName_0, LinkedList v) {
            Intrinsics.checkNotNullParameter((Object)$rec, (String)"$rec");
            LinkedList linkedList = v;
            if (linkedList == null) {
                linkedList = new LinkedList();
            }
            LinkedList ret = linkedList;
            ret.add($rec.getTupleId());
            return ret;
        }
    }
}

