/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq.codebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.ml.clustering.CentroidCluster;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.pq.codebook.ClusterableWithIndex;
import org.vitrivr.cottontail.dbms.index.pq.codebook.PQCodebook;
import org.vitrivr.cottontail.storage.serializers.mapdb.DoubleVectorMapDBSerializer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B$\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0006J!\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\rH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0002\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\rH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001d\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0084\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0084\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0019\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001d\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00138VX\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/codebook/DoublePrecisionPQCodebook;", "Lorg/vitrivr/cottontail/dbms/index/pq/codebook/PQCodebook;", "Lorg/vitrivr/cottontail/core/values/DoubleVectorValue;", "centroids", "", "covMatrix", "(Ljava/util/List;Ljava/util/List;)V", "getCentroids", "()Ljava/util/List;", "getCovMatrix", "diffBuffer", "[D", "logicalSize", "", "getLogicalSize", "()I", "numberOfCentroids", "getNumberOfCentroids", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types;", "get", "ci", "get-nzrm-wA", "(I)[D", "quantizeSubspaceForVector", "v", "start", "quantizeSubspaceForVector-9RieNTE", "([DI)I", "Companion", "Serializer", "cottontaildb-dbms"})
public final class DoublePrecisionPQCodebook
implements PQCodebook<DoubleVectorValue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DoubleVectorValue> centroids;
    @NotNull
    private final List<DoubleVectorValue> covMatrix;
    @NotNull
    private final double[] diffBuffer;

    public DoublePrecisionPQCodebook(@NotNull List<DoubleVectorValue> centroids, @NotNull List<DoubleVectorValue> covMatrix) {
        Intrinsics.checkNotNullParameter(centroids, (String)"centroids");
        Intrinsics.checkNotNullParameter(covMatrix, (String)"covMatrix");
        this.centroids = centroids;
        this.covMatrix = covMatrix;
        this.diffBuffer = DoubleVectorValue.constructor-impl((double[])new double[this.getLogicalSize()]);
    }

    @NotNull
    protected final List<DoubleVectorValue> getCentroids() {
        return this.centroids;
    }

    @NotNull
    protected final List<DoubleVectorValue> getCovMatrix() {
        return this.covMatrix;
    }

    @Override
    @NotNull
    public Types<DoubleVectorValue> getType() {
        return (Types)new Types.DoubleVector(this.getLogicalSize());
    }

    @Override
    public int getNumberOfCentroids() {
        return this.centroids.size();
    }

    @Override
    public int getLogicalSize() {
        return DoubleVectorValue.getLogicalSize-impl((double[])this.centroids.get(0).unbox-impl());
    }

    @NotNull
    public double[] get-nzrm-wA(int ci) {
        return this.centroids.get(ci).unbox-impl();
    }

    public int quantizeSubspaceForVector-9RieNTE(@NotNull double[] v, int start) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int mahIndex = 0;
        double mah = Double.POSITIVE_INFINITY;
        int i = 0;
        Iterator<DoubleVectorValue> iterator = this.centroids.iterator();
        block0: while (iterator.hasNext()) {
            double[] c = iterator.next().unbox-impl();
            double dist = 0.0;
            int n = 0;
            int n2 = this.diffBuffer.length;
            while (n < n2) {
                int it = n++;
                this.diffBuffer[it] = c[it] - v[start + it];
            }
            int j = 0;
            Iterator<DoubleVectorValue> iterator2 = this.covMatrix.iterator();
            while (iterator2.hasNext()) {
                double[] m = iterator2.next().unbox-impl();
                int n3 = j;
                j = n3 + 1;
                dist = Math.fma(this.diffBuffer[n3], DoubleVectorValue.dot-iEH02FE((double[])m, (VectorValue)DoubleVectorValue.box-impl((double[])this.diffBuffer)), dist);
                if (!(dist >= mah)) continue;
                n3 = i;
                i = n3 + 1;
                continue block0;
            }
            if (dist < mah) {
                mah = dist;
                mahIndex = i;
            }
            int n4 = i;
            i = n4 + 1;
        }
        return mahIndex;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/codebook/DoublePrecisionPQCodebook$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/dbms/index/pq/codebook/DoublePrecisionPQCodebook;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb-dbms"})
    public static final class Serializer
    implements org.mapdb.Serializer<DoublePrecisionPQCodebook> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull DoublePrecisionPQCodebook value) {
            double[] v;
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.packInt(value.getLogicalSize());
            DoubleVectorMapDBSerializer vectorSerializer = new DoubleVectorMapDBSerializer(value.getLogicalSize());
            out.packInt(value.getCentroids().size());
            Iterator<DoubleVectorValue> iterator = value.getCentroids().iterator();
            while (iterator.hasNext()) {
                v = iterator.next().unbox-impl();
                vectorSerializer.serialize-AmBGWyM(out, v);
            }
            out.packInt(value.getCovMatrix().size());
            iterator = value.getCovMatrix().iterator();
            while (iterator.hasNext()) {
                v = iterator.next().unbox-impl();
                vectorSerializer.serialize-AmBGWyM(out, v);
            }
        }

        @NotNull
        public DoublePrecisionPQCodebook deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            int logicalSize = input.unpackInt();
            DoubleVectorMapDBSerializer vectorSerializer = new DoubleVectorMapDBSerializer(logicalSize);
            int centroidsSize = input.unpackInt();
            ArrayList<DoubleVectorValue> centroids = new ArrayList<DoubleVectorValue>(centroidsSize);
            int n = 0;
            while (n < centroidsSize) {
                int i = n++;
                centroids.add(DoubleVectorValue.box-impl((double[])vectorSerializer.deserialize-zqGldYU(input, available)));
            }
            int covMatrixSize = input.unpackInt();
            ArrayList<DoubleVectorValue> covMatrix = new ArrayList<DoubleVectorValue>(covMatrixSize);
            int n2 = 0;
            while (n2 < covMatrixSize) {
                int i = n2++;
                covMatrix.add(DoubleVectorValue.box-impl((double[])vectorSerializer.deserialize-zqGldYU(input, available)));
            }
            return new DoublePrecisionPQCodebook((List<DoubleVectorValue>)centroids, (List<DoubleVectorValue>)covMatrix);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/codebook/DoublePrecisionPQCodebook$Companion;", "", "()V", "learnFromData", "Lorg/vitrivr/cottontail/dbms/index/pq/codebook/DoublePrecisionPQCodebook;", "subspaceData", "", "Lorg/vitrivr/cottontail/core/values/DoubleVectorValue;", "numCentroids", "", "seed", "", "maxIterations", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final DoublePrecisionPQCodebook learnFromData(@NotNull List<DoubleVectorValue> subspaceData, int numCentroids, long seed, int maxIterations) {
            void $this$mapTo$iv$iv;
            int n;
            Intrinsics.checkNotNullParameter(subspaceData, (String)"subspaceData");
            int n2 = 0;
            int n3 = subspaceData.size();
            double[][] dArrayArray = new double[n3][];
            while (n2 < n3) {
                n = n2++;
                dArrayArray[n] = subspaceData.get(n).unbox-impl();
            }
            double[][] array = dArrayArray;
            RealMatrix covMatrix = new Covariance((double[][])array, false).getCovarianceMatrix();
            Intrinsics.checkNotNullExpressionValue((Object)covMatrix, (String)"covMatrix");
            List<CentroidCluster<ClusterableWithIndex>> centroidClusters2 = PQCodebook.Companion.clusterRealData(array, covMatrix, numCentroids, seed, maxIterations);
            ArrayList<DoubleVectorValue> centroids = new ArrayList<DoubleVectorValue>(numCentroids);
            n = 0;
            while (n < numCentroids) {
                int i = n++;
                double[] dArray = centroidClusters2.get(i).getCenter().getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)dArray, (String)"centroidClusters[i].center.point");
                centroids.add(DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])dArray)));
            }
            double[][] i = covMatrix.getData();
            Intrinsics.checkNotNullExpressionValue((Object)i, (String)"covMatrix.data");
            Object[] $this$map$iv = (Object[])i;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                double[] dArray = (double[])item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])it)));
            }
            List dataCovMatrix = (List)destination$iv$iv;
            return new DoublePrecisionPQCodebook((List<DoubleVectorValue>)centroids, dataCovMatrix);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

