/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.va;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.Atomic;
import org.mapdb.IndexTreeList;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.functions.math.MinkowskiDistance;
import org.vitrivr.cottontail.core.queries.functions.math.VectorDistance;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.types.RealVectorValue;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.exceptions.TxException;
import org.vitrivr.cottontail.dbms.execution.TransactionContext;
import org.vitrivr.cottontail.dbms.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.dbms.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.dbms.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.TxStatus;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.va.VAFIndex;
import org.vitrivr.cottontail.dbms.index.va.VAFIndexConfig;
import org.vitrivr.cottontail.dbms.index.va.bounds.Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L1Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L2Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L2SBounds;
import org.vitrivr.cottontail.dbms.index.va.signature.Marks;
import org.vitrivr.cottontail.dbms.index.va.signature.MarksGenerator;
import org.vitrivr.cottontail.dbms.index.va.signature.VAFSignature;
import org.vitrivr.cottontail.dbms.locking.LockMode;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.dbms.statistics.columns.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.FloatVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.IntVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.LongVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.utilities.math.KnnUtilities;
import org.vitrivr.cottontail.utilities.selection.ComparablePair;
import org.vitrivr.cottontail.utilities.selection.MinHeapSelection;
import org.vitrivr.cottontail.utilities.selection.MinSingleSelection;
import org.vitrivr.cottontail.utilities.selection.Selection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0002,-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020#H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b&\u0010'J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006."}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "path", "Ljava/nio/file/Path;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "config", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndexConfig;", "(Ljava/nio/file/Path;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;Lorg/vitrivr/cottontail/dbms/index/va/VAFIndexConfig;)V", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/va/VAFIndexConfig;", "marksStore", "Lorg/mapdb/Atomic$Var;", "Lorg/vitrivr/cottontail/dbms/index/va/signature/Marks;", "produces", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getProduces", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "signatures", "Lorg/mapdb/IndexTreeList;", "Lorg/vitrivr/cottontail/dbms/index/va/signature/VAFSignature;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "cost", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "cost-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class VAFIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColumnDef<?>[] produces;
    @NotNull
    private final IndexType type;
    @NotNull
    private final VAFIndexConfig config;
    @NotNull
    private final Atomic.Var<Marks> marksStore;
    @NotNull
    private final IndexTreeList<VAFSignature> signatures;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private static final String VAF_INDEX_SIGNATURES_FIELD = "vaf_signatures";
    @NotNull
    private static final String VAF_INDEX_MARKS_FIELD = "vaf_marks";
    @NotNull
    private static final Logger LOGGER;

    public VAFIndex(@NotNull Path path, @NotNull DefaultEntity parent, @Nullable VAFIndexConfig config) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(path, parent);
        ColumnDef[] columnDefArray = new ColumnDef[]{KnnUtilities.INSTANCE.distanceColumnDef(this.getParent().getName())};
        this.produces = columnDefArray;
        this.type = IndexType.VAF;
        this.marksStore = (Atomic.Var)this.getStore().atomicVar(VAF_INDEX_MARKS_FIELD, (Serializer)Marks.Serializer).createOrOpen();
        this.signatures = (IndexTreeList)this.getStore().indexTreeList(VAF_INDEX_SIGNATURES_FIELD, (Serializer)VAFSignature.Serializer).createOrOpen();
        if (!(this.getColumns().length == 1)) {
            boolean bl = false;
            String string = Companion + " only supports indexing a single column.";
            throw new IllegalArgumentException(string.toString());
        }
        Atomic.Var configOnDisk = (Atomic.Var)this.getStore().atomicVar("cdb_index_config", (Serializer)VAFIndexConfig.Serializer).createOrOpen();
        if (configOnDisk.get() == null) {
            this.config = config != null ? config : new VAFIndexConfig(50);
            configOnDisk.set((Object)this.getConfig());
        } else {
            Object object = configOnDisk.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"configOnDisk.get()");
            this.config = (VAFIndexConfig)object;
        }
        this.getStore().commit();
        this.supportsPartitioning = true;
    }

    public /* synthetic */ VAFIndex(Path path, DefaultEntity defaultEntity, VAFIndexConfig vAFIndexConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            vAFIndexConfig = null;
        }
        this(path, defaultEntity, vAFIndexConfig);
    }

    @Override
    @NotNull
    public ColumnDef<?>[] getProduces() {
        return this.produces;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public VAFIndexConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public float[] cost-7eHliGg(@NotNull Predicate predicate) {
        int n;
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        if (!(predicate instanceof ProximityPredicate)) {
            return Cost.Companion.getINVALID-7CRCzCo();
        }
        if (!Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn(), this.getColumns()[0])) {
            return Cost.Companion.getINVALID-7CRCzCo();
        }
        if (!(((ProximityPredicate)predicate).getDistance() instanceof MinkowskiDistance)) {
            return Cost.Companion.getINVALID-7CRCzCo();
        }
        int n2 = this.signatures.size();
        ColumnDef<?>[] columnDefArray = this.marksStore.get();
        Intrinsics.checkNotNullExpressionValue((Object)columnDefArray, (String)"this.marksStore.get()");
        float f = (float)(n2 * Marks.getD-impl(((Marks)columnDefArray).unbox-impl())) * Cost.getCpu-impl((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo()) + 0.1f * ((float)(this.signatures.size() * this.getColumns()[0].getType().getPhysicalSize()) * Cost.getCpu-impl((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo()));
        int n3 = this.signatures.size();
        columnDefArray = this.marksStore.get();
        Intrinsics.checkNotNullExpressionValue((Object)columnDefArray, (String)"this.marksStore.get()");
        float f2 = (float)(n3 * Marks.getD-impl(((Marks)columnDefArray).unbox-impl())) * ((float)2 * Cost.getCpu-impl((float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo()) + Cost.getCpu-impl((float[])Cost.Companion.getFLOP-7CRCzCo()));
        columnDefArray = this.getProduces();
        float f3 = ((ProximityPredicate)predicate).getK();
        float f4 = f2;
        float f5 = f;
        int n4 = 0;
        for (ColumnDef<?> columnDef : columnDefArray) {
            void it;
            ColumnDef<?> columnDef2 = columnDef;
            n = n4;
            boolean bl = false;
            int n5 = it.getType().getPhysicalSize();
            n4 = n + n5;
        }
        n = n4;
        return Cost.plus-wQ19W7k((float[])Cost.constructor-impl$default((float)f5, (float)f4, (float)(f3 * (float)n), (float)0.0f, (int)8, null), (float[])Cost.times-7eHliGg((float[])Cost.times-7eHliGg((float[])predicate.getCost-7CRCzCo(), (Number)Float.valueOf(0.1f)), (Number)this.signatures.size()));
    }

    @Override
    public boolean canProcess(@NotNull Predicate predicate) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        return predicate instanceof ProximityPredicate && Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn(), this.getColumns()[0]);
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    static {
        Logger logger = LoggerFactory.getLogger(VAFIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(VAFIndex::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "VAF_INDEX_MARKS_FIELD", "", "VAF_INDEX_SIGNATURES_FIELD", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;Lorg/vitrivr/cottontail/dbms/execution/TransactionContext;)V", "clear", "", "count", "", "filter", "", "Lorg/vitrivr/cottontail/core/basics/Record;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "filterRange", "partitionIndex", "", "partitions", "rebuild", "update", "event", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractIndex.Tx {
        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)VAFIndex.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public long count() {
            long l;
            void this_$iv;
            AbstractTx abstractTx = this;
            VAFIndex vAFIndex = VAFIndex.this;
            boolean $i$f$withReadLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
            ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
            readLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                l = vAFIndex.signatures.size();
            }
            finally {
                readLock.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void rebuild() {
            void this_$iv;
            AbstractTx abstractTx = this;
            VAFIndex vAFIndex = VAFIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                int $i$f$forEach;
                int n4;
                boolean bl = false;
                boolean bl2 = false;
                Companion.getLOGGER().debug("Rebuilding VAF index {}", (Object)vAFIndex.getName());
                EntityTx txn = (EntityTx)this.getContext().getTx(vAFIndex.getParent());
                ValueStatistics<?> stat = this.getDbo().getParent().getStatistics().get(vAFIndex.getColumns()[0]);
                double[] min = new double[vAFIndex.getColumns()[0].getType().getLogicalSize()];
                double[] max = new double[vAFIndex.getColumns()[0].getType().getLogicalSize()];
                ValueStatistics<?> valueStatistics = stat;
                if (valueStatistics instanceof FloatVectorValueStatistics) {
                    int n5 = min.length;
                    n4 = 0;
                    while (n4 < n5) {
                        int n6;
                        int it = n6 = n4++;
                        boolean bl3 = false;
                        min[it] = ((FloatVectorValueStatistics)stat).getMin-JdBqzJc()[it];
                        max[it] = ((FloatVectorValueStatistics)stat).getMax-JdBqzJc()[it];
                    }
                } else if (valueStatistics instanceof DoubleVectorValueStatistics) {
                    int n7 = min.length;
                    n4 = 0;
                    while (n4 < n7) {
                        int n8;
                        int it = n8 = n4++;
                        boolean bl4 = false;
                        min[it] = ((DoubleVectorValueStatistics)stat).getMin-aM0kQ94()[it];
                        max[it] = ((DoubleVectorValueStatistics)stat).getMax-aM0kQ94()[it];
                    }
                } else if (valueStatistics instanceof IntVectorValueStatistics) {
                    int n9 = min.length;
                    n4 = 0;
                    while (n4 < n9) {
                        int n10;
                        int it = n10 = n4++;
                        boolean bl5 = false;
                        min[it] = ((IntVectorValueStatistics)stat).getMin-NP4WLaU()[it];
                        max[it] = ((IntVectorValueStatistics)stat).getMax-NP4WLaU()[it];
                    }
                } else if (valueStatistics instanceof LongVectorValueStatistics) {
                    int n11 = min.length;
                    n4 = 0;
                    while (n4 < n11) {
                        int n12;
                        int it = n12 = n4++;
                        boolean bl6 = false;
                        min[it] = ((LongVectorValueStatistics)stat).getMin-KCB4rAk()[it];
                        max[it] = ((LongVectorValueStatistics)stat).getMax-KCB4rAk()[it];
                    }
                } else {
                    Iterator $this$forEach$iv = txn.scan(vAFIndex.getColumns());
                    $i$f$forEach = 0;
                    Iterator iterator = $this$forEach$iv;
                    while (iterator.hasNext()) {
                        Object element$iv = iterator.next();
                        Record r = (Record)element$iv;
                        boolean bl7 = false;
                        Value value = r.get(vAFIndex.getColumns()[0]);
                        if (value == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.VectorValue<*>");
                        }
                        VectorValue value2 = (VectorValue)value;
                        int n13 = 0;
                        int n14 = value2.getLogicalSize();
                        while (n13 < n14) {
                            int i = n13++;
                            min[i] = Math.min(min[i], value2.get(i).asDouble-5B6OyQQ());
                            max[i] = Math.max(max[i], value2.get(i).asDouble-5B6OyQQ());
                        }
                    }
                }
                int $this$forEach$iv = 0;
                $i$f$forEach = vAFIndex.getColumns()[0].getType().getLogicalSize();
                Object object = new int[$i$f$forEach];
                double[] dArray = max;
                double[] dArray2 = min;
                MarksGenerator marksGenerator = MarksGenerator.INSTANCE;
                while ($this$forEach$iv < $i$f$forEach) {
                    int element$iv = $this$forEach$iv++;
                    object[element$iv] = vAFIndex.getConfig().getMarksPerDimension();
                }
                double[][] marks = marksGenerator.getEquidistantMarks-fNqUH2g(dArray2, dArray, (int[])object);
                vAFIndex.marksStore.set((Object)Marks.box-impl(marks));
                vAFIndex.signatures.clear();
                Iterator $this$forEach$iv2 = txn.scan(vAFIndex.getColumns());
                $i$f$forEach = 0;
                object = $this$forEach$iv2;
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    Record r = (Record)element$iv;
                    boolean bl8 = false;
                    Value value = r.get(vAFIndex.getColumns()[0]);
                    if (!(value instanceof RealVectorValue)) continue;
                    vAFIndex.signatures.add((Object)new VAFSignature(r.getTupleId(), Marks.getCells-impl(marks, (RealVectorValue)value)));
                }
                vAFIndex.getDirtyField().compareAndSet(true, false);
                Companion.getLOGGER().debug("Done rebuilding VAF index {}", (Object)vAFIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n15 = 0;
                while (n15 < n) {
                    int n16 = n15++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation event) {
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            AbstractTx abstractTx = this;
            VAFIndex vAFIndex = VAFIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                vAFIndex.getDirtyField().compareAndSet(false, true);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void clear() {
            void this_$iv;
            AbstractTx abstractTx = this;
            VAFIndex vAFIndex = VAFIndex.this;
            boolean $i$f$withWriteLock = false;
            if (this_$iv.getStatus() == TxStatus.CLOSED) {
                throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
            }
            if (this_$iv.getStatus() == TxStatus.ERROR) {
                throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
            }
            this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.EXCLUSIVE);
            AbstractTx.access$setStatus((AbstractTx)this_$iv, TxStatus.DIRTY);
            ReentrantReadWriteLock reentrantReadWriteLock = this_$iv.getTxLatch();
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2++;
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl = false;
                boolean bl2 = false;
                vAFIndex.getDirtyField().compareAndSet(false, true);
                vAFIndex.signatures.clear();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                int n4 = 0;
                while (n4 < n) {
                    int n5 = n4++;
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        @NotNull
        public Iterator<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return this.filterRange(predicate, 0, 1);
        }

        @Override
        @NotNull
        public Iterator<Record> filterRange(@NotNull Predicate predicate, int partitionIndex, int partitions) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return new Iterator<Record>(predicate, VAFIndex.this, this, partitions, partitionIndex){
                @NotNull
                private final ProximityPredicate predicate;
                @NotNull
                private final RealVectorValue<?> query;
                private final double[][] marks;
                @NotNull
                private final Bounds bounds;
                @NotNull
                private final Lazy resultsQueue$delegate;
                @NotNull
                private final IntRange range;
                final /* synthetic */ Predicate $predicate;
                final /* synthetic */ VAFIndex this$0;
                final /* synthetic */ Tx this$1;
                final /* synthetic */ int $partitions;
                final /* synthetic */ int $partitionIndex;
                {
                    Bounds bounds;
                    this.$predicate = $predicate;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    this.$partitions = $partitions;
                    this.$partitionIndex = $partitionIndex;
                    if (!(this.$predicate instanceof ProximityPredicate)) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + this.this$0.getName() + "' (VAF Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass(this.$predicate.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (ProximityPredicate)this.$predicate;
                    Marks marks = (Marks)VAFIndex.access$getMarksStore$p(this.this$0).get();
                    this.marks = (double[][])(marks != null ? marks.unbox-impl() : null);
                    this.resultsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayDeque<StandaloneRecord>>(this){
                        final /* synthetic */ filterRange.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final ArrayDeque<StandaloneRecord> invoke() {
                            return filterRange.1.access$prepareResults(this.this$0);
                        }
                    }));
                    AbstractTx this_$iv = this.this$1;
                    boolean $i$f$withReadLock22 = false;
                    if (this_$iv.getStatus() == TxStatus.CLOSED) {
                        throw new TxException.TxClosedException(this_$iv.getContext().getTxId());
                    }
                    if (this_$iv.getStatus() == TxStatus.ERROR) {
                        throw new TxException.TxInErrorException(this_$iv.getContext().getTxId());
                    }
                    this_$iv.getContext().requestLock(this_$iv.getDbo(), LockMode.SHARED);
                    ReentrantReadWriteLock.ReadLock readLock = this_$iv.getTxLatch().readLock();
                    readLock.lock();
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        readLock.unlock();
                    }
                    Value value = this.predicate.getQuery().getValue();
                    if (!(value instanceof RealVectorValue)) {
                        boolean bl = false;
                        Value value2 = value;
                        String string = "Bound value for query vector has wrong type (found = " + (value2 == null ? null : value2.getType()) + ").";
                        throw new IllegalStateException(string.toString());
                    }
                    this.query = (RealVectorValue)value;
                    VectorDistance $i$f$withReadLock22 = this.predicate.getDistance();
                    if ($i$f$withReadLock22 instanceof ManhattanDistance) {
                        Marks marks2 = this.marks != null ? Marks.box-impl(this.marks) : null;
                        Intrinsics.checkNotNullExpressionValue((Object)marks2, (String)"this.marks");
                        bounds = new L1Bounds(this.query, marks2.unbox-impl(), null);
                    } else if ($i$f$withReadLock22 instanceof EuclideanDistance) {
                        Marks marks3 = this.marks != null ? Marks.box-impl(this.marks) : null;
                        Intrinsics.checkNotNullExpressionValue((Object)marks3, (String)"this.marks");
                        bounds = new L2Bounds(this.query, marks3.unbox-impl(), null);
                    } else if ($i$f$withReadLock22 instanceof SquaredEuclideanDistance) {
                        Marks marks4 = this.marks != null ? Marks.box-impl(this.marks) : null;
                        Intrinsics.checkNotNullExpressionValue((Object)marks4, (String)"this.marks");
                        bounds = new L2SBounds(this.query, marks4.unbox-impl(), null);
                    } else {
                        throw new IllegalArgumentException("The " + this.predicate.getDistance() + " distance kernel is not supported by VAFIndex.");
                    }
                    this.bounds = bounds;
                    int pSize = Math.floorDiv(VAFIndex.access$getSignatures$p(this.this$0).size(), this.$partitions) + 1;
                    this.range = RangesKt.until((int)(pSize * this.$partitionIndex), (int)Math.min(pSize * (this.$partitionIndex + 1), VAFIndex.access$getSignatures$p(this.this$0).size()));
                }

                private final ArrayDeque<StandaloneRecord> getResultsQueue() {
                    Lazy lazy = this.resultsQueue$delegate;
                    return (ArrayDeque)lazy.getValue();
                }

                public boolean hasNext() {
                    return !((Collection)this.getResultsQueue()).isEmpty();
                }

                @NotNull
                public Record next() {
                    return (Record)this.getResultsQueue().removeFirst();
                }

                private final ArrayDeque<StandaloneRecord> prepareResults() {
                    int n;
                    ArrayDeque queue = new ArrayDeque(this.predicate.getK());
                    EntityTx txn = (EntityTx)this.this$1.getContext().getTx(this.this$0.getParent());
                    Selection knn = this.predicate.getK() == 1 ? (Selection)new MinSingleSelection<T>() : (Selection)new MinHeapSelection<T>(this.predicate.getK());
                    Value value = this.predicate.getQuery().getValue();
                    if (value == null) {
                        return queue;
                    }
                    Value queryArgument = value;
                    long read = 0L;
                    IntRange intRange = this.range;
                    int n2 = intRange.getFirst();
                    if (n2 <= (n = intRange.getLast())) {
                        int sigIndex;
                        do {
                            Value probingArgument;
                            sigIndex = n2++;
                            VAFSignature signature = (VAFSignature)VAFIndex.access$getSignatures$p(this.this$0).get(sigIndex);
                            if (signature == null) continue;
                            if (knn.getSize() >= this.predicate.getK()) {
                                T t = knn.peek();
                                Intrinsics.checkNotNull(t);
                                if (!this.bounds.isVASSACandidate(signature, ((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl())) continue;
                            }
                            if (!((probingArgument = txn.read(signature.getTupleId(), this.this$0.getColumns()).get(this.this$0.getColumns()[0])) instanceof VectorValue)) continue;
                            Value[] valueArray = new Value[]{queryArgument, probingArgument};
                            DoubleValue distance = (DoubleValue)this.predicate.getDistance().invoke(valueArray);
                            Long l = signature.getTupleId();
                            DoubleValue doubleValue = distance;
                            Intrinsics.checkNotNull((Object)doubleValue);
                            knn.offer((Comparable)new ComparablePair<Long, Comparable>(l, (Comparable)doubleValue));
                            ++read;
                        } while (sigIndex != n);
                    }
                    double skipped = (1.0 - (double)read / (double)VAFIndex.access$getSignatures$p(this.this$0).size()) * (double)100;
                    VAFIndex.Companion.getLOGGER().debug("VA-file scan: Skipped over " + skipped + "% of entries.");
                    n = 0;
                    int n3 = knn.getSize();
                    while (n < n3) {
                        int i = n++;
                        Value[] valueArray = new Value[]{(Value)((ComparablePair)knn.get(i)).getSecond()};
                        queue.add((Object)new StandaloneRecord(((Number)((ComparablePair)knn.get(i)).getFirst()).longValue(), this.this$0.getProduces(), valueArray));
                    }
                    return queue;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }

                public static final /* synthetic */ ArrayDeque access$prepareResults(filterRange.1 $this) {
                    return $this.prepareResults();
                }
            };
        }
    }
}

