/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.va.bounds;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.values.types.RealVectorValue;
import org.vitrivr.cottontail.dbms.index.va.bounds.Bounds;
import org.vitrivr.cottontail.dbms.index.va.signature.Marks;
import org.vitrivr.cottontail.dbms.index.va.signature.VAFSignature;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B$\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0010\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/bounds/LpBounds;", "Lorg/vitrivr/cottontail/dbms/index/va/bounds/Bounds;", "query", "Lorg/vitrivr/cottontail/core/values/types/RealVectorValue;", "marks", "Lorg/vitrivr/cottontail/dbms/index/va/signature/Marks;", "p", "", "(Lorg/vitrivr/cottontail/core/values/types/RealVectorValue;[[DILkotlin/jvm/internal/DefaultConstructorMarker;)V", "exp", "", "lat", "", "", "[[[D", "<set-?>", "lb", "getLb", "()D", "getP", "()I", "rq", "", "ub", "getUb", "isVASSACandidate", "", "signature", "Lorg/vitrivr/cottontail/dbms/index/va/signature/VAFSignature;", "threshold", "update", "cottontaildb-dbms"})
public final class LpBounds
implements Bounds {
    private final int p;
    private double lb;
    private double ub;
    private final double exp;
    @NotNull
    private final int[] rq;
    @NotNull
    private final double[][][] lat;

    private LpBounds(RealVectorValue<?> query2, double[][] marks, int p) {
        this.p = p;
        this.exp = 1.0 / (double)this.p;
        this.rq = Marks.getCells-impl(marks, query2);
        int n = ((Object[])marks).length;
        double[][][] dArrayArray = new double[n][][];
        LpBounds lpBounds = this;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            double qj = query2.get(n2).getValue().doubleValue();
            int n3 = 0;
            int n4 = marks[n2].length;
            double[][] dArrayArray2 = new double[n4][];
            int n5 = n2;
            double[][][] dArrayArray3 = dArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                double[] dArray = new double[]{Math.pow(qj - marks[n2][n6], this.p), Math.pow(marks[n2][n6] - qj, this.p)};
                dArrayArray2[n6] = dArray;
            }
            dArrayArray3[n5] = dArrayArray2;
        }
        lpBounds.lat = dArrayArray;
    }

    public final int getP() {
        return this.p;
    }

    @Override
    public double getLb() {
        return this.lb;
    }

    @Override
    public double getUb() {
        return this.ub;
    }

    @Override
    @NotNull
    public LpBounds update(@NotNull VAFSignature signature) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.lb = 0.0;
        this.ub = 0.0;
        int[] ri = signature.getCells();
        int n = 0;
        int n2 = signature.getCells().length;
        while (n < n2) {
            int j = n++;
            if (ri[j] < this.rq[j]) {
                this.lb = this.getLb() + this.lat[j][ri[j] + 1][0];
                this.ub = this.getUb() + this.lat[j][ri[j]][0];
                continue;
            }
            if (ri[j] == this.rq[j]) {
                this.ub = this.getUb() + Math.max(this.lat[j][ri[j]][0], this.lat[j][ri[j] + 1][1]);
                continue;
            }
            if (ri[j] <= this.rq[j]) continue;
            this.lb = this.getLb() + this.lat[j][ri[j]][1];
            this.ub = this.getUb() + this.lat[j][ri[j] + 1][1];
        }
        this.lb = Math.pow(this.getLb(), this.exp);
        this.ub = Math.pow(this.getUb(), this.exp);
        return this;
    }

    @Override
    public boolean isVASSACandidate(@NotNull VAFSignature signature, double threshold) {
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        double tsquared = Math.pow(threshold, this.p);
        double lb = 0.0;
        int[] nArray = signature.getCells();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int j = n;
            int rij = nArray[n];
            ++n;
            if (rij < this.rq[j]) {
                lb += this.lat[j][rij + 1][0];
            } else if (rij > this.rq[j]) {
                lb += this.lat[j][rij][1];
            }
            if (!(lb >= tsquared)) continue;
            return false;
        }
        return lb < tsquared;
    }

    public /* synthetic */ LpBounds(RealVectorValue query2, double[][] marks, int p, DefaultConstructorMarker $constructor_marker) {
        this(query2, marks, p);
    }
}

