/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.queries.binding;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.queries.binding.BindingContext;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\"\u0010\u000f\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tH\u0016J\u0014\u0010\u001b\u001a\u00020\u00192\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\u0013\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0010H\u0096\u0002J\u0013\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0013H\u0096\u0002J\u0013\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u0019H\u0096\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000eH\u0016J\u001a\u0010!\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0016R&\u0010\u0005\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bj\n\u0012\u0006\u0012\u0004\u0018\u00010\t`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/binding/DefaultBindingContext;", "Lorg/vitrivr/cottontail/core/queries/binding/BindingContext;", "startSize", "", "(I)V", "boundFunctions", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenHashMap;", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Closed;", "", "Lorg/vitrivr/cottontail/core/values/types/Value;", "boundLiterals", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "boundRecord", "Lorg/vitrivr/cottontail/core/basics/Record;", "bind", "Lorg/vitrivr/cottontail/core/queries/binding/Binding$Column;", "column", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "Lorg/vitrivr/cottontail/core/queries/binding/Binding$Function;", "function", "Lorg/vitrivr/cottontail/core/queries/functions/Function;", "arguments", "", "Lorg/vitrivr/cottontail/core/queries/binding/Binding;", "Lorg/vitrivr/cottontail/core/queries/binding/Binding$Literal;", "value", "bindNull", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "copy", "get", "binding", "update", "", "record", "cottontaildb-dbms"})
public final class DefaultBindingContext
implements BindingContext {
    @NotNull
    private final ArrayList<Value> boundLiterals;
    @NotNull
    private final Object2ObjectOpenHashMap<Signature.Closed<?>, Value[]> boundFunctions;
    @Nullable
    private Record boundRecord;

    public DefaultBindingContext(int startSize) {
        this.boundLiterals = new ArrayList(startSize);
        this.boundFunctions = new Object2ObjectOpenHashMap();
    }

    public /* synthetic */ DefaultBindingContext(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        this(n);
    }

    @Nullable
    public Value get(@NotNull Binding.Literal binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        if (!Intrinsics.areEqual((Object)binding.getContext(), (Object)this)) {
            boolean bl = false;
            String string = "The given binding " + binding + " has not been registered with this binding context.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.boundLiterals.get(binding.getBindingIndex());
    }

    @Nullable
    public Value get(@NotNull Binding.Column binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        if (!Intrinsics.areEqual((Object)binding.getContext(), (Object)this)) {
            boolean bl = false;
            String string = "The given binding " + binding + " has not been registered with this binding context.";
            throw new IllegalArgumentException(string.toString());
        }
        Record record = this.boundRecord;
        return record == null ? null : record.get(binding.getColumn());
    }

    @Nullable
    public Value get(@NotNull Binding.Function binding) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        if (!Intrinsics.areEqual((Object)binding.getContext(), (Object)this)) {
            boolean bl = false;
            String string = "The given binding " + binding + " has not been registered with this binding context.";
            throw new IllegalArgumentException(string.toString());
        }
        Value[] valueArray = (Value[])this.boundFunctions.get((Object)binding.getFunction().getSignature());
        if (valueArray == null) {
            throw new IllegalStateException("No arguments array registered for function " + binding.getFunction() + '.');
        }
        Value[] arguments = valueArray;
        Iterator iterator = binding.getArguments().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Binding a = (Binding)iterator.next();
            arguments[i] = a.getValue();
        }
        return binding.getFunction().invoke(Arrays.copyOf(arguments, arguments.length));
    }

    @NotNull
    public Binding.Literal bind(@NotNull Value value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int bindingIndex = this.boundLiterals.size();
        if (!this.boundLiterals.add(value)) {
            boolean bl = false;
            String string = "Failed to add " + value + " to list of bound values for index " + bindingIndex + '.';
            throw new IllegalStateException(string.toString());
        }
        return new Binding.Literal(bindingIndex, value.getType(), (BindingContext)this);
    }

    @NotNull
    public Binding.Literal bindNull(@NotNull Types<?> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        int bindingIndex = this.boundLiterals.size();
        if (!this.boundLiterals.add(null)) {
            boolean bl = false;
            String string = "Failed to add null to list of bound values for index " + bindingIndex + '.';
            throw new IllegalStateException(string.toString());
        }
        return new Binding.Literal(bindingIndex, type, (BindingContext)this);
    }

    @NotNull
    public Binding.Column bind(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return new Binding.Column(column, (BindingContext)this);
    }

    @NotNull
    public Binding.Function bind(@NotNull Function<?> function, @NotNull List<? extends Binding> arguments) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(function, (String)"function");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            Iterable $this$all$iv = arguments;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Binding it = (Binding)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getContext(), (Object)this)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Failed to create function binding. Cannot combine function call with arguments from different cntext.";
            throw new IllegalStateException(string.toString());
        }
        this.boundFunctions.putIfAbsent((Object)function.getSignature(), (Object)new Value[arguments.size()]);
        return new Binding.Function(function, arguments, (BindingContext)this);
    }

    public void update(@NotNull Binding.Literal binding, @Nullable Value value) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        if (!Intrinsics.areEqual((Object)binding.getContext(), (Object)this)) {
            boolean $i$a$-require-DefaultBindingContext$update$32 = false;
            String $i$a$-require-DefaultBindingContext$update$32 = "The given binding " + binding + " has not been registered with this binding context.";
            throw new IllegalArgumentException($i$a$-require-DefaultBindingContext$update$32.toString());
        }
        if (!(value == null || binding.getType().compatible(value))) {
            boolean bl = false;
            String string = "Value " + value + " cannot be bound to " + binding + " because of type mismatch (" + binding.getType() + ").";
            throw new IllegalArgumentException(string.toString());
        }
        this.boundLiterals.set(binding.getBindingIndex(), value);
    }

    public void update(@NotNull Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        this.boundRecord = record;
    }

    @NotNull
    public BindingContext copy() {
        Object element$iv;
        DefaultBindingContext copy = new DefaultBindingContext(this.boundLiterals.size());
        Object $this$forEach$iv = this.boundLiterals;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            Value it = (Value)element$iv;
            boolean bl = false;
            copy.boundLiterals.add(it);
        }
        $this$forEach$iv = (Map)this.boundFunctions;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object $dstr$k$v = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            Signature.Closed k = (Signature.Closed)$dstr$k$v.getKey();
            Value[] v = (Value[])$dstr$k$v.getValue();
            Map map2 = (Map)copy.boundFunctions;
            Intrinsics.checkNotNullExpressionValue((Object)v, (String)"v");
            Value[] valueArray = v;
            Value[] valueArray2 = Arrays.copyOf(valueArray, valueArray.length);
            Intrinsics.checkNotNullExpressionValue((Object)valueArray2, (String)"copyOf(this, size)");
            valueArray = valueArray2;
            map2.put(k, valueArray);
        }
        copy.boundRecord = this.boundRecord;
        return copy;
    }

    public DefaultBindingContext() {
        this(0, 1, null);
    }
}

