/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.queries.binding;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.values.types.Value;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B1\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0001H\u0016J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0096\u0002J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u0014\u0010\u001b\u001a\u00020\u00172\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0007H\u0016J\u001b\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u001f\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u0018\u0010\u001f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00150 H\u0016R \u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/queries/binding/RecordBinding;", "Lorg/vitrivr/cottontail/core/basics/Record;", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "values", "Lorg/vitrivr/cottontail/core/queries/binding/Binding$Literal;", "(J[Lorg/vitrivr/cottontail/core/database/ColumnDef;[Lorg/vitrivr/cottontail/core/queries/binding/Binding$Literal;)V", "getColumns", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getTupleId", "()J", "setTupleId", "(J)V", "[Lorg/vitrivr/cottontail/core/queries/binding/Binding$Literal;", "copy", "get", "Lorg/vitrivr/cottontail/core/values/types/Value;", "index", "", "column", "has", "", "indexOf", "set", "", "value", "toMap", "", "cottontaildb-dbms"})
public final class RecordBinding
implements Record {
    private long tupleId;
    @NotNull
    private final ColumnDef<?>[] columns;
    @NotNull
    private final Binding.Literal[] values;

    public RecordBinding(long tupleId, @NotNull ColumnDef<?>[] columns, @NotNull Binding.Literal[] values) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this.tupleId = tupleId;
        this.columns = columns;
        this.values = values;
    }

    public long getTupleId() {
        return this.tupleId;
    }

    public void setTupleId(long l) {
        this.tupleId = l;
    }

    @NotNull
    public ColumnDef<?>[] getColumns() {
        return this.columns;
    }

    @NotNull
    public Record copy() {
        long l = this.getTupleId();
        ColumnDef<?>[] columnDefArray = this.getColumns();
        ColumnDef<?>[] columnDefArray2 = Arrays.copyOf(columnDefArray, columnDefArray.length);
        Intrinsics.checkNotNullExpressionValue(columnDefArray2, (String)"copyOf(this, size)");
        columnDefArray2 = Arrays.copyOf(this.values, this.values.length);
        Intrinsics.checkNotNullExpressionValue(columnDefArray2, (String)"copyOf(this, size)");
        return new RecordBinding(l, columnDefArray2, (Binding.Literal[])columnDefArray2);
    }

    public boolean has(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.contains((Object[])this.getColumns(), column);
    }

    public int indexOf(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return ArraysKt.indexOf((Object[])this.getColumns(), column);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ColumnDef<?>, Value> toMap() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Binding.Literal[] literalArray = this.values;
        Object[] objectArray = this.getColumns();
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            void var10_11 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray2 = thisCollection$iv.toArray(new Value[0]);
        if (objectArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        Object[] objectArray3 = objectArray2;
        Object[] objectArray4 = objectArray;
        return (Map)new Object2ObjectArrayMap(objectArray4, objectArray3);
    }

    @Nullable
    public Value get(@NotNull ColumnDef<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.get(ArraysKt.indexOf((Object[])this.getColumns(), column));
    }

    @Nullable
    public Value get(int index) {
        if (!(0 <= index ? index < this.getSize() : false)) {
            boolean bl = false;
            String string = "The specified column " + index + " is out of bounds.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.values[index].getValue();
    }

    public void set(@NotNull ColumnDef<?> column, @Nullable Value value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.set(ArraysKt.indexOf((Object[])this.getColumns(), column), value);
    }

    public void set(int index, @Nullable Value value) {
        if (!(0 <= index ? index < this.getSize() : false)) {
            boolean bl = false;
            String string = "The specified column " + index + " is out of bounds.";
            throw new IllegalArgumentException(string.toString());
        }
        this.values[index].update(value);
    }

    public int getSize() {
        return Record.DefaultImpls.getSize((Record)this);
    }
}

