/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.statistics.entity;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.entity.RecordStatistics;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\b\u0002\u0010\u0004\u001a\u00060\u0003j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001e\u0010\u0004\u001a\u00060\u0003j\u0002`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/entity/EntityStatistics;", "Lorg/vitrivr/cottontail/dbms/statistics/entity/RecordStatistics;", "count", "", "maximumTupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "(JJ)V", "getCount", "()J", "setCount", "(J)V", "getMaximumTupleId", "setMaximumTupleId", "consume", "", "action", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation;", "copy", "reset", "Serializer", "cottontaildb-dbms"})
public final class EntityStatistics
extends RecordStatistics {
    @NotNull
    public static final Serializer Serializer = new Serializer(null);
    private long count;
    private long maximumTupleId;

    public EntityStatistics(long count, long maximumTupleId) {
        this.count = count;
        this.maximumTupleId = maximumTupleId;
    }

    public /* synthetic */ EntityStatistics(long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            l = 0L;
        }
        if ((n & 2) != 0) {
            l2 = -1L;
        }
        this(l, l2);
    }

    public final long getCount() {
        return this.count;
    }

    public final void setCount(long l) {
        this.count = l;
    }

    public final long getMaximumTupleId() {
        return this.maximumTupleId;
    }

    public final void setMaximumTupleId(long l) {
        this.maximumTupleId = l;
    }

    public final void consume(@NotNull Operation.DataManagementOperation action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Operation.DataManagementOperation dataManagementOperation = action;
        if (dataManagementOperation instanceof Operation.DataManagementOperation.DeleteOperation) {
            --this.count;
            Map<ColumnDef<?>, Value> $this$forEach$iv = ((Operation.DataManagementOperation.DeleteOperation)action).getDeleted();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ColumnDef<?>, Value>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ColumnDef<?>, Value> element$iv;
                Map.Entry<ColumnDef<?>, Value> $dstr$t$u = element$iv = iterator.next();
                boolean bl = false;
                ColumnDef<?> t = $dstr$t$u.getKey();
                Value u = $dstr$t$u.getValue();
                ValueStatistics valueStatistics = (ValueStatistics)this.getColumns().get(t);
                if (valueStatistics == null) continue;
                valueStatistics.delete(u);
            }
        } else if (dataManagementOperation instanceof Operation.DataManagementOperation.InsertOperation) {
            ++this.count;
            this.maximumTupleId = Math.max(this.maximumTupleId, action.getTupleId());
            Map<ColumnDef<?>, Value> $this$forEach$iv = ((Operation.DataManagementOperation.InsertOperation)action).getInserts();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ColumnDef<?>, Value>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ColumnDef<?>, Value> element$iv;
                Map.Entry<ColumnDef<?>, Value> $dstr$t$u = element$iv = iterator.next();
                boolean bl = false;
                ColumnDef<?> t = $dstr$t$u.getKey();
                Value u = $dstr$t$u.getValue();
                ValueStatistics valueStatistics = (ValueStatistics)this.getColumns().get(t);
                if (valueStatistics == null) continue;
                valueStatistics.insert(u);
            }
        } else if (dataManagementOperation instanceof Operation.DataManagementOperation.UpdateOperation) {
            Map<ColumnDef<?>, Pair<Value, Value>> $this$forEach$iv = ((Operation.DataManagementOperation.UpdateOperation)action).getUpdates();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<ColumnDef<?>, Pair<Value, Value>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<ColumnDef<?>, Pair<Value, Value>> element$iv;
                Map.Entry<ColumnDef<?>, Pair<Value, Value>> $dstr$t$u = element$iv = iterator.next();
                boolean bl = false;
                ColumnDef<?> t = $dstr$t$u.getKey();
                Pair<Value, Value> u = $dstr$t$u.getValue();
                ValueStatistics valueStatistics = (ValueStatistics)this.getColumns().get(t);
                if (valueStatistics == null) continue;
                valueStatistics.update((Value)u.getFirst(), (Value)u.getSecond());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.count = 0L;
        this.maximumTupleId = -1L;
    }

    @Override
    @NotNull
    public EntityStatistics copy() {
        EntityStatistics copy = new EntityStatistics(this.count, this.maximumTupleId);
        for (Map.Entry entry : ((Map)this.getColumns()).entrySet()) {
            ColumnDef t = (ColumnDef)entry.getKey();
            ValueStatistics u = (ValueStatistics)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)t, (String)"t");
            copy.set(t, u.copy());
        }
        return copy;
    }

    public EntityStatistics() {
        this(0L, 0L, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/dbms/statistics/entity/EntityStatistics$Serializer;", "Lorg/mapdb/Serializer;", "Lorg/vitrivr/cottontail/dbms/statistics/entity/EntityStatistics;", "()V", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "cottontaildb-dbms"})
    public static final class Serializer
    implements org.mapdb.Serializer<EntityStatistics> {
        private Serializer() {
        }

        public void serialize(@NotNull DataOutput2 out, @NotNull EntityStatistics value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            out.packLong(value.getCount());
            out.packLong(value.getMaximumTupleId());
            out.packInt(value.getColumns().size());
            Map $this$forEach$iv = (Map)value.getColumns();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$t$u = element$iv = iterator.next();
                boolean bl = false;
                ColumnDef t = (ColumnDef)$dstr$t$u.getKey();
                ValueStatistics u = (ValueStatistics)$dstr$t$u.getValue();
                out.writeUTF(t.getName().toString());
                out.packInt(t.getType().getOrdinal());
                out.packInt(t.getType().getLogicalSize());
                out.writeBoolean(t.getNullable());
                out.writeBoolean(t.getPrimary());
                Intrinsics.checkNotNullExpressionValue((Object)u, (String)"u");
                ValueStatistics.Companion.serialize(out, u);
            }
        }

        @NotNull
        public EntityStatistics deserialize(@NotNull DataInput2 input, int available) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            EntityStatistics statistics = new EntityStatistics(input.unpackLong(), input.unpackLong());
            int n = input.unpackInt();
            int n2 = 0;
            while (n2 < n) {
                int n3;
                int it = n3 = n2++;
                boolean bl = false;
                Object object = input.readUTF();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"input.readUTF()");
                CharSequence charSequence = (CharSequence)object;
                object = new char[1];
                object[0] = 46;
                Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)charSequence, (char[])object, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                Name.ColumnName name = new Name.ColumnName(stringArray);
                ColumnDef def = new ColumnDef(name, Types.Companion.forOrdinal(input.unpackInt(), input.unpackInt()), input.readBoolean(), input.readBoolean());
                Map map2 = (Map)statistics.getColumns();
                Object object2 = ValueStatistics.Companion.deserialize(input, available);
                map2.put(def, object2);
            }
            return statistics;
        }

        public /* synthetic */ Serializer(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

