/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.server.grpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.ExperimentalTime;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.execution.TransactionManager;
import org.vitrivr.cottontail.server.grpc.services.DDLService;
import org.vitrivr.cottontail.server.grpc.services.DMLService;
import org.vitrivr.cottontail.server.grpc.services.DQLService;
import org.vitrivr.cottontail.server.grpc.services.TXNService;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/server/grpc/CottontailGrpcServer;", "", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "isRunning", "", "()Z", "server", "Lio/grpc/Server;", "kotlin.jvm.PlatformType", "transactionManager", "Lorg/vitrivr/cottontail/dbms/execution/TransactionManager;", "stop", "", "cottontaildb-dbms"})
@ExperimentalTime
public final class CottontailGrpcServer {
    @NotNull
    private final Config config;
    @NotNull
    private final ThreadPoolExecutor executor;
    @NotNull
    private final TransactionManager transactionManager;
    @NotNull
    private final DefaultCatalogue catalogue;
    private final Server server;

    /*
     * WARNING - void declaration
     */
    public CottontailGrpcServer(@NotNull Config config) {
        ServerBuilder serverBuilder;
        void it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.executor = this.config.getExecution().newExecutor();
        this.transactionManager = new TransactionManager(this.config.getExecution().getTransactionTableSize(), this.config.getExecution().getTransactionHistorySize());
        this.catalogue = new DefaultCatalogue(this.config);
        ServerBuilder serverBuilder2 = ServerBuilder.forPort((int)this.config.getServer().getPort()).executor((Executor)this.executor).addService((BindableService)new DDLService(this.catalogue, this.transactionManager)).addService((BindableService)new DMLService(this.catalogue, this.transactionManager)).addService((BindableService)new DQLService(this.catalogue, this.transactionManager)).addService((BindableService)new TXNService(this.catalogue, this.transactionManager));
        CottontailGrpcServer cottontailGrpcServer = this;
        boolean bl = false;
        if (this.getConfig().getServer().getUseTls()) {
            Path path = this.getConfig().getServer().getCertFile();
            Intrinsics.checkNotNull((Object)path);
            File certFile = path.toFile();
            Path path2 = this.getConfig().getServer().getPrivateKey();
            Intrinsics.checkNotNull((Object)path2);
            File privateKeyFile = path2.toFile();
            serverBuilder = it.useTransportSecurity(certFile, privateKeyFile);
        } else {
            serverBuilder = it;
        }
        cottontailGrpcServer.server = serverBuilder.build();
        try {
            this.server.start();
        }
        catch (Throwable e) {
            this.catalogue.close();
        }
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    @NotNull
    public final DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    public final boolean isRunning() {
        return !this.server.isShutdown();
    }

    public final void stop() {
        this.server.shutdown();
        this.server.awaitTermination();
        this.executor.shutdown();
        this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        this.catalogue.close();
    }
}

