/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.storage.serializers.mapdb.BooleanValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.BooleanVectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.ByteValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.Complex32ValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.Complex32VectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.Complex64ValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.Complex64VectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.DateValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.DoubleValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.DoubleVectorMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.FloatValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.FloatVectorMapDBValueSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.IntValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.IntVectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.LongValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.LongVectorValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.ShortValueMapDBSerializer;
import org.vitrivr.cottontail.storage.serializers.mapdb.StringValueMapDBSerializer;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\b\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/ValueSerializerFactory;", "", "()V", "mapdb", "Lorg/vitrivr/cottontail/storage/serializers/mapdb/MapDBSerializer;", "T", "Lorg/vitrivr/cottontail/core/values/types/Value;", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "cottontaildb-dbms"})
public final class ValueSerializerFactory {
    @NotNull
    public static final ValueSerializerFactory INSTANCE = new ValueSerializerFactory();

    private ValueSerializerFactory() {
    }

    @NotNull
    public final <T extends Value> MapDBSerializer<T> mapdb(@NotNull Types<T> type) {
        MapDBSerializer mapDBSerializer;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Types<T> types = type;
        if (Intrinsics.areEqual(types, (Object)Types.Boolean.INSTANCE)) {
            mapDBSerializer = BooleanValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Date.INSTANCE)) {
            mapDBSerializer = DateValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Byte.INSTANCE)) {
            mapDBSerializer = ByteValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex32.INSTANCE)) {
            mapDBSerializer = Complex32ValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Complex64.INSTANCE)) {
            mapDBSerializer = Complex64ValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Double.INSTANCE)) {
            mapDBSerializer = DoubleValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Float.INSTANCE)) {
            mapDBSerializer = FloatValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Int.INSTANCE)) {
            mapDBSerializer = IntValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Long.INSTANCE)) {
            mapDBSerializer = LongValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.Short.INSTANCE)) {
            mapDBSerializer = ShortValueMapDBSerializer.INSTANCE;
        } else if (Intrinsics.areEqual(types, (Object)Types.String.INSTANCE)) {
            mapDBSerializer = StringValueMapDBSerializer.INSTANCE;
        } else if (types instanceof Types.BooleanVector) {
            mapDBSerializer = new BooleanVectorValueMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.Complex32Vector) {
            mapDBSerializer = new Complex32VectorValueMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.Complex64Vector) {
            mapDBSerializer = new Complex64VectorValueMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.DoubleVector) {
            mapDBSerializer = new DoubleVectorMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.FloatVector) {
            mapDBSerializer = new FloatVectorMapDBValueSerializer(type.getLogicalSize());
        } else if (types instanceof Types.IntVector) {
            mapDBSerializer = new IntVectorValueMapDBSerializer(type.getLogicalSize());
        } else if (types instanceof Types.LongVector) {
            mapDBSerializer = new LongVectorValueMapDBSerializer(type.getLogicalSize());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return mapDBSerializer;
    }
}

