/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.storage.serializers.mapdb;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.vitrivr.cottontail.core.values.BooleanVectorValue;
import org.vitrivr.cottontail.storage.serializers.mapdb.MapDBSerializer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/mapdb/BooleanVectorValueMapDBSerializer;", "Lorg/vitrivr/cottontail/storage/serializers/mapdb/MapDBSerializer;", "Lorg/vitrivr/cottontail/core/values/BooleanVectorValue;", "size", "", "(I)V", "arraySize", "getSize", "()I", "deserialize", "input", "Lorg/mapdb/DataInput2;", "available", "deserialize-i2EKPjs", "(Lorg/mapdb/DataInput2;I)[Z", "serialize", "", "out", "Lorg/mapdb/DataOutput2;", "value", "serialize-1xv5vZI", "(Lorg/mapdb/DataOutput2;[Z)V", "Companion", "cottontaildb-dbms"})
public final class BooleanVectorValueMapDBSerializer
implements MapDBSerializer<BooleanVectorValue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    private final int arraySize;
    private static final int LONG_BIT_SHIFT = 6;

    public BooleanVectorValueMapDBSerializer(int size) {
        this.size = size;
        this.arraySize = BooleanVectorValueMapDBSerializer.Companion.bitToWordIndex(this.size - 1) + 1;
        if (!(this.size > 0)) {
            boolean bl = false;
            String string = "Cannot initialize vector value serializer with size value of " + this.getSize() + '.';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getSize() {
        return this.size;
    }

    public void serialize-1xv5vZI(@NotNull DataOutput2 out, @NotNull boolean[] value) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = this.arraySize;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            long v = 0L;
            int n3 = n2 << 6;
            int n4 = Math.min(n2 + 1 << 6, this.size);
            int n5 = n2;
            long[] lArray2 = lArray;
            while (n3 < n4) {
                int idx;
                if (!value[idx = n3++]) continue;
                v |= 1L << idx;
            }
            lArray2[n5] = v;
        }
        long[] words = lArray;
        out.packLongArray(words, 0, this.arraySize);
    }

    @NotNull
    public boolean[] deserialize-i2EKPjs(@NotNull DataInput2 input, int available) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        long[] words = new long[this.arraySize];
        input.unpackLongArray(words, 0, this.arraySize);
        int n = this.size;
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            long check;
            int n2 = i;
            long l = words[BooleanVectorValueMapDBSerializer.Companion.bitToWordIndex(n2)];
            blArray[n2] = (l & (check = 1L << n2)) == check;
        }
        return BooleanVectorValue.constructor-impl((boolean[])blArray);
    }

    @Override
    public boolean isTrusted() {
        return MapDBSerializer.DefaultImpls.isTrusted(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/storage/serializers/mapdb/BooleanVectorValueMapDBSerializer$Companion;", "", "()V", "LONG_BIT_SHIFT", "", "bitToWordIndex", "bitIndex", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        private final int bitToWordIndex(int bitIndex) {
            return bitIndex >> 6;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

