/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.test;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.client.SimpleClient;
import org.vitrivr.cottontail.client.iterators.Tuple;
import org.vitrivr.cottontail.client.iterators.TupleIterator;
import org.vitrivr.cottontail.client.language.basics.Type;
import org.vitrivr.cottontail.client.language.ddl.CreateEntity;
import org.vitrivr.cottontail.client.language.ddl.CreateIndex;
import org.vitrivr.cottontail.client.language.ddl.CreateSchema;
import org.vitrivr.cottontail.client.language.ddl.DropSchema;
import org.vitrivr.cottontail.client.language.ddl.OptimizeEntity;
import org.vitrivr.cottontail.client.language.dml.BatchInsert;
import org.vitrivr.cottontail.client.language.dml.Insert;
import org.vitrivr.cottontail.client.language.dql.Query;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.grpc.CottontailGrpc;
import org.vitrivr.cottontail.test.TestConstants;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J,\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/test/GrpcTestUtils;", "", "()V", "countElements", "", "client", "Lorg/vitrivr/cottontail/client/SimpleClient;", "entityName", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "(Lorg/vitrivr/cottontail/client/SimpleClient;Lorg/vitrivr/cottontail/core/database/Name$EntityName;)Ljava/lang/Long;", "createLuceneIndexOnTestEntity", "", "createTestEntity", "createTestSchema", "createTestVectorEntity", "dropTestSchema", "insertIntoTestEntity", "string", "", "int", "", "double", "", "populateTestEntity", "populateVectorEntity", "cottontaildb-dbms_testFixtures"})
public final class GrpcTestUtils {
    @NotNull
    public static final GrpcTestUtils INSTANCE = new GrpcTestUtils();

    private GrpcTestUtils() {
    }

    public final void createTestSchema(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        client.create(new CreateSchema(TestConstants.INSTANCE.getTEST_SCHEMA().getFqn()));
    }

    public final void dropTestSchema(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        try {
            client.drop(new DropSchema(TestConstants.INSTANCE.getTEST_SCHEMA().getFqn()));
        }
        catch (Exception e) {
            System.err.println("Failed to drop test schema " + TestConstants.INSTANCE.getTEST_SCHEMA() + " due to exception: " + e.getMessage() + '.');
        }
    }

    public final void createTestEntity(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        CreateEntity create = CreateEntity.column$default((CreateEntity)CreateEntity.column$default((CreateEntity)CreateEntity.column$default((CreateEntity)new CreateEntity(TestConstants.INSTANCE.getTEST_ENTITY_NAME().getFqn()), (String)TestConstants.INSTANCE.getSTRING_COLUMN_NAME(), (Type)Type.STRING, (int)0, (boolean)false, (int)12, null), (String)TestConstants.INSTANCE.getINT_COLUMN_NAME(), (Type)Type.INTEGER, (int)0, (boolean)false, (int)12, null), (String)TestConstants.INSTANCE.getDOUBLE_COLUMN_NAME(), (Type)Type.DOUBLE, (int)0, (boolean)false, (int)12, null);
        client.create(create);
    }

    public final void createTestVectorEntity(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        CreateEntity create = CreateEntity.column$default((CreateEntity)CreateEntity.column$default((CreateEntity)CreateEntity.column$default((CreateEntity)new CreateEntity(TestConstants.INSTANCE.getTEST_VECTOR_ENTITY_NAME().getFqn()), (String)TestConstants.INSTANCE.getSTRING_COLUMN_NAME(), (Type)Type.STRING, (int)0, (boolean)false, (int)12, null), (String)TestConstants.INSTANCE.getINT_COLUMN_NAME(), (Type)Type.INTEGER, (int)0, (boolean)false, (int)12, null), (String)TestConstants.INSTANCE.getTWOD_COLUMN_NAME(), (Type)Type.FLOAT_VECTOR, (int)2, (boolean)false, (int)8, null);
        client.create(create);
    }

    public final void populateTestEntity(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String[] stringArray = new String[]{TestConstants.INSTANCE.getSTRING_COLUMN_NAME(), TestConstants.INSTANCE.getINT_COLUMN_NAME(), TestConstants.INSTANCE.getDOUBLE_COLUMN_NAME()};
        BatchInsert batch = new BatchInsert(null, 1, null).into(TestConstants.INSTANCE.getTEST_ENTITY_NAME().getFqn()).columns(stringArray);
        Random.Default random = Random.Default;
        int n = 50000;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Object[] objectArray = new Object[]{RandomStringUtils.randomAlphabetic((int)5), random.nextInt(0, 100), random.nextDouble(1.0)};
            batch.append(objectArray);
        }
        client.insert(batch);
    }

    public final void insertIntoTestEntity(@NotNull SimpleClient client, @NotNull String string, int n, double d) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Pair[] pairArray = new Pair[]{new Pair((Object)TestConstants.INSTANCE.getSTRING_COLUMN_NAME(), (Object)string), new Pair((Object)TestConstants.INSTANCE.getINT_COLUMN_NAME(), (Object)n), new Pair((Object)TestConstants.INSTANCE.getDOUBLE_COLUMN_NAME(), (Object)d)};
        Insert insert = new Insert(null, 1, null).into(TestConstants.INSTANCE.getTEST_ENTITY_NAME().getFqn()).values(pairArray);
        client.insert(insert);
    }

    public static /* synthetic */ void insertIntoTestEntity$default(GrpcTestUtils grpcTestUtils, SimpleClient simpleClient, String string, int n, double d, int n2, Object object) {
        if ((n2 & 2) != 0) {
            String string2 = RandomStringUtils.randomAlphabetic((int)5);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomAlphabetic(5)");
            string = string2;
        }
        if ((n2 & 4) != 0) {
            n = Random.Default.nextInt(0, 100);
        }
        if ((n2 & 8) != 0) {
            d = Random.Default.nextDouble(1.0);
        }
        grpcTestUtils.insertIntoTestEntity(simpleClient, string, n, d);
    }

    public final void createLuceneIndexOnTestEntity(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        client.create(new CreateIndex(TestConstants.INSTANCE.getTEST_ENTITY_NAME().getFqn(), TestConstants.INSTANCE.getSTRING_COLUMN_NAME(), CottontailGrpc.IndexType.LUCENE));
        client.optimize(new OptimizeEntity(TestConstants.INSTANCE.getTEST_ENTITY_NAME().getFqn()));
    }

    public final void populateVectorEntity(@NotNull SimpleClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        String[] stringArray = new String[]{TestConstants.INSTANCE.getSTRING_COLUMN_NAME(), TestConstants.INSTANCE.getINT_COLUMN_NAME(), TestConstants.INSTANCE.getTWOD_COLUMN_NAME()};
        BatchInsert batch = new BatchInsert(null, 1, null).into(TestConstants.INSTANCE.getTEST_VECTOR_ENTITY_NAME().getFqn()).columns(stringArray);
        Random.Default random = Random.Default;
        int n = 50000;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            float lat = random.nextFloat() + (float)random.nextInt(0, 50);
            float lon = random.nextFloat() + (float)random.nextInt(0, 50);
            Object[] objectArray = new float[]{lat, lon};
            float[] arr = objectArray;
            objectArray = new Object[3];
            objectArray[0] = (float)RandomStringUtils.randomAlphabetic((int)5);
            objectArray[1] = random.nextInt(0, 10);
            objectArray[2] = (float)arr;
            batch.append(objectArray);
        }
        client.insert(batch);
    }

    @Nullable
    public final Long countElements(@NotNull SimpleClient client, @NotNull Name.EntityName entityName) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)entityName, (String)"entityName");
        Query query = new Query(entityName.toString()).count();
        TupleIterator res = client.query(query);
        return ((Tuple)res.next()).asLong(0);
    }
}

