/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.test;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.config.ExecutionConfig;
import org.vitrivr.cottontail.config.ServerConfig;
import org.vitrivr.cottontail.core.database.Name;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010!\u001a\u00020\"R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0014\u0010\u001c\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\fR\u000e\u0010\u001e\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/vitrivr/cottontail/test/TestConstants;", "", "()V", "ALL_ENTITY_NAMES", "", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getALL_ENTITY_NAMES", "()Ljava/util/List;", "DBO_CONSTANT", "", "DOUBLE_COLUMN_NAME", "getDOUBLE_COLUMN_NAME", "()Ljava/lang/String;", "INT_COLUMN_NAME", "getINT_COLUMN_NAME", "STRING_COLUMN_NAME", "getSTRING_COLUMN_NAME", "TEST_COLLECTION_SIZE", "", "TEST_ENTITY_NAME", "getTEST_ENTITY_NAME", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "TEST_SCHEMA", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "getTEST_SCHEMA", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "TEST_VECTOR_ENTITY_NAME", "getTEST_VECTOR_ENTITY_NAME", "TWOD_COLUMN_NAME", "getTWOD_COLUMN_NAME", "largeVectorMaxDimension", "mediumVectorMaxDimension", "smallVectorMaxDimension", "testConfig", "Lorg/vitrivr/cottontail/config/Config;", "cottontaildb-dbms_testFixtures"})
public final class TestConstants {
    @NotNull
    public static final TestConstants INSTANCE = new TestConstants();
    public static final int TEST_COLLECTION_SIZE = 50000;
    public static final int smallVectorMaxDimension = 128;
    public static final int mediumVectorMaxDimension = 512;
    public static final int largeVectorMaxDimension = 2048;
    @NotNull
    private static final Name.SchemaName TEST_SCHEMA = Name.SchemaName.Companion.create("test-schema");
    @NotNull
    private static final Name.EntityName TEST_ENTITY_NAME = TEST_SCHEMA.entity("test-entity");
    @NotNull
    private static final Name.EntityName TEST_VECTOR_ENTITY_NAME = TEST_SCHEMA.entity("test-vector-entity");
    @NotNull
    private static final String STRING_COLUMN_NAME = "string_col";
    @NotNull
    private static final String INT_COLUMN_NAME = "int_col";
    @NotNull
    private static final String DOUBLE_COLUMN_NAME = "double_col";
    @NotNull
    private static final String TWOD_COLUMN_NAME = "twod_col";
    @NotNull
    private static final List<Name.EntityName> ALL_ENTITY_NAMES;
    @NotNull
    public static final String DBO_CONSTANT = "dbo";

    private TestConstants() {
    }

    @NotNull
    public final Name.SchemaName getTEST_SCHEMA() {
        return TEST_SCHEMA;
    }

    @NotNull
    public final Name.EntityName getTEST_ENTITY_NAME() {
        return TEST_ENTITY_NAME;
    }

    @NotNull
    public final Name.EntityName getTEST_VECTOR_ENTITY_NAME() {
        return TEST_VECTOR_ENTITY_NAME;
    }

    @NotNull
    public final String getSTRING_COLUMN_NAME() {
        return STRING_COLUMN_NAME;
    }

    @NotNull
    public final String getINT_COLUMN_NAME() {
        return INT_COLUMN_NAME;
    }

    @NotNull
    public final String getDOUBLE_COLUMN_NAME() {
        return DOUBLE_COLUMN_NAME;
    }

    @NotNull
    public final String getTWOD_COLUMN_NAME() {
        return TWOD_COLUMN_NAME;
    }

    @NotNull
    public final List<Name.EntityName> getALL_ENTITY_NAMES() {
        return ALL_ENTITY_NAMES;
    }

    @NotNull
    public final Config testConfig() {
        Path path = Files.createTempDirectory("cottontaildb-test-" + UUID.randomUUID(), new FileAttribute[0]);
        ExecutionConfig executionConfig = new ExecutionConfig(2, 4, 0L, 0, false, 0, 0, 124, null);
        ServerConfig serverConfig = new ServerConfig(0, 2, null, null, 13, null);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(\"cot\u2026st-${UUID.randomUUID()}\")");
        return new Config(path, false, null, null, null, serverConfig, executionConfig, null, null, 414, null);
    }

    static {
        Object[] objectArray = new Name.EntityName[2];
        objectArray[0] = TEST_ENTITY_NAME;
        objectArray[1] = TEST_VECTOR_ENTITY_NAME;
        ALL_ENTITY_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }
}

