/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.catalogue;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.StampedLock;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.vfs.ClusteringStrategy;
import jetbrains.exodus.vfs.VfsConfig;
import jetbrains.exodus.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.config.Config;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.FunctionRegistry;
import org.vitrivr.cottontail.dbms.catalogue.Catalogue;
import org.vitrivr.cottontail.dbms.catalogue.CatalogueTx;
import org.vitrivr.cottontail.dbms.catalogue.entries.ColumnCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.EntityCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexStructCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.MetadataEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.SchemaCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.SequenceCatalogueEntries;
import org.vitrivr.cottontail.dbms.catalogue.entries.StatisticsCatalogueEntry;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.functions.InitializeKt;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.schema.DefaultSchema;
import org.vitrivr.cottontail.dbms.schema.Schema;
import org.vitrivr.cottontail.dbms.schema.SchemaTx;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 42\u00020\u0001:\u000245B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010.\u001a\u00020/H\u0016J\u0014\u00100\u001a\u000601R\u00020\u00002\u0006\u00102\u001a\u000203H\u0016R\u0014\u0010\u0005\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-\u00a8\u00066"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "catalogue", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/Catalogue;", "closeLock", "Ljava/util/concurrent/locks/StampedLock;", "getCloseLock$cottontaildb_dbms", "()Ljava/util/concurrent/locks/StampedLock;", "closed", "", "getClosed", "()Z", "getConfig", "()Lorg/vitrivr/cottontail/config/Config;", "environment", "Ljetbrains/exodus/env/Environment;", "getEnvironment$cottontaildb_dbms", "()Ljetbrains/exodus/env/Environment;", "functions", "Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "getFunctions", "()Lorg/vitrivr/cottontail/core/queries/functions/FunctionRegistry;", "name", "Lorg/vitrivr/cottontail/core/database/Name$RootName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$RootName;", "parent", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getParent", "()Lorg/vitrivr/cottontail/dbms/general/DBO;", "path", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "vfs", "Ljetbrains/exodus/vfs/VirtualFileSystem;", "getVfs$cottontaildb_dbms", "()Ljetbrains/exodus/vfs/VirtualFileSystem;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class DefaultCatalogue
implements Catalogue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Config config;
    @NotNull
    private final Path path;
    @Nullable
    private final DBO parent;
    @NotNull
    private final FunctionRegistry functions;
    @NotNull
    private final StampedLock closeLock;
    @NotNull
    private final Environment environment;
    @NotNull
    private final VirtualFileSystem vfs;
    @NotNull
    public static final String ENTITY_STORE_PREFIX = "ctt_ent";
    @NotNull
    public static final String COLUMN_STORE_PREFIX = "ctt_col";
    @NotNull
    public static final String INDEX_STORE_PREFIX = "ctt_idx";

    public DefaultCatalogue(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.path = this.getConfig().getRoot();
        this.functions = new FunctionRegistry();
        this.closeLock = new StampedLock();
        File file = this.getConfig().dataFolder().toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"this.config.dataFolder().toFile()");
        this.environment = Environments.newInstance((File)file, (EnvironmentConfig)this.getConfig().getXodus().toEnvironmentConfig());
        Transaction transaction = this.environment.beginExclusiveTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"this.environment.beginExclusiveTransaction()");
        Transaction tx = transaction;
        try {
            Object version;
            Object object;
            block8: {
                block7: {
                    if (this.environment.getAllStoreNames(tx).size() == 0) {
                        MetadataEntry.Companion.init$cottontaildb_dbms(this, tx);
                        MetadataEntry.Companion.write$cottontaildb_dbms(new MetadataEntry("db_version", this.getVersion().toString()), this, tx);
                        SchemaCatalogueEntry.Companion.init$cottontaildb_dbms(this, tx);
                        EntityCatalogueEntry.Companion.init$cottontaildb_dbms(this, tx);
                        SequenceCatalogueEntries.INSTANCE.init$cottontaildb_dbms(this, tx);
                        ColumnCatalogueEntry.Companion.init$cottontaildb_dbms(this, tx);
                        StatisticsCatalogueEntry.Companion.init$cottontaildb_dbms(this, tx);
                        IndexCatalogueEntry.Companion.init$cottontaildb_dbms(this, tx);
                        IndexStructCatalogueEntry.Companion.init$cottontaildb_dbms(this, tx);
                    }
                    VfsConfig config2 = new VfsConfig();
                    config2.setClusteringStrategy((ClusteringStrategy)new ClusteringStrategy.QuadraticClusteringStrategy(65536));
                    config2.getClusteringStrategy().setMaxClusterSize(0x100000);
                    this.vfs = new VirtualFileSystem(this.environment, config2, tx);
                    object = MetadataEntry.Companion.read$cottontaildb_dbms("db_version", this, tx);
                    if (object == null) break block7;
                    MetadataEntry it = object;
                    boolean bl = false;
                    DBOVersion dBOVersion = DBOVersion.valueOf(it.getValue());
                    object = dBOVersion;
                    if (dBOVersion != null) break block8;
                }
                object = DBOVersion.UNDEFINED;
            }
            if ((version = object) != this.getVersion()) {
                throw new DatabaseException.VersionMismatchException(this.getVersion(), (DBOVersion)((Object)version));
            }
            tx.commit();
        }
        catch (Throwable e) {
            tx.abort();
            throw e;
        }
        InitializeKt.initialize(this.getFunctions());
    }

    @Override
    @NotNull
    public Config getConfig() {
        return this.config;
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Name.RootName getName() {
        return Name.RootName.INSTANCE;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V3_0;
    }

    @Override
    @Nullable
    public DBO getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Catalogue getCatalogue() {
        return this;
    }

    @Override
    @NotNull
    public FunctionRegistry getFunctions() {
        return this.functions;
    }

    @Override
    public boolean getClosed() {
        return !this.environment.isOpen();
    }

    @NotNull
    public final StampedLock getCloseLock$cottontaildb_dbms() {
        return this.closeLock;
    }

    @NotNull
    public final Environment getEnvironment$cottontaildb_dbms() {
        return this.environment;
    }

    @NotNull
    public final VirtualFileSystem getVfs$cottontaildb_dbms() {
        return this.vfs;
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        StampedLock $this$write$iv = this.closeLock;
        boolean $i$f$write = false;
        long stamp$iv = $this$write$iv.writeLock();
        try {
            boolean $i$a$-write-DefaultCatalogue$close$22 = false;
            this.vfs.shutdown();
            this.environment.close();
            Unit $i$a$-write-DefaultCatalogue$close$22 = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            throw e$iv;
        }
        finally {
            $this$write$iv.unlock(stamp$iv);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue$Companion;", "", "()V", "COLUMN_STORE_PREFIX", "", "ENTITY_STORE_PREFIX", "INDEX_STORE_PREFIX", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/catalogue/CatalogueTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "dbo", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "cleanup", "", "createSchema", "Lorg/vitrivr/cottontail/dbms/schema/Schema;", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "dropSchema", "listSchemas", "", "schemaForName", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements CatalogueTx {
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            if (DefaultCatalogue.this.getClosed()) {
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), DefaultCatalogue.this);
            }
            this.closeStamp = DefaultCatalogue.this.getCloseLock$cottontaildb_dbms().readLock();
        }

        @Override
        @NotNull
        public DefaultCatalogue getDbo() {
            return DefaultCatalogue.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Name.SchemaName> listSchemas() {
            Lock lock2 = this.getTxLatch();
            DefaultCatalogue defaultCatalogue = DefaultCatalogue.this;
            lock2.lock();
            try {
                boolean bl = false;
                Store store = SchemaCatalogueEntry.Companion.store$cottontaildb_dbms(defaultCatalogue, this.getContext().getXodusTx());
                List list = new ArrayList();
                Cursor cursor2 = store.openCursor(this.getContext().getXodusTx());
                Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"store.openCursor(this.context.xodusTx)");
                Cursor $this$forEach$iv = cursor2;
                boolean $i$f$forEach = false;
                Closeable closeable = (Closeable)$this$forEach$iv;
                Throwable throwable = null;
                try {
                    Cursor it$iv = (Cursor)closeable;
                    boolean bl2 = false;
                    while ($this$forEach$iv.getNext()) {
                        Cursor $this$listSchemas_u24lambda_u241_u24lambda_u240 = $this$forEach$iv;
                        boolean bl3 = false;
                        Comparable comparable = SchemaCatalogueEntry.Companion.entryToObject($this$listSchemas_u24lambda_u241_u24lambda_u240.getValue());
                        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.entries.SchemaCatalogueEntry");
                        SchemaCatalogueEntry entry = (SchemaCatalogueEntry)comparable;
                        list.add(entry.getName());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                List list2 = list;
                return list2;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Schema schemaForName(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultCatalogue defaultCatalogue = DefaultCatalogue.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!SchemaCatalogueEntry.Companion.exists$cottontaildb_dbms(name, defaultCatalogue, this.getContext().getXodusTx())) {
                    throw new DatabaseException.SchemaDoesNotExistException(name);
                }
                Schema schema = new DefaultSchema(name, defaultCatalogue);
                return schema;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Schema createSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultCatalogue defaultCatalogue = DefaultCatalogue.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (SchemaCatalogueEntry.Companion.exists$cottontaildb_dbms(name, defaultCatalogue, this.getContext().getXodusTx())) {
                    throw new DatabaseException.SchemaAlreadyExistsException(name);
                }
                SchemaCatalogueEntry.Companion.write$cottontaildb_dbms(new SchemaCatalogueEntry(name), defaultCatalogue, this.getContext().getXodusTx());
                Schema schema = new DefaultSchema(name, defaultCatalogue);
                return schema;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropSchema(@NotNull Name.SchemaName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultCatalogue defaultCatalogue = DefaultCatalogue.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!SchemaCatalogueEntry.Companion.exists$cottontaildb_dbms(name, defaultCatalogue, this.getContext().getXodusTx())) {
                    throw new DatabaseException.SchemaDoesNotExistException(name);
                }
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(new DefaultSchema(name, defaultCatalogue));
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.schema.SchemaTx");
                SchemaTx schemaTx = (SchemaTx)tx;
                Iterable $this$forEach$iv = schemaTx.listEntities();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Name.EntityName it = (Name.EntityName)element$iv;
                    boolean bl2 = false;
                    schemaTx.dropEntity(it);
                }
                SchemaCatalogueEntry.Companion.delete$cottontaildb_dbms(name, defaultCatalogue, this.getContext().getXodusTx());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        public void cleanup() {
            DefaultCatalogue.this.getCloseLock$cottontaildb_dbms().unlockRead(this.closeStamp);
        }
    }
}

