/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.catalogue.entries;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000H\u0096\u0002J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/SchemaCatalogueEntry;", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "(Lorg/vitrivr/cottontail/core/database/Name$SchemaName;)V", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "compareTo", "", "other", "component1", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "cottontaildb-dbms"})
public final class SchemaCatalogueEntry
implements Comparable<SchemaCatalogueEntry> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.SchemaName name;
    @NotNull
    private static final String CATALOGUE_SCHEMA_STORE_NAME = "ctt_cat_schemas";

    public SchemaCatalogueEntry(@NotNull Name.SchemaName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @NotNull
    public final Name.SchemaName getName() {
        return this.name;
    }

    @Override
    public int compareTo(@NotNull SchemaCatalogueEntry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.name.toString().compareTo(other.name.toString());
    }

    @NotNull
    public final Name.SchemaName component1() {
        return this.name;
    }

    @NotNull
    public final SchemaCatalogueEntry copy(@NotNull Name.SchemaName name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new SchemaCatalogueEntry(name);
    }

    public static /* synthetic */ SchemaCatalogueEntry copy$default(SchemaCatalogueEntry schemaCatalogueEntry, Name.SchemaName schemaName, int n, Object object) {
        if ((n & 1) != 0) {
            schemaName = schemaCatalogueEntry.name;
        }
        return schemaCatalogueEntry.copy(schemaName);
    }

    @NotNull
    public String toString() {
        return "SchemaCatalogueEntry(name=" + this.name + ')';
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SchemaCatalogueEntry)) {
            return false;
        }
        SchemaCatalogueEntry schemaCatalogueEntry = (SchemaCatalogueEntry)other;
        return Intrinsics.areEqual((Object)this.name, (Object)schemaCatalogueEntry.name);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0001\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ%\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0012J'\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001d\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001bJ%\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001eJ\u001e\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/SchemaCatalogueEntry$Companion;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "CATALOGUE_SCHEMA_STORE_NAME", "", "delete", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "delete$cottontaildb_dbms", "exists", "exists$cottontaildb_dbms", "init", "", "init$cottontaildb_dbms", "read", "Lorg/vitrivr/cottontail/dbms/catalogue/entries/SchemaCatalogueEntry;", "read$cottontaildb_dbms", "readObject", "stream", "Ljava/io/ByteArrayInputStream;", "store", "Ljetbrains/exodus/env/Store;", "store$cottontaildb_dbms", "write", "entry", "write$cottontaildb_dbms", "writeObject", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "", "", "cottontaildb-dbms"})
    public static final class Companion
    extends ComparableBinding {
        private Companion() {
        }

        public final void init$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (catalogue.getEnvironment$cottontaildb_dbms().openStore(SchemaCatalogueEntry.CATALOGUE_SCHEMA_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to create schema catalogue store.");
            }
        }

        @NotNull
        public final Store store$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Store store = catalogue.getEnvironment$cottontaildb_dbms().openStore(SchemaCatalogueEntry.CATALOGUE_SCHEMA_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open store for schema catalogue.");
            }
            return store;
        }

        @Nullable
        public final SchemaCatalogueEntry read$cottontaildb_dbms(@NotNull Name.SchemaName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            SchemaCatalogueEntry schemaCatalogueEntry;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            ByteIterable rawEntry = this.store$cottontaildb_dbms(catalogue, transaction).get(transaction, (ByteIterable)NameBinding.Schema.INSTANCE.objectToEntry((Comparable)name));
            if (rawEntry != null) {
                Comparable comparable = this.entryToObject(rawEntry);
                Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.entries.SchemaCatalogueEntry");
                schemaCatalogueEntry = (SchemaCatalogueEntry)comparable;
            } else {
                schemaCatalogueEntry = null;
            }
            return schemaCatalogueEntry;
        }

        public final boolean exists$cottontaildb_dbms(@NotNull Name.SchemaName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            return this.store$cottontaildb_dbms(catalogue, transaction).get(transaction, (ByteIterable)NameBinding.Schema.INSTANCE.objectToEntry((Comparable)name)) != null;
        }

        public final boolean write$cottontaildb_dbms(@NotNull SchemaCatalogueEntry entry, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            return this.store$cottontaildb_dbms(catalogue, transaction).put(transaction, (ByteIterable)NameBinding.Schema.INSTANCE.objectToEntry((Comparable)entry.getName()), (ByteIterable)this.objectToEntry(entry));
        }

        public final boolean delete$cottontaildb_dbms(@NotNull Name.SchemaName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            return this.store$cottontaildb_dbms(catalogue, transaction).delete(transaction, (ByteIterable)NameBinding.Schema.INSTANCE.objectToEntry((Comparable)name));
        }

        @NotNull
        public SchemaCatalogueEntry readObject(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            return new SchemaCatalogueEntry(NameBinding.Schema.INSTANCE.readObject(stream));
        }

        public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<?> object) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            if (!(object instanceof SchemaCatalogueEntry)) {
                boolean bl = false;
                String string = object + " cannot be written as schema entry.";
                throw new IllegalArgumentException(string.toString());
            }
            NameBinding.Schema.INSTANCE.writeObject(output, (Comparable)((SchemaCatalogueEntry)object).getName());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

