/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.catalogue.entries;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ%\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0012J)\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J)\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0016J%\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001aJ\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/SequenceCatalogueEntries;", "", "()V", "CATALOGUE_SEQUENCE_STORE_NAME", "", "create", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$SequenceName;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "create$cottontaildb_dbms", "delete", "delete$cottontaildb_dbms", "init", "", "init$cottontaildb_dbms", "next", "", "next$cottontaildb_dbms", "(Lorg/vitrivr/cottontail/core/database/Name$SequenceName;Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;Ljetbrains/exodus/env/Transaction;)Ljava/lang/Long;", "read", "read$cottontaildb_dbms", "reset", "reset$cottontaildb_dbms", "store", "Ljetbrains/exodus/env/Store;", "store$cottontaildb_dbms", "cottontaildb-dbms"})
public final class SequenceCatalogueEntries {
    @NotNull
    public static final SequenceCatalogueEntries INSTANCE = new SequenceCatalogueEntries();
    @NotNull
    private static final String CATALOGUE_SEQUENCE_STORE_NAME = "ctt_cat_sequences";

    private SequenceCatalogueEntries() {
    }

    public final void init$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (catalogue.getEnvironment$cottontaildb_dbms().openStore(CATALOGUE_SEQUENCE_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
            throw new DatabaseException.DataCorruptionException("Failed to create store for sequence catalogue.");
        }
    }

    @NotNull
    public final Store store$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Store store = catalogue.getEnvironment$cottontaildb_dbms().openStore(CATALOGUE_SEQUENCE_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
        if (store == null) {
            throw new DatabaseException.DataCorruptionException("Failed to open store for sequence catalogue.");
        }
        return store;
    }

    @Nullable
    public final Long read$cottontaildb_dbms(@NotNull Name.SequenceName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        ByteIterable rawEntry = this.store$cottontaildb_dbms(catalogue, transaction).get(transaction, (ByteIterable)NameBinding.Sequence.INSTANCE.objectToEntry((Comparable)name));
        return rawEntry != null ? Long.valueOf(LongBinding.compressedEntryToLong((ByteIterable)rawEntry)) : (Long)null;
    }

    @Nullable
    public final Long next$cottontaildb_dbms(@NotNull Name.SequenceName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Store store = this.store$cottontaildb_dbms(catalogue, transaction);
        ArrayByteIterable rawName = NameBinding.Sequence.INSTANCE.objectToEntry((Comparable)name);
        ByteIterable rawEntry = this.store$cottontaildb_dbms(catalogue, transaction).get(transaction, (ByteIterable)rawName);
        if (rawEntry != null) {
            long next = LongBinding.compressedEntryToLong((ByteIterable)rawEntry) + 1L;
            store.put(transaction, (ByteIterable)rawName, (ByteIterable)LongBinding.longToCompressedEntry((long)next));
            return next;
        }
        return null;
    }

    public final boolean create$cottontaildb_dbms(@NotNull Name.SequenceName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return this.store$cottontaildb_dbms(catalogue, transaction).add(transaction, (ByteIterable)NameBinding.Sequence.INSTANCE.objectToEntry((Comparable)name), (ByteIterable)LongBinding.longToCompressedEntry((long)0L));
    }

    public final boolean delete$cottontaildb_dbms(@NotNull Name.SequenceName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return this.store$cottontaildb_dbms(catalogue, transaction).delete(transaction, (ByteIterable)NameBinding.Sequence.INSTANCE.objectToEntry((Comparable)name));
    }

    public final boolean reset$cottontaildb_dbms(@NotNull Name.SequenceName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        return this.store$cottontaildb_dbms(catalogue, transaction).put(transaction, (ByteIterable)NameBinding.Sequence.INSTANCE.objectToEntry((Comparable)name), (ByteIterable)LongBinding.longToCompressedEntry((long)0L));
    }
}

