/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.catalogue.entries;

import java.io.ByteArrayInputStream;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.entries.NameBinding;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.statistics.columns.AbstractValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.BooleanValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.BooleanVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ByteStringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ByteValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.Complex32ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.Complex32VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.Complex64ValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.Complex64VectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.DateValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.DoubleValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.FloatValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.FloatVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.IntValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.IntVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.LongValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.LongVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ShortValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.StringValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.storage.serializers.statistics.StatisticsSerializerFactory;
import org.vitrivr.cottontail.storage.serializers.statistics.xodus.XodusBinding;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\r\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\bH\u00c6\u0003J\r\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\nH\u00c6\u0003J/\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\f\b\u0002\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\f\b\u0002\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/StatisticsCatalogueEntry;", "", "def", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "(Lorg/vitrivr/cottontail/core/database/ColumnDef;)V", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "(Lorg/vitrivr/cottontail/core/database/Name$ColumnName;Lorg/vitrivr/cottontail/core/values/types/Types;Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;)V", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getStatistics", "()Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toSerialized", "Lorg/vitrivr/cottontail/dbms/catalogue/entries/StatisticsCatalogueEntry$Serialized;", "toString", "", "Companion", "Serialized", "cottontaildb-dbms"})
public final class StatisticsCatalogueEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.ColumnName name;
    @NotNull
    private final Types<?> type;
    @NotNull
    private final ValueStatistics<?> statistics;
    @NotNull
    private static final String CATALOGUE_STATISTICS_STORE_NAME = "ctt_cat_statistics";

    public StatisticsCatalogueEntry(@NotNull Name.ColumnName name, @NotNull Types<?> type, @NotNull ValueStatistics<?> statistics) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(statistics, (String)"statistics");
        this.name = name;
        this.type = type;
        this.statistics = statistics;
    }

    @NotNull
    public final Name.ColumnName getName() {
        return this.name;
    }

    @NotNull
    public final Types<?> getType() {
        return this.type;
    }

    @NotNull
    public final ValueStatistics<?> getStatistics() {
        return this.statistics;
    }

    public StatisticsCatalogueEntry(@NotNull ColumnDef<?> def) {
        AbstractValueStatistics abstractValueStatistics;
        Types types;
        Intrinsics.checkNotNullParameter(def, (String)"def");
        Name.ColumnName columnName = def.getName();
        Types types2 = types = def.getType();
        if (Intrinsics.areEqual((Object)types, (Object)Types.Boolean.INSTANCE)) {
            abstractValueStatistics = new BooleanValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Byte.INSTANCE)) {
            abstractValueStatistics = new ByteValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Short.INSTANCE)) {
            abstractValueStatistics = new ShortValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Date.INSTANCE)) {
            abstractValueStatistics = new DateValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Double.INSTANCE)) {
            abstractValueStatistics = new DoubleValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Float.INSTANCE)) {
            abstractValueStatistics = new FloatValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Int.INSTANCE)) {
            abstractValueStatistics = new IntValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Long.INSTANCE)) {
            abstractValueStatistics = new LongValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.String.INSTANCE)) {
            abstractValueStatistics = new StringValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Complex32.INSTANCE)) {
            abstractValueStatistics = new Complex32ValueStatistics();
        } else if (Intrinsics.areEqual((Object)types, (Object)Types.Complex64.INSTANCE)) {
            abstractValueStatistics = new Complex64ValueStatistics();
        } else if (types instanceof Types.BooleanVector) {
            abstractValueStatistics = new BooleanVectorValueStatistics(def.getType().getLogicalSize());
        } else if (types instanceof Types.DoubleVector) {
            abstractValueStatistics = new DoubleVectorValueStatistics(def.getType().getLogicalSize());
        } else if (types instanceof Types.FloatVector) {
            abstractValueStatistics = new FloatVectorValueStatistics(def.getType().getLogicalSize());
        } else if (types instanceof Types.IntVector) {
            abstractValueStatistics = new IntVectorValueStatistics(def.getType().getLogicalSize());
        } else if (types instanceof Types.LongVector) {
            abstractValueStatistics = new LongVectorValueStatistics(def.getType().getLogicalSize());
        } else if (types instanceof Types.Complex32Vector) {
            abstractValueStatistics = new Complex32VectorValueStatistics(def.getType().getLogicalSize());
        } else if (types instanceof Types.Complex64Vector) {
            abstractValueStatistics = new Complex64VectorValueStatistics(def.getType().getLogicalSize());
        } else if (types instanceof Types.ByteString) {
            abstractValueStatistics = new ByteStringValueStatistics();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this(columnName, types2, abstractValueStatistics);
    }

    private final Serialized toSerialized() {
        return new Serialized(this.type, this.statistics);
    }

    @NotNull
    public final Name.ColumnName component1() {
        return this.name;
    }

    @NotNull
    public final Types<?> component2() {
        return this.type;
    }

    @NotNull
    public final ValueStatistics<?> component3() {
        return this.statistics;
    }

    @NotNull
    public final StatisticsCatalogueEntry copy(@NotNull Name.ColumnName name, @NotNull Types<?> type, @NotNull ValueStatistics<?> statistics) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(statistics, (String)"statistics");
        return new StatisticsCatalogueEntry(name, type, statistics);
    }

    public static /* synthetic */ StatisticsCatalogueEntry copy$default(StatisticsCatalogueEntry statisticsCatalogueEntry, Name.ColumnName columnName, Types types, ValueStatistics valueStatistics, int n, Object object) {
        if ((n & 1) != 0) {
            columnName = statisticsCatalogueEntry.name;
        }
        if ((n & 2) != 0) {
            types = statisticsCatalogueEntry.type;
        }
        if ((n & 4) != 0) {
            valueStatistics = statisticsCatalogueEntry.statistics;
        }
        return statisticsCatalogueEntry.copy(columnName, types, valueStatistics);
    }

    @NotNull
    public String toString() {
        return "StatisticsCatalogueEntry(name=" + this.name + ", type=" + this.type + ", statistics=" + this.statistics + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.type.hashCode();
        result = result * 31 + this.statistics.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StatisticsCatalogueEntry)) {
            return false;
        }
        StatisticsCatalogueEntry statisticsCatalogueEntry = (StatisticsCatalogueEntry)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)statisticsCatalogueEntry.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.type, statisticsCatalogueEntry.type)) {
            return false;
        }
        return Intrinsics.areEqual(this.statistics, statisticsCatalogueEntry.statistics);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001bB\u001d\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000H\u0096\u0002J\r\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\r\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0003J%\u0010\u0010\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\fH\u00d6\u0001J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0015\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/StatisticsCatalogueEntry$Serialized;", "", "type", "Lorg/vitrivr/cottontail/core/values/types/Types;", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "(Lorg/vitrivr/cottontail/core/values/types/Types;Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;)V", "getStatistics", "()Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "getType", "()Lorg/vitrivr/cottontail/core/values/types/Types;", "compareTo", "", "other", "component1", "component2", "copy", "equals", "", "", "hashCode", "toActual", "Lorg/vitrivr/cottontail/dbms/catalogue/entries/StatisticsCatalogueEntry;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "toString", "", "Companion", "cottontaildb-dbms"})
    private static final class Serialized
    implements Comparable<Serialized> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Types<?> type;
        @NotNull
        private final ValueStatistics<?> statistics;

        public Serialized(@NotNull Types<?> type, @NotNull ValueStatistics<?> statistics) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter(statistics, (String)"statistics");
            this.type = type;
            this.statistics = statistics;
        }

        @NotNull
        public final Types<?> getType() {
            return this.type;
        }

        @NotNull
        public final ValueStatistics<?> getStatistics() {
            return this.statistics;
        }

        @NotNull
        public final StatisticsCatalogueEntry toActual(@NotNull Name.ColumnName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new StatisticsCatalogueEntry(name, this.type, this.statistics);
        }

        @Override
        public int compareTo(@NotNull Serialized other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return Intrinsics.compare((int)this.type.getOrdinal(), (int)other.type.getOrdinal());
        }

        @NotNull
        public final Types<?> component1() {
            return this.type;
        }

        @NotNull
        public final ValueStatistics<?> component2() {
            return this.statistics;
        }

        @NotNull
        public final Serialized copy(@NotNull Types<?> type, @NotNull ValueStatistics<?> statistics) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter(statistics, (String)"statistics");
            return new Serialized(type, statistics);
        }

        public static /* synthetic */ Serialized copy$default(Serialized serialized, Types types, ValueStatistics valueStatistics, int n, Object object) {
            if ((n & 1) != 0) {
                types = serialized.type;
            }
            if ((n & 2) != 0) {
                valueStatistics = serialized.statistics;
            }
            return serialized.copy(types, valueStatistics);
        }

        @NotNull
        public String toString() {
            return "Serialized(type=" + this.type + ", statistics=" + this.statistics + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.statistics.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Serialized)) {
                return false;
            }
            Serialized serialized = (Serialized)other;
            if (!Intrinsics.areEqual(this.type, serialized.type)) {
                return false;
            }
            return Intrinsics.areEqual(this.statistics, serialized.statistics);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/StatisticsCatalogueEntry$Serialized$Companion;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "readObject", "Lorg/vitrivr/cottontail/dbms/catalogue/entries/StatisticsCatalogueEntry$Serialized;", "stream", "Ljava/io/ByteArrayInputStream;", "writeObject", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "", "cottontaildb-dbms"})
        public static final class Companion
        extends ComparableBinding {
            private Companion() {
            }

            @NotNull
            public Serialized readObject(@NotNull ByteArrayInputStream stream) {
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                Types type = Types.Companion.forOrdinal(IntegerBinding.readCompressed((ByteArrayInputStream)stream), IntegerBinding.readCompressed((ByteArrayInputStream)stream));
                XodusBinding serializer2 = StatisticsSerializerFactory.INSTANCE.xodus(type);
                return new Serialized(type, serializer2.read(stream));
            }

            public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<? super Serialized> object) {
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                Intrinsics.checkNotNullParameter(object, (String)"object");
                if (!(object instanceof Serialized)) {
                    boolean bl = false;
                    String string = object + " cannot be written as statistics entry.";
                    throw new IllegalArgumentException(string.toString());
                }
                IntegerBinding.writeCompressed((LightOutputStream)output, (int)((Serialized)object).getType().getOrdinal());
                IntegerBinding.writeCompressed((LightOutputStream)output, (int)((Serialized)object).getType().getLogicalSize());
                XodusBinding<ValueStatistics<?>> xodusBinding = StatisticsSerializerFactory.INSTANCE.xodus(((Serialized)object).getType());
                Intrinsics.checkNotNull(xodusBinding, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.statistics.xodus.XodusBinding<org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics<*>>");
                XodusBinding<ValueStatistics<?>> serializer2 = xodusBinding;
                serializer2.write(output, ((Serialized)object).getStatistics());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0010J'\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0013J\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0016J%\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/vitrivr/cottontail/dbms/catalogue/entries/StatisticsCatalogueEntry$Companion;", "", "()V", "CATALOGUE_STATISTICS_STORE_NAME", "", "delete", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "transaction", "Ljetbrains/exodus/env/Transaction;", "delete$cottontaildb_dbms", "init", "", "init$cottontaildb_dbms", "read", "Lorg/vitrivr/cottontail/dbms/catalogue/entries/StatisticsCatalogueEntry;", "read$cottontaildb_dbms", "store", "Ljetbrains/exodus/env/Store;", "store$cottontaildb_dbms", "write", "entry", "write$cottontaildb_dbms", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Store store$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Store store = catalogue.getEnvironment$cottontaildb_dbms().openStore(StatisticsCatalogueEntry.CATALOGUE_STATISTICS_STORE_NAME, StoreConfig.USE_EXISTING, transaction, false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Failed to open store for column statistics catalogue.");
            }
            return store;
        }

        public final void init$cottontaildb_dbms(@NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (catalogue.getEnvironment$cottontaildb_dbms().openStore(StatisticsCatalogueEntry.CATALOGUE_STATISTICS_STORE_NAME, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, transaction, true) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to create column statistics catalogue store.");
            }
        }

        @Nullable
        public final StatisticsCatalogueEntry read$cottontaildb_dbms(@NotNull Name.ColumnName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            StatisticsCatalogueEntry statisticsCatalogueEntry;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            ByteIterable rawEntry = this.store$cottontaildb_dbms(catalogue, transaction).get(transaction, (ByteIterable)NameBinding.Column.INSTANCE.objectToEntry((Comparable)name));
            if (rawEntry != null) {
                Comparable comparable = Serialized.Companion.entryToObject(rawEntry);
                Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.catalogue.entries.StatisticsCatalogueEntry.Serialized");
                statisticsCatalogueEntry = ((Serialized)comparable).toActual(name);
            } else {
                statisticsCatalogueEntry = null;
            }
            return statisticsCatalogueEntry;
        }

        public final boolean write$cottontaildb_dbms(@NotNull StatisticsCatalogueEntry entry, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            return this.store$cottontaildb_dbms(catalogue, transaction).put(transaction, (ByteIterable)NameBinding.Column.INSTANCE.objectToEntry((Comparable)entry.getName()), (ByteIterable)Serialized.Companion.objectToEntry(entry.toSerialized()));
        }

        public final boolean delete$cottontaildb_dbms(@NotNull Name.ColumnName name, @NotNull DefaultCatalogue catalogue, @NotNull Transaction transaction) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            return this.store$cottontaildb_dbms(catalogue, transaction).delete(transaction, (ByteIterable)NameBinding.Column.INSTANCE.objectToEntry((Comparable)name));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

