/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.column;

import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.catalogue.entries.StatisticsCatalogueEntry;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializerFactory;
import org.vitrivr.cottontail.storage.serializers.values.xodus.XodusBinding;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001#B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/dbms/column/DefaultColumn;", "T", "Lorg/vitrivr/cottontail/core/values/types/Value;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "columnDef", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/ColumnDef;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "closed", "", "getClosed", "()Z", "getColumnDef", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Tx", "cottontaildb-dbms"})
public final class DefaultColumn<T extends Value>
implements Column<T> {
    @NotNull
    private final ColumnDef<T> columnDef;
    @NotNull
    private final DefaultEntity parent;

    public DefaultColumn(@NotNull ColumnDef<T> columnDef2, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter(columnDef2, (String)"columnDef");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.columnDef = columnDef2;
        this.parent = parent;
    }

    @Override
    @NotNull
    public ColumnDef<T> getColumnDef() {
        return this.columnDef;
    }

    @Override
    @NotNull
    public DefaultEntity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Name.ColumnName getName() {
        return this.getColumnDef().getName();
    }

    @Override
    public boolean getClosed() {
        return this.getParent().getClosed();
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V3_0;
    }

    @Override
    @NotNull
    public ColumnTx<T> newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    @Override
    @NotNull
    public Types<T> getType() {
        return Column.DefaultImpls.getType(this);
    }

    @Override
    public int getSize() {
        return Column.DefaultImpls.getSize(this);
    }

    @Override
    public boolean getNullable() {
        return Column.DefaultImpls.getNullable(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J#\u0010\u0016\u001a\u00020\u00112\n\u0010\u0017\u001a\u00060\tj\u0002`\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\u0014\u0010\u001f\u001a\u00020\u00112\n\u0010\u0017\u001a\u00060\tj\u0002`\u0018H\u0016J\b\u0010 \u001a\u00020\tH\u0016J\u0010\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\"H\u0016J\u0018\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\"2\u0006\u0010#\u001a\u00020$H\u0016J\u001b\u0010%\u001a\u0004\u0018\u00018\u00002\n\u0010\u0017\u001a\u00060\tj\u0002`\u0018H\u0016\u00a2\u0006\u0002\u0010&J\u001b\u0010'\u001a\u0004\u0018\u00018\u00002\n\u0010\u0017\u001a\u00060\tj\u0002`\u0018H\u0016\u00a2\u0006\u0002\u0010&J\f\u0010(\u001a\u00060\tj\u0002`\u0018H\u0016J\f\u0010)\u001a\u00060\tj\u0002`\u0018H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013H\u0016J%\u0010*\u001a\u0004\u0018\u00018\u00002\n\u0010\u0017\u001a\u00060\tj\u0002`\u00182\b\u0010\u0019\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010+R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015\u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/dbms/column/DefaultColumn$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/column/ColumnTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/column/DefaultColumn;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "binding", "Lorg/vitrivr/cottontail/storage/serializers/values/xodus/XodusBinding;", "closeStamp", "", "dataStore", "Ljetbrains/exodus/env/Store;", "dbo", "Lorg/vitrivr/cottontail/dbms/column/DefaultColumn;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/column/DefaultColumn;", "dirty", "", "statistics", "Lorg/vitrivr/cottontail/dbms/statistics/columns/ValueStatistics;", "getStatistics$annotations", "()V", "add", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "value", "(JLorg/vitrivr/cottontail/core/values/types/Value;)Z", "beforeCommit", "", "cleanup", "clear", "contains", "count", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "partition", "Lkotlin/ranges/LongRange;", "delete", "(J)Lorg/vitrivr/cottontail/core/values/types/Value;", "get", "largestTupleId", "smallestTupleId", "update", "(JLorg/vitrivr/cottontail/core/values/types/Value;)Lorg/vitrivr/cottontail/core/values/types/Value;", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements ColumnTx<T> {
        @NotNull
        private Store dataStore;
        @NotNull
        private final XodusBinding<T> binding;
        @NotNull
        private final ValueStatistics<T> statistics;
        private volatile boolean dirty;
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            Store store = DefaultColumn.this.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(DefaultColumn.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for column " + DefaultColumn.this.getName() + " is missing.");
            }
            this.dataStore = store;
            this.binding = ValueSerializerFactory.INSTANCE.xodus(DefaultColumn.this.getColumnDef().getType(), DefaultColumn.this.getNullable());
            Object object = StatisticsCatalogueEntry.Companion.read$cottontaildb_dbms(DefaultColumn.this.getName(), DefaultColumn.this.getCatalogue(), this.getContext().getXodusTx());
            if (object == null || (object = ((StatisticsCatalogueEntry)object).getStatistics()) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to PUT value from " + DefaultColumn.this.getName() + ": Reading column statistics failed.");
            }
            this.statistics = object;
            if (((DefaultColumn)this.getDbo()).getClosed()) {
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), this.getDbo());
            }
            this.closeStamp = ((DefaultColumn)this.getDbo()).getCatalogue().getCloseLock$cottontaildb_dbms().readLock();
        }

        private static /* synthetic */ void getStatistics$annotations() {
        }

        @Override
        @NotNull
        public DefaultColumn<T> getDbo() {
            return DefaultColumn.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public ValueStatistics<T> statistics() {
            ValueStatistics valueStatistics;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                valueStatistics = this.statistics;
            }
            finally {
                lock2.unlock();
            }
            return valueStatistics;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long smallestTupleId() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Cursor cursor2 = this.dataStore.openCursor(this.getContext().getXodusTx());
                long ret = cursor2.getNext() ? LongBinding.compressedEntryToLong((ByteIterable)cursor2.getKey()) : -1L;
                cursor2.close();
                l = ret;
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long largestTupleId() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Cursor cursor2 = this.dataStore.openCursor(this.getContext().getXodusTx());
                long ret = cursor2.getLast() ? LongBinding.compressedEntryToLong((ByteIterable)cursor2.getKey()) : -1L;
                cursor2.close();
                l = ret;
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.dataStore.count(this.getContext().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(long tupleId) {
            boolean bl;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl2 = false;
                bl = this.dataStore.get(this.getContext().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(tupleId)) != null;
            }
            finally {
                lock2.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T get(long tupleId) {
            Lock lock2 = this.getTxLatch();
            DefaultColumn defaultColumn = DefaultColumn.this;
            lock2.lock();
            try {
                boolean bl = false;
                ByteIterable byteIterable = this.dataStore.get(this.getContext().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(tupleId));
                if (byteIterable == null) {
                    throw new IllegalArgumentException("Tuple " + tupleId + " does not exist on column " + defaultColumn.getName() + '.');
                }
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"this.dataStore.get(this.\u2026is@DefaultColumn.name}.\")");
                ByteIterable ret = byteIterable;
                Object t = this.binding.entryToValue(ret);
                return t;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        public boolean add(long tupleId, @Nullable T value) {
            ArrayByteIterable rawTuple = ExtensionsKt.toKey(tupleId);
            ByteIterable valueRaw = this.binding.valueToEntry(value);
            if (this.dataStore.add(this.getContext().getXodusTx(), (ByteIterable)rawTuple, valueRaw)) {
                this.dirty = true;
                this.statistics.insert(value);
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T update(long tupleId, @Nullable T value) {
            Lock lock2 = this.getTxLatch();
            DefaultColumn defaultColumn = DefaultColumn.this;
            lock2.lock();
            try {
                boolean bl = false;
                ArrayByteIterable rawTuple = ExtensionsKt.toKey(tupleId);
                ByteIterable valueRaw = this.binding.valueToEntry(value);
                ByteIterable byteIterable = this.dataStore.get(this.getContext().getXodusTx(), (ByteIterable)rawTuple);
                if (byteIterable == null) {
                    throw new IllegalArgumentException("Cannot update tuple " + tupleId + " because it does not exist.");
                }
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"this.dataStore.get(this.\u2026ause it does not exist.\")");
                ByteIterable existingRaw = byteIterable;
                Object existing = this.binding.entryToValue(existingRaw);
                if (!this.dataStore.put(this.getContext().getXodusTx(), (ByteIterable)rawTuple, valueRaw)) {
                    throw new DatabaseException.DataCorruptionException("Failed to PUT tuple " + tupleId + " to column " + defaultColumn.getName() + '.');
                }
                this.dirty = true;
                this.statistics.update(existing, value);
                Object t = existing;
                return t;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public T delete(long tupleId) {
            Lock lock2 = this.getTxLatch();
            DefaultColumn defaultColumn = DefaultColumn.this;
            lock2.lock();
            try {
                boolean bl = false;
                ArrayByteIterable rawTuple = ExtensionsKt.toKey(tupleId);
                ByteIterable byteIterable = this.dataStore.get(this.getContext().getXodusTx(), (ByteIterable)rawTuple);
                if (byteIterable == null) {
                    throw new IllegalArgumentException("Cannot DELETE tuple " + tupleId + " because it does not exist.");
                }
                Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"this.dataStore.get(this.\u2026ause it does not exist.\")");
                ByteIterable existingRaw = byteIterable;
                Object existing = this.binding.entryToValue(existingRaw);
                if (!this.dataStore.delete(this.getContext().getXodusTx(), (ByteIterable)rawTuple)) {
                    throw new DatabaseException.DataCorruptionException("Failed to DELETE tuple " + tupleId + " to column " + defaultColumn.getName() + '.');
                }
                this.dirty = true;
                this.statistics.delete(existing);
                Object t = existing;
                return t;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                this.dataStore.getEnvironment().truncateStore(this.dataStore.getName(), this.getContext().getXodusTx());
                Store store = this.dataStore.getEnvironment().openStore(this.dataStore.getName(), StoreConfig.USE_EXISTING, this.getContext().getXodusTx());
                Intrinsics.checkNotNullExpressionValue((Object)store, (String)"this.dataStore.environme\u2026NG, this.context.xodusTx)");
                this.dataStore = store;
                this.statistics.reset();
                this.dirty = true;
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<T> cursor() {
            org.vitrivr.cottontail.core.basics.Cursor cursor2;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                cursor2 = this.cursor(new LongRange(this.smallestTupleId(), this.largestTupleId()));
            }
            finally {
                lock2.unlock();
            }
            return cursor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<T> cursor(@NotNull LongRange partition) {
            org.vitrivr.cottontail.core.basics.Cursor cursor2;
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Lock lock2 = this.getTxLatch();
            DefaultColumn defaultColumn = DefaultColumn.this;
            lock2.lock();
            try {
                boolean bl = false;
                cursor2 = new org.vitrivr.cottontail.core.basics.Cursor<T>(defaultColumn, this, partition){
                    @NotNull
                    private final XodusBinding<T> binding;
                    private final Transaction subTransaction;
                    @NotNull
                    private final Cursor cursor;
                    private long tupleId;
                    @Nullable
                    private T value;
                    private boolean dirty;
                    final /* synthetic */ LongRange $partition;
                    {
                        this.$partition = $partition;
                        this.binding = ValueSerializerFactory.INSTANCE.xodus($receiver.getColumnDef().getType(), $receiver.getNullable());
                        this.subTransaction = $receiver2.getContext().getXodusTx().getReadonlySnapshot();
                        Cursor cursor2 = Tx.access$getDataStore$p($receiver2).openCursor(this.subTransaction);
                        Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"this@Tx.dataStore.openCursor(this.subTransaction)");
                        this.cursor = cursor2;
                        this.tupleId = -1L;
                        this.dirty = true;
                    }

                    public boolean moveNext() {
                        boolean bl;
                        if (!(!this.subTransaction.isFinished())) {
                            boolean bl2 = false;
                            String string = "Cursor cannot be moved because associated transaction has completed!";
                            throw new IllegalStateException(string.toString());
                        }
                        if (this.tupleId == -1L) {
                            if (this.$partition.getFirst() == -1L) {
                                return false;
                            }
                            bl = this.cursor.getSearchKeyRange((ByteIterable)ExtensionsKt.toKey(this.$partition.getFirst())) != null;
                        } else {
                            bl = this.dirty = this.cursor.getNext();
                        }
                        if (this.dirty) {
                            this.tupleId = LongBinding.compressedEntryToLong((ByteIterable)this.cursor.getKey());
                        }
                        return this.dirty && this.tupleId <= this.$partition.getLast();
                    }

                    public long key() {
                        return this.tupleId;
                    }

                    @Nullable
                    public T value() {
                        if (this.dirty) {
                            ByteIterable byteIterable = this.cursor.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"this.cursor.value");
                            this.value = this.binding.entryToValue(byteIterable);
                            this.dirty = false;
                        }
                        return this.value;
                    }

                    public void close() {
                        this.cursor.close();
                        this.subTransaction.abort();
                    }

                    public boolean hasNext() {
                        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
                    }

                    @Nullable
                    public T next() {
                        return (T)((Value)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this));
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                lock2.unlock();
            }
            return cursor2;
        }

        @Override
        public void beforeCommit() {
            if (this.dirty) {
                StatisticsCatalogueEntry statisticsCatalogueEntry = StatisticsCatalogueEntry.Companion.read$cottontaildb_dbms(DefaultColumn.this.getName(), DefaultColumn.this.getCatalogue(), this.getContext().getXodusTx());
                if (statisticsCatalogueEntry == null) {
                    throw new DatabaseException.DataCorruptionException("Failed to DELETE value from " + DefaultColumn.this.getName() + ": Reading column statistics failed.");
                }
                StatisticsCatalogueEntry entry = statisticsCatalogueEntry;
                StatisticsCatalogueEntry.Companion.write$cottontaildb_dbms(StatisticsCatalogueEntry.copy$default(entry, null, null, this.statistics, 3, null), DefaultColumn.this.getCatalogue(), this.getContext().getXodusTx());
            }
            super.beforeCommit();
        }

        @Override
        public void cleanup() {
            ((DefaultColumn)this.getDbo()).getCatalogue().getCloseLock$cottontaildb_dbms().unlockRead(this.closeStamp);
        }

        @Override
        @NotNull
        public ColumnDef<T> getColumnDef() {
            return ColumnTx.DefaultImpls.getColumnDef(this);
        }

        public static final /* synthetic */ Store access$getDataStore$p(Tx $this) {
            return $this.dataStore;
        }
    }
}

