/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.entity;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.entries.ColumnCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.EntityCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.SequenceCatalogueEntries;
import org.vitrivr.cottontail.dbms.catalogue.entries.StatisticsCatalogueEntry;
import org.vitrivr.cottontail.dbms.column.Column;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.column.DefaultColumn;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.Entity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.Index;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.dbms.schema.DefaultSchema;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u00060\u001cR\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "Lorg/vitrivr/cottontail/dbms/entity/Entity;", "name", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "parent", "Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "closed", "", "getClosed", "()Z", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/schema/DefaultSchema;", "sequenceName", "Lorg/vitrivr/cottontail/core/database/Name$SequenceName;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Tx", "cottontaildb-dbms"})
public final class DefaultEntity
implements Entity {
    @NotNull
    private final Name.EntityName name;
    @NotNull
    private final DefaultSchema parent;
    @NotNull
    private final Name.SequenceName sequenceName;

    public DefaultEntity(@NotNull Name.EntityName name, @NotNull DefaultSchema parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        this.sequenceName = this.getName().tid();
    }

    @Override
    @NotNull
    public Name.EntityName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public DefaultSchema getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public DefaultCatalogue getCatalogue() {
        return this.getParent().getCatalogue();
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return DBOVersion.V3_0;
    }

    @Override
    public boolean getClosed() {
        return this.getParent().getClosed();
    }

    @Override
    @NotNull
    public Tx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u00060\u0007j\u0002`\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J2\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J%\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0%H\u0016\u00a2\u0006\u0002\u0010'J-\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0%2\u0006\u0010(\u001a\u00020)H\u0016\u00a2\u0006\u0002\u0010*J\u0014\u0010+\u001a\u00020\u00142\n\u0010\u0019\u001a\u00060\u0007j\u0002`\u001aH\u0016J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0014\u0010.\u001a\u00060\u0007j\u0002`\u001a2\u0006\u0010/\u001a\u00020$H\u0016J\f\u00100\u001a\u00060\u0007j\u0002`\u001aH\u0016J\u0012\u00101\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0\u001fH\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00020\u00110\u001fH\u0016J\b\u00103\u001a\u00020\u0014H\u0016J+\u00104\u001a\u00020$2\n\u0010\u0019\u001a\u00060\u0007j\u0002`\u001a2\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030&0%H\u0016\u00a2\u0006\u0002\u00105J\f\u00106\u001a\u00060\u0007j\u0002`\u001aH\u0016J\u0010\u00107\u001a\u00020\u00142\u0006\u0010/\u001a\u00020$H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "columns", "Lit/unimi/dsi/fastutil/objects/Object2ObjectLinkedOpenHashMap;", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "Lorg/vitrivr/cottontail/dbms/column/Column;", "dbo", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "indexes", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "Lorg/vitrivr/cottontail/dbms/index/Index;", "cleanup", "", "columnForName", "name", "contains", "", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "count", "createIndex", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "", "configuration", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "cursor", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/core/basics/Cursor;", "partition", "Lkotlin/ranges/LongRange;", "([Lorg/vitrivr/cottontail/core/database/ColumnDef;Lkotlin/ranges/LongRange;)Lorg/vitrivr/cottontail/core/basics/Cursor;", "delete", "dropIndex", "indexForName", "insert", "record", "largestTupleId", "listColumns", "listIndexes", "optimize", "read", "(J[Lorg/vitrivr/cottontail/core/database/ColumnDef;)Lorg/vitrivr/cottontail/core/basics/Record;", "smallestTupleId", "update", "cottontaildb-dbms"})
    public final class Tx
    extends AbstractTx
    implements EntityTx {
        @NotNull
        private final Object2ObjectLinkedOpenHashMap<Name.ColumnName, Column<?>> columns;
        @NotNull
        private final Object2ObjectLinkedOpenHashMap<Name.IndexName, Index> indexes;
        private final long closeStamp;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            this.columns = new Object2ObjectLinkedOpenHashMap();
            this.indexes = new Object2ObjectLinkedOpenHashMap();
            if (this.getDbo().getClosed()) {
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), this.getDbo());
            }
            this.closeStamp = this.getDbo().getCatalogue().getCloseLock$cottontaildb_dbms().readLock();
            EntityCatalogueEntry entityCatalogueEntry = EntityCatalogueEntry.Companion.read$cottontaildb_dbms(DefaultEntity.this.getName(), DefaultEntity.this.getCatalogue(), this.getContext().getXodusTx());
            if (entityCatalogueEntry == null) {
                throw new DatabaseException.DataCorruptionException("Catalogue entry for entity " + DefaultEntity.this.getName() + " is missing.");
            }
            EntityCatalogueEntry entityEntry = entityCatalogueEntry;
            for (Name.ColumnName c : entityEntry.getColumns()) {
                ColumnCatalogueEntry columnEntry;
                if (ColumnCatalogueEntry.Companion.read$cottontaildb_dbms(c, DefaultEntity.this.getCatalogue(), this.getContext().getXodusTx()) == null) {
                    throw new DatabaseException.DataCorruptionException("Catalogue entry for column " + c + " is missing.");
                }
                ((Map)this.columns).put(c, new DefaultColumn(columnEntry.toColumnDef(), DefaultEntity.this));
            }
            for (Name.IndexName i : entityEntry.getIndexes()) {
                IndexCatalogueEntry indexEntry;
                if (IndexCatalogueEntry.Companion.read$cottontaildb_dbms(i, DefaultEntity.this.getCatalogue(), this.getContext().getXodusTx()) == null) {
                    throw new DatabaseException.DataCorruptionException("Catalogue entry for index " + i + " is missing.");
                }
                ((Map)this.indexes).put(i, indexEntry.getType().getDescriptor().open(i, this.getDbo()));
            }
        }

        @Override
        @NotNull
        public DefaultEntity getDbo() {
            return DefaultEntity.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(long tupleId) {
            boolean bl;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl2 = false;
                TransactionContext transactionContext = this.getContext();
                Collection collection = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"this.columns.values");
                Object object = CollectionsKt.first((Iterable)collection);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.columns.values.first()");
                org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx((DBO)object);
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                bl = ((ColumnTx)tx).contains(tupleId);
            }
            finally {
                lock2.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Record read(long tupleId, @NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                boolean bl = false;
                Object $this$map$iv = columns;
                boolean $i$f$map = false;
                ColumnDef<?>[] columnDefArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((ColumnDef<?>[])$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var15_15 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    TransactionContext transactionContext = this.getContext();
                    Collection collection2 = this.columns.values();
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"this.columns.values");
                    Object object = CollectionsKt.first((Iterable)collection2);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.columns.values.first()");
                    org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx((DBO)object);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                    ColumnTx cfr_ignored_0 = (ColumnTx)tx;
                    TransactionContext transactionContext2 = this.getContext();
                    Column column = (Column)this.columns.get((Object)it.getName());
                    if (column == null) {
                        throw new IllegalArgumentException("Column " + it.getName() + " does not exist on entity " + defaultEntity.getName() + '.');
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)column, (String)"this.columns[it.name] ?:\u2026is@DefaultEntity.name}.\")");
                    org.vitrivr.cottontail.dbms.general.Tx tx2 = transactionContext2.getTx(column);
                    Intrinsics.checkNotNull((Object)tx2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                    ColumnTx tx3 = (ColumnTx)tx2;
                    collection.add(tx3.get(tupleId));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Value[] valueArray = thisCollection$iv.toArray(new Value[0]);
                Intrinsics.checkNotNull((Object)valueArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                Value[] values = valueArray;
                Record record = (Record)new StandaloneRecord(tupleId, columns, values);
                return record;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                TransactionContext transactionContext = this.getContext();
                Collection collection = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"this.columns.values");
                Object object = CollectionsKt.first((Iterable)collection);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.columns.values.first()");
                org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx((DBO)object);
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                l = ((ColumnTx)tx).count();
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long smallestTupleId() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                TransactionContext transactionContext = this.getContext();
                Collection collection = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"this.columns.values");
                Object object = CollectionsKt.first((Iterable)collection);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.columns.values.first()");
                org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx((DBO)object);
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                l = ((ColumnTx)tx).smallestTupleId();
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long largestTupleId() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                TransactionContext transactionContext = this.getContext();
                Collection collection = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"this.columns.values");
                Object object = CollectionsKt.first((Iterable)collection);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.columns.values.first()");
                org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx((DBO)object);
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                l = ((ColumnTx)tx).largestTupleId();
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> listColumns() {
            List list;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                Collection collection = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"this.columns.values");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Column column = (Column)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(it.getColumnDef());
                }
                list = (List)destination$iv$iv;
            }
            finally {
                lock2.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Column<?> columnForName(@NotNull Name.ColumnName name) {
            Column column;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                Name.ColumnName fqn = defaultEntity.getName().column(name.getSimple());
                Column column2 = (Column)this.columns.get((Object)fqn);
                if (column2 == null) {
                    throw new DatabaseException.ColumnDoesNotExistException(fqn);
                }
                Column column3 = column2;
                column = column3;
            }
            finally {
                lock2.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)column, (String)"this.txLatch.withLock {\n\u2026tException(fqn)\n        }");
            return column;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<Name.IndexName> listIndexes() {
            List list;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Set set = this.indexes.keySet();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"this.indexes.keys");
                list = CollectionsKt.toList((Iterable)set);
            }
            finally {
                lock2.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Index indexForName(@NotNull Name.IndexName name) {
            Index index;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Index index2 = (Index)this.indexes.get((Object)name);
                if (index2 == null) {
                    throw new DatabaseException.IndexDoesNotExistException((Name)name);
                }
                Index index3 = index2;
                index = index3;
            }
            finally {
                lock2.unlock();
            }
            Intrinsics.checkNotNullExpressionValue((Object)index, (String)"this.txLatch.withLock {\n\u2026Exception(name)\n        }");
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Index createIndex(@NotNull Name.IndexName name, @NotNull IndexType type, @NotNull List<Name.ColumnName> columns, @NotNull IndexConfig<?> configuration) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                IndexCatalogueEntry indexEntry;
                IndexType[] indexTypeArray;
                boolean bl = false;
                EntityCatalogueEntry entityCatalogueEntry = EntityCatalogueEntry.Companion.read$cottontaildb_dbms(defaultEntity.getName(), defaultEntity.getCatalogue(), this.getContext().getXodusTx());
                if (entityCatalogueEntry == null) {
                    throw new DatabaseException.DataCorruptionException("CREATE index " + name + " failed: Failed to read catalogue entry for entity.");
                }
                EntityCatalogueEntry entity = entityCatalogueEntry;
                if (IndexCatalogueEntry.Companion.exists$cottontaildb_dbms(name, defaultEntity.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.IndexAlreadyExistsException(name);
                }
                IndexCatalogueEntry indexCatalogueEntry = this.count() == 0L && SetsKt.setOf((Object[])(indexTypeArray = new IndexType[]{IndexType.BTREE_UQ, IndexType.BTREE, IndexType.LUCENE})).contains((Object)type) ? new IndexCatalogueEntry(name, type, IndexState.CLEAN, columns, configuration) : (indexEntry = new IndexCatalogueEntry(name, type, IndexState.DIRTY, columns, configuration));
                if (!IndexCatalogueEntry.Companion.write$cottontaildb_dbms(indexEntry, defaultEntity.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.DataCorruptionException("CREATE index " + name + " failed: Failed to create catalogue entry.");
                }
                if (!type.getDescriptor().initialize(name, this)) {
                    throw new DatabaseException.DataCorruptionException("CREATE index " + name + " failed: Failed to initialize store.");
                }
                EntityCatalogueEntry.Companion.write$cottontaildb_dbms(EntityCatalogueEntry.copy$default(entity, null, 0L, null, CollectionsKt.plus((Collection)entity.getIndexes(), (Object)name), 7, null), defaultEntity.getCatalogue(), this.getContext().getXodusTx());
                Object ret = type.getDescriptor().open(name, defaultEntity);
                ((Map)this.indexes).put(name, ret);
                Object obj = ret;
                return obj;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dropIndex(@NotNull Name.IndexName name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                EntityCatalogueEntry entityCatalogueEntry = EntityCatalogueEntry.Companion.read$cottontaildb_dbms(defaultEntity.getName(), defaultEntity.getCatalogue(), this.getContext().getXodusTx());
                if (entityCatalogueEntry == null) {
                    throw new DatabaseException.DataCorruptionException("CREATE index " + name + " failed: Failed to read catalogue entry for entity.");
                }
                EntityCatalogueEntry entity = entityCatalogueEntry;
                IndexCatalogueEntry indexCatalogueEntry = IndexCatalogueEntry.Companion.read$cottontaildb_dbms(name, defaultEntity.getCatalogue(), this.getContext().getXodusTx());
                if (indexCatalogueEntry == null) {
                    throw new DatabaseException.IndexDoesNotExistException((Name)name);
                }
                IndexCatalogueEntry indexEntry = indexCatalogueEntry;
                if (!indexEntry.getType().getDescriptor().deinitialize(name, this)) {
                    throw new DatabaseException.DataCorruptionException("DROP index " + name + " failed: Failed to de-initialize store.");
                }
                this.indexes.remove((Object)name);
                if (!IndexCatalogueEntry.Companion.delete$cottontaildb_dbms(name, defaultEntity.getCatalogue(), this.getContext().getXodusTx())) {
                    throw new DatabaseException.DataCorruptionException("DROP index " + name + " failed: Failed to delete catalogue entry.");
                }
                EntityCatalogueEntry.Companion.write$cottontaildb_dbms(EntityCatalogueEntry.copy$default(entity, null, 0L, null, CollectionsKt.minus((Iterable)entity.getIndexes(), (Object)name), 7, null), defaultEntity.getCatalogue(), this.getContext().getXodusTx());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void optimize() {
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                Object object;
                void $this$mapTo$iv$iv2;
                boolean bl = false;
                Collection collection = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"this.columns.values");
                Iterable $this$map$iv2 = collection;
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    ValueStatistics stat;
                    void it;
                    Column column = (Column)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    TransactionContext transactionContext = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx((DBO)it);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                    Intrinsics.checkNotNull(((ColumnTx)tx).statistics(), (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics<org.vitrivr.cottontail.core.values.types.Value>");
                    stat.reset();
                    object.add(stat);
                }
                List statistics = (List)destination$iv$iv;
                Collection collection2 = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"this.columns.values");
                Iterable $i$f$map22 = collection2;
                object = this;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Column bl2 = (Column)item$iv$iv;
                    Collection collection3 = destination$iv$iv2;
                    boolean bl3 = false;
                    collection3.add(it.getColumnDef());
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$toTypedArray2 = false;
                void thisCollection$iv2 = $this$toTypedArray$iv;
                ColumnDef[] columnDefArray = thisCollection$iv2.toArray(new ColumnDef[0]);
                Intrinsics.checkNotNull((Object)columnDefArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                Cursor<Record> cursor2 = ((Tx)object).cursor(columnDefArray);
                while (cursor2.moveNext()) {
                    Record value = (Record)cursor2.value();
                    ColumnDef[] $i$f$toTypedArray2 = value.getColumns();
                    int n = $i$f$toTypedArray2.length;
                    for (int thisCollection$iv2 = 0; thisCollection$iv2 < n; ++thisCollection$iv2) {
                        int i = thisCollection$iv2;
                        ColumnDef c = $i$f$toTypedArray2[thisCollection$iv2];
                        ((ValueStatistics)statistics.get(i)).insert(value.get(c));
                    }
                }
                cursor2.close();
                Collection collection4 = this.columns.values();
                Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"this.columns.values");
                Iterable $this$forEachIndexed$iv = collection4;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    StatisticsCatalogueEntry entry;
                    void c;
                    int n;
                    Object item$iv$iv;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    item$iv$iv = (Column)item$iv;
                    int i = n;
                    boolean bl4 = false;
                    if (StatisticsCatalogueEntry.Companion.read$cottontaildb_dbms(c.getColumnDef().getName(), defaultEntity.getCatalogue(), this.getContext().getXodusTx()) == null) {
                        throw new DatabaseException.DataCorruptionException("Failed to DELETE value from " + c.getColumnDef().getName() + ": Reading column statistics failed.");
                    }
                    StatisticsCatalogueEntry.Companion.write$cottontaildb_dbms(StatisticsCatalogueEntry.copy$default(entry, null, null, (ValueStatistics)statistics.get(i), 3, null), defaultEntity.getCatalogue(), this.getContext().getXodusTx());
                }
                for (Index index : (ObjectCollection)this.indexes.values()) {
                    TransactionContext transactionContext = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)index, (String)"index");
                    org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx(index);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.IndexTx");
                    ((IndexTx)tx).rebuild();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Cursor<Record> cursor(@NotNull ColumnDef<?>[] columns) {
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Cursor<Record> cursor2 = this.cursor(columns, new LongRange(this.smallestTupleId(), this.largestTupleId()));
                return cursor2;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Cursor<Record> cursor(@NotNull ColumnDef<?>[] columns, @NotNull LongRange partition) {
            Cursor<Record> cursor2;
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                cursor2 = new Cursor<Record>(columns, this, partition){
                    @NotNull
                    private final Cursor<? extends Value>[] cursors;
                    final /* synthetic */ ColumnDef<?>[] $columns;
                    {
                        this.$columns = $columns;
                        int n = 0;
                        int n2 = $columns.length;
                        Cursor[] cursorArray = new Cursor[n2];
                        cursor.2.1 var8_7 = this;
                        while (n < n2) {
                            int n3 = n++;
                            Column column = (Column)Tx.access$getColumns$p($receiver).get((Object)$columns[n3].getName());
                            if (column == null) {
                                throw new IllegalStateException("Column " + $columns[n3] + " missing in transaction.");
                            }
                            org.vitrivr.cottontail.dbms.general.Tx tx = $receiver.getContext().getTx(column);
                            Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                            cursorArray[n3] = ((ColumnTx)tx).cursor($partition);
                        }
                        var8_7.cursors = cursorArray;
                    }

                    public long key() {
                        return this.cursors[0].key();
                    }

                    @NotNull
                    public Record value() {
                        int n = 0;
                        int n2 = this.$columns.length;
                        Value[] valueArray = new Value[n2];
                        ColumnDef<?>[] columnDefArray = this.$columns;
                        long l = this.cursors[0].key();
                        while (n < n2) {
                            int n3 = n++;
                            valueArray[n3] = (Value)this.cursors[n3].value();
                        }
                        Value[] valueArray2 = valueArray;
                        ColumnDef<?>[] columnDefArray2 = columnDefArray;
                        long l2 = l;
                        return (Record)new StandaloneRecord(l2, columnDefArray2, valueArray2);
                    }

                    public boolean moveNext() {
                        boolean bl;
                        block1: {
                            Cursor<? extends Value>[] $this$all$iv = this.cursors;
                            boolean $i$f$all = false;
                            int n = $this$all$iv.length;
                            for (int i = 0; i < n; ++i) {
                                Cursor<? extends Value> element$iv;
                                Cursor<? extends Value> it = element$iv = $this$all$iv[i];
                                boolean bl2 = false;
                                if (it.moveNext()) continue;
                                bl = false;
                                break block1;
                            }
                            bl = true;
                        }
                        return bl;
                    }

                    public void close() {
                        Cursor<? extends Value>[] $this$forEach$iv = this.cursors;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            Cursor<? extends Value> element$iv;
                            Cursor<? extends Value> it = element$iv = $this$forEach$iv[i];
                            boolean bl = false;
                            it.close();
                        }
                    }

                    public boolean hasNext() {
                        return Cursor.DefaultImpls.hasNext((Cursor)this);
                    }

                    @NotNull
                    public Record next() {
                        return (Record)Cursor.DefaultImpls.next((Cursor)this);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                lock2.unlock();
            }
            return (Cursor)cursor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long insert(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                Long l = SequenceCatalogueEntries.INSTANCE.next$cottontaildb_dbms(defaultEntity.sequenceName, defaultEntity.getCatalogue(), this.getContext().getXodusTx());
                if (l == null) {
                    throw new DatabaseException.DataCorruptionException("Sequence entry for entity " + defaultEntity.getName() + " is missing.");
                }
                long nextTupleId = l;
                Object2ObjectArrayMap inserts = new Object2ObjectArrayMap(this.columns.size());
                for (Column column : (ObjectCollection)this.columns.values()) {
                    Value value = record.get(column.getColumnDef());
                    ((Map)inserts).put(column.getColumnDef(), value);
                    if (value == null && !column.getColumnDef().getNullable()) {
                        throw new DatabaseException.ValidationException("Cannot INSERT a NULL value into column " + column.getColumnDef() + '.');
                    }
                    TransactionContext transactionContext = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)column, (String)"column");
                    org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx(column);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<org.vitrivr.cottontail.core.values.types.Value>");
                    ((ColumnTx)tx).add(nextTupleId, value);
                }
                Operation.DataManagementOperation.InsertOperation operation = new Operation.DataManagementOperation.InsertOperation(this.getContext().getTxId(), defaultEntity.getName(), nextTupleId, (Map)inserts);
                for (Index index : (ObjectCollection)this.indexes.values()) {
                    TransactionContext transactionContext = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)index, (String)"index");
                    org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx(index);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.IndexTx");
                    ((IndexTx)tx).insert(operation);
                }
                this.getContext().signalEvent(operation);
                long l2 = nextTupleId;
                return l2;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(@NotNull Record record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                Object2ObjectArrayMap updates = new Object2ObjectArrayMap(record.getColumns().length);
                for (ColumnDef def : record.getColumns()) {
                    Column column;
                    if ((Column)this.columns.get((Object)def.getName()) == null) {
                        throw new DatabaseException.ColumnDoesNotExistException(def.getName());
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)column, (String)"this.columns[def.name] ?\u2026tExistException(def.name)");
                    org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(column);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                    ColumnTx columnTx = (ColumnTx)tx;
                    Value value = record.get(def);
                    if (value == null && !def.getNullable()) {
                        throw new DatabaseException.ValidationException("Record " + record.getTupleId() + " cannot be updated with NULL value for column " + def + ", because column is not nullable.");
                    }
                    Map map2 = (Map)updates;
                    Intrinsics.checkNotNull((Object)columnTx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<org.vitrivr.cottontail.core.values.types.Value>");
                    map2.put(def, new Pair((Object)columnTx.update(record.getTupleId(), value), (Object)value));
                }
                Operation.DataManagementOperation.UpdateOperation operation = new Operation.DataManagementOperation.UpdateOperation(this.getContext().getTxId(), defaultEntity.getName(), record.getTupleId(), (Map)updates);
                for (Index index : (ObjectCollection)this.indexes.values()) {
                    TransactionContext transactionContext = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)index, (String)"index");
                    org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx(index);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.IndexTx");
                    ((IndexTx)tx).update(operation);
                }
                this.getContext().signalEvent(operation);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete(long tupleId) {
            Lock lock2 = this.getTxLatch();
            DefaultEntity defaultEntity = DefaultEntity.this;
            lock2.lock();
            try {
                boolean bl = false;
                Object2ObjectArrayMap deleted = new Object2ObjectArrayMap(this.columns.size());
                for (Column column : (ObjectCollection)this.columns.values()) {
                    Map map2 = (Map)deleted;
                    ColumnDef columnDef2 = column.getColumnDef();
                    TransactionContext transactionContext = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)column, (String)"column");
                    org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx(column);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                    Object t = ((ColumnTx)tx).delete(tupleId);
                    map2.put(columnDef2, t);
                }
                Operation.DataManagementOperation.DeleteOperation operation = new Operation.DataManagementOperation.DeleteOperation(this.getContext().getTxId(), defaultEntity.getName(), tupleId, (Map)deleted);
                for (Index index : (ObjectCollection)this.indexes.values()) {
                    TransactionContext transactionContext = this.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)index, (String)"index");
                    org.vitrivr.cottontail.dbms.general.Tx tx = transactionContext.getTx(index);
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.IndexTx");
                    ((IndexTx)tx).delete(operation);
                }
                this.getContext().signalEvent(operation);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        public void cleanup() {
            this.getDbo().getCatalogue().getCloseLock$cottontaildb_dbms().unlockRead(this.closeStamp);
        }

        public static final /* synthetic */ Object2ObjectLinkedOpenHashMap access$getColumns$p(Tx $this) {
            return $this.columns;
        }
    }
}

