/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.exceptions;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.general.DBOVersion;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\b\u0016\u0018\u00002\u00020\u0001:\u000f\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "", "message", "", "cause", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "ColumnDoesNotExistException", "DataCorruptionException", "DuplicateColumnException", "EntityAlreadyExistsException", "EntityDoesNotExistException", "IndexAlreadyExistsException", "IndexDoesNotExistException", "IndexNotSupportedException", "InvalidFileException", "NoColumnException", "ReservedValueException", "SchemaAlreadyExistsException", "SchemaDoesNotExistException", "ValidationException", "VersionMismatchException", "cottontaildb-dbms"})
public class DatabaseException
extends Throwable {
    public DatabaseException(@NotNull String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(message, cause);
    }

    public /* synthetic */ DatabaseException(String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            throwable = null;
        }
        this(string, throwable);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$VersionMismatchException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "expected", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "found", "(Lorg/vitrivr/cottontail/dbms/general/DBOVersion;Lorg/vitrivr/cottontail/dbms/general/DBOVersion;)V", "getExpected", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getFound", "cottontaildb-dbms"})
    public static final class VersionMismatchException
    extends DatabaseException {
        @NotNull
        private final DBOVersion expected;
        @NotNull
        private final DBOVersion found;

        public VersionMismatchException(@NotNull DBOVersion expected, @NotNull DBOVersion found) {
            Intrinsics.checkNotNullParameter((Object)((Object)expected), (String)"expected");
            Intrinsics.checkNotNullParameter((Object)((Object)found), (String)"found");
            super("Version mismatch for DBO: Expected " + (Object)((Object)expected) + " but found " + (Object)((Object)found) + '.', null, 2, null);
            this.expected = expected;
            this.found = found;
        }

        @NotNull
        public final DBOVersion getExpected() {
            return this.expected;
        }

        @NotNull
        public final DBOVersion getFound() {
            return this.found;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$SchemaAlreadyExistsException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "schema", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "(Lorg/vitrivr/cottontail/core/database/Name$SchemaName;)V", "getSchema", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "cottontaildb-dbms"})
    public static final class SchemaAlreadyExistsException
    extends DatabaseException {
        @NotNull
        private final Name.SchemaName schema;

        public SchemaAlreadyExistsException(@NotNull Name.SchemaName schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super("Schema '" + schema + "' does already exist!", null, 2, null);
            this.schema = schema;
        }

        @NotNull
        public final Name.SchemaName getSchema() {
            return this.schema;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$SchemaDoesNotExistException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "schema", "Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "(Lorg/vitrivr/cottontail/core/database/Name$SchemaName;)V", "getSchema", "()Lorg/vitrivr/cottontail/core/database/Name$SchemaName;", "cottontaildb-dbms"})
    public static final class SchemaDoesNotExistException
    extends DatabaseException {
        @NotNull
        private final Name.SchemaName schema;

        public SchemaDoesNotExistException(@NotNull Name.SchemaName schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super("Schema '" + schema + "' does not exist!", null, 2, null);
            this.schema = schema;
        }

        @NotNull
        public final Name.SchemaName getSchema() {
            return this.schema;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$EntityAlreadyExistsException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "entity", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;)V", "getEntity", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "cottontaildb-dbms"})
    public static final class EntityAlreadyExistsException
    extends DatabaseException {
        @NotNull
        private final Name.EntityName entity;

        public EntityAlreadyExistsException(@NotNull Name.EntityName entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super("Entity '" + entity + "' does already exist!", null, 2, null);
            this.entity = entity;
        }

        @NotNull
        public final Name.EntityName getEntity() {
            return this.entity;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$EntityDoesNotExistException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "entity", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;)V", "getEntity", "()Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "cottontaildb-dbms"})
    public static final class EntityDoesNotExistException
    extends DatabaseException {
        @NotNull
        private final Name.EntityName entity;

        public EntityDoesNotExistException(@NotNull Name.EntityName entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super("Entity '" + entity + "' does not exist!", null, 2, null);
            this.entity = entity;
        }

        @NotNull
        public final Name.EntityName getEntity() {
            return this.entity;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$IndexAlreadyExistsException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "index", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;)V", "getIndex", "()Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "cottontaildb-dbms"})
    public static final class IndexAlreadyExistsException
    extends DatabaseException {
        @NotNull
        private final Name.IndexName index;

        public IndexAlreadyExistsException(@NotNull Name.IndexName index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super("Index '" + index + "' does already exist!", null, 2, null);
            this.index = index;
        }

        @NotNull
        public final Name.IndexName getIndex() {
            return this.index;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$IndexDoesNotExistException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "index", "Lorg/vitrivr/cottontail/core/database/Name;", "(Lorg/vitrivr/cottontail/core/database/Name;)V", "getIndex", "()Lorg/vitrivr/cottontail/core/database/Name;", "cottontaildb-dbms"})
    public static final class IndexDoesNotExistException
    extends DatabaseException {
        @NotNull
        private final Name index;

        public IndexDoesNotExistException(@NotNull Name index) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            super("Index '" + index + "' does not exist!", null, 2, null);
            this.index = index;
        }

        @NotNull
        public final Name getIndex() {
            return this.index;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$IndexNotSupportedException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "index", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "reason", "", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Ljava/lang/String;)V", "getIndex", "()Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "cottontaildb-dbms"})
    public static final class IndexNotSupportedException
    extends DatabaseException {
        @NotNull
        private final Name.IndexName index;

        public IndexNotSupportedException(@NotNull Name.IndexName index, @NotNull String reason) {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super("Index '" + index + "' could not be created: " + reason, null, 2, null);
            this.index = index;
        }

        @NotNull
        public final Name.IndexName getIndex() {
            return this.index;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$NoColumnException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "entity", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;)V", "cottontaildb-dbms"})
    public static final class NoColumnException
    extends DatabaseException {
        public NoColumnException(@NotNull Name.EntityName entity) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super("Entity '" + entity + "' could not be created because it does not contain a column.", null, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$DuplicateColumnException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "entity", "Lorg/vitrivr/cottontail/core/database/Name$EntityName;", "name", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "(Lorg/vitrivr/cottontail/core/database/Name$EntityName;Lorg/vitrivr/cottontail/core/database/Name$ColumnName;)V", "cottontaildb-dbms"})
    public static final class DuplicateColumnException
    extends DatabaseException {
        public DuplicateColumnException(@NotNull Name.EntityName entity, @NotNull Name.ColumnName name) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super("Entity '" + entity + "' could not be created because it contains duplicate column names '" + name + "'.", null, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$ColumnDoesNotExistException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "column", "Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "(Lorg/vitrivr/cottontail/core/database/Name$ColumnName;)V", "getColumn", "()Lorg/vitrivr/cottontail/core/database/Name$ColumnName;", "cottontaildb-dbms"})
    public static final class ColumnDoesNotExistException
    extends DatabaseException {
        @NotNull
        private final Name.ColumnName column;

        public ColumnDoesNotExistException(@NotNull Name.ColumnName column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            super("Column " + column + " does not exist.", null, 2, null);
            this.column = column;
        }

        @NotNull
        public final Name.ColumnName getColumn() {
            return this.column;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$InvalidFileException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "type", "", "(Ljava/lang/String;)V", "cottontaildb-dbms"})
    public static final class InvalidFileException
    extends DatabaseException {
        public InvalidFileException(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super("The provided file is not a valid " + type + " file!", null, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$DataCorruptionException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "message", "", "(Ljava/lang/String;)V", "cottontaildb-dbms"})
    public static final class DataCorruptionException
    extends DatabaseException {
        public DataCorruptionException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, null, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$ReservedValueException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "message", "", "(Ljava/lang/String;)V", "cottontaildb-dbms"})
    public static final class ReservedValueException
    extends DatabaseException {
        public ReservedValueException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, null, 2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$ValidationException;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException;", "message", "", "(Ljava/lang/String;)V", "cottontaildb-dbms"})
    public static final class ValidationException
    extends TransactionException {
        public ValidationException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message, (DefaultConstructorMarker)null);
        }
    }
}

