/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.exceptions;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.general.DBO;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0005\u0006\u0007\bB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u0082\u0001\u0005\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException;", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException;", "message", "", "(Ljava/lang/String;)V", "Commit", "DBOClosed", "InConflict", "Rollback", "Lorg/vitrivr/cottontail/dbms/exceptions/DatabaseException$ValidationException;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException$Commit;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException$DBOClosed;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException$InConflict;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException$Rollback;", "cottontaildb-dbms"})
public abstract class TransactionException
extends DatabaseException {
    private TransactionException(String message) {
        super(message, null, 2, null);
    }

    public /* synthetic */ TransactionException(String message, DefaultConstructorMarker $constructor_marker) {
        this(message);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException$DBOClosed;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException;", "tid", "", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "dbo", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "(JLorg/vitrivr/cottontail/dbms/general/DBO;)V", "cottontaildb-dbms"})
    public static final class DBOClosed
    extends TransactionException {
        public DBOClosed(long tid, @NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            super("Tx object for transaction " + tid + " could not be created for DBO '" + dbo.getName() + "': Enclosing DBO was closed.", (DefaultConstructorMarker)null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException$Commit;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException;", "tid", "", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "message", "", "(JLjava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "cottontaildb-dbms"})
    public static final class Commit
    extends TransactionException {
        @Nullable
        private final String message;

        public Commit(long tid, @Nullable String message) {
            super("Transaction " + tid + " could not be committed: " + message, (DefaultConstructorMarker)null);
            this.message = message;
        }

        @Override
        @Nullable
        public String getMessage() {
            return this.message;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException$Rollback;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException;", "tid", "", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "message", "", "(JLjava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "cottontaildb-dbms"})
    public static final class Rollback
    extends TransactionException {
        @Nullable
        private final String message;

        public Rollback(long tid, @Nullable String message) {
            super("Transaction " + tid + " could not be rolled back: " + message, (DefaultConstructorMarker)null);
            this.message = message;
        }

        @Override
        @Nullable
        public String getMessage() {
            return this.message;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException$InConflict;", "Lorg/vitrivr/cottontail/dbms/exceptions/TransactionException;", "tid", "", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "(J)V", "cottontaildb-dbms"})
    public static final class InConflict
    extends TransactionException {
        public InConflict(long tid) {
            super("Transaction " + tid + " could not be committed because of conflict with another transaction.", (DefaultConstructorMarker)null);
        }
    }
}

