/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.execution;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.config.Config;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \t*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;", "", "config", "Lorg/vitrivr/cottontail/config/Config;", "(Lorg/vitrivr/cottontail/config/Config;)V", "connectionWorkerCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "connectionWorkerPool", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "getConnectionWorkerPool", "()Ljava/util/concurrent/ExecutorService;", "queryDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getQueryDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "queryWorkerCounter", "queryWorkerPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "serviceWorkerCounter", "serviceWorkerPool", "Ljava/util/concurrent/ScheduledExecutorService;", "availableIntraQueryWorkers", "", "availableQueryWorkers", "shutdownAndWait", "", "cottontaildb-dbms"})
public final class ExecutionManager {
    @NotNull
    private final AtomicInteger queryWorkerCounter;
    @NotNull
    private final AtomicInteger connectionWorkerCounter;
    @NotNull
    private final AtomicInteger serviceWorkerCounter;
    @NotNull
    private final ThreadPoolExecutor queryWorkerPool;
    private final ScheduledExecutorService serviceWorkerPool;
    private final ExecutorService connectionWorkerPool;
    @NotNull
    private final CoroutineDispatcher queryDispatcher;

    public ExecutionManager(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.queryWorkerCounter = new AtomicInteger(1);
        this.connectionWorkerCounter = new AtomicInteger(1);
        this.serviceWorkerCounter = new AtomicInteger(1);
        this.queryWorkerPool = new ThreadPoolExecutor(config.getExecution().getCoreThreads(), config.getExecution().getMaxThreads(), config.getExecution().getKeepAliveMs(), TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue(config.getExecution().getQueueSize()), arg_0 -> ExecutionManager.queryWorkerPool$lambda$0(this, arg_0));
        this.serviceWorkerPool = Executors.newScheduledThreadPool(2, arg_0 -> ExecutionManager.serviceWorkerPool$lambda$1(this, arg_0));
        this.connectionWorkerPool = Executors.newFixedThreadPool(config.getServer().getConnectionThreads(), arg_0 -> ExecutionManager.connectionWorkerPool$lambda$2(this, arg_0));
        this.queryDispatcher = (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)this.queryWorkerPool);
    }

    public final ExecutorService getConnectionWorkerPool() {
        return this.connectionWorkerPool;
    }

    @NotNull
    public final CoroutineDispatcher getQueryDispatcher() {
        return this.queryDispatcher;
    }

    public final int availableQueryWorkers() {
        return this.queryWorkerPool.getMaximumPoolSize() - this.queryWorkerPool.getActiveCount();
    }

    public final int availableIntraQueryWorkers() {
        return Math.floorDiv(this.queryWorkerPool.getMaximumPoolSize(), 2) - this.queryWorkerPool.getActiveCount();
    }

    public final void shutdownAndWait() {
        this.serviceWorkerPool.shutdown();
        this.connectionWorkerPool.shutdown();
        this.queryWorkerPool.shutdown();
        if (this.serviceWorkerPool.awaitTermination(5000L, TimeUnit.MILLISECONDS) && this.queryWorkerPool.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
            this.connectionWorkerPool.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
    }

    private static final Thread queryWorkerPool$lambda$0(ExecutionManager this$0, Runnable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread thread = new Thread(it, "cottontaildb-query-worker-" + this$0.queryWorkerCounter.getAndIncrement());
        thread.setPriority(10);
        return thread;
    }

    private static final Thread serviceWorkerPool$lambda$1(ExecutionManager this$0, Runnable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread thread = new Thread(it, "cottontaildb-service-worker-" + this$0.serviceWorkerCounter.getAndIncrement());
        thread.setPriority(1);
        return thread;
    }

    private static final Thread connectionWorkerPool$lambda$2(ExecutionManager this$0, Runnable it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Thread thread = new Thread(it, "cottontaildb-connection-handler-" + this$0.connectionWorkerCounter.getAndIncrement());
        thread.setPriority(10);
        return thread;
    }
}

