/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.execution.locking;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.dbms.execution.locking.DeadlockException;
import org.vitrivr.cottontail.dbms.execution.locking.LockHolder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00052\u0012\u0010\u0012\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0018\u00010\u0013J\u0012\u0010\u0014\u001a\u00020\u00102\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00170\u0017J\u001e\u0010\u0018\u001a\u00020\u00192\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u00052\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0012\u0010\u001c\u001a\u00020\u00102\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0014\u0010\u001e\u001a\u00020\u00102\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002R\u0086\u0001\u0010\u0003\u001az\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012 \u0012\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005 \u0006*\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0018\u00010\u00070\u0007 \u0006*<\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0006*\b\u0012\u0002\b\u0003\u0018\u00010\u00050\u0005\u0012 \u0012\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005 \u0006*\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/locking/WaitForGraph;", "", "()V", "adjacencyList", "", "Lorg/vitrivr/cottontail/dbms/execution/locking/LockHolder;", "kotlin.jvm.PlatformType", "Lit/unimi/dsi/fastutil/objects/ObjectOpenHashSet;", "", "exclusiveLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "rwl", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "sharedLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$ReadLock;", "add", "", "predecessor", "successors", "", "detectDeadlock", "currentTxn", "findCycles", "", "hasEdge", "", "txn1", "txn2", "remove", "txn", "removeSuccessor", "txnToRemove", "DepthFirstSearch", "cottontaildb-dbms"})
public final class WaitForGraph {
    private final Map<LockHolder<?>, ObjectOpenHashSet<LockHolder<?>>> adjacencyList = Collections.synchronizedMap((Map)new Object2ObjectOpenHashMap());
    @NotNull
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    @NotNull
    private final ReentrantReadWriteLock.ReadLock sharedLock;
    @NotNull
    private final ReentrantReadWriteLock.WriteLock exclusiveLock;

    public WaitForGraph() {
        ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"this.rwl.readLock()");
        this.sharedLock = readLock;
        ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.rwl.writeLock()");
        this.exclusiveLock = writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull LockHolder<?> predecessor, @Nullable Set<? extends LockHolder<?>> successors) {
        Intrinsics.checkNotNullParameter(predecessor, (String)"predecessor");
        this.sharedLock.lock();
        try {
            ObjectOpenHashSet txnList = this.adjacencyList.getOrDefault(predecessor, new ObjectOpenHashSet());
            Set<? extends LockHolder<?>> set = successors;
            Intrinsics.checkNotNull(set);
            txnList.addAll((Collection)set);
            Map<LockHolder<?>, ObjectOpenHashSet<LockHolder<?>>> map2 = this.adjacencyList;
            Intrinsics.checkNotNullExpressionValue(map2, (String)"this.adjacencyList");
            map2.put(predecessor, txnList);
        }
        finally {
            this.sharedLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(@NotNull LockHolder<?> txn) {
        Intrinsics.checkNotNullParameter(txn, (String)"txn");
        this.sharedLock.lock();
        try {
            this.adjacencyList.remove(txn);
            this.removeSuccessor(txn);
        }
        finally {
            this.sharedLock.unlock();
        }
    }

    public final boolean hasEdge(@NotNull LockHolder<?> txn1, @NotNull LockHolder<?> txn2) {
        Intrinsics.checkNotNullParameter(txn1, (String)"txn1");
        Intrinsics.checkNotNullParameter(txn2, (String)"txn2");
        ObjectOpenHashSet<LockHolder<?>> objectOpenHashSet = this.adjacencyList.get(txn1);
        if (objectOpenHashSet == null) {
            return false;
        }
        ObjectOpenHashSet<LockHolder<?>> txnList = objectOpenHashSet;
        return txnList.contains(txn2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<List<LockHolder<?>>> findCycles() {
        List<List<LockHolder<?>>> list;
        this.exclusiveLock.lock();
        try {
            DepthFirstSearch dfs = new DepthFirstSearch();
            dfs.start();
            list = dfs.getCycles();
        }
        finally {
            this.exclusiveLock.unlock();
        }
        return list;
    }

    public final void detectDeadlock(@NotNull LockHolder<?> currentTxn) throws DeadlockException {
        Intrinsics.checkNotNullParameter(currentTxn, (String)"currentTxn");
        List<List<LockHolder<?>>> cycles = this.findCycles();
        for (List<LockHolder<?>> cycleGroup : cycles) {
            if (!cycleGroup.contains(currentTxn)) continue;
            throw new DeadlockException(currentTxn, cycleGroup);
        }
    }

    private final void removeSuccessor(LockHolder<?> txnToRemove) {
        for (LockHolder<?> predecessor : this.adjacencyList.keySet()) {
            ObjectOpenHashSet<LockHolder<?>> successors;
            ObjectOpenHashSet<LockHolder<?>> objectOpenHashSet = successors = this.adjacencyList.get(predecessor);
            if (objectOpenHashSet == null) continue;
            objectOpenHashSet.remove(txnToRemove);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u0016\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0005J\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u0011\u001a\u00020\u00102\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00062\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/locking/WaitForGraph$DepthFirstSearch;", "", "(Lorg/vitrivr/cottontail/dbms/execution/locking/WaitForGraph;)V", "cycles", "", "", "Lorg/vitrivr/cottontail/dbms/execution/locking/LockHolder;", "visited", "", "getCycleFromPath", "path", "target", "getCycles", "getVisited", "", "start", "", "visit", "node", "cottontaildb-dbms"})
    public final class DepthFirstSearch {
        @NotNull
        private final Set<LockHolder<?>> visited = new HashSet();
        @NotNull
        private final List<List<LockHolder<?>>> cycles = new ArrayList();

        public final void start() {
            for (LockHolder txn : WaitForGraph.this.adjacencyList.keySet()) {
                if (this.visited.contains(txn)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)txn, (String)"txn");
                this.visit(txn, new ArrayList());
            }
        }

        @NotNull
        public final List<List<LockHolder<?>>> getCycles() {
            return this.cycles;
        }

        @NotNull
        public final Set<LockHolder<?>> getVisited() {
            return this.visited;
        }

        private final void visit(LockHolder<?> node, List<LockHolder<?>> path) {
            this.visited.add(node);
            path.add(node);
            if (WaitForGraph.this.adjacencyList.containsKey(node)) {
                Object v = WaitForGraph.this.adjacencyList.get(node);
                Intrinsics.checkNotNull(v);
                for (LockHolder neighbour : (ObjectOpenHashSet)v) {
                    if (!this.visited.contains(neighbour)) {
                        Intrinsics.checkNotNullExpressionValue((Object)neighbour, (String)"neighbour");
                        this.visit(neighbour, new ArrayList(path));
                        continue;
                    }
                    if (!path.contains(neighbour)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)neighbour, (String)"neighbour");
                    this.cycles.add(this.getCycleFromPath(path, neighbour));
                }
            }
        }

        private final List<LockHolder<?>> getCycleFromPath(List<? extends LockHolder<?>> path, LockHolder<?> target) {
            return path.subList(path.indexOf(target), path.size());
        }
    }
}

