/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.execution.operators.sort;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.values.types.Value;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u0000 \u00042\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0005\u0004\u0005\u0006\u0007\b\u0082\u0001\u0004\t\n\u000b\f\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator;", "Ljava/util/Comparator;", "Lorg/vitrivr/cottontail/core/basics/Record;", "Lkotlin/Comparator;", "Companion", "MultiNonNullColumnComparator", "MultiNullColumnComparator", "SingleNonNullColumnComparator", "SingleNullColumnComparator", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$MultiNonNullColumnComparator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$MultiNullColumnComparator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$SingleNonNullColumnComparator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$SingleNullColumnComparator;", "cottontaildb-dbms"})
public interface RecordComparator
extends Comparator<Record> {
    @NotNull
    public static final Companion Companion = org.vitrivr.cottontail.dbms.execution.operators.sort.RecordComparator$Companion.$$INSTANCE;

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u001c\u0010\u0005\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0004\u0012\u00020\t0\u00070\u0006\u00a8\u0006\n"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$Companion;", "", "()V", "fromList", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator;", "sortOn", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "cottontaildb-dbms"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public final RecordComparator fromList(@NotNull List<? extends Pair<? extends ColumnDef<?>, ? extends SortOrder>> sortOn) {
            RecordComparator recordComparator;
            Intrinsics.checkNotNullParameter(sortOn, (String)"sortOn");
            if (sortOn.size() == 1 && ((ColumnDef)((Pair)CollectionsKt.first(sortOn)).getFirst()).getNullable()) {
                recordComparator = new SingleNullColumnComparator((ColumnDef)((Pair)CollectionsKt.first(sortOn)).getFirst(), (SortOrder)((Pair)CollectionsKt.first(sortOn)).getSecond());
                return recordComparator;
            }
            if (sortOn.size() == 1 && !((ColumnDef)((Pair)CollectionsKt.first(sortOn)).getFirst()).getNullable()) {
                recordComparator = new SingleNonNullColumnComparator((ColumnDef)((Pair)CollectionsKt.first(sortOn)).getFirst(), (SortOrder)((Pair)CollectionsKt.first(sortOn)).getSecond());
                return recordComparator;
            }
            if (sortOn.size() > 1) {
                boolean bl;
                block7: {
                    Iterable $this$any$iv = sortOn;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Pair it = (Pair)element$iv;
                            boolean bl2 = false;
                            if (!((ColumnDef)it.getFirst()).getNullable()) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    recordComparator = new MultiNullColumnComparator(sortOn);
                    return recordComparator;
                }
            }
            recordComparator = new MultiNonNullColumnComparator(sortOn);
            return recordComparator;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$SingleNonNullColumnComparator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator;", "sortOn", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "sortOrder", "Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "(Lorg/vitrivr/cottontail/core/database/ColumnDef;Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;)V", "getSortOn", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getSortOrder", "()Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "compare", "", "o1", "Lorg/vitrivr/cottontail/core/basics/Record;", "o2", "cottontaildb-dbms"})
    public static final class SingleNonNullColumnComparator
    implements RecordComparator {
        @NotNull
        private final ColumnDef<?> sortOn;
        @NotNull
        private final SortOrder sortOrder;

        public SingleNonNullColumnComparator(@NotNull ColumnDef<?> sortOn, @NotNull SortOrder sortOrder) {
            Intrinsics.checkNotNullParameter(sortOn, (String)"sortOn");
            Intrinsics.checkNotNullParameter((Object)sortOrder, (String)"sortOrder");
            this.sortOn = sortOn;
            this.sortOrder = sortOrder;
            if (!(!this.sortOn.getNullable())) {
                boolean bl = false;
                String string = "Column cannot be nullable for SingleNonNullColumnComparator but is.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final ColumnDef<?> getSortOn() {
            return this.sortOn;
        }

        @NotNull
        public final SortOrder getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public int compare(@NotNull Record o1, @NotNull Record o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            Value value = o1.get(this.sortOn);
            Intrinsics.checkNotNull((Object)value);
            Value value2 = o2.get(this.sortOn);
            Intrinsics.checkNotNull((Object)value2);
            int sort = MathKt.getSign((int)value.compareTo((Object)value2));
            if (sort == 0) {
                sort = MathKt.getSign((int)Intrinsics.compare((long)o1.getTupleId(), (long)o2.getTupleId()));
            }
            return this.sortOrder.times(sort);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$SingleNullColumnComparator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator;", "sortOn", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "sortOrder", "Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "(Lorg/vitrivr/cottontail/core/database/ColumnDef;Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;)V", "getSortOn", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getSortOrder", "()Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "compare", "", "o1", "Lorg/vitrivr/cottontail/core/basics/Record;", "o2", "cottontaildb-dbms"})
    public static final class SingleNullColumnComparator
    implements RecordComparator {
        @NotNull
        private final ColumnDef<?> sortOn;
        @NotNull
        private final SortOrder sortOrder;

        public SingleNullColumnComparator(@NotNull ColumnDef<?> sortOn, @NotNull SortOrder sortOrder) {
            Intrinsics.checkNotNullParameter(sortOn, (String)"sortOn");
            Intrinsics.checkNotNullParameter((Object)sortOrder, (String)"sortOrder");
            this.sortOn = sortOn;
            this.sortOrder = sortOrder;
        }

        @NotNull
        public final ColumnDef<?> getSortOn() {
            return this.sortOn;
        }

        @NotNull
        public final SortOrder getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public int compare(@NotNull Record o1, @NotNull Record o2) {
            int n;
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            Value left = o1.get(this.sortOn);
            Value right = o2.get(this.sortOn);
            if (left == null && right == null) {
                n = MathKt.getSign((int)Intrinsics.compare((long)o1.getTupleId(), (long)o2.getTupleId()));
            } else if (left != null && right != null) {
                int sort = MathKt.getSign((int)left.compareTo((Object)right));
                if (sort == 0) {
                    sort = MathKt.getSign((int)Intrinsics.compare((long)o1.getTupleId(), (long)o2.getTupleId()));
                }
                n = sort;
            } else {
                n = right != null ? -1 : 1;
            }
            return this.sortOrder.times(n);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R$\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$MultiNonNullColumnComparator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator;", "sortOn", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "(Ljava/util/List;)V", "compare", "", "o1", "Lorg/vitrivr/cottontail/core/basics/Record;", "o2", "cottontaildb-dbms"})
    public static final class MultiNonNullColumnComparator
    implements RecordComparator {
        @NotNull
        private final List<Pair<ColumnDef<?>, SortOrder>> sortOn;

        public MultiNonNullColumnComparator(@NotNull List<? extends Pair<? extends ColumnDef<?>, ? extends SortOrder>> sortOn) {
            boolean bl;
            block4: {
                Intrinsics.checkNotNullParameter(sortOn, (String)"sortOn");
                this.sortOn = sortOn;
                Iterable $this$any$iv = this.sortOn;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl2 = false;
                        if (!((ColumnDef)it.getFirst()).getNullable()) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!(!bl)) {
                boolean bl3 = false;
                String string = "Columns cannot be nullable for SingleNonNullColumnComparator but are.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        public int compare(@NotNull Record o1, @NotNull Record o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            for (Pair<ColumnDef<?>, SortOrder> c : this.sortOn) {
                SortOrder sortOrder = (SortOrder)c.getSecond();
                Value value = o1.get((ColumnDef)c.getFirst());
                Intrinsics.checkNotNull((Object)value);
                Value value2 = o2.get((ColumnDef)c.getFirst());
                Intrinsics.checkNotNull((Object)value2);
                int comparison = sortOrder.times(MathKt.getSign((int)value.compareTo((Object)value2)));
                if (comparison == 0) continue;
                return comparison;
            }
            return MathKt.getSign((int)Intrinsics.compare((long)o1.getTupleId(), (long)o2.getTupleId()));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u001c\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R$\u0010\u0002\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator$MultiNullColumnComparator;", "Lorg/vitrivr/cottontail/dbms/execution/operators/sort/RecordComparator;", "sortOn", "", "Lkotlin/Pair;", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "Lorg/vitrivr/cottontail/core/queries/sort/SortOrder;", "(Ljava/util/List;)V", "compare", "", "o1", "Lorg/vitrivr/cottontail/core/basics/Record;", "o2", "cottontaildb-dbms"})
    public static final class MultiNullColumnComparator
    implements RecordComparator {
        @NotNull
        private final List<Pair<ColumnDef<?>, SortOrder>> sortOn;

        public MultiNullColumnComparator(@NotNull List<? extends Pair<? extends ColumnDef<?>, ? extends SortOrder>> sortOn) {
            Intrinsics.checkNotNullParameter(sortOn, (String)"sortOn");
            this.sortOn = sortOn;
        }

        @Override
        public int compare(@NotNull Record o1, @NotNull Record o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            for (Pair<ColumnDef<?>, SortOrder> c : this.sortOn) {
                int comparison;
                int n;
                Value c1 = o1.get((ColumnDef)c.getFirst());
                Value c2 = o2.get((ColumnDef)c.getFirst());
                SortOrder sortOrder = (SortOrder)c.getSecond();
                if (c1 == null && c2 == null) {
                    n = 0;
                } else if (c1 == null && c2 != null) {
                    n = -1;
                } else if (c1 != null && c2 == null) {
                    n = 1;
                } else {
                    Value value = c1;
                    Intrinsics.checkNotNull((Object)value);
                    Value value2 = c2;
                    Intrinsics.checkNotNull((Object)value2);
                    n = MathKt.getSign((int)value.compareTo((Object)value2));
                }
                if ((comparison = sortOrder.times(n)) == 0) continue;
                return comparison;
            }
            return MathKt.getSign((int)Intrinsics.compare((long)o1.getTupleId(), (long)o2.getTupleId()));
        }
    }
}

