/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.execution.transactions;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.ExecutionManager;
import org.vitrivr.cottontail.dbms.execution.locking.Lock;
import org.vitrivr.cottontail.dbms.execution.locking.LockHolder;
import org.vitrivr.cottontail.dbms.execution.locking.LockManager;
import org.vitrivr.cottontail.dbms.execution.locking.LockMode;
import org.vitrivr.cottontail.dbms.execution.operators.basics.Operator;
import org.vitrivr.cottontail.dbms.execution.transactions.Transaction;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionStatus;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionType;
import org.vitrivr.cottontail.dbms.general.DBO;
import org.vitrivr.cottontail.dbms.general.Tx;
import org.vitrivr.cottontail.dbms.operations.Operation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0002\"#B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\u001f\u001a\b\u0018\u00010\u0015R\u00020\u00002\n\u0010 \u001a\u00060\u001cj\u0002`!H\u0086\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00000\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R^\u0010\u001a\u001aR\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u0012\u0014\u0012\u0012 \u001d*\b\u0018\u00010\u0015R\u00020\u00000\u0015R\u00020\u0000 \u001d*(\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c\u0012\u0014\u0012\u0012 \u001d*\b\u0018\u00010\u0015R\u00020\u00000\u0015R\u00020\u0000\u0018\u00010\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;", "", "executionManager", "Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;", "transactionTableSize", "", "transactionHistorySize", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "(Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;IILorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;)V", "getExecutionManager", "()Lorg/vitrivr/cottontail/dbms/execution/ExecutionManager;", "lockManager", "Lorg/vitrivr/cottontail/dbms/execution/locking/LockManager;", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "getLockManager$cottontaildb_dbms", "()Lorg/vitrivr/cottontail/dbms/execution/locking/LockManager;", "tidCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "transactionHistory", "", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$TransactionImpl;", "getTransactionHistory$cottontaildb_dbms", "()Ljava/util/List;", "getTransactionHistorySize", "()I", "transactions", "", "", "kotlin.jvm.PlatformType", "", "get", "txId", "Lorg/vitrivr/cottontail/core/database/TransactionId;", "Companion", "TransactionImpl", "cottontaildb-dbms"})
public final class TransactionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutionManager executionManager;
    private final int transactionHistorySize;
    @NotNull
    private final DefaultCatalogue catalogue;
    private final Map<Long, TransactionImpl> transactions;
    @NotNull
    private final AtomicLong tidCounter;
    @NotNull
    private final LockManager<DBO> lockManager;
    @NotNull
    private final List<TransactionImpl> transactionHistory;
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionManager.class);

    public TransactionManager(@NotNull ExecutionManager executionManager, int transactionTableSize, int transactionHistorySize, @NotNull DefaultCatalogue catalogue) {
        Intrinsics.checkNotNullParameter((Object)executionManager, (String)"executionManager");
        Intrinsics.checkNotNullParameter((Object)catalogue, (String)"catalogue");
        this.executionManager = executionManager;
        this.transactionHistorySize = transactionHistorySize;
        this.catalogue = catalogue;
        this.transactions = Collections.synchronizedMap((Map)new Long2ObjectOpenHashMap(transactionTableSize, 0.25f));
        this.tidCounter = new AtomicLong(1L);
        this.lockManager = new LockManager();
        List list = Collections.synchronizedList(new ArrayList(this.transactionHistorySize));
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(ArrayLi\u2026.transactionHistorySize))");
        this.transactionHistory = list;
    }

    @NotNull
    public final ExecutionManager getExecutionManager() {
        return this.executionManager;
    }

    public final int getTransactionHistorySize() {
        return this.transactionHistorySize;
    }

    @NotNull
    public final LockManager<DBO> getLockManager$cottontaildb_dbms() {
        return this.lockManager;
    }

    @NotNull
    public final List<TransactionImpl> getTransactionHistory$cottontaildb_dbms() {
        return this.transactionHistory;
    }

    @Nullable
    public final TransactionImpl get(long txId) {
        return this.transactions.get(txId);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u00106\u001a\u000207H\u0016J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020:092\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u0002072\u0006\u0010>\u001a\u00020$H\u0002J\u0010\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020\u0002H\u0016J\b\u0010A\u001a\u000207H\u0016J\b\u0010B\u001a\u000207H\u0002J\u0018\u0010C\u001a\u0002072\u0006\u0010@\u001a\u00020\u00022\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u000207H\u0016J\u0010\u0010G\u001a\u0002072\u0006\u0010H\u001a\u00020IH\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0019\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000eR\u0011\u0010\u001e\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000eR\u001e\u0010 \u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000eR\u0011\u0010\"\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000eR\u001e\u0010%\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020$@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001e\u0010)\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020(@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u000203X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006J"}, d2={"Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager$TransactionImpl;", "Lorg/vitrivr/cottontail/dbms/execution/locking/LockHolder;", "Lorg/vitrivr/cottontail/dbms/general/DBO;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/Transaction;", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "type", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "(Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionManager;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;)V", "activeContexts", "Ljava/util/HashSet;", "Lkotlin/coroutines/CoroutineContext;", "availableIntraQueryWorkers", "", "getAvailableIntraQueryWorkers", "()I", "availableQueryWorkers", "getAvailableQueryWorkers", "created", "", "getCreated", "()J", "<set-?>", "ended", "getEnded", "()Ljava/lang/Long;", "Ljava/lang/Long;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "numberOfError", "getNumberOfError", "numberOfOngoing", "getNumberOfOngoing", "numberOfSuccess", "getNumberOfSuccess", "numberOfTxs", "getNumberOfTxs", "", "readonly", "getReadonly", "()Z", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "state", "getState", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionStatus;", "txns", "", "Lorg/vitrivr/cottontail/core/database/Name;", "Lorg/vitrivr/cottontail/dbms/general/Tx;", "getType", "()Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionType;", "xodusTx", "Ljetbrains/exodus/env/Transaction;", "getXodusTx", "()Ljetbrains/exodus/env/Transaction;", "commit", "", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lorg/vitrivr/cottontail/core/basics/Record;", "operator", "Lorg/vitrivr/cottontail/dbms/execution/operators/basics/Operator;", "finalize", "committed", "getTx", "dbo", "kill", "performRollback", "requestLock", "mode", "Lorg/vitrivr/cottontail/dbms/execution/locking/LockMode;", "rollback", "signalEvent", "action", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation;", "cottontaildb-dbms"})
    public final class TransactionImpl
    extends LockHolder<DBO>
    implements Transaction,
    TransactionContext {
        @NotNull
        private final TransactionType type;
        @NotNull
        private volatile TransactionStatus state;
        @NotNull
        private final jetbrains.exodus.env.Transaction xodusTx;
        @NotNull
        private final Map<Name, Tx> txns;
        @NotNull
        private final Mutex mutex;
        private final long created;
        @Nullable
        private Long ended;
        private volatile int numberOfSuccess;
        private volatile int numberOfError;
        @NotNull
        private final HashSet<CoroutineContext> activeContexts;
        private boolean readonly;

        public TransactionImpl(TransactionType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            super(TransactionManager.this.tidCounter.getAndIncrement());
            this.type = type;
            this.state = TransactionStatus.IDLE;
            jetbrains.exodus.env.Transaction transaction = TransactionManager.this.catalogue.getEnvironment$cottontaildb_dbms().beginTransaction();
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"this@TransactionManager.\u2026onment.beginTransaction()");
            this.xodusTx = transaction;
            Object2ObjectMap object2ObjectMap = Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)new Object2ObjectLinkedOpenHashMap()));
            Intrinsics.checkNotNullExpressionValue((Object)object2ObjectMap, (String)"synchronize(Object2ObjectLinkedOpenHashMap())");
            this.txns = (Map)object2ObjectMap;
            this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
            this.created = System.currentTimeMillis();
            this.activeContexts = new HashSet();
            this.readonly = true;
            Map map2 = TransactionManager.this.transactions;
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"this@TransactionManager.transactions");
            Map map3 = map2;
            map3.put(this.getTxId(), this);
            TransactionManager.this.getTransactionHistory$cottontaildb_dbms().add(this);
            if (TransactionManager.this.getTransactionHistory$cottontaildb_dbms().size() >= TransactionManager.this.getTransactionHistorySize()) {
                TransactionManager.this.getTransactionHistory$cottontaildb_dbms().remove(0);
            }
        }

        @Override
        @NotNull
        public TransactionType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public TransactionStatus getState() {
            return this.state;
        }

        @Override
        @NotNull
        public jetbrains.exodus.env.Transaction getXodusTx() {
            return this.xodusTx;
        }

        public final int getNumberOfTxs() {
            return this.txns.size();
        }

        public final long getCreated() {
            return this.created;
        }

        @Nullable
        public final Long getEnded() {
            return this.ended;
        }

        public final int getNumberOfSuccess() {
            return this.numberOfSuccess;
        }

        public final int getNumberOfError() {
            return this.numberOfError;
        }

        public final int getNumberOfOngoing() {
            return this.activeContexts.size();
        }

        @Override
        public int getAvailableQueryWorkers() {
            return TransactionManager.this.getExecutionManager().availableQueryWorkers();
        }

        @Override
        public int getAvailableIntraQueryWorkers() {
            return TransactionManager.this.getExecutionManager().availableIntraQueryWorkers();
        }

        @Override
        public boolean getReadonly() {
            return this.readonly;
        }

        @Override
        @NotNull
        public Tx getTx(@NotNull DBO dbo) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Tx tx = this.txns.computeIfAbsent(dbo.getName(), arg_0 -> TransactionImpl.getTx$lambda$0((Function1)new Function1<Name, Tx>(dbo, this){
                final /* synthetic */ DBO $dbo;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.$dbo = $dbo;
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final Tx invoke(@NotNull Name it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.$dbo.newTx(this.this$0);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)tx, (String)"override fun getTx(dbo: \u2026dbo.newTx(this)\n        }");
            return tx;
        }

        @Override
        public void requestLock(@NotNull DBO dbo, @NotNull LockMode mode) {
            Intrinsics.checkNotNullParameter((Object)dbo, (String)"dbo");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            TransactionManager.this.getLockManager$cottontaildb_dbms().lock(this, dbo, mode);
        }

        @Override
        public void signalEvent(@NotNull Operation.DataManagementOperation action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        }

        @Override
        @NotNull
        public Flow<Record> execute(@NotNull Operator operator) {
            Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
            return FlowKt.cancellable((Flow)FlowKt.onCompletion((Flow)FlowKt.onStart((Flow)FlowKt.flowOn(operator.toFlow(this), (CoroutineContext)((CoroutineContext)TransactionManager.this.getExecutionManager().getQueryDispatcher())), (Function2)((Function2)new Function2<FlowCollector<? super Record>, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = TransactionImpl.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (TransactionImpl)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$execute$1$1 = false;
                                if (!var4_4.getState().getCanExecute()) {
                                    $i$a$-check-TransactionManager$TransactionImpl$execute$1$1$1 = false;
                                    $i$a$-check-TransactionManager$TransactionImpl$execute$1$1$1 = "Cannot start execution of transaction " + var4_4.getTxId() + " because it is in the wrong state (s = " + (Object)var4_4.getState() + ").";
                                    throw new IllegalStateException($i$a$-check-TransactionManager$TransactionImpl$execute$1$1$1.toString());
                                }
                                TransactionImpl.access$setState$p(var4_4, TransactionStatus.RUNNING);
                                $i$f$currentCoroutineContext = false;
                                TransactionImpl.access$getActiveContexts$p(var4_4).add(this.getContext());
                                var8_12 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull FlowCollector<? super Record> p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (Function3)((Function3)new Function3<FlowCollector<? super Record>, Throwable, Continuation<? super Unit>, Object>(this, null){
                Object L$1;
                Object L$2;
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(3, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            it = (Throwable)this.L$0;
                            var3_4 = TransactionImpl.access$getMutex$p(this.this$0);
                            var5_5 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = it;
                            this.L$1 = $this$withLock_u24default$iv;
                            this.L$2 = var5_5;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var10_2) {
                                return var10_2;
                            }
                            ** GOTO lbl27
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var5_5 = (TransactionImpl)this.L$2;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$1;
                            it = (Throwable)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl27:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$execute$2$1 = false;
                                $i$f$currentCoroutineContext = false;
                                TransactionImpl.access$getActiveContexts$p(var5_5).remove(this.getContext());
                                if (it == null) {
                                    TransactionImpl.access$setNumberOfSuccess$p(var5_5, var5_5.getNumberOfSuccess() + 1);
                                    if (var5_5.getNumberOfOngoing() == 0 && var5_5.getState() == TransactionStatus.RUNNING) {
                                        TransactionImpl.access$setState$p(var5_5, TransactionStatus.IDLE);
                                    }
                                } else {
                                    TransactionImpl.access$setNumberOfError$p(var5_5, var5_5.getNumberOfError() + 1);
                                    TransactionImpl.access$setState$p(var5_5, TransactionStatus.ERROR);
                                }
                                var9_11 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull FlowCollector<? super Record> p1, @Nullable Throwable p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<FlowCollector<? super Record>, Throwable, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p2;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            })));
        }

        @Override
        public void commit() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = TransactionImpl.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (TransactionImpl)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$commit$1$1 = false;
                                if (!var4_4.getState().getCanCommit()) {
                                    throw new TransactionException.Commit(var4_4.getTxId(), "Unable to COMMIT because transaction is in wrong state (s = " + (Object)var4_4.getState() + ").");
                                }
                                TransactionImpl.access$setState$p(var4_4, TransactionStatus.FINALIZING);
                                commit = false;
                                try {
                                    var8_9 = CollectionsKt.reversed((Iterable)TransactionImpl.access$getTxns$p(var4_4).values()).iterator();
                                    var9_12 = 0;
                                    while (var8_9.hasNext()) {
                                        i = var9_12++;
                                        txn = (Tx)var8_9.next();
                                        try {
                                            txn.beforeCommit();
                                        }
                                        catch (Throwable e) {
                                            TransactionManager.access$getLOGGER$cp().error("An error occurred while preparing Tx " + i + " (" + txn.getDbo().getName() + ") of transaction " + var4_4.getTxId() + " for commit. This is serious!", e);
                                            throw e;
                                        }
                                    }
                                    commit = var4_4.getXodusTx().commit();
                                    if (!commit) {
                                        throw new TransactionException.InConflict(var4_4.getTxId());
                                    }
                                    TransactionImpl.access$finalize(var4_4, commit != false);
                                }
                                catch (Throwable e) {
                                    try {
                                        var4_4.getXodusTx().abort();
                                        throw e;
                                    }
                                    catch (Throwable var8_11) {
                                        TransactionImpl.access$finalize(var4_4, commit != false);
                                        throw var8_11;
                                    }
                                }
                                var13_16 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @Override
        public void rollback() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = TransactionImpl.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (TransactionImpl)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$rollback$1$1 = false;
                                if (!var4_4.getState().getCanRollback()) {
                                    throw new TransactionException.Rollback(var4_4.getTxId(), "Unable to ROLLBACK because transaction is in wrong state (s = " + (Object)var4_4.getState() + ").");
                                }
                                TransactionImpl.access$performRollback(var4_4);
                                var7_9 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        @Override
        public void kill() {
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                Object L$0;
                Object L$1;
                int label;
                final /* synthetic */ TransactionImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = TransactionImpl.access$getMutex$p(this.this$0);
                            var4_4 = this.this$0;
                            owner$iv = null;
                            $i$f$withLock = false;
                            this.L$0 = $this$withLock_u24default$iv;
                            this.L$1 = var4_4;
                            this.label = 1;
                            v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                            if (v0 == var14_2) {
                                return var14_2;
                            }
                            ** GOTO lbl24
                        }
                        case 1: {
                            $i$f$withLock = false;
                            var4_4 = (TransactionImpl)this.L$1;
                            owner$iv = null;
                            $this$withLock_u24default$iv = (Mutex)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl24:
                            // 2 sources

                            try {
                                $i$a$-withLock$default-TransactionManager$TransactionImpl$kill$1$1 = false;
                                if (var4_4.getState() == TransactionStatus.RUNNING) {
                                    $this$forEach$iv = TransactionImpl.access$getActiveContexts$p(var4_4);
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        it = (CoroutineContext)element$iv;
                                        $i$a$-forEach-TransactionManager$TransactionImpl$kill$1$1$1 = false;
                                        JobKt.cancel((CoroutineContext)it, (CancellationException)new CancellationException("Transaction " + var4_4.getTxId() + " was killed by user."));
                                    }
                                } else if (var4_4.getState().getCanRollback()) {
                                    TransactionImpl.access$performRollback(var4_4);
                                } else {
                                    throw new IllegalStateException("Unable to kill transaction " + var4_4.getTxId() + " because it is in wrong state (s = " + (Object)var4_4.getState() + ").");
                                }
                                var13_14 = Unit.INSTANCE;
                            }
                            finally {
                                $this$withLock_u24default$iv.unlock(owner$iv);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void performRollback() {
            this.state = TransactionStatus.FINALIZING;
            try {
                Iterator iterator = CollectionsKt.reversed((Iterable)this.txns.values()).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    Tx txn = (Tx)iterator.next();
                    try {
                        txn.beforeRollback();
                    }
                    catch (Throwable e) {
                        LOGGER.error("An error occurred while rolling back Tx " + i + " (" + txn.getDbo().getName() + ") of transaction " + this.getTxId() + ". This is serious!", e);
                    }
                }
                this.getXodusTx().abort();
            }
            finally {
                this.finalize(false);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void finalize(boolean committed) {
            void $this$forEach$iv;
            Iterable iterable = this.allLocks();
            TransactionManager transactionManager = TransactionManager.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Lock it = (Lock)element$iv;
                boolean bl = false;
                transactionManager.getLockManager$cottontaildb_dbms().unlock(this, (DBO)it.getObj());
            }
            this.txns.clear();
            this.ended = System.currentTimeMillis();
            this.state = committed ? TransactionStatus.COMMIT : TransactionStatus.ROLLBACK;
            TransactionManager.this.transactions.remove(this.getTxId());
        }

        private static final Tx getTx$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Tx)$tmp0.invoke(p0);
        }

        public static final /* synthetic */ Mutex access$getMutex$p(TransactionImpl $this) {
            return $this.mutex;
        }

        public static final /* synthetic */ void access$setState$p(TransactionImpl $this, TransactionStatus transactionStatus) {
            $this.state = transactionStatus;
        }

        public static final /* synthetic */ HashSet access$getActiveContexts$p(TransactionImpl $this) {
            return $this.activeContexts;
        }

        public static final /* synthetic */ void access$setNumberOfSuccess$p(TransactionImpl $this, int n) {
            $this.numberOfSuccess = n;
        }

        public static final /* synthetic */ void access$setNumberOfError$p(TransactionImpl $this, int n) {
            $this.numberOfError = n;
        }

        public static final /* synthetic */ Map access$getTxns$p(TransactionImpl $this) {
            return $this.txns;
        }

        public static final /* synthetic */ void access$finalize(TransactionImpl $this, boolean committed) {
            $this.finalize(committed);
        }

        public static final /* synthetic */ void access$performRollback(TransactionImpl $this) {
            $this.performRollback();
        }
    }
}

