/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.nodes.traits.LimitTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.NotPartitionableTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.OrderTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.Trait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.WriteModel;
import org.vitrivr.cottontail.dbms.operations.Operation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "Tx", "cottontaildb-dbms"})
public abstract class AbstractHDIndex
extends AbstractIndex {
    public AbstractHDIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00a4\u0004\u0018\u00002\u00060\u0001R\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019J \u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001fR\u0015\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "Lorg/vitrivr/cottontail/dbms/index/WriteModel;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "column", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumn", "()Lorg/vitrivr/cottontail/core/database/ColumnDef;", "supportedDistances", "", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Closed;", "getSupportedDistances", "()Ljava/util/Set;", "canProcess", "", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "delete", "", "operation", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$DeleteOperation;", "insert", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$InsertOperation;", "traitsFor", "", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/TraitType;", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/Trait;", "update", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$UpdateOperation;", "cottontaildb-dbms"})
    protected abstract class Tx
    extends AbstractIndex.Tx
    implements WriteModel {
        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(AbstractHDIndex.this, context2);
        }

        @NotNull
        public final ColumnDef<?> getColumn() {
            return this.getColumns()[0];
        }

        @NotNull
        protected abstract Set<Signature.Closed<?>> getSupportedDistances();

        public boolean canProcess(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return predicate instanceof ProximityPredicate && Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn(), this.getColumn()) && this.getSupportedDistances().contains(((ProximityPredicate)predicate).getDistance().getSignature());
        }

        @Override
        @NotNull
        public Map<TraitType<?>, Trait> traitsFor(@NotNull Predicate predicate) {
            Map map2;
            Pair[] pairArray;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Predicate predicate2 = predicate;
            if (predicate2 instanceof ProximityPredicate.NNS) {
                pairArray = new Pair[]{TuplesKt.to((Object)OrderTrait.Companion, (Object)new OrderTrait(CollectionsKt.listOf((Object)TuplesKt.to((Object)((ProximityPredicate.NNS)predicate).getDistanceColumn(), (Object)SortOrder.ASCENDING)))), TuplesKt.to((Object)LimitTrait.Companion, (Object)new LimitTrait(((ProximityPredicate.NNS)predicate).getK()))};
                map2 = MapsKt.mutableMapOf((Pair[])pairArray);
            } else if (predicate2 instanceof ProximityPredicate.FNS) {
                pairArray = new Pair[]{TuplesKt.to((Object)OrderTrait.Companion, (Object)new OrderTrait(CollectionsKt.listOf((Object)TuplesKt.to((Object)((ProximityPredicate.FNS)predicate).getDistanceColumn(), (Object)SortOrder.DESCENDING)))), TuplesKt.to((Object)LimitTrait.Companion, (Object)new LimitTrait(((ProximityPredicate.FNS)predicate).getK()))};
                map2 = MapsKt.mutableMapOf((Pair[])pairArray);
            } else {
                throw new IllegalArgumentException("Unsupported predicate for HD-index. This is a programmer's error!");
            }
            Map traits = map2;
            if (!AbstractHDIndex.this.getSupportsPartitioning()) {
                traits.putAll(MapsKt.mapOf((Pair)TuplesKt.to((Object)NotPartitionableTrait.INSTANCE, (Object)NotPartitionableTrait.INSTANCE)));
            }
            return traits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void insert(@NotNull Operation.DataManagementOperation.InsertOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            AbstractHDIndex abstractHDIndex = AbstractHDIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!abstractHDIndex.getSupportsIncrementalUpdate()) {
                    AbstractIndex.Tx.updateState$default(this, IndexState.STALE, null, 2, null);
                } else if (!this.tryApply(operation)) {
                    Value value = operation.getInserts().get(this.getColumn());
                    AbstractIndex.Tx.updateState$default(this, IndexState.DIRTY, null, 2, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void update(@NotNull Operation.DataManagementOperation.UpdateOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            AbstractHDIndex abstractHDIndex = AbstractHDIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!abstractHDIndex.getSupportsIncrementalUpdate()) {
                    AbstractIndex.Tx.updateState$default(this, IndexState.STALE, null, 2, null);
                } else if (!this.tryApply(operation)) {
                    Pair<Value, Value> pair = operation.getUpdates().get(this.getColumn());
                    Value value = pair != null ? (Value)pair.getSecond() : null;
                    AbstractIndex.Tx.updateState$default(this, IndexState.DIRTY, null, 2, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void delete(@NotNull Operation.DataManagementOperation.DeleteOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            AbstractHDIndex abstractHDIndex = AbstractHDIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!abstractHDIndex.getSupportsIncrementalUpdate()) {
                    AbstractIndex.Tx.updateState$default(this, IndexState.STALE, null, 2, null);
                } else if (!this.tryApply(operation)) {
                    AbstractIndex.Tx.updateState$default(this, IndexState.DIRTY, null, 2, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }
    }
}

