/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.dbms.catalogue.DefaultCatalogue;
import org.vitrivr.cottontail.dbms.catalogue.entries.ColumnCatalogueEntry;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexCatalogueEntry;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.TransactionException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.general.AbstractTx;
import org.vitrivr.cottontail.dbms.general.DBOVersion;
import org.vitrivr.cottontail.dbms.index.Index;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.IndexTx;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "Lorg/vitrivr/cottontail/dbms/index/Index;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "catalogue", "Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "getCatalogue", "()Lorg/vitrivr/cottontail/dbms/catalogue/DefaultCatalogue;", "closed", "", "getClosed", "()Z", "getName", "()Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "getParent", "()Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "version", "Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "getVersion", "()Lorg/vitrivr/cottontail/dbms/general/DBOVersion;", "Tx", "cottontaildb-dbms"})
public abstract class AbstractIndex
implements Index {
    @NotNull
    private final Name.IndexName name;
    @NotNull
    private final DefaultEntity parent;
    @NotNull
    private final DefaultCatalogue catalogue;
    @NotNull
    private final DBOVersion version;

    public AbstractIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.name = name;
        this.parent = parent;
        this.catalogue = this.parent.getCatalogue();
        this.version = DBOVersion.V3_0;
    }

    @Override
    @NotNull
    public final Name.IndexName getName() {
        return this.name;
    }

    @Override
    @NotNull
    public final DefaultEntity getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public final DefaultCatalogue getCatalogue() {
        return this.catalogue;
    }

    @Override
    @NotNull
    public DBOVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean getClosed() {
        return this.parent.getClosed();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u00172\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001d\u00a8\u0006#"}, d2={"Lorg/vitrivr/cottontail/dbms/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/general/AbstractTx;", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "closeStamp", "", "columns", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "getColumns", "()[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "[Lorg/vitrivr/cottontail/core/database/ColumnDef;", "config", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "dbo", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "getDbo", "()Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "state", "Lorg/vitrivr/cottontail/dbms/index/IndexState;", "getState", "()Lorg/vitrivr/cottontail/dbms/index/IndexState;", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "cleanup", "", "updateState", "cottontaildb-dbms"})
    protected abstract class Tx
    extends AbstractTx
    implements IndexTx {
        @NotNull
        private final ColumnDef<?>[] columns;
        private final long closeStamp;

        /*
         * WARNING - void declaration
         */
        public Tx(TransactionContext context2) {
            ColumnDef[] columnDefArray;
            block7: {
                block6: {
                    void $this$toTypedArray$iv;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    super(context2);
                    Tx tx = this;
                    columnDefArray = IndexCatalogueEntry.Companion.read$cottontaildb_dbms(AbstractIndex.this.getName(), AbstractIndex.this.getCatalogue(), this.getContext().getXodusTx());
                    if (columnDefArray == null || (columnDefArray = columnDefArray.getColumns()) == null) break block6;
                    Iterable iterable = (Iterable)columnDefArray;
                    Object object = AbstractIndex.this;
                    Tx tx2 = tx;
                    boolean $i$f$map = false;
                    void var6_7 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Name.ColumnName columnName = (Name.ColumnName)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        ColumnDef<?> columnDef2 = ColumnCatalogueEntry.Companion.read$cottontaildb_dbms((Name.ColumnName)it, ((AbstractIndex)object).getCatalogue(), this.getContext().getXodusTx());
                        if (columnDef2 == null || (columnDef2 = columnDef2.toColumnDef()) == null) {
                            throw new DatabaseException.DataCorruptionException("Failed to obtain columns for index " + ((AbstractIndex)object).getName() + " because catalogue entry for column could not be read " + it + '.');
                        }
                        collection.add(columnDef2);
                    }
                    tx = tx2;
                    object = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    ColumnDef[] columnDefArray2 = thisCollection$iv.toArray(new ColumnDef[0]);
                    Intrinsics.checkNotNull((Object)columnDefArray2, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    columnDefArray = columnDefArray2;
                    if (columnDefArray2 != null) break block7;
                }
                throw new DatabaseException.DataCorruptionException("Failed to obtain columns for index " + AbstractIndex.this.getName() + ": Could not read catalogue entry for index.");
            }
            tx.columns = columnDefArray;
            if (this.getDbo().getClosed()) {
                throw new TransactionException.DBOClosed(this.getContext().getTxId(), this.getDbo());
            }
            this.closeStamp = this.getDbo().getCatalogue().getCloseLock$cottontaildb_dbms().readLock();
        }

        @Override
        @NotNull
        public final AbstractIndex getDbo() {
            return AbstractIndex.this;
        }

        @Override
        public boolean getSupportsIncrementalUpdate() {
            return AbstractIndex.this.getSupportsIncrementalUpdate();
        }

        @Override
        public boolean getSupportsPartitioning() {
            return AbstractIndex.this.getSupportsPartitioning();
        }

        @Override
        @NotNull
        public ColumnDef<?>[] getColumns() {
            return this.columns;
        }

        @Override
        @NotNull
        public IndexState getState() {
            Object object = IndexCatalogueEntry.Companion.read$cottontaildb_dbms(AbstractIndex.this.getName(), AbstractIndex.this.getCatalogue(), this.getContext().getXodusTx());
            if (object == null || (object = object.getState()) == null) {
                throw new DatabaseException.DataCorruptionException("Failed to obtain state for index " + AbstractIndex.this.getName() + ": Could not read catalogue entry for index.");
            }
            return object;
        }

        @Override
        @NotNull
        public IndexConfig<?> getConfig() {
            IndexCatalogueEntry indexCatalogueEntry = IndexCatalogueEntry.Companion.read$cottontaildb_dbms(AbstractIndex.this.getName(), AbstractIndex.this.getCatalogue(), this.getContext().getXodusTx());
            if (indexCatalogueEntry == null) {
                throw new DatabaseException.DataCorruptionException("Failed to read catalogue entry for index " + AbstractIndex.this.getName() + '.');
            }
            IndexCatalogueEntry entry = indexCatalogueEntry;
            return entry.getConfig();
        }

        protected final void updateState(@NotNull IndexState state, @Nullable IndexConfig<?> config) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
            IndexCatalogueEntry indexCatalogueEntry = IndexCatalogueEntry.Companion.read$cottontaildb_dbms(AbstractIndex.this.getName(), AbstractIndex.this.getCatalogue(), this.getContext().getXodusTx());
            if (indexCatalogueEntry == null) {
                throw new DatabaseException.DataCorruptionException("Failed to update state for index " + AbstractIndex.this.getName() + ": Could not read catalogue entry for index.");
            }
            IndexCatalogueEntry oldEntry = indexCatalogueEntry;
            if (oldEntry.getState() == state) {
                return;
            }
            IndexCatalogueEntry newEntry = config != null ? IndexCatalogueEntry.copy$default(oldEntry, null, null, state, null, config, 11, null) : IndexCatalogueEntry.copy$default(oldEntry, null, null, state, null, null, 27, null);
            IndexCatalogueEntry.Companion.write$cottontaildb_dbms(newEntry, AbstractIndex.this.getCatalogue(), this.getContext().getXodusTx());
        }

        public static /* synthetic */ void updateState$default(Tx tx, IndexState indexState, IndexConfig indexConfig, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: updateState");
            }
            if ((n & 2) != 0) {
                indexConfig = null;
            }
            tx.updateState(indexState, indexConfig);
        }

        @Override
        public void cleanup() {
            this.getDbo().getCatalogue().getCloseLock$cottontaildb_dbms().unlockRead(this.closeStamp);
        }
    }
}

