/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.gg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SplittableRandom;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.bindings.ComparableBinding;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.Argument;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.types.NumericValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.index.AbstractHDIndex;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.gg.GGIndex;
import org.vitrivr.cottontail.dbms.index.gg.GGIndexConfig;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.utilities.selection.ComparablePair;
import org.vitrivr.cottontail.utilities.selection.MinHeapSelection;
import org.vitrivr.cottontail.utilities.selection.MinSingleSelection;
import org.vitrivr.cottontail.utilities.selection.Selection;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class GGIndex
extends AbstractHDIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private static final Logger LOGGER;

    public GGIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.type = IndexType.GG;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    static {
        Logger logger = LoggerFactory.getLogger(GGIndex.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014R\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u00060\u0014R\u00020\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "getLOGGER", "()Lorg/slf4j/Logger;", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "parameters", "", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "entity", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "initialize", "open", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<GGIndex> {
        private Companion() {
        }

        @NotNull
        public final Logger getLOGGER() {
            return LOGGER;
        }

        @Override
        @NotNull
        public GGIndex open(@NotNull Name.IndexName name, @NotNull DefaultEntity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new GGIndex(name, entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        @NotNull
        public IndexConfig<GGIndex> buildConfig(@NotNull Map<String, String> parameters) {
            String string;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                    string = parameters.get("distance");
                    if (string == null) break block2;
                    String it = string;
                    boolean bl = false;
                    Name.FunctionName functionName = Name.FunctionName.Companion.create(it);
                    string = functionName;
                    if (functionName != null) break block3;
                }
                string = GGIndexConfig.Companion.getDEFAULT_DISTANCE();
            }
            String string2 = parameters.get("num_groups");
            String string3 = parameters.get("seed");
            long l = string3 != null ? Long.parseLong(string3) : System.currentTimeMillis();
            int n = string2 != null ? Integer.parseInt(string2) : 100;
            String string4 = string;
            return new GGIndexConfig((Name.FunctionName)string4, n, l);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return GGIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0010H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020&H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020'H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006("}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "config", "Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig;", "supportedDistances", "", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Closed;", "getSupportedDistances", "()Ljava/util/Set;", "clear", "", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "partition", "Lkotlin/ranges/LongRange;", "rebuild", "tryApply", "", "operation", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$DeleteOperation;", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$InsertOperation;", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$UpdateOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractHDIndex.Tx {
        @NotNull
        private final Set<Signature.Closed<?>> supportedDistances;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            GGIndexConfig config = this.getConfig();
            Types[] typesArray = new Types[]{this.getColumn().getType(), this.getColumn().getType()};
            this.supportedDistances = SetsKt.setOf((Object)new Signature.Closed(config.getDistance(), typesArray, (Types)Types.Double.INSTANCE));
        }

        @NotNull
        public GGIndexConfig getConfig() {
            IndexConfig<?> indexConfig = super.getConfig();
            Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.gg.GGIndexConfig");
            return (GGIndexConfig)indexConfig;
        }

        @Override
        @NotNull
        protected Set<Signature.Closed<?>> getSupportedDistances() {
            return this.supportedDistances;
        }

        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return Cost.Companion.getZERO-7CRCzCo();
        }

        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate.NNS)) {
                boolean bl = false;
                String string = "GGIndex can only process proximity predicates.";
                throw new IllegalArgumentException(string.toString());
            }
            return CollectionsKt.listOf((Object)((ProximityPredicate.NNS)predicate).getDistanceColumn());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            Lock lock2 = this.getTxLatch();
            GGIndex gGIndex = GGIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                Companion.getLOGGER().debug("Rebuilding GG index {}", (Object)gGIndex.getName());
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx txn = (EntityTx)tx;
                Set remainingTids = new LinkedHashSet();
                boolean $i$f$emptyArray = false;
                Cursor cursor2 = txn.cursor((ColumnDef[])((Object[])new ColumnDef[0]));
                Iterator $this$forEach$iv = (Iterator)cursor2;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Record it = (Record)element$iv;
                    boolean bl2 = false;
                    remainingTids.add(it.getTupleId());
                }
                cursor2.close();
                int groupSize = (remainingTids.size() + this.getConfig().getNumGroups() - 1) / this.getConfig().getNumGroups();
                Set finishedTIds = new LinkedHashSet();
                SplittableRandom random = new SplittableRandom(this.getConfig().getSeed());
                this.clear();
                while (!((Collection)remainingTids).isEmpty()) {
                    long groupSeedTid = ((Number)CollectionsKt.elementAt((Iterable)remainingTids, (int)random.nextInt(remainingTids.size()))).longValue();
                    Value groupSeedValue = txn.read(groupSeedTid, this.getColumns()).get(this.getColumns()[0]);
                    if (!(groupSeedValue instanceof VectorValue)) continue;
                    Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed(this.getColumns()[0].getType())};
                    Signature.Closed signature = new Signature.Closed(this.getConfig().getDistance(), typedArray, (Types)Types.Double.INSTANCE);
                    Function function = gGIndex.getParent().getParent().getParent().getFunctions().obtain(signature);
                    if (!(function instanceof VectorDistance)) {
                        boolean $i$a$-check-GGIndex$Tx$rebuild$1$32 = false;
                        String $i$a$-check-GGIndex$Tx$rebuild$1$32 = "GGIndex rebuild failed: Function " + signature + " is not a vector distance function.";
                        throw new IllegalStateException($i$a$-check-GGIndex$Tx$rebuild$1$32.toString());
                    }
                    MinHeapSelection<Comparable> knn = new MinHeapSelection<Comparable>(groupSize);
                    Iterable $this$forEach$iv2 = remainingTids;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        Value[] valueArray;
                        DoubleValue distance;
                        long tid = ((Number)element$iv).longValue();
                        boolean bl3 = false;
                        Record r = txn.read(tid, this.getColumns());
                        Value vec = r.get(this.getColumns()[0]);
                        if (!(vec instanceof VectorValue) || (distance = (DoubleValue)((VectorDistance)function).invoke(valueArray = new Value[]{vec})) == null) continue;
                        if (knn.getSize() >= groupSize) {
                            Object t = knn.peek();
                            Intrinsics.checkNotNull(t);
                            if (DoubleValue.compareTo-impl((double)((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), (Value)((Value)distance)) <= 0) continue;
                        }
                        knn.offer(new ComparablePair<Pair, Comparable>(new Pair((Object)tid, (Object)vec), (Comparable)distance));
                    }
                    VectorValue groupMean = ((VectorValue)groupSeedValue).new();
                    List groupTids = new ArrayList();
                    int n = knn.getSize();
                    for (int i = 0; i < n; ++i) {
                        Pair element = (Pair)((ComparablePair)knn.get(i)).getFirst();
                        groupMean = groupMean.plus((VectorValue)element.getSecond());
                        groupTids.add(element.getFirst());
                        if (!remainingTids.remove(element.getFirst())) {
                            boolean $i$a$-check-GGIndex$Tx$rebuild$1$62 = false;
                            String $i$a$-check-GGIndex$Tx$rebuild$1$62 = gGIndex.getName().getSimple() + " processed an element that should have been removed by now.";
                            throw new IllegalStateException($i$a$-check-GGIndex$Tx$rebuild$1$62.toString());
                        }
                        if (finishedTIds.add(element.getFirst())) continue;
                        boolean bl4 = false;
                        String string = gGIndex.getName().getSimple() + " processed an element that was already processed.";
                        throw new IllegalStateException(string.toString());
                    }
                    groupMean = groupMean.div((NumericValue)DoubleValue.box-impl((double)DoubleValue.constructor-impl((Number)knn.getSize())));
                }
                AbstractIndex.Tx.updateState$default(this, IndexState.CLEAN, null, 2, null);
                Companion.getLOGGER().debug("Rebuilding GGIndex {} complete.", (Object)gGIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            catch (Throwable throwable) {
                lock2.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                AbstractIndex.Tx.updateState$default(this, IndexState.STALE, null, 2, null);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        @NotNull
        public Cursor<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return (Cursor)new Cursor<Record>(predicate, this, GGIndex.this){
                @NotNull
                private final ProximityPredicate predicate;
                @NotNull
                private final VectorValue<?> vector;
                @NotNull
                private final Lazy resultsQueue$delegate;
                final /* synthetic */ Tx this$0;
                final /* synthetic */ GGIndex this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    if (!($predicate instanceof ProximityPredicate) || !Intrinsics.areEqual((Object)((ProximityPredicate)$predicate).getDistance().getSignature().getName(), (Object)$receiver.getConfig().getDistance())) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + $receiver2.getName() + "' (GGIndex) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($predicate.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (ProximityPredicate)$predicate;
                    this.resultsQueue$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ArrayDeque<StandaloneRecord>>(this){
                        final /* synthetic */ filter.1 this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        @NotNull
                        public final ArrayDeque<StandaloneRecord> invoke() {
                            return filter.1.access$prepareResults(this.this$0);
                        }
                    }));
                    Value value = this.predicate.getQuery().getValue();
                    if (!(value instanceof VectorValue)) {
                        boolean bl = false;
                        Value value2 = value;
                        String string = "Bound value for query vector has wrong type (found = " + (value2 != null ? value2.getType() : null) + ").";
                        throw new IllegalStateException(string.toString());
                    }
                    this.vector = (VectorValue)value;
                }

                private final ArrayDeque<StandaloneRecord> getResultsQueue() {
                    Lazy lazy = this.resultsQueue$delegate;
                    return (ArrayDeque)lazy.getValue();
                }

                public boolean moveNext() {
                    boolean bl;
                    if (!((Collection)this.getResultsQueue()).isEmpty()) {
                        this.getResultsQueue().removeFirst();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public long key() {
                    return ((StandaloneRecord)this.getResultsQueue().first()).getTupleId();
                }

                @NotNull
                public Record value() {
                    return (Record)this.getResultsQueue().first();
                }

                public void close() {
                    this.getResultsQueue().clear();
                }

                private final ArrayDeque<StandaloneRecord> prepareResults() {
                    int considerNumGroups = (this.this$0.getConfig().getNumGroups() + 9) / 10;
                    org.vitrivr.cottontail.dbms.general.Tx tx = this.this$0.getContext().getTx(this.this$1.getParent());
                    Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                    EntityTx txn = (EntityTx)tx;
                    Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed(this.this$0.getColumns()[0].getType())};
                    Signature.Closed signature = new Signature.Closed(this.this$0.getConfig().getDistance(), typedArray, (Types)Types.Double.INSTANCE);
                    Function function = this.this$1.getParent().getParent().getParent().getFunctions().obtain(signature);
                    if (!(function instanceof VectorDistance)) {
                        boolean $i$a$-check-GGIndex$Tx$filter$1$prepareResults$22 = false;
                        String $i$a$-check-GGIndex$Tx$filter$1$prepareResults$22 = "Function " + signature + " is not a vector distance function.";
                        throw new IllegalStateException($i$a$-check-GGIndex$Tx$filter$1$prepareResults$22.toString());
                    }
                    if (!(this.predicate.getK() < txn.largestTupleId() / (long)this.this$0.getConfig().getNumGroups() * (long)considerNumGroups)) {
                        boolean $i$a$-require-GGIndex$Tx$filter$1$prepareResults$32 = false;
                        String $i$a$-require-GGIndex$Tx$filter$1$prepareResults$32 = "Value of k is too large for this index considering " + considerNumGroups + " groups.";
                        throw new IllegalArgumentException($i$a$-require-GGIndex$Tx$filter$1$prepareResults$32.toString());
                    }
                    MinHeapSelection<T> groupKnn = new MinHeapSelection<T>(considerNumGroups);
                    GGIndex.Companion.getLOGGER().debug("Scanning group mean signals.");
                    Selection knn = this.predicate.getK() == 1L ? (Selection)new MinSingleSelection<T>() : (Selection)new MinHeapSelection<T>((int)this.predicate.getK());
                    GGIndex.Companion.getLOGGER().debug("Scanning group members.");
                    int n = groupKnn.getSize();
                    for (int k = 0; k < n; ++k) {
                        for (long tupleId : (long[])((ComparablePair)groupKnn.get(k)).getFirst()) {
                            Value[] valueArray;
                            DoubleValue distance;
                            Value value = txn.read(tupleId, this.this$0.getColumns()).get(this.this$0.getColumns()[0]);
                            if (!(value instanceof VectorValue) || (distance = (DoubleValue)((VectorDistance)function).invoke(valueArray = new Value[]{value})) == null) continue;
                            if (knn.getSize() >= knn.getK()) {
                                T t = knn.peek();
                                Intrinsics.checkNotNull(t);
                                if (DoubleValue.compareTo-impl((double)((DoubleValue)((ComparablePair)t).getSecond()).unbox-impl(), (Value)((Value)distance)) <= 0) continue;
                            }
                            knn.offer((Comparable)new ComparablePair<Long, Comparable>(tupleId, (Comparable)distance));
                        }
                    }
                    ArrayDeque queue = new ArrayDeque((int)this.predicate.getK());
                    int n2 = knn.getSize();
                    for (int i = 0; i < n2; ++i) {
                        ColumnDef[] columnDefArray = new ColumnDef[]{this.predicate.getDistanceColumn()};
                        ColumnDef[] columnDefArray2 = columnDefArray;
                        columnDefArray = new Value[]{(Value)((ComparablePair)knn.get(i)).getSecond()};
                        queue.add((Object)new StandaloneRecord(((Number)((ComparablePair)knn.get(i)).getFirst()).longValue(), columnDefArray2, (Value[])columnDefArray));
                    }
                    return queue;
                }

                public boolean hasNext() {
                    return Cursor.DefaultImpls.hasNext((Cursor)this);
                }

                @NotNull
                public Record next() {
                    return (Record)Cursor.DefaultImpls.next((Cursor)this);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }

                public static final /* synthetic */ ArrayDeque access$prepareResults(filter.1 $this) {
                    return $this.prepareResults();
                }
            };
        }

        @Override
        @NotNull
        public Cursor<Record> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("The UniqueHashIndex does not support ranged filtering!");
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.InsertOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            throw new UnsupportedOperationException("GGIndex does not support incremental updates!");
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.UpdateOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            throw new UnsupportedOperationException("GGIndex does not support incremental updates!");
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.DeleteOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            throw new UnsupportedOperationException("GGIndex does not support incremental updates!");
        }
    }
}

