/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.gg;

import java.io.ByteArrayInputStream;
import java.util.Set;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.CosineDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.gg.GGIndex;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001b\u001cB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/gg/GGIndex;", "distance", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "numGroups", "", "seed", "", "(Lorg/vitrivr/cottontail/core/database/Name$FunctionName;IJ)V", "getDistance", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getNumGroups", "()I", "getSeed", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Binding", "Companion", "cottontaildb-dbms"})
public final class GGIndexConfig
implements IndexConfig<GGIndex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.FunctionName distance;
    private final int numGroups;
    private final long seed;
    @NotNull
    public static final String KEY_DISTANCE_KEY = "distance";
    @NotNull
    public static final String KEY_NUM_GROUPS_KEY = "num_groups";
    @NotNull
    public static final String KEY_SEED_KEY = "seed";
    @NotNull
    private static final Name.FunctionName DEFAULT_DISTANCE = EuclideanDistance.Companion.getFUNCTION_NAME();
    @NotNull
    private static final Set<Name.FunctionName> SUPPORTED_DISTANCES;

    public GGIndexConfig(@NotNull Name.FunctionName distance, int numGroups, long seed) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)KEY_DISTANCE_KEY);
        this.distance = distance;
        this.numGroups = numGroups;
        this.seed = seed;
        if (!(this.numGroups > 1)) {
            boolean $i$a$-require-GGIndexConfig$32 = false;
            String $i$a$-require-GGIndexConfig$32 = "GGIndex requires at least a single group.";
            throw new IllegalArgumentException($i$a$-require-GGIndexConfig$32.toString());
        }
        if (!SUPPORTED_DISTANCES.contains(this.distance)) {
            boolean bl = false;
            String string = "GGIndex only support COSINE and INNERPRODUCT distance.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Name.FunctionName getDistance() {
        return this.distance;
    }

    public final int getNumGroups() {
        return this.numGroups;
    }

    public final long getSeed() {
        return this.seed;
    }

    @Override
    public int compareTo(@NotNull IndexConfig<GGIndex> other) {
        return IndexConfig.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public final Name.FunctionName component1() {
        return this.distance;
    }

    public final int component2() {
        return this.numGroups;
    }

    public final long component3() {
        return this.seed;
    }

    @NotNull
    public final GGIndexConfig copy(@NotNull Name.FunctionName distance, int numGroups, long seed) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)KEY_DISTANCE_KEY);
        return new GGIndexConfig(distance, numGroups, seed);
    }

    public static /* synthetic */ GGIndexConfig copy$default(GGIndexConfig gGIndexConfig, Name.FunctionName functionName, int n, long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            functionName = gGIndexConfig.distance;
        }
        if ((n2 & 2) != 0) {
            n = gGIndexConfig.numGroups;
        }
        if ((n2 & 4) != 0) {
            l = gGIndexConfig.seed;
        }
        return gGIndexConfig.copy(functionName, n, l);
    }

    @NotNull
    public String toString() {
        return "GGIndexConfig(distance=" + this.distance + ", numGroups=" + this.numGroups + ", seed=" + this.seed + ')';
    }

    public int hashCode() {
        int result = this.distance.hashCode();
        result = result * 31 + Integer.hashCode(this.numGroups);
        result = result * 31 + Long.hashCode(this.seed);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GGIndexConfig)) {
            return false;
        }
        GGIndexConfig gGIndexConfig = (GGIndexConfig)other;
        if (!Intrinsics.areEqual((Object)this.distance, (Object)gGIndexConfig.distance)) {
            return false;
        }
        if (this.numGroups != gGIndexConfig.numGroups) {
            return false;
        }
        return this.seed == gGIndexConfig.seed;
    }

    static {
        Object[] objectArray = new Name.FunctionName[]{ManhattanDistance.Companion.getFUNCTION_NAME(), EuclideanDistance.Companion.getFUNCTION_NAME(), CosineDistance.Companion.getFUNCTION_NAME()};
        SUPPORTED_DISTANCES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig$Companion;", "", "()V", "DEFAULT_DISTANCE", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getDEFAULT_DISTANCE", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "KEY_DISTANCE_KEY", "", "KEY_NUM_GROUPS_KEY", "KEY_SEED_KEY", "SUPPORTED_DISTANCES", "", "getSUPPORTED_DISTANCES", "()Ljava/util/Set;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Name.FunctionName getDEFAULT_DISTANCE() {
            return DEFAULT_DISTANCE;
        }

        @NotNull
        public final Set<Name.FunctionName> getSUPPORTED_DISTANCES() {
            return SUPPORTED_DISTANCES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig$Binding;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "readObject", "", "Lorg/vitrivr/cottontail/dbms/index/gg/GGIndexConfig;", "stream", "Ljava/io/ByteArrayInputStream;", "writeObject", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "cottontaildb-dbms"})
    public static final class Binding
    extends ComparableBinding {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @NotNull
        public Comparable<GGIndexConfig> readObject(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            String string = StringBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BINDING.readObject(stream)");
            return new GGIndexConfig(Name.FunctionName.Companion.create(string), IntegerBinding.readCompressed((ByteArrayInputStream)stream), LongBinding.readCompressed((ByteArrayInputStream)stream));
        }

        public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<? super GGIndexConfig> object) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            if (!(object instanceof GGIndexConfig)) {
                boolean bl = false;
                String string = "GGIndexConfig.Binding can only be used to serialize instances of GGIndexConfig.";
                throw new IllegalArgumentException(string.toString());
            }
            StringBinding.BINDING.writeObject(output, (Comparable)((Object)((GGIndexConfig)object).getDistance().getSimple()));
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((GGIndexConfig)object).getNumGroups());
            LongBinding.writeCompressed((LightOutputStream)output, (long)((GGIndexConfig)object).getSeed());
        }
    }
}

