/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.hash;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.queries.nodes.traits.Trait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.BooleanPredicate;
import org.vitrivr.cottontail.core.queries.predicates.ComparisonOperator;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.pattern.LikePatternValue;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.hash.BTreeIndexConfig;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.storage.serializers.values.ValueSerializerFactory;
import org.vitrivr.cottontail.storage.serializers.values.xodus.XodusBinding;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class BTreeIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private static final Logger LOGGER;

    public BTreeIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.type = IndexType.BTREE;
        this.supportsIncrementalUpdate = true;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    static {
        Logger logger = LoggerFactory.getLogger(BTreeIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(BTreeIndex::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "parameters", "", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "entity", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "initialize", "open", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<BTreeIndex> {
        private Companion() {
        }

        @Override
        @NotNull
        public BTreeIndex open(@NotNull Name.IndexName name, @NotNull DefaultEntity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new BTreeIndex(name, entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                Store store = entity.getDbo().getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(name), StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, entity.getContext().getXodusTx(), true);
                bl = store != null;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize BTREE index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                entity.getDbo().getCatalogue().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name), entity.getContext().getXodusTx());
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize BTREE index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<BTreeIndex> buildConfig(@NotNull Map<String, String> parameters) {
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            return new IndexConfig<BTreeIndex>(){

                public int compareTo(@NotNull IndexConfig<BTreeIndex> other) {
                    return IndexConfig.DefaultImpls.compareTo(this, other);
                }
            };
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return BTreeIndexConfig.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u001a\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010 \u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\"\u0010#J\b\u0010$\u001a\u00020\u0016H\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u001cH\u0016J\u001c\u00100\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002J \u00101\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u000303\u0012\u0004\u0012\u000204022\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u00105\u001a\u00020\u001c2\u0006\u0010&\u001a\u000206H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "binding", "Lorg/vitrivr/cottontail/storage/serializers/values/xodus/XodusBinding;", "Lorg/vitrivr/cottontail/core/values/types/Value;", "getBinding$annotations", "()V", "config", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/hash/BTreeIndex;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "dataStore", "Ljetbrains/exodus/env/Store;", "addMapping", "", "key", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "canProcess", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "clear", "", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "delete", "operation", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$DeleteOperation;", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "partition", "Lkotlin/ranges/LongRange;", "insert", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$InsertOperation;", "rebuild", "removeMapping", "traitsFor", "", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/TraitType;", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/Trait;", "update", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$UpdateOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractIndex.Tx {
        @NotNull
        private final XodusBinding<Value> binding;
        @NotNull
        private Store dataStore;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(BTreeIndex.this, context2);
            XodusBinding xodusBinding = ValueSerializerFactory.INSTANCE.xodus(this.getColumns()[0].getType(), this.getColumns()[0].getNullable());
            Intrinsics.checkNotNull(xodusBinding, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.storage.serializers.values.xodus.XodusBinding<org.vitrivr.cottontail.core.values.types.Value>");
            this.binding = xodusBinding;
            Store store = BTreeIndex.this.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(BTreeIndex.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for index " + BTreeIndex.this.getName() + " is missing.");
            }
            this.dataStore = store;
        }

        private static /* synthetic */ void getBinding$annotations() {
        }

        @NotNull
        public IndexConfig<BTreeIndex> getConfig() {
            return BTreeIndexConfig.INSTANCE;
        }

        private final boolean addMapping(Value key, long tupleId) {
            ByteIterable keyRaw = this.binding.valueToEntry(key);
            ArrayByteIterable tupleIdRaw = LongBinding.longToCompressedEntry((long)tupleId);
            return this.dataStore.put(this.getContext().getXodusTx(), keyRaw, (ByteIterable)tupleIdRaw);
        }

        private final boolean removeMapping(Value key, long tupleId) {
            ByteIterable keyRaw = this.binding.valueToEntry(key);
            ArrayByteIterable valueRaw = LongBinding.longToCompressedEntry((long)tupleId);
            Cursor cursor2 = this.dataStore.openCursor(this.getContext().getXodusTx());
            boolean ret = cursor2.getSearchBoth(keyRaw, (ByteIterable)valueRaw) && cursor2.deleteCurrent();
            cursor2.close();
            return ret;
        }

        public boolean canProcess(@NotNull Predicate predicate) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof BooleanPredicate.Atomic)) {
                return false;
            }
            if (((BooleanPredicate.Atomic)predicate).getNot()) {
                return false;
            }
            if (!predicate.getColumns().contains(this.getColumns()[0])) {
                return false;
            }
            ComparisonOperator comparisonOperator = ((BooleanPredicate.Atomic)predicate).getOperator();
            if (comparisonOperator instanceof ComparisonOperator.Binary.Equal ? true : comparisonOperator instanceof ComparisonOperator.In) {
                bl = true;
            } else if (comparisonOperator instanceof ComparisonOperator.Binary.Like) {
                ComparisonOperator comparisonOperator2 = ((BooleanPredicate.Atomic)predicate).getOperator();
                Intrinsics.checkNotNull((Object)comparisonOperator2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.queries.predicates.ComparisonOperator.Binary.Like");
                bl = ((ComparisonOperator.Binary.Like)comparisonOperator2).getRight().getValue() instanceof LikePatternValue.StartsWith;
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate)) {
                    boolean bl2 = false;
                    String string = "BTree index can only process boolean predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                List list = ArraysKt.toList((Object[])this.getColumns());
                return list;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Map<TraitType<?>, Trait> traitsFor(@NotNull Predicate predicate) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate)) {
                    boolean bl2 = false;
                    String string = "BTree index can only process boolean predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                map2 = MapsKt.emptyMap();
            }
            finally {
                lock2.unlock();
            }
            return map2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                float[] fArray;
                int n;
                ColumnDef it;
                int n2;
                int n3;
                float[] fArray2;
                float f;
                float f2;
                Iterable iterable;
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate.Atomic) || !Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)predicate.getColumns()), this.getColumns()[0]) || ((BooleanPredicate.Atomic)predicate).getNot()) {
                    float[] fArray3 = Cost.Companion.getINVALID-7CRCzCo();
                    return fArray3;
                }
                ComparisonOperator operator = ((BooleanPredicate.Atomic)predicate).getOperator();
                if (operator instanceof ComparisonOperator.Binary.Equal) {
                    iterable = predicate.getColumns();
                    f2 = 0.0f;
                    f = 0.0f;
                    fArray2 = Cost.plus-wQ19W7k((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo(), (float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo());
                    n3 = 0;
                    for (Object t : iterable) {
                        ColumnDef columnDef2 = (ColumnDef)t;
                        n2 = n3;
                        boolean bl2 = false;
                        n = it.getType().getPhysicalSize();
                        n3 = n2 + n;
                    }
                    n2 = n3;
                    fArray = Cost.plus-wQ19W7k((float[])fArray2, (float[])Cost.constructor-impl$default((float)f, (float)f2, (float)n2, (float)0.0f, (int)11, null));
                } else if (operator instanceof ComparisonOperator.Binary.Like) {
                    iterable = predicate.getColumns();
                    f2 = 0.0f;
                    f = 0.0f;
                    fArray2 = Cost.plus-wQ19W7k((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo(), (float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo());
                    n3 = 0;
                    for (Object t : iterable) {
                        it = (ColumnDef)t;
                        n2 = n3;
                        boolean bl3 = false;
                        n = it.getType().getPhysicalSize();
                        n3 = n2 + n;
                    }
                    n2 = n3;
                    fArray = Cost.plus-wQ19W7k((float[])fArray2, (float[])Cost.constructor-impl$default((float)f, (float)f2, (float)n2, (float)0.0f, (int)11, null));
                } else if (operator instanceof ComparisonOperator.In) {
                    iterable = predicate.getColumns();
                    f2 = 0.0f;
                    f = 0.0f;
                    fArray2 = Cost.plus-wQ19W7k((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo(), (float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo());
                    n3 = 0;
                    for (Object t : iterable) {
                        it = (ColumnDef)t;
                        n2 = n3;
                        boolean bl4 = false;
                        n = it.getType().getPhysicalSize();
                        n3 = n2 + n;
                    }
                    n2 = n3;
                    fArray = Cost.plus-wQ19W7k((float[])fArray2, (float[])Cost.times-7eHliGg((float[])Cost.constructor-impl$default((float)f, (float)f2, (float)n2, (float)0.0f, (int)11, null), (Number)((ComparisonOperator.In)operator).getRight().size()));
                } else {
                    fArray = Cost.Companion.getINVALID-7CRCzCo();
                }
                float[] fArray4 = fArray;
                return fArray4;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            Lock lock2 = this.getTxLatch();
            BTreeIndex bTreeIndex = BTreeIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                LOGGER.debug("Rebuilding BTree index {}", (Object)bTreeIndex.getName());
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx entityTx = (EntityTx)tx;
                this.clear();
                org.vitrivr.cottontail.core.basics.Cursor cursor2 = entityTx.cursor(this.getColumns());
                Iterator $this$forEach$iv = (Iterator)cursor2;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Record record = (Record)element$iv;
                    boolean bl2 = false;
                    Value value = record.get(this.getColumns()[0]);
                    if (value == null) continue;
                    this.addMapping(value, record.getTupleId());
                }
                cursor2.close();
                AbstractIndex.Tx.updateState$default(this, IndexState.CLEAN, null, 2, null);
                LOGGER.debug("Rebuilding BTree index {} completed!", (Object)bTreeIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(@NotNull Operation.DataManagementOperation.InsertOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Value value = operation.getInserts().get(this.getColumns()[0]);
                if (value != null) {
                    this.addMapping(value, operation.getTupleId());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation.UpdateOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                Value value;
                Value old;
                boolean bl = false;
                Pair<Value, Value> pair = operation.getUpdates().get(this.getColumns()[0]);
                Object object = old = pair != null ? (Value)pair.getFirst() : null;
                if (old != null) {
                    this.removeMapping(old, operation.getTupleId());
                }
                Pair<Value, Value> pair2 = operation.getUpdates().get(this.getColumns()[0]);
                Object object2 = value = pair2 != null ? (Value)pair2.getSecond() : null;
                if (value != null) {
                    this.addMapping(value, operation.getTupleId());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(@NotNull Operation.DataManagementOperation.DeleteOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Value old = operation.getDeleted().get(this.getColumns()[0]);
                if (old != null) {
                    this.removeMapping(old, operation.getTupleId());
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.dataStore.count(this.getContext().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock2 = this.getTxLatch();
            BTreeIndex bTreeIndex = BTreeIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                bTreeIndex.getParent().getParent().getParent().getEnvironment$cottontaildb_dbms().truncateStore(ExtensionsKt.storeName(bTreeIndex.getName()), this.getContext().getXodusTx());
                Store store = bTreeIndex.getParent().getParent().getParent().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(bTreeIndex.getName()), StoreConfig.USE_EXISTING, this.getContext().getXodusTx(), false);
                if (store == null) {
                    throw new DatabaseException.DataCorruptionException("Data store for column " + bTreeIndex.getName() + " is missing.");
                }
                this.dataStore = store;
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Record> filter(@NotNull Predicate predicate) {
            org.vitrivr.cottontail.core.basics.Cursor<Record> cursor2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                cursor2 = new org.vitrivr.cottontail.core.basics.Cursor<Record>(this, predicate){
                    @NotNull
                    private final Queue<Value> queryValueQueue;
                    private final Transaction subTransaction;
                    @NotNull
                    private final Cursor cursor;
                    final /* synthetic */ Tx this$0;
                    {
                        this.this$0 = $receiver;
                        this.queryValueQueue = new LinkedList<E>();
                        this.subTransaction = $receiver.getContext().getXodusTx().getReadonlySnapshot();
                        if (!($predicate instanceof BooleanPredicate.Atomic)) {
                            boolean $i$a$-require-BTreeIndex$Tx$filter$1$1$32 = false;
                            String $i$a$-require-BTreeIndex$Tx$filter$1$1$32 = "NonUniqueHashIndex.filter() does only support Atomic.Literal boolean predicates.";
                            throw new IllegalArgumentException($i$a$-require-BTreeIndex$Tx$filter$1$1$32.toString());
                        }
                        if (!(!((BooleanPredicate.Atomic)$predicate).getNot())) {
                            boolean $i$a$-require-BTreeIndex$Tx$filter$1$1$42 = false;
                            String $i$a$-require-BTreeIndex$Tx$filter$1$1$42 = "NonUniqueHashIndex.filter() does not support negated statements (i.e. NOT EQUALS or NOT IN).";
                            throw new IllegalArgumentException($i$a$-require-BTreeIndex$Tx$filter$1$1$42.toString());
                        }
                        ComparisonOperator comparisonOperator = ((BooleanPredicate.Atomic)$predicate).getOperator();
                        if (comparisonOperator instanceof ComparisonOperator.In) {
                            void $this$mapNotNullTo$iv$iv;
                            void $this$mapNotNull$iv;
                            ComparisonOperator comparisonOperator2 = ((BooleanPredicate.Atomic)$predicate).getOperator();
                            Intrinsics.checkNotNull((Object)comparisonOperator2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.queries.predicates.ComparisonOperator.In");
                            Iterable $i$a$-require-BTreeIndex$Tx$filter$1$1$42 = ((ComparisonOperator.In)comparisonOperator2).getRight();
                            Queue<Value> queue = this.queryValueQueue;
                            boolean $i$f$mapNotNull = false;
                            void var6_11 = $this$mapNotNull$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                            boolean $i$f$forEach = false;
                            Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                            while (iterator.hasNext()) {
                                Value it$iv$iv;
                                T element$iv$iv$iv;
                                T element$iv$iv = element$iv$iv$iv = iterator.next();
                                boolean bl = false;
                                Binding it = (Binding)element$iv$iv;
                                boolean bl2 = false;
                                if (it.getValue() == null) continue;
                                boolean bl3 = false;
                                destination$iv$iv.add(it$iv$iv);
                            }
                            queue.addAll((List)destination$iv$iv);
                        } else if (comparisonOperator instanceof ComparisonOperator.Binary.Equal) {
                            ComparisonOperator comparisonOperator3 = ((BooleanPredicate.Atomic)$predicate).getOperator();
                            Intrinsics.checkNotNull((Object)comparisonOperator3, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.queries.predicates.ComparisonOperator.Binary.Equal");
                            Value value = ((ComparisonOperator.Binary.Equal)comparisonOperator3).getRight().getValue();
                            if (value == null) {
                                throw new IllegalArgumentException("UniqueHashIndex.filter() does not support NULL operands.");
                            }
                            this.queryValueQueue.add(value);
                        } else {
                            throw new IllegalArgumentException("UniqueHashIndex.filter() does only support EQUAL and IN operators.");
                        }
                        Cursor cursor2 = Tx.access$getDataStore$p($receiver).openCursor(this.subTransaction);
                        Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"this@Tx.dataStore.openCursor(this.subTransaction)");
                        this.cursor = cursor2;
                    }

                    public boolean moveNext() {
                        try {
                            if (this.cursor.getNextDup()) {
                                return true;
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        Value nextQueryValue = this.queryValueQueue.poll();
                        while (nextQueryValue != null) {
                            if (this.cursor.getSearchKey(Tx.access$getBinding$p(this.this$0).valueToEntry(nextQueryValue)) != null) {
                                return true;
                            }
                            nextQueryValue = this.queryValueQueue.poll();
                        }
                        return false;
                    }

                    public long key() {
                        return LongBinding.compressedEntryToLong((ByteIterable)this.cursor.getValue());
                    }

                    @NotNull
                    public Record value() {
                        long l = this.key();
                        ColumnDef<?>[] columnDefArray = this.this$0.getColumns();
                        Value[] valueArray = new Value[1];
                        XodusBinding xodusBinding = Tx.access$getBinding$p(this.this$0);
                        ByteIterable byteIterable = this.cursor.getKey();
                        Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"this.cursor.key");
                        valueArray[0] = xodusBinding.entryToValue(byteIterable);
                        return (Record)new StandaloneRecord(l, columnDefArray, valueArray);
                    }

                    public void close() {
                        this.cursor.close();
                        this.subTransaction.abort();
                    }

                    public boolean hasNext() {
                        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
                    }

                    @NotNull
                    public Record next() {
                        return (Record)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                lock2.unlock();
            }
            return (org.vitrivr.cottontail.core.basics.Cursor)cursor2;
        }

        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Record> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("The NonUniqueHashIndex does not support ranged filtering!");
        }

        public static final /* synthetic */ Store access$getDataStore$p(Tx $this) {
            return $this.dataStore;
        }

        public static final /* synthetic */ XodusBinding access$getBinding$p(Tx $this) {
            return $this.binding;
        }
    }
}

