/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lsh;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.index.AbstractHDIndex;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig;
import org.vitrivr.cottontail.dbms.index.lsh.signature.LSHSignature;
import org.vitrivr.cottontail.dbms.index.lsh.signature.LSHSignatureGenerator;
import org.vitrivr.cottontail.dbms.operations.Operation;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class LSHIndex
extends AbstractHDIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexType type;
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private static final Logger LOGGER;

    public LSHIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.type = IndexType.LSH;
        this.supportsIncrementalUpdate = true;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    static {
        Logger logger = LoggerFactory.getLogger(LSHIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(LSHIndex::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "parameters", "", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "entity", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "initialize", "open", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<LSHIndex> {
        private Companion() {
        }

        @Override
        @NotNull
        public LSHIndex open(@NotNull Name.IndexName name, @NotNull DefaultEntity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new LSHIndex(name, entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                Store store = entity.getDbo().getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(name), StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, entity.getContext().getXodusTx(), true);
                bl = store != null;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize LSH index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                entity.getDbo().getCatalogue().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name), entity.getContext().getXodusTx());
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize LSH index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<LSHIndex> buildConfig(@NotNull Map<String, String> parameters) {
            String string;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                    string = parameters.get("distances");
                    if (string == null) break block2;
                    String it = string;
                    boolean bl = false;
                    Name.FunctionName functionName = Name.FunctionName.Companion.create(it);
                    string = functionName;
                    if (functionName != null) break block3;
                }
                string = LSHIndexConfig.Companion.getDEFAULT_DISTANCE();
            }
            String string2 = parameters.get("buckets");
            String string3 = parameters.get("stages");
            String string4 = parameters.get("seed");
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 16;
            LSHSignatureGenerator lSHSignatureGenerator = null;
            long l = string4 != null ? Long.parseLong(string4) : System.currentTimeMillis();
            int n2 = string3 != null ? Integer.parseInt(string3) : 5;
            int n3 = string2 != null ? Integer.parseInt(string2) : 50;
            String string5 = string;
            return new LSHIndexConfig((Name.FunctionName)string5, n3, n2, l, lSHSignatureGenerator, n, defaultConstructorMarker);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return LSHIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J)\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016J \u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00f8\u0001\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b#\u0010$J\b\u0010%\u001a\u00020\u0016H\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J)\u0010,\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b-\u0010\u0019J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000200H\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000201H\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u000202H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u000f\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\n\u0002\b!\u00a8\u00063"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "config", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndexConfig;", "dataStore", "Ljetbrains/exodus/env/Store;", "supportedDistances", "", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Closed;", "getSupportedDistances", "()Ljava/util/Set;", "addMapping", "", "signature", "Lorg/vitrivr/cottontail/dbms/index/lsh/signature/LSHSignature;", "tupleId", "", "Lorg/vitrivr/cottontail/core/database/TupleId;", "addMapping-sYs80uk", "([IJ)Z", "clear", "", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "partition", "Lkotlin/ranges/LongRange;", "rebuild", "removeMapping", "removeMapping-sYs80uk", "tryApply", "operation", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$DeleteOperation;", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$InsertOperation;", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$UpdateOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractHDIndex.Tx {
        @NotNull
        private final Set<Signature.Closed<?>> supportedDistances;
        @NotNull
        private Store dataStore;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            Store store = LSHIndex.this.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(LSHIndex.this.getName()), StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, this.getContext().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for index " + LSHIndex.this.getName() + " is missing.");
            }
            this.dataStore = store;
            LSHIndexConfig config = this.getConfig();
            Types[] typesArray = new Types[]{this.getColumn().getType(), this.getColumn().getType()};
            this.supportedDistances = SetsKt.setOf((Object)new Signature.Closed(config.getDistance(), typesArray, (Types)Types.Double.INSTANCE));
        }

        @NotNull
        public LSHIndexConfig getConfig() {
            IndexConfig<?> indexConfig = super.getConfig();
            Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.lsh.LSHIndexConfig");
            return (LSHIndexConfig)indexConfig;
        }

        @Override
        @NotNull
        protected Set<Signature.Closed<?>> getSupportedDistances() {
            return this.supportedDistances;
        }

        private final boolean addMapping-sYs80uk(int[] signature, long tupleId) {
            ArrayByteIterable signatureRaw = LSHSignature.Binding.INSTANCE.objectToEntry(LSHSignature.box-impl(signature));
            ArrayByteIterable tupleIdRaw = ExtensionsKt.toKey(tupleId);
            return this.dataStore.exists(this.getContext().getXodusTx(), (ByteIterable)signatureRaw, (ByteIterable)tupleIdRaw) ? this.dataStore.put(this.getContext().getXodusTx(), (ByteIterable)signatureRaw, (ByteIterable)tupleIdRaw) : false;
        }

        private final boolean removeMapping-sYs80uk(int[] signature, long tupleId) {
            ArrayByteIterable signatureRaw = LSHSignature.Binding.INSTANCE.objectToEntry(LSHSignature.box-impl(signature));
            ArrayByteIterable valueRaw = ExtensionsKt.toKey(tupleId);
            Cursor cursor2 = this.dataStore.openCursor(this.getContext().getXodusTx());
            return cursor2.getSearchBoth((ByteIterable)signatureRaw, (ByteIterable)valueRaw) ? cursor2.deleteCurrent() : false;
        }

        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate)) {
                boolean bl = false;
                String string = "LSHIndex can only process proximity predicates.";
                throw new IllegalArgumentException(string.toString());
            }
            return CollectionsKt.emptyList();
        }

        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        @Override
        public void rebuild() {
            LOGGER.debug("Rebuilding SB-LSH index {}", (Object)LSHIndex.this.getName());
            org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
            Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
            EntityTx entityTx = (EntityTx)tx;
            Value value = entityTx.read(entityTx.smallestTupleId(), this.getColumns()).get(this.getColumns()[0]);
            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.VectorValue<*>");
            VectorValue specimen = (VectorValue)value;
            this.clear();
            LSHSignatureGenerator generator = this.getConfig().generator(specimen.getLogicalSize());
            org.vitrivr.cottontail.core.basics.Cursor cursor2 = entityTx.cursor(this.getColumns());
            Iterator $this$forEach$iv = (Iterator)cursor2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                Value value2;
                Object element$iv = iterator.next();
                Record it = (Record)element$iv;
                boolean bl = false;
                if (it.get(this.getColumns()[0]) == null) {
                    throw new DatabaseException("Could not find column for entry in index " + this, null, 2, null);
                }
                if (!(value2 instanceof VectorValue)) continue;
                int[] signature = generator.generate-dna7En8((VectorValue)value2);
                this.addMapping-sYs80uk(signature, it.getTupleId());
            }
            cursor2.close();
            this.updateState(IndexState.CLEAN, LSHIndexConfig.copy$default(this.getConfig(), null, 0, 0, 0L, generator, 15, null));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.InsertOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            LSHIndex lSHIndex = LSHIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                LSHSignatureGenerator lSHSignatureGenerator = this.getConfig().getGenerator();
                if (lSHSignatureGenerator == null) {
                    throw new IllegalStateException("Failed to obtain LSHSignatureGenerator for index " + lSHIndex.getName() + ". This is a programmer's error!");
                }
                LSHSignatureGenerator generator = lSHSignatureGenerator;
                Value value = operation.getInserts().get(this.getColumns()[0]);
                if (!(value instanceof VectorValue)) {
                    boolean bl2 = false;
                    String string = "Failed to add " + value + " to LSHIndex. Incoming value is not a vector! This is a programmer's error!";
                    throw new IllegalStateException(string.toString());
                }
                boolean bl3 = this.addMapping-sYs80uk(generator.generate-dna7En8((VectorValue)value), operation.getTupleId());
                return bl3;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.UpdateOperation operation) {
            Pair<Value, Value> value;
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            LSHSignatureGenerator lSHSignatureGenerator = this.getConfig().getGenerator();
            if (lSHSignatureGenerator == null) {
                throw new IllegalStateException("Failed to obtain LSHSignatureGenerator for index " + LSHIndex.this.getName() + ". This is a programmer's error!");
            }
            LSHSignatureGenerator generator = lSHSignatureGenerator;
            Pair<Value, Value> pair = value = operation.getUpdates().get(this.getColumns()[0]);
            if (!((pair != null ? (Value)pair.getFirst() : null) instanceof VectorValue)) {
                boolean $i$a$-check-LSHIndex$Tx$tryApply$42 = false;
                String $i$a$-check-LSHIndex$Tx$tryApply$42 = "Failed to add " + value + " to LSHIndex. Incoming value is not a vector! This is a programmer's error!";
                throw new IllegalStateException($i$a$-check-LSHIndex$Tx$tryApply$42.toString());
            }
            Pair<Value, Value> pair2 = value;
            if (!((pair2 != null ? (Value)pair2.getSecond() : null) instanceof VectorValue)) {
                boolean bl = false;
                String string = "Failed to add " + value + " to LSHIndex. Incoming value is not a vector! This is a programmer's error!";
                throw new IllegalStateException(string.toString());
            }
            Pair<Value, Value> pair3 = value;
            Intrinsics.checkNotNull(pair3);
            Object object = pair3.getFirst();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.VectorValue<*>");
            if (!this.removeMapping-sYs80uk(generator.generate-dna7En8((VectorValue)object), operation.getTupleId())) return false;
            Object object2 = value.getSecond();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.VectorValue<*>");
            if (!this.addMapping-sYs80uk(generator.generate-dna7En8((VectorValue)object2), operation.getTupleId())) return false;
            return true;
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.DeleteOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            LSHSignatureGenerator lSHSignatureGenerator = this.getConfig().getGenerator();
            if (lSHSignatureGenerator == null) {
                throw new IllegalStateException("Failed to obtain LSHSignatureGenerator for index " + LSHIndex.this.getName() + ". This is a programmer's error!");
            }
            LSHSignatureGenerator generator = lSHSignatureGenerator;
            Value value = operation.getDeleted().get(this.getColumns()[0]);
            if (!(value instanceof VectorValue)) {
                boolean bl = false;
                String string = "Failed to add " + value + " to LSHIndex. Incoming value is not a vector! This is a programmer's error!";
                throw new IllegalStateException(string.toString());
            }
            return this.removeMapping-sYs80uk(generator.generate-dna7En8((VectorValue)value), operation.getTupleId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.dataStore.count(this.getContext().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock2 = this.getTxLatch();
            LSHIndex lSHIndex = LSHIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                lSHIndex.getCatalogue().getEnvironment$cottontaildb_dbms().truncateStore(ExtensionsKt.storeName(lSHIndex.getName()), this.getContext().getXodusTx());
                Store store = lSHIndex.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(lSHIndex.getName()), StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, this.getContext().getXodusTx(), false);
                if (store == null) {
                    throw new DatabaseException.DataCorruptionException("Data store for index " + lSHIndex.getName() + " is missing.");
                }
                this.dataStore = store;
                AbstractIndex.Tx.updateState$default(this, IndexState.STALE, null, 2, null);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Record> filter(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            return (org.vitrivr.cottontail.core.basics.Cursor)new org.vitrivr.cottontail.core.basics.Cursor<Record>(predicate, LSHIndex.this, this){
                @NotNull
                private final ProximityPredicate predicate;
                private final Transaction subTx;
                private final Cursor cursor;
                {
                    if (!($predicate instanceof ProximityPredicate)) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + $receiver.getName() + "' (LSH Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($predicate.getClass()).getSimpleName() + "'.");
                    }
                    this.predicate = (ProximityPredicate)$predicate;
                    this.subTx = $receiver2.getContext().getXodusTx().getReadonlySnapshot();
                    this.cursor = Tx.access$getDataStore$p($receiver2).openCursor(this.subTx);
                    LSHIndexConfig config = $receiver2.getConfig();
                    if (!Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)this.predicate.getColumns()), $receiver2.getColumns()[0]) || !Intrinsics.areEqual((Object)this.predicate.getDistance().getName(), (Object)config.getDistance())) {
                        throw new QueryException.UnsupportedPredicateException("Index '" + $receiver.getName() + "' (lsh-index) does not support the provided predicate.");
                    }
                    Value value = this.predicate.getQuery().getValue();
                    if (!(value instanceof VectorValue)) {
                        boolean bl = false;
                        Value value2 = value;
                        String string = "Bound value for query vector has wrong type (found = " + (value2 != null ? value2.getType() : null) + ").";
                        throw new IllegalStateException(string.toString());
                    }
                    LSHSignatureGenerator lSHSignatureGenerator = config.getGenerator();
                    int[] signature = lSHSignatureGenerator != null ? lSHSignatureGenerator.generate-dna7En8((VectorValue)value) : null;
                    if (!(signature != null)) {
                        boolean bl = false;
                        String string = "Failed to generate signature for query vector.";
                        throw new IllegalStateException(string.toString());
                    }
                    this.cursor.getSearchKey((ByteIterable)LSHSignature.Binding.INSTANCE.objectToEntry(signature != null ? LSHSignature.box-impl(signature) : null));
                }

                public boolean moveNext() {
                    return this.cursor.getNextDup();
                }

                @NotNull
                public Record next() {
                    return this.value();
                }

                @NotNull
                public Record value() {
                    boolean $i$f$emptyArray = false;
                    $i$f$emptyArray = false;
                    return (Record)new StandaloneRecord(this.key(), (ColumnDef[])((Object[])new ColumnDef[0]), (Value[])((Object[])new Value[0]));
                }

                public long key() {
                    return LongBinding.compressedEntryToLong((ByteIterable)this.cursor.getValue());
                }

                public void close() {
                    this.cursor.close();
                    this.subTx.commit();
                }

                public boolean hasNext() {
                    return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
                }

                public void remove() {
                    throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                }
            };
        }

        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Record> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("The LSHIndex does not support ranged filtering!");
        }

        public static final /* synthetic */ Store access$getDataStore$p(Tx $this) {
            return $this.dataStore;
        }
    }
}

