/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lsh;

import java.io.ByteArrayInputStream;
import java.util.Set;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.CosineDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.InnerProductDistance;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.lsh.LSHIndex;
import org.vitrivr.cottontail.dbms.index.lsh.signature.LSHSignatureGenerator;
import org.vitrivr.cottontail.dbms.index.lsh.signature.SBLSHSignatureGenerator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B1\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J=\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0006J\t\u0010!\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000e\u00a8\u0006&"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndex;", "distance", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "buckets", "", "stages", "seed", "", "generator", "Lorg/vitrivr/cottontail/dbms/index/lsh/signature/LSHSignatureGenerator;", "(Lorg/vitrivr/cottontail/core/database/Name$FunctionName;IIJLorg/vitrivr/cottontail/dbms/index/lsh/signature/LSHSignatureGenerator;)V", "getBuckets", "()I", "getDistance", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getGenerator", "()Lorg/vitrivr/cottontail/dbms/index/lsh/signature/LSHSignatureGenerator;", "getSeed", "()J", "getStages", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "dimension", "hashCode", "toString", "", "Binding", "Companion", "cottontaildb-dbms"})
public final class LSHIndexConfig
implements IndexConfig<LSHIndex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.FunctionName distance;
    private final int buckets;
    private final int stages;
    private final long seed;
    @Nullable
    private final LSHSignatureGenerator generator;
    @NotNull
    public static final String KEY_DISTANCES = "distances";
    @NotNull
    public static final String KEY_NUM_STAGES = "stages";
    @NotNull
    public static final String KEY_NUM_BUCKETS = "buckets";
    @NotNull
    public static final String KEY_SEED = "seed";
    @NotNull
    private static final Name.FunctionName DEFAULT_DISTANCE = CosineDistance.Companion.getFUNCTION_NAME();
    @NotNull
    private static final Set<Name.FunctionName> SUPPORTED_DISTANCES;

    public LSHIndexConfig(@NotNull Name.FunctionName distance, int buckets, int stages, long seed, @Nullable LSHSignatureGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        this.distance = distance;
        this.buckets = buckets;
        this.stages = stages;
        this.seed = seed;
        this.generator = generator;
        if (!(this.buckets > 1)) {
            boolean $i$a$-require-LSHIndexConfig$42 = false;
            String $i$a$-require-LSHIndexConfig$42 = "LSHIndex requires at least two buckets.";
            throw new IllegalArgumentException($i$a$-require-LSHIndexConfig$42.toString());
        }
        if (!(this.stages > 0)) {
            boolean $i$a$-require-LSHIndexConfig$52 = false;
            String $i$a$-require-LSHIndexConfig$52 = "LSHIndex requires at least a single stage.";
            throw new IllegalArgumentException($i$a$-require-LSHIndexConfig$52.toString());
        }
        if (!SUPPORTED_DISTANCES.contains(this.distance)) {
            boolean bl = false;
            String string = "LSHIndex only support COSINE and INNERPRODUCT distance.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ LSHIndexConfig(Name.FunctionName functionName, int n, int n2, long l, LSHSignatureGenerator lSHSignatureGenerator, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            lSHSignatureGenerator = null;
        }
        this(functionName, n, n2, l, lSHSignatureGenerator);
    }

    @NotNull
    public final Name.FunctionName getDistance() {
        return this.distance;
    }

    public final int getBuckets() {
        return this.buckets;
    }

    public final int getStages() {
        return this.stages;
    }

    public final long getSeed() {
        return this.seed;
    }

    @Nullable
    public final LSHSignatureGenerator getGenerator() {
        return this.generator;
    }

    @NotNull
    public final LSHSignatureGenerator generator(int dimension) {
        Name.FunctionName functionName = this.distance;
        if (!(Intrinsics.areEqual((Object)functionName, (Object)CosineDistance.Companion.getFUNCTION_NAME()) ? true : Intrinsics.areEqual((Object)functionName, (Object)InnerProductDistance.Companion.getFUNCTION_NAME()))) {
            throw new IllegalStateException("The " + this.distance + " distance is currently not supported by the LSH index engine.");
        }
        return new SBLSHSignatureGenerator(this.stages, this.buckets, this.seed, dimension);
    }

    @Override
    public int compareTo(@NotNull IndexConfig<LSHIndex> other) {
        return IndexConfig.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public final Name.FunctionName component1() {
        return this.distance;
    }

    public final int component2() {
        return this.buckets;
    }

    public final int component3() {
        return this.stages;
    }

    public final long component4() {
        return this.seed;
    }

    @Nullable
    public final LSHSignatureGenerator component5() {
        return this.generator;
    }

    @NotNull
    public final LSHIndexConfig copy(@NotNull Name.FunctionName distance, int buckets, int stages, long seed, @Nullable LSHSignatureGenerator generator) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        return new LSHIndexConfig(distance, buckets, stages, seed, generator);
    }

    public static /* synthetic */ LSHIndexConfig copy$default(LSHIndexConfig lSHIndexConfig, Name.FunctionName functionName, int n, int n2, long l, LSHSignatureGenerator lSHSignatureGenerator, int n3, Object object) {
        if ((n3 & 1) != 0) {
            functionName = lSHIndexConfig.distance;
        }
        if ((n3 & 2) != 0) {
            n = lSHIndexConfig.buckets;
        }
        if ((n3 & 4) != 0) {
            n2 = lSHIndexConfig.stages;
        }
        if ((n3 & 8) != 0) {
            l = lSHIndexConfig.seed;
        }
        if ((n3 & 0x10) != 0) {
            lSHSignatureGenerator = lSHIndexConfig.generator;
        }
        return lSHIndexConfig.copy(functionName, n, n2, l, lSHSignatureGenerator);
    }

    @NotNull
    public String toString() {
        return "LSHIndexConfig(distance=" + this.distance + ", buckets=" + this.buckets + ", stages=" + this.stages + ", seed=" + this.seed + ", generator=" + this.generator + ')';
    }

    public int hashCode() {
        int result = this.distance.hashCode();
        result = result * 31 + Integer.hashCode(this.buckets);
        result = result * 31 + Integer.hashCode(this.stages);
        result = result * 31 + Long.hashCode(this.seed);
        result = result * 31 + (this.generator == null ? 0 : this.generator.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LSHIndexConfig)) {
            return false;
        }
        LSHIndexConfig lSHIndexConfig = (LSHIndexConfig)other;
        if (!Intrinsics.areEqual((Object)this.distance, (Object)lSHIndexConfig.distance)) {
            return false;
        }
        if (this.buckets != lSHIndexConfig.buckets) {
            return false;
        }
        if (this.stages != lSHIndexConfig.stages) {
            return false;
        }
        if (this.seed != lSHIndexConfig.seed) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.generator, (Object)lSHIndexConfig.generator);
    }

    static {
        Object[] objectArray = new Name.FunctionName[]{CosineDistance.Companion.getFUNCTION_NAME(), InnerProductDistance.Companion.getFUNCTION_NAME()};
        SUPPORTED_DISTANCES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndexConfig$Companion;", "", "()V", "DEFAULT_DISTANCE", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getDEFAULT_DISTANCE", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "KEY_DISTANCES", "", "KEY_NUM_BUCKETS", "KEY_NUM_STAGES", "KEY_SEED", "SUPPORTED_DISTANCES", "", "getSUPPORTED_DISTANCES", "()Ljava/util/Set;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Name.FunctionName getDEFAULT_DISTANCE() {
            return DEFAULT_DISTANCE;
        }

        @NotNull
        public final Set<Name.FunctionName> getSUPPORTED_DISTANCES() {
            return SUPPORTED_DISTANCES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndexConfig$Binding;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "readObject", "", "Lorg/vitrivr/cottontail/dbms/index/lsh/LSHIndexConfig;", "stream", "Ljava/io/ByteArrayInputStream;", "writeObject", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "cottontaildb-dbms"})
    public static final class Binding
    extends ComparableBinding {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        @NotNull
        public Comparable<LSHIndexConfig> readObject(@NotNull ByteArrayInputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            String string = StringBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BINDING.readObject(stream)");
            return new LSHIndexConfig(Name.FunctionName.Companion.create(string), IntegerBinding.readCompressed((ByteArrayInputStream)stream), IntegerBinding.readCompressed((ByteArrayInputStream)stream), LongBinding.readCompressed((ByteArrayInputStream)stream), null, 16, null);
        }

        public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<? super LSHIndexConfig> object) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            if (!(object instanceof LSHIndexConfig)) {
                boolean bl = false;
                String string = "LSHIndexConfig.Binding can only be used to serialize instances of LSHIndexConfig.";
                throw new IllegalArgumentException(string.toString());
            }
            StringBinding.BINDING.writeObject(output, (Comparable)((Object)((LSHIndexConfig)object).getDistance().getSimple()));
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((LSHIndexConfig)object).getBuckets());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((LSHIndexConfig)object).getStages());
            LongBinding.writeCompressed((LightOutputStream)output, (long)((LSHIndexConfig)object).getSeed());
        }
    }
}

