/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.lucene;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.bindings.ComparableBinding;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.LongRange;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.similarities.SimilarityBase;
import org.apache.lucene.store.Directory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.binding.Binding;
import org.vitrivr.cottontail.core.queries.nodes.traits.NotPartitionableTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.OrderTrait;
import org.vitrivr.cottontail.core.queries.nodes.traits.Trait;
import org.vitrivr.cottontail.core.queries.nodes.traits.TraitType;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.BooleanPredicate;
import org.vitrivr.cottontail.core.queries.predicates.ComparisonOperator;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.StringValue;
import org.vitrivr.cottontail.core.values.pattern.LikePatternValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.dbms.catalogue.entries.IndexCatalogueEntry;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.lucene.LuceneAnalyzerType;
import org.vitrivr.cottontail.dbms.index.lucene.LuceneIndexConfig;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.storage.lucene.XodusDirectory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class LuceneIndex
extends AbstractIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private final IndexType type;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    public static final String TID_COLUMN = "_tid";

    public LuceneIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.supportsIncrementalUpdate = true;
        this.type = IndexType.LUCENE;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    static {
        Logger logger = LoggerFactory.getLogger(LuceneIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(LuceneIndex::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013R\u00020\u0014H\u0016J\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "TID_COLUMN", "", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "parameters", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "entity", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "initialize", "open", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<LuceneIndex> {
        private Companion() {
        }

        @Override
        @NotNull
        public LuceneIndex open(@NotNull Name.IndexName name, @NotNull DefaultEntity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new LuceneIndex(name, entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                XodusDirectory directory = new XodusDirectory(entity.getDbo().getCatalogue().getVfs$cottontaildb_dbms(), name.toString(), entity.getContext().getXodusTx(), null, 8, null);
                IndexWriterConfig config = new IndexWriterConfig().setOpenMode(IndexWriterConfig.OpenMode.CREATE).setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                IndexWriter writer = new IndexWriter((Directory)directory, config);
                writer.close();
                directory.close();
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize Lucene Index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                XodusDirectory directory = new XodusDirectory(entity.getDbo().getCatalogue().getVfs$cottontaildb_dbms(), name.toString(), entity.getContext().getXodusTx(), null, 8, null);
                for (String file : directory.listAll()) {
                    directory.deleteFile(file);
                }
                directory.close();
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize Lucene Index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<LuceneIndex> buildConfig(@NotNull Map<String, String> parameters) {
            LuceneAnalyzerType luceneAnalyzerType;
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            try {
                String string = parameters.get("analyzer_type");
                if (string == null) {
                    string = "";
                }
                luceneAnalyzerType = LuceneAnalyzerType.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                luceneAnalyzerType = LuceneAnalyzerType.STANDARD;
            }
            LuceneAnalyzerType luceneAnalyzerType2 = luceneAnalyzerType;
            return new LuceneIndexConfig(luceneAnalyzerType2);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return LuceneIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001bH\u0016J\u001a\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b&\u0010'J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020,H\u0016J)\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\n\u00101\u001a\u00060)j\u0002`2H\u0002\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b3\u00104J\u0016\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u00105\u001a\b\u0012\u0004\u0012\u000207062\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u001bH\u0016J \u0010=\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030?\u0012\u0004\u0012\u00020@0>2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010A\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020BH\u0016J\f\u0010C\u001a\u00020D*\u00020EH\u0002J\f\u0010C\u001a\u00020D*\u00020FH\u0002J\f\u0010C\u001a\u00020D*\u00020GH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006H"}, d2={"Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndex;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "config", "Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/lucene/LuceneIndexConfig;", "directory", "Lorg/apache/lucene/store/Directory;", "indexReader", "Lorg/apache/lucene/index/IndexReader;", "getIndexReader", "()Lorg/apache/lucene/index/IndexReader;", "indexReader$delegate", "Lkotlin/Lazy;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "getIndexWriter", "()Lorg/apache/lucene/index/IndexWriter;", "indexWriter$delegate", "readerInitialized", "", "writerInitialized", "beforeCommit", "", "beforeRollback", "canProcess", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "clear", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "", "delete", "operation", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$DeleteOperation;", "documentFromValue", "Lorg/apache/lucene/document/Document;", "value", "Lorg/vitrivr/cottontail/core/values/StringValue;", "tupleId", "Lorg/vitrivr/cottontail/core/database/TupleId;", "documentFromValue-RAUCjew", "(Ljava/lang/String;J)Lorg/apache/lucene/document/Document;", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "partition", "Lkotlin/ranges/LongRange;", "insert", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$InsertOperation;", "rebuild", "traitsFor", "", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/TraitType;", "Lorg/vitrivr/cottontail/core/queries/nodes/traits/Trait;", "update", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$UpdateOperation;", "toLuceneQuery", "Lorg/apache/lucene/search/Query;", "Lorg/vitrivr/cottontail/core/queries/predicates/BooleanPredicate;", "Lorg/vitrivr/cottontail/core/queries/predicates/BooleanPredicate$Atomic;", "Lorg/vitrivr/cottontail/core/queries/predicates/BooleanPredicate$Compound;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractIndex.Tx {
        @NotNull
        private final Directory directory;
        private volatile boolean readerInitialized;
        private volatile boolean writerInitialized;
        @NotNull
        private final Lazy indexWriter$delegate;
        @NotNull
        private final Lazy indexReader$delegate;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(LuceneIndex.this, context2);
            this.directory = new XodusDirectory(LuceneIndex.this.getCatalogue().getVfs$cottontaildb_dbms(), LuceneIndex.this.getName().toString(), this.getContext().getXodusTx(), null, 8, null);
            this.indexWriter$delegate = LazyKt.lazy((Function0)((Function0)new Function0<IndexWriter>(this){
                final /* synthetic */ Tx this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final IndexWriter invoke() {
                    IndexWriterConfig config = new IndexWriterConfig().setOpenMode(IndexWriterConfig.OpenMode.APPEND).setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
                    Tx.access$setWriterInitialized$p(this.this$0, true);
                    return new IndexWriter(Tx.access$getDirectory$p(this.this$0), config);
                }
            }));
            this.indexReader$delegate = LazyKt.lazy((Function0)((Function0)new Function0<DirectoryReader>(this){
                final /* synthetic */ Tx this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final DirectoryReader invoke() {
                    Tx.access$setReaderInitialized$p(this.this$0, true);
                    return DirectoryReader.open((Directory)Tx.access$getDirectory$p(this.this$0));
                }
            }));
        }

        @NotNull
        public LuceneIndexConfig getConfig() {
            IndexCatalogueEntry indexCatalogueEntry = IndexCatalogueEntry.Companion.read$cottontaildb_dbms(LuceneIndex.this.getName(), LuceneIndex.this.getParent().getParent().getParent(), this.getContext().getXodusTx());
            if (indexCatalogueEntry == null) {
                throw new DatabaseException.DataCorruptionException("Failed to read catalogue entry for index " + LuceneIndex.this.getName() + '.');
            }
            IndexCatalogueEntry entry = indexCatalogueEntry;
            IndexConfig<?> indexConfig = entry.getConfig();
            Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.lucene.LuceneIndexConfig");
            return (LuceneIndexConfig)indexConfig;
        }

        private final IndexWriter getIndexWriter() {
            Lazy lazy = this.indexWriter$delegate;
            return (IndexWriter)lazy.getValue();
        }

        private final IndexReader getIndexReader() {
            Lazy lazy = this.indexReader$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-indexReader>(...)");
            return (IndexReader)object;
        }

        private final Document documentFromValue-RAUCjew(String value, long tupleId) {
            Document doc = new Document();
            doc.add((IndexableField)new NumericDocValuesField(LuceneIndex.TID_COLUMN, tupleId));
            doc.add((IndexableField)new StoredField(LuceneIndex.TID_COLUMN, tupleId));
            doc.add((IndexableField)new TextField(this.getColumns()[0].getName() + "_txt", value, Field.Store.NO));
            doc.add((IndexableField)new StringField(this.getColumns()[0].getName() + "_str", value, Field.Store.NO));
            return doc;
        }

        private final Query toLuceneQuery(BooleanPredicate $this$toLuceneQuery) {
            Query query2;
            BooleanPredicate booleanPredicate = $this$toLuceneQuery;
            if (booleanPredicate instanceof BooleanPredicate.Atomic) {
                query2 = this.toLuceneQuery((BooleanPredicate.Atomic)$this$toLuceneQuery);
            } else if (booleanPredicate instanceof BooleanPredicate.Compound) {
                query2 = this.toLuceneQuery((BooleanPredicate.Compound)$this$toLuceneQuery);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return query2;
        }

        private final Query toLuceneQuery(BooleanPredicate.Atomic $this$toLuceneQuery) {
            Query query2;
            Value value;
            ColumnDef columnDef2;
            ComparisonOperator op = $this$toLuceneQuery.getOperator();
            if (!(op instanceof ComparisonOperator.Binary)) {
                throw new QueryException("Conversion to Lucene query failed: Only binary operators are supported.");
            }
            Binding left = op.getLeft();
            Binding right = ((ComparisonOperator.Binary)op).getRight();
            if (right instanceof Binding.Column && Intrinsics.areEqual((Object)((Binding.Column)right).getColumn(), this.getColumns()[0])) {
                columnDef2 = ((Binding.Column)right).getColumn();
            } else if (left instanceof Binding.Column && Intrinsics.areEqual((Object)((Binding.Column)left).getColumn(), this.getColumns()[0])) {
                columnDef2 = ((Binding.Column)left).getColumn();
            } else {
                throw new QueryException("Conversion to Lucene query failed: One side of the comparison operator must be a column value!");
            }
            ColumnDef column = columnDef2;
            if (right instanceof Binding.Literal) {
                value = right.getValue();
                if (value == null) {
                    throw new QueryException("Conversion to Lucene query failed: Literal value cannot be null!");
                }
            } else if (left instanceof Binding.Literal) {
                value = right.getValue();
                if (value == null) {
                    throw new QueryException("Conversion to Lucene query failed: Literal value cannot be null!");
                }
            } else {
                throw new QueryException("Conversion to Lucene query failed: One side of the comparison operator must be a literal value!");
            }
            Value literal = value;
            ComparisonOperator.Binary binary = (ComparisonOperator.Binary)op;
            if (binary instanceof ComparisonOperator.Binary.Equal) {
                if (!(literal instanceof StringValue)) {
                    throw new QueryException("Conversion to Lucene query failed: EQUAL queries strictly require a StringValue as second operand!");
                }
                query2 = (Query)new TermQuery(new Term(column.getName() + "_str", ((StringValue)literal).unbox-impl()));
            } else if (binary instanceof ComparisonOperator.Binary.Like) {
                Query query3;
                String[] stringArray;
                Value value2 = literal;
                if (value2 instanceof StringValue) {
                    stringArray = new String[]{((StringValue)literal).unbox-impl()};
                    String[] stringArray2 = stringArray;
                    stringArray = new String[]{column.getName() + "_txt"};
                    query3 = QueryParserUtil.parse((String[])stringArray2, (String[])stringArray, (Analyzer)((Analyzer)new StandardAnalyzer()));
                } else if (value2 instanceof LikePatternValue) {
                    stringArray = new String[]{((LikePatternValue)literal).toLucene().getValue()};
                    String[] stringArray3 = stringArray;
                    stringArray = new String[]{column.getName() + "_txt"};
                    query3 = QueryParserUtil.parse((String[])stringArray3, (String[])stringArray, (Analyzer)((Analyzer)new StandardAnalyzer()));
                } else {
                    throw new QueryException("Conversion to Lucene query failed: LIKE queries require a StringValue OR LikePatternValue as second operand!");
                }
                Query query4 = query3;
                Intrinsics.checkNotNullExpressionValue((Object)query4, (String)"{\n                    wh\u2026      }\n                }");
                query2 = query4;
            } else if (binary instanceof ComparisonOperator.Binary.Match) {
                if (!(literal instanceof StringValue)) {
                    throw new QueryException("Conversion to Lucene query failed: MATCH queries strictly require a StringValue as second operand!");
                }
                String[] stringArray = new String[]{((StringValue)literal).unbox-impl()};
                String[] stringArray4 = stringArray;
                stringArray = new String[]{column.getName() + "_txt"};
                Query query5 = QueryParserUtil.parse((String[])stringArray4, (String[])stringArray, (Analyzer)((Analyzer)new StandardAnalyzer()));
                Intrinsics.checkNotNullExpressionValue((Object)query5, (String)"{\n                    if\u2026      }\n                }");
                query2 = query5;
            } else {
                throw new QueryException("Lucene Query Conversion failed: Only EQUAL, MATCH and LIKE queries can be mapped to a Apache Lucene!");
            }
            return query2;
        }

        private final Query toLuceneQuery(BooleanPredicate.Compound $this$toLuceneQuery) {
            BooleanClause.Occur occur;
            BooleanPredicate.Compound compound = $this$toLuceneQuery;
            if (compound instanceof BooleanPredicate.Compound.And) {
                occur = BooleanClause.Occur.MUST;
            } else if (compound instanceof BooleanPredicate.Compound.Or) {
                occur = BooleanClause.Occur.SHOULD;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            BooleanClause.Occur clause = occur;
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(this.toLuceneQuery($this$toLuceneQuery.getP1()), clause);
            builder.add(this.toLuceneQuery($this$toLuceneQuery.getP2()), clause);
            BooleanQuery booleanQuery = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)booleanQuery, (String)"builder.build()");
            return (Query)booleanQuery;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean canProcess(@NotNull Predicate predicate) {
            boolean bl;
            ColumnDef it;
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof BooleanPredicate)) return false;
            Iterable $this$all$iv = predicate.getColumns();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    it = (ColumnDef)element$iv;
                    boolean bl3 = false;
                    if (ArraysKt.contains((Object[])this.getColumns(), (Object)it)) continue;
                    return false;
                }
                bl2 = true;
            }
            if (!bl2) return false;
            $this$all$iv = ((BooleanPredicate)predicate).getAtomics();
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator = $this$all$iv.iterator();
            do {
                Object element$iv;
                if (!iterator.hasNext()) return true;
                element$iv = iterator.next();
                it = (BooleanPredicate.Atomic)element$iv;
                boolean bl4 = false;
                if (!(it.getOperator() instanceof ComparisonOperator.Binary.Like) && !(it.getOperator() instanceof ComparisonOperator.Binary.Equal)) {
                    if (!(it.getOperator() instanceof ComparisonOperator.Binary.Match)) return false;
                }
                bl = true;
            } while (bl);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            LuceneIndex luceneIndex = LuceneIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate)) {
                    boolean bl2 = false;
                    String string = "Lucene can only process boolean predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                List list = CollectionsKt.listOf((Object)new ColumnDef(luceneIndex.getParent().getName().column("score"), (Types)Types.Double.INSTANCE, false, false, 12, null));
                return list;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Map<TraitType<?>, Trait> traitsFor(@NotNull Predicate predicate) {
            Map map2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            LuceneIndex luceneIndex = LuceneIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof BooleanPredicate)) {
                    boolean bl2 = false;
                    String string = "Lucene Index can only process Boolean predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)NotPartitionableTrait.INSTANCE, (Object)NotPartitionableTrait.INSTANCE), TuplesKt.to((Object)OrderTrait.Companion, (Object)new OrderTrait(CollectionsKt.listOf((Object)TuplesKt.to((Object)new ColumnDef(luceneIndex.getParent().getName().column("score"), (Types)Types.Double.INSTANCE, false, false, 12, null), (Object)SortOrder.DESCENDING))))};
                map2 = MapsKt.mapOf((Pair[])pairArray);
            }
            finally {
                lock2.unlock();
            }
            return map2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            float[] fArray;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (this.canProcess(predicate)) {
                void var3_3;
                DirectoryReader reader = DirectoryReader.open((Directory)this.directory);
                float[] cost = null;
                cost = Cost.Companion.getZERO-7CRCzCo();
                int n = predicate.getColumns().size();
                int n2 = 0;
                while (n2 < n) {
                    int it = n2++;
                    boolean bl = false;
                    cost = Cost.plus-wQ19W7k((float[])cost, (float[])Cost.times-7eHliGg((float[])Cost.plus-wQ19W7k((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo(), (float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo()), (Number)SimilarityBase.log2((double)reader.numDocs())));
                }
                fArray = var3_3;
            } else {
                fArray = Cost.Companion.getINVALID-7CRCzCo();
            }
            return fArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                long l = this.getIndexReader().numDocs();
                return l;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            Lock lock2 = this.getTxLatch();
            LuceneIndex luceneIndex = LuceneIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                LOGGER.debug("Rebuilding Lucene index {}", (Object)luceneIndex.getName());
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx entityTx = (EntityTx)tx;
                org.vitrivr.cottontail.dbms.general.Tx tx2 = this.getContext().getTx(entityTx.columnForName(this.getColumns()[0].getName()));
                Intrinsics.checkNotNull((Object)tx2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<org.vitrivr.cottontail.core.values.StringValue>");
                ColumnTx columnTx = (ColumnTx)tx2;
                this.getIndexWriter().deleteAll();
                this.getIndexWriter().flush();
                AutoCloseable autoCloseable = (AutoCloseable)columnTx.cursor();
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)autoCloseable;
                    boolean bl2 = false;
                    while (cursor2.moveNext()) {
                        StringValue stringValue = (StringValue)cursor2.value();
                        String value = stringValue != null ? stringValue.unbox-impl() : null;
                        if (value == null) continue;
                        this.getIndexWriter().addDocument((Iterable)this.documentFromValue-RAUCjew(value, cursor2.key()));
                        if (this.getIndexWriter().getPendingNumDocs() % 10000L != 0L) continue;
                        this.getIndexWriter().flush();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                AbstractIndex.Tx.updateState$default(this, IndexState.CLEAN, null, 2, null);
                LOGGER.debug("Rebuilding Lucene index {} completed!", (Object)luceneIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insert(@NotNull Operation.DataManagementOperation.InsertOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Value value = operation.getInserts().get(this.getColumns()[0]);
                if (value instanceof StringValue) {
                    this.getIndexWriter().addDocument((Iterable)this.documentFromValue-RAUCjew(((StringValue)value).unbox-impl(), operation.getTupleId()));
                    if (this.getIndexWriter().getPendingNumDocs() % 10000L == 0L) {
                        this.getIndexWriter().flush();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void update(@NotNull Operation.DataManagementOperation.UpdateOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                Value value;
                boolean bl = false;
                Pair<Value, Value> pair = operation.getUpdates().get(this.getColumns()[0]);
                Object object = value = pair != null ? (Value)pair.getSecond() : null;
                if (value instanceof StringValue) {
                    this.getIndexWriter().updateDocument(new Term(LuceneIndex.TID_COLUMN, String.valueOf(operation.getTupleId())), (Iterable)this.documentFromValue-RAUCjew(((StringValue)value).unbox-impl(), operation.getTupleId()));
                    if (this.getIndexWriter().getPendingNumDocs() % 10000L == 0L) {
                        this.getIndexWriter().flush();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(@NotNull Operation.DataManagementOperation.DeleteOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                Term[] termArray = new Term[]{new Term(LuceneIndex.TID_COLUMN, String.valueOf(operation.getTupleId()))};
                this.getIndexWriter().deleteDocuments(termArray);
                if (this.getIndexWriter().getPendingNumDocs() % 10000L == 0L) {
                    this.getIndexWriter().flush();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                this.getIndexWriter().deleteAll();
                AbstractIndex.Tx.updateState$default(this, IndexState.STALE, null, 2, null);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Cursor<Record> filter(@NotNull Predicate predicate) {
            Cursor<Record> cursor2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            LuceneIndex luceneIndex = LuceneIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                cursor2 = new Cursor<Record>(predicate, luceneIndex, this){
                    @NotNull
                    private final BooleanPredicate predicate;
                    @NotNull
                    private final ColumnDef<?>[] columns;
                    private volatile int returned;
                    @NotNull
                    private final Query query;
                    @NotNull
                    private final IndexSearcher searcher;
                    private final TopDocs results;
                    {
                        if (!($predicate instanceof BooleanPredicate)) {
                            throw new QueryException.UnsupportedPredicateException("Index '" + $receiver.getName() + "' (lucene index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($predicate.getClass()).getSimpleName() + "'.");
                        }
                        this.predicate = (BooleanPredicate)$predicate;
                        Collection $this$toTypedArray$iv = $receiver2.columnsFor($predicate);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
                        Intrinsics.checkNotNull((Object)columnDefArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        this.columns = columnDefArray;
                        this.query = Tx.access$toLuceneQuery($receiver2, this.predicate);
                        this.searcher = new IndexSearcher(Tx.access$getIndexReader($receiver2));
                        this.results = this.searcher.search(this.query, Integer.MAX_VALUE);
                    }

                    public boolean moveNext() {
                        return (long)this.returned < this.results.totalHits.value;
                    }

                    public long key() {
                        ScoreDoc scores = this.results.scoreDocs[this.returned];
                        Document doc = this.searcher.doc(scores.doc);
                        String string = doc.get("_tid");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc[TID_COLUMN]");
                        return Long.parseLong(string);
                    }

                    @NotNull
                    public Record value() {
                        int n = this.returned;
                        this.returned = n + 1;
                        ScoreDoc scores = this.results.scoreDocs[n];
                        Document doc = this.searcher.doc(scores.doc);
                        String string = doc.get("_tid");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"doc[TID_COLUMN]");
                        Value[] valueArray = new Value[]{DoubleValue.box-impl((double)DoubleValue.constructor-impl((float)scores.score))};
                        return (Record)new StandaloneRecord(Long.parseLong(string), this.columns, valueArray);
                    }

                    public void close() {
                    }

                    public boolean hasNext() {
                        return Cursor.DefaultImpls.hasNext((Cursor)this);
                    }

                    @NotNull
                    public Record next() {
                        return (Record)Cursor.DefaultImpls.next((Cursor)this);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                lock2.unlock();
            }
            return (Cursor)cursor2;
        }

        @Override
        @NotNull
        public Cursor<Record> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("The LuceneIndex does not support ranged filtering!");
        }

        @Override
        public void beforeCommit() {
            super.beforeCommit();
            if (this.writerInitialized) {
                if (this.getIndexWriter().hasUncommittedChanges()) {
                    this.getIndexWriter().commit();
                }
                this.getIndexWriter().close();
            }
            if (this.readerInitialized) {
                this.getIndexReader().close();
            }
            this.directory.close();
        }

        @Override
        public void beforeRollback() {
            super.beforeCommit();
            if (this.writerInitialized) {
                if (this.getIndexWriter().hasUncommittedChanges()) {
                    this.getIndexWriter().rollback();
                }
                this.getIndexWriter().close();
            }
            if (this.readerInitialized) {
                this.getIndexReader().close();
            }
            this.directory.close();
        }

        public static final /* synthetic */ Query access$toLuceneQuery(Tx $this, BooleanPredicate $receiver) {
            return $this.toLuceneQuery($receiver);
        }

        public static final /* synthetic */ IndexReader access$getIndexReader(Tx $this) {
            return $this.getIndexReader();
        }

        public static final /* synthetic */ void access$setWriterInitialized$p(Tx $this, boolean bl) {
            $this.writerInitialized = bl;
        }

        public static final /* synthetic */ Directory access$getDirectory$p(Tx $this) {
            return $this.directory;
        }

        public static final /* synthetic */ void access$setReaderInitialized$p(Tx $this, boolean bl) {
            $this.readerInitialized = bl;
        }
    }
}

