/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.LongRange;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.Argument;
import org.vitrivr.cottontail.core.queries.functions.Function;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.exceptions.QueryException;
import org.vitrivr.cottontail.dbms.execution.operators.sort.RecordComparator;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.index.AbstractHDIndex;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.pq.PQIndex;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.PQLookupTable;
import org.vitrivr.cottontail.dbms.index.pq.PQSignature;
import org.vitrivr.cottontail.dbms.index.pq.ProductQuantizer;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.utilities.selection.HeapSelection;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class PQIndex
extends AbstractHDIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private static final Logger LOGGER;

    public PQIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
    }

    @Override
    @NotNull
    public IndexType getType() {
        return IndexType.PQ;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    static {
        Logger logger = LoggerFactory.getLogger(PQIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(PQIndex::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "parameters", "", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "entity", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "initialize", "open", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<PQIndex> {
        private Companion() {
        }

        @Override
        @NotNull
        public PQIndex open(@NotNull Name.IndexName name, @NotNull DefaultEntity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new PQIndex(name, entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                Store store = entity.getDbo().getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(name), StoreConfig.WITH_DUPLICATES, entity.getContext().getXodusTx(), true);
                bl = store != null;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize PQ index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                entity.getDbo().getCatalogue().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name), entity.getContext().getXodusTx());
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize PQ index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<PQIndex> buildConfig(@NotNull Map<String, String> parameters) {
            String string;
            block3: {
                block2: {
                    Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
                    string = parameters.get("distance");
                    if (string == null) break block2;
                    String it = string;
                    boolean bl = false;
                    Name.FunctionName functionName = Name.FunctionName.Companion.create(it);
                    string = functionName;
                    if (functionName != null) break block3;
                }
                string = EuclideanDistance.Companion.getFUNCTION_NAME();
            }
            String string2 = parameters.get("sample_size");
            String string3 = parameters.get("num_centroids");
            String string4 = parameters.get("num_subspaces");
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 48;
            List list = null;
            long l = 0L;
            Integer n2 = string4 != null ? Integer.valueOf(Integer.parseInt(string4)) : null;
            int n3 = string3 != null ? Integer.parseInt(string3) : 100;
            int n4 = string2 != null ? Integer.parseInt(string2) : 1500;
            String string5 = string;
            return new PQIndexConfig((Name.FunctionName)string5, n4, n3, n2, l, list, n, defaultConstructorMarker);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return PQIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b \u0010!J\b\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0019H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020.H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020/H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u00060"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "config", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "dataStore", "Ljetbrains/exodus/env/Store;", "supportedDistances", "", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Closed;", "getSupportedDistances", "()Ljava/util/Set;", "acquireLearningData", "", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "txn", "Lorg/vitrivr/cottontail/dbms/entity/EntityTx;", "random", "Lorg/apache/commons/math3/random/RandomGenerator;", "clear", "", "columnsFor", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "partition", "Lkotlin/ranges/LongRange;", "rebuild", "tryApply", "", "operation", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$DeleteOperation;", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$InsertOperation;", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$UpdateOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractHDIndex.Tx {
        @NotNull
        private final Set<Signature.Closed<?>> supportedDistances;
        @NotNull
        private Store dataStore;

        public Tx(TransactionContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
            PQIndexConfig config = this.getConfig();
            Types[] typesArray = new Types[]{this.getColumn().getType(), this.getColumn().getType()};
            this.supportedDistances = SetsKt.setOf((Object)new Signature.Closed(config.getDistance(), typesArray, (Types)Types.Double.INSTANCE));
            Store store = PQIndex.this.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(PQIndex.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getXodusTx(), false);
            if (store == null) {
                throw new DatabaseException.DataCorruptionException("Data store for index " + PQIndex.this.getName() + " is missing.");
            }
            this.dataStore = store;
        }

        @NotNull
        public PQIndexConfig getConfig() {
            IndexConfig<?> indexConfig = super.getConfig();
            Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig");
            return (PQIndexConfig)indexConfig;
        }

        @Override
        @NotNull
        protected Set<Signature.Closed<?>> getSupportedDistances() {
            return this.supportedDistances;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                if (!(predicate instanceof ProximityPredicate)) {
                    boolean bl2 = false;
                    String string = "PQIndex can only process proximity predicates.";
                    throw new IllegalArgumentException(string.toString());
                }
                List list = CollectionsKt.listOf((Object)((ProximityPredicate)predicate).getDistanceColumn());
                return list;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                int n;
                boolean bl = false;
                if (!(predicate instanceof ProximityPredicate)) {
                    float[] fArray = Cost.Companion.getINVALID-7CRCzCo();
                    return fArray;
                }
                if (!Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn(), this.getColumns()[0])) {
                    float[] fArray = Cost.Companion.getINVALID-7CRCzCo();
                    return fArray;
                }
                if (!Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getDistance().getName(), (Object)this.getConfig().getDistance())) {
                    float[] fArray = Cost.Companion.getINVALID-7CRCzCo();
                    return fArray;
                }
                long count = this.count();
                Integer n2 = this.getConfig().getNumSubspaces();
                int subspaces = n2 != null ? n2.intValue() : ProductQuantizer.Companion.defaultNumberOfSubspaces(((ProximityPredicate)predicate).getColumn().getType().getLogicalSize());
                Iterable iterable = this.columnsFor(predicate);
                long l = ((ProximityPredicate)predicate).getK();
                float f = (float)count * ((float)4 * Cost.getCpu-impl((float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo()) + Cost.getCpu-impl((float[])Cost.Companion.getFLOP-7CRCzCo())) + Cost.getCpu-impl((float[])predicate.getCost-7CRCzCo()) * (float)((ProximityPredicate)predicate).getK();
                float f2 = (float)(count * (long)subspaces) * Cost.getIo-impl((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo()) + (float)(((ProximityPredicate)predicate).getK() * (long)((ProximityPredicate)predicate).getColumn().getType().getLogicalSize()) * Cost.getIo-impl((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo());
                int n3 = 0;
                for (Object t : iterable) {
                    void it;
                    ColumnDef columnDef2 = (ColumnDef)t;
                    n = n3;
                    boolean bl2 = false;
                    int n4 = it.getType().getPhysicalSize();
                    n3 = n + n4;
                }
                n = n3;
                float[] fArray = Cost.constructor-impl$default((float)f2, (float)f, (float)(l * (long)n), (float)0.0f, (int)8, null);
                return fArray;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            Lock lock2 = this.getTxLatch();
            PQIndex pQIndex = PQIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                LOGGER.debug("Rebuilding PQ index {}", (Object)pQIndex.getName());
                JDKRandomGenerator random = new JDKRandomGenerator((int)System.currentTimeMillis());
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(this.getDbo().getParent());
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx entityTx = (EntityTx)tx;
                PQIndexConfig config = this.getConfig();
                ColumnDef<?> indexedColumn = this.getColumns()[0];
                Types types = indexedColumn.getType();
                Intrinsics.checkNotNull((Object)types, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.Types.Vector<*, *>");
                Types.Vector type = (Types.Vector)types;
                Argument.Typed[] typedArray = new Argument.Typed[]{new Argument.Typed((Types)type), new Argument.Typed((Types)type)};
                Function function = pQIndex.getCatalogue().getFunctions().obtain(new Signature.SemiClosed(config.getDistance(), typedArray));
                Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance<*>");
                VectorDistance distanceFunction = (VectorDistance)function;
                ProductQuantizer newPq = ProductQuantizer.Companion.learnFromData(distanceFunction, this.acquireLearningData(entityTx, (RandomGenerator)random), config);
                this.clear();
                ColumnDef[] columnDefArray = new ColumnDef[]{indexedColumn};
                org.vitrivr.cottontail.core.basics.Cursor cursor2 = entityTx.cursor(columnDefArray);
                Iterator $this$forEach$iv = (Iterator)cursor2;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Record rec = (Record)element$iv;
                    boolean bl2 = false;
                    Value value = rec.get(0);
                    if (!(value instanceof VectorValue)) continue;
                    int[] sig = newPq.quantize-WCB9L64((VectorValue)value);
                    this.dataStore.put(this.getContext().getXodusTx(), PQSignature.Binding.INSTANCE.valueToEntry-OK72CuY(sig), (ByteIterable)ExtensionsKt.toKey(rec.getTupleId()));
                }
                cursor2.close();
                this.updateState(IndexState.CLEAN, PQIndexConfig.copy$default(this.getConfig(), null, 0, 0, null, 0L, newPq.centroids(), 31, null));
                LOGGER.debug("Rebuilding PQ index {} completed!", (Object)pQIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.dataStore.count(this.getContext().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock2 = this.getTxLatch();
            PQIndex pQIndex = PQIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                pQIndex.getCatalogue().getEnvironment$cottontaildb_dbms().truncateStore(ExtensionsKt.storeName(pQIndex.getName()), this.getContext().getXodusTx());
                Store store = pQIndex.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(pQIndex.getName()), StoreConfig.USE_EXISTING, this.getContext().getXodusTx(), false);
                if (store == null) {
                    throw new DatabaseException.DataCorruptionException("Data store for index " + pQIndex.getName() + " is missing.");
                }
                this.dataStore = store;
                AbstractIndex.Tx.updateState$default(this, IndexState.STALE, null, 2, null);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.InsertOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            return false;
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.UpdateOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            return false;
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.DeleteOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Record> filter(@NotNull Predicate predicate) {
            org.vitrivr.cottontail.core.basics.Cursor<Record> cursor2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            PQIndex pQIndex = PQIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                cursor2 = new org.vitrivr.cottontail.core.basics.Cursor<Record>(this, predicate, pQIndex){
                    @NotNull
                    private final PQIndexConfig config;
                    @NotNull
                    private final ProximityPredicate predicate;
                    @NotNull
                    private final ProductQuantizer pq;
                    @NotNull
                    private final EntityTx entityTx;
                    @NotNull
                    private final double[][] lookupTable;
                    @NotNull
                    private HeapSelection<Record> selection;
                    private long position;
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ Predicate $predicate;
                    {
                        HeapSelection<T> heapSelection;
                        this.this$0 = $receiver;
                        this.$predicate = $predicate;
                        this.config = $receiver.getConfig();
                        if (!($predicate instanceof ProximityPredicate)) {
                            throw new QueryException.UnsupportedPredicateException("Index '" + $receiver2.getName() + "' (PQ Index) does not support predicates of type '" + Reflection.getOrCreateKotlinClass($predicate.getClass()).getSimpleName() + "'.");
                        }
                        this.predicate = (ProximityPredicate)$predicate;
                        this.pq = ProductQuantizer.Companion.loadFromConfig(this.predicate.getDistance(), this.config);
                        org.vitrivr.cottontail.dbms.general.Tx tx = $receiver.getContext().getTx($receiver2.getParent());
                        Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                        this.entityTx = (EntityTx)tx;
                        Value value = this.predicate.getQuery().getValue();
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.VectorValue<*>");
                        this.lookupTable = this.pq.createLookupTable-v6EEJP4((VectorValue)value);
                        ProximityPredicate proximityPredicate = this.predicate;
                        if (proximityPredicate instanceof ProximityPredicate.NNS) {
                            heapSelection = new HeapSelection<T>(this.predicate.getK(), new RecordComparator.SingleNonNullColumnComparator(this.predicate.getDistanceColumn(), SortOrder.ASCENDING));
                        } else if (proximityPredicate instanceof ProximityPredicate.FNS) {
                            heapSelection = new HeapSelection<T>(this.predicate.getK(), new RecordComparator.SingleNonNullColumnComparator(this.predicate.getDistanceColumn(), SortOrder.DESCENDING));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        this.selection = heapSelection;
                        this.position = -1L;
                    }

                    public boolean moveNext() {
                        if (this.selection.getAdded() == 0L) {
                            this.prepare();
                        }
                        ++this.position;
                        return this.position < this.selection.getSize();
                    }

                    public long key() {
                        return this.selection.get(this.position).getTupleId();
                    }

                    @NotNull
                    public Record value() {
                        return this.selection.get(this.position);
                    }

                    public void close() {
                    }

                    private final void prepare() {
                        Comparator comparator;
                        long preNNSSize = (long)((double)this.predicate.getK() * 1.15);
                        ProximityPredicate proximityPredicate = this.predicate;
                        if (proximityPredicate instanceof ProximityPredicate.NNS) {
                            comparator = filter.1.1::prepare$lambda$0;
                        } else if (proximityPredicate instanceof ProximityPredicate.FNS) {
                            comparator = filter.1.1::prepare$lambda$1;
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        Comparator comparator2 = comparator;
                        HeapSelection<Pair> preNNSSelection = new HeapSelection<Pair>(preNNSSize, comparator2);
                        Collection $this$toTypedArray$iv = this.this$0.columnsFor(this.$predicate);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
                        Intrinsics.checkNotNull((Object)columnDefArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        ColumnDef[] produces = columnDefArray;
                        Transaction subTx = this.this$0.getContext().getXodusTx().getReadonlySnapshot();
                        Cursor cursor2 = Tx.access$getDataStore$p(this.this$0).openCursor(subTx);
                        while (cursor2.getNext()) {
                            ByteIterable byteIterable = cursor2.getKey();
                            Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"cursor.key");
                            int[] signature = PQSignature.Binding.INSTANCE.entryToValue-WCB9L64(byteIterable);
                            double approximation = PQLookupTable.approximateDistance-OK72CuY(this.lookupTable, signature);
                            if (preNNSSelection.getAdded() >= preNNSSize) {
                                T t = preNNSSelection.peek();
                                Intrinsics.checkNotNull(t);
                                if (!(((Number)((Pair)t).getSecond()).doubleValue() > approximation)) continue;
                            }
                            List tupleIds = new ArrayList<E>();
                            do {
                                tupleIds.add(LongBinding.compressedEntryToLong((ByteIterable)cursor2.getValue()));
                            } while (cursor2.getNextDup());
                            preNNSSelection.offer(TuplesKt.to((Object)CollectionsKt.toLongArray((Collection)tupleIds), (Object)approximation));
                        }
                        cursor2.close();
                        subTx.abort();
                        Value value = this.predicate.getQuery().getValue();
                        Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.VectorValue<*>");
                        VectorValue query2 = (VectorValue)value;
                        long l = preNNSSelection.getSize();
                        for (long j = 0L; j < l; ++j) {
                            for (long tupleId : (long[])((Pair)preNNSSelection.get(j)).getFirst()) {
                                Value value2 = this.entityTx.read(tupleId, this.this$0.getColumns()).get(0);
                                Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.VectorValue<*>");
                                VectorValue value3 = (VectorValue)value2;
                                Value[] valueArray = new Value[]{(Value)query2, (Value)value3};
                                DoubleValue distance = (DoubleValue)this.predicate.getDistance().invoke(valueArray);
                                valueArray = new Value[]{(Value)distance};
                                this.selection.offer((Record)new StandaloneRecord(tupleId, produces, valueArray));
                            }
                        }
                    }

                    public boolean hasNext() {
                        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
                    }

                    @NotNull
                    public Record next() {
                        return (Record)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }

                    private static final int prepare$lambda$0(Pair o1, Pair o2) {
                        return Double.compare(((Number)o1.getSecond()).doubleValue(), ((Number)o2.getSecond()).doubleValue());
                    }

                    private static final int prepare$lambda$1(Pair o1, Pair o2) {
                        return -Double.compare(((Number)o1.getSecond()).doubleValue(), ((Number)o2.getSecond()).doubleValue());
                    }
                };
            }
            finally {
                lock2.unlock();
            }
            return (org.vitrivr.cottontail.core.basics.Cursor)cursor2;
        }

        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Record> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            throw new UnsupportedOperationException("The PQIndex does not support ranged filtering!");
        }

        private final List<VectorValue<?>> acquireLearningData(EntityTx txn, RandomGenerator random) {
            LinkedList<Value> learningData = new LinkedList<Value>();
            double learningDataFraction = (double)this.getConfig().getSampleSize() / (double)txn.count();
            org.vitrivr.cottontail.core.basics.Cursor cursor2 = txn.cursor(this.getColumns());
            Iterator $this$forEach$iv = (Iterator)cursor2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                Value value;
                Object element$iv = iterator.next();
                Record it = (Record)element$iv;
                boolean bl = false;
                if (!(random.nextDouble() <= learningDataFraction) || !((value = it.get(this.getColumns()[0])) instanceof VectorValue)) continue;
                learningData.add(value);
            }
            cursor2.close();
            return learningData;
        }

        public static final /* synthetic */ Store access$getDataStore$p(Tx $this) {
            return $this.dataStore;
        }
    }
}

