/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.CosineDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.PQIndex;
import org.xerial.snappy.Snappy;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0013\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002*+BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0016J\t\u0010\u001f\u001a\u00020\nH\u00c6\u0003J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003JR\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001\u00a2\u0006\u0002\u0010\"J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0006H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0017\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndex;", "distance", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "sampleSize", "", "numCentroids", "numSubspaces", "seed", "", "centroids", "", "", "(Lorg/vitrivr/cottontail/core/database/Name$FunctionName;IILjava/lang/Integer;JLjava/util/List;)V", "getCentroids", "()Ljava/util/List;", "getDistance", "()Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getNumCentroids", "()I", "getNumSubspaces", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getSampleSize", "getSeed", "()J", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "(Lorg/vitrivr/cottontail/core/database/Name$FunctionName;IILjava/lang/Integer;JLjava/util/List;)Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "equals", "", "other", "", "hashCode", "toString", "", "Binding", "Companion", "cottontaildb-dbms"})
public final class PQIndexConfig
implements IndexConfig<PQIndex> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Name.FunctionName distance;
    private final int sampleSize;
    private final int numCentroids;
    @Nullable
    private final Integer numSubspaces;
    private final long seed;
    @NotNull
    private final List<double[]> centroids;
    @NotNull
    public static final String KEY_DISTANCE = "distance";
    @NotNull
    public static final String KEY_NUM_SUBSPACES = "num_subspaces";
    @NotNull
    public static final String KEY_NUM_CENTROIDS = "num_centroids";
    @NotNull
    public static final String KEY_SAMPLE_SIZE = "sample_size";
    @NotNull
    private static final Set<Name.FunctionName> SUPPORTED_DISTANCES;

    public PQIndexConfig(@NotNull Name.FunctionName distance, int sampleSize, int numCentroids, @Nullable Integer numSubspaces, long seed, @NotNull List<double[]> centroids) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)KEY_DISTANCE);
        Intrinsics.checkNotNullParameter(centroids, (String)"centroids");
        this.distance = distance;
        this.sampleSize = sampleSize;
        this.numCentroids = numCentroids;
        this.numSubspaces = numSubspaces;
        this.seed = seed;
        this.centroids = centroids;
        if (!(this.numCentroids > 0)) {
            boolean $i$a$-require-PQIndexConfig$52 = false;
            String $i$a$-require-PQIndexConfig$52 = "PQIndex requires at least one centroid.";
            throw new IllegalArgumentException($i$a$-require-PQIndexConfig$52.toString());
        }
        if (!(this.numSubspaces == null || this.numSubspaces > 0)) {
            boolean $i$a$-require-PQIndexConfig$62 = false;
            String $i$a$-require-PQIndexConfig$62 = "PQIndex requires at least one sub space.";
            throw new IllegalArgumentException($i$a$-require-PQIndexConfig$62.toString());
        }
        if (!(this.numCentroids <= Short.MAX_VALUE)) {
            boolean $i$a$-require-PQIndexConfig$72 = false;
            String $i$a$-require-PQIndexConfig$72 = "PQIndex supports a maximum number of 32767 centroids.";
            throw new IllegalArgumentException($i$a$-require-PQIndexConfig$72.toString());
        }
        if (!SUPPORTED_DISTANCES.contains(this.distance)) {
            boolean bl = false;
            String string = "PQIndex only support L1, L2, L2SQUARED, COSINE and INNERPRODUCT distance.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ PQIndexConfig(Name.FunctionName functionName, int n, int n2, Integer n3, long l, List list, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 8) != 0) {
            n3 = null;
        }
        if ((n4 & 0x10) != 0) {
            l = System.currentTimeMillis();
        }
        if ((n4 & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(functionName, n, n2, n3, l, list);
    }

    @NotNull
    public final Name.FunctionName getDistance() {
        return this.distance;
    }

    public final int getSampleSize() {
        return this.sampleSize;
    }

    public final int getNumCentroids() {
        return this.numCentroids;
    }

    @Nullable
    public final Integer getNumSubspaces() {
        return this.numSubspaces;
    }

    public final long getSeed() {
        return this.seed;
    }

    @NotNull
    public final List<double[]> getCentroids() {
        return this.centroids;
    }

    @Override
    public int compareTo(@NotNull IndexConfig<PQIndex> other) {
        return IndexConfig.DefaultImpls.compareTo(this, other);
    }

    @NotNull
    public final Name.FunctionName component1() {
        return this.distance;
    }

    public final int component2() {
        return this.sampleSize;
    }

    public final int component3() {
        return this.numCentroids;
    }

    @Nullable
    public final Integer component4() {
        return this.numSubspaces;
    }

    public final long component5() {
        return this.seed;
    }

    @NotNull
    public final List<double[]> component6() {
        return this.centroids;
    }

    @NotNull
    public final PQIndexConfig copy(@NotNull Name.FunctionName distance, int sampleSize, int numCentroids, @Nullable Integer numSubspaces, long seed, @NotNull List<double[]> centroids) {
        Intrinsics.checkNotNullParameter((Object)distance, (String)KEY_DISTANCE);
        Intrinsics.checkNotNullParameter(centroids, (String)"centroids");
        return new PQIndexConfig(distance, sampleSize, numCentroids, numSubspaces, seed, centroids);
    }

    public static /* synthetic */ PQIndexConfig copy$default(PQIndexConfig pQIndexConfig, Name.FunctionName functionName, int n, int n2, Integer n3, long l, List list, int n4, Object object) {
        if ((n4 & 1) != 0) {
            functionName = pQIndexConfig.distance;
        }
        if ((n4 & 2) != 0) {
            n = pQIndexConfig.sampleSize;
        }
        if ((n4 & 4) != 0) {
            n2 = pQIndexConfig.numCentroids;
        }
        if ((n4 & 8) != 0) {
            n3 = pQIndexConfig.numSubspaces;
        }
        if ((n4 & 0x10) != 0) {
            l = pQIndexConfig.seed;
        }
        if ((n4 & 0x20) != 0) {
            list = pQIndexConfig.centroids;
        }
        return pQIndexConfig.copy(functionName, n, n2, n3, l, list);
    }

    @NotNull
    public String toString() {
        return "PQIndexConfig(distance=" + this.distance + ", sampleSize=" + this.sampleSize + ", numCentroids=" + this.numCentroids + ", numSubspaces=" + this.numSubspaces + ", seed=" + this.seed + ", centroids=" + this.centroids + ')';
    }

    public int hashCode() {
        int result = this.distance.hashCode();
        result = result * 31 + Integer.hashCode(this.sampleSize);
        result = result * 31 + Integer.hashCode(this.numCentroids);
        result = result * 31 + (this.numSubspaces == null ? 0 : ((Object)this.numSubspaces).hashCode());
        result = result * 31 + Long.hashCode(this.seed);
        result = result * 31 + ((Object)this.centroids).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PQIndexConfig)) {
            return false;
        }
        PQIndexConfig pQIndexConfig = (PQIndexConfig)other;
        if (!Intrinsics.areEqual((Object)this.distance, (Object)pQIndexConfig.distance)) {
            return false;
        }
        if (this.sampleSize != pQIndexConfig.sampleSize) {
            return false;
        }
        if (this.numCentroids != pQIndexConfig.numCentroids) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.numSubspaces, (Object)pQIndexConfig.numSubspaces)) {
            return false;
        }
        if (this.seed != pQIndexConfig.seed) {
            return false;
        }
        return Intrinsics.areEqual(this.centroids, pQIndexConfig.centroids);
    }

    static {
        Object[] objectArray = new Name.FunctionName[]{ManhattanDistance.Companion.getFUNCTION_NAME(), EuclideanDistance.Companion.getFUNCTION_NAME(), SquaredEuclideanDistance.Companion.getFUNCTION_NAME(), CosineDistance.Companion.getFUNCTION_NAME()};
        SUPPORTED_DISTANCES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig$Companion;", "", "()V", "KEY_DISTANCE", "", "KEY_NUM_CENTROIDS", "KEY_NUM_SUBSPACES", "KEY_SAMPLE_SIZE", "SUPPORTED_DISTANCES", "", "Lorg/vitrivr/cottontail/core/database/Name$FunctionName;", "getSUPPORTED_DISTANCES", "()Ljava/util/Set;", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<Name.FunctionName> getSUPPORTED_DISTANCES() {
            return SUPPORTED_DISTANCES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016\u00a8\u0006\r"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig$Binding;", "Ljetbrains/exodus/bindings/ComparableBinding;", "()V", "readObject", "", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "stream", "Ljava/io/ByteArrayInputStream;", "writeObject", "", "output", "Ljetbrains/exodus/util/LightOutputStream;", "object", "cottontaildb-dbms"})
    public static final class Binding
    extends ComparableBinding {
        @NotNull
        public static final Binding INSTANCE = new Binding();

        private Binding() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Comparable<PQIndexConfig> readObject(@NotNull ByteArrayInputStream stream) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            String string = StringBinding.BINDING.readObject(stream);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BINDING.readObject(stream)");
            Name.FunctionName distance = Name.FunctionName.Companion.create(string);
            int sampleSize = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            int numCentroids = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            int numSubspaces = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            long seed = LongBinding.readCompressed((ByteArrayInputStream)stream);
            int actualNumberOfCentroids = IntegerBinding.readCompressed((ByteArrayInputStream)stream);
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)actualNumberOfCentroids);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Snappy.uncompressDoubleArray((byte[])stream.readNBytes(IntegerBinding.readCompressed((ByteArrayInputStream)stream))));
            }
            List centroids = (List)destination$iv$iv;
            return new PQIndexConfig(distance, sampleSize, numCentroids, numSubspaces == -1 ? (Integer)null : Integer.valueOf(numSubspaces), seed, centroids);
        }

        public void writeObject(@NotNull LightOutputStream output, @NotNull Comparable<? super PQIndexConfig> object) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            Intrinsics.checkNotNullParameter(object, (String)"object");
            if (!(object instanceof PQIndexConfig)) {
                boolean $i$a$-require-PQIndexConfig$Binding$writeObject$22 = false;
                String $i$a$-require-PQIndexConfig$Binding$writeObject$22 = "PQIndexConfig.Binding can only be used to serialize instances of PQIndexConfig.";
                throw new IllegalArgumentException($i$a$-require-PQIndexConfig$Binding$writeObject$22.toString());
            }
            StringBinding.BINDING.writeObject(output, (Comparable)((Object)((PQIndexConfig)object).getDistance().getSimple()));
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((PQIndexConfig)object).getSampleSize());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((PQIndexConfig)object).getNumCentroids());
            Integer n = ((PQIndexConfig)object).getNumSubspaces();
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)(n != null ? n : -1));
            LongBinding.writeCompressed((LightOutputStream)output, (long)((PQIndexConfig)object).getSeed());
            IntegerBinding.writeCompressed((LightOutputStream)output, (int)((PQIndexConfig)object).getCentroids().size());
            for (double[] c : ((PQIndexConfig)object).getCentroids()) {
                byte[] compressed = Snappy.compress((double[])c);
                IntegerBinding.writeCompressed((LightOutputStream)output, (int)compressed.length);
                output.write(compressed);
            }
        }
    }
}

