/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.pq;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.jetbrains.annotations.NotNull;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.DoubleVectorValue;
import org.vitrivr.cottontail.core.values.FloatVectorValue;
import org.vitrivr.cottontail.core.values.IntVectorValue;
import org.vitrivr.cottontail.core.values.LongVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.index.pq.PQIndexConfig;
import org.vitrivr.cottontail.dbms.index.pq.PQLookupTable;
import org.vitrivr.cottontail.dbms.index.pq.PQSignature;
import org.vitrivr.cottontail.utilities.math.clustering.Cluster;
import org.vitrivr.cottontail.utilities.math.clustering.KMeansClusterer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\"\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\"\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0011\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u0082\u0002\u000f\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/ProductQuantizer;", "", "codebooks", "", "Lorg/vitrivr/cottontail/dbms/index/pq/ProductQuantizer$PQCodebook;", "([Lorg/vitrivr/cottontail/dbms/index/pq/ProductQuantizer$PQCodebook;)V", "[Lorg/vitrivr/cottontail/dbms/index/pq/ProductQuantizer$PQCodebook;", "numberOfSubspaces", "", "getNumberOfSubspaces", "()I", "centroids", "", "", "createLookupTable", "Lorg/vitrivr/cottontail/dbms/index/pq/PQLookupTable;", "query", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "createLookupTable-v6EEJP4", "(Lorg/vitrivr/cottontail/core/values/types/VectorValue;)[[D", "quantize", "Lorg/vitrivr/cottontail/dbms/index/pq/PQSignature;", "v", "quantize-WCB9L64", "(Lorg/vitrivr/cottontail/core/values/types/VectorValue;)[I", "Companion", "PQCodebook", "cottontaildb-dbms"})
public final class ProductQuantizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PQCodebook[] codebooks;

    private ProductQuantizer(PQCodebook[] codebooks) {
        this.codebooks = codebooks;
    }

    private final int getNumberOfSubspaces() {
        return this.codebooks.length;
    }

    @NotNull
    public final int[] quantize-WCB9L64(@NotNull VectorValue<?> v) {
        Intrinsics.checkNotNullParameter(v, (String)"v");
        int n = 0;
        int n2 = this.getNumberOfSubspaces();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            PQCodebook codebook = this.codebooks[n3];
            VectorValue subvector = v.slice(n3 * codebook.getSubspaceSize(), codebook.getSubspaceSize());
            nArray[n3] = codebook.quantize(subvector);
        }
        return PQSignature.constructor-impl(nArray);
    }

    @NotNull
    public final double[][] createLookupTable-v6EEJP4(@NotNull VectorValue<?> query2) {
        Intrinsics.checkNotNullParameter(query2, (String)"query");
        int n = this.getNumberOfSubspaces();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            PQCodebook codebook = this.codebooks[n2];
            VectorValue subspaceQuery = query2.slice(n2 * codebook.getSubspaceSize(), codebook.getSubspaceSize());
            int n3 = 0;
            int n4 = codebook.getNumberOfCentroids();
            double[] dArray = new double[n4];
            int n5 = n2;
            double[][] dArrayArray2 = dArrayArray;
            while (n3 < n4) {
                int n6 = n3++;
                Value[] valueArray = new Value[]{(Value)subspaceQuery, (Value)codebook.getCentroids()[n6]};
                Value value = codebook.getDistance().invoke(valueArray);
                Intrinsics.checkNotNull((Object)value);
                dArray[n6] = ((DoubleValue)value).unbox-impl();
            }
            dArrayArray2[n5] = dArray;
        }
        return PQLookupTable.constructor-impl(dArrayArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<double[]> centroids() {
        void $this$flatMapTo$iv$iv;
        PQCodebook[] $this$flatMap$iv = this.codebooks;
        boolean $i$f$flatMap = false;
        PQCodebook[] pQCodebookArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void $this$mapTo$iv$iv;
            void element$iv$iv;
            void cb = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            VectorValue<?>[] $this$map$iv = cb.getCentroids();
            boolean $i$f$map = false;
            VectorValue<?>[] vectorValueArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n2 = ((void)$this$mapTo$iv$iv).length;
            for (int j = 0; j < n2; ++j) {
                void v;
                void item$iv$iv;
                void var19_19 = item$iv$iv = $this$mapTo$iv$iv[j];
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                int n3 = 0;
                int n4 = v.getLogicalSize();
                double[] dArray = new double[n4];
                while (n3 < n4) {
                    int n5 = n3++;
                    dArray[n5] = v.get(n5).getValue().doubleValue();
                }
                collection.add(dArray);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public /* synthetic */ ProductQuantizer(PQCodebook[] codebooks, DefaultConstructorMarker $constructor_marker) {
        this(codebooks);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J,\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/ProductQuantizer$Companion;", "", "()V", "defaultNumberOfSubspaces", "", "d", "learnFromData", "Lorg/vitrivr/cottontail/dbms/index/pq/ProductQuantizer;", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "data", "", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "config", "Lorg/vitrivr/cottontail/dbms/index/pq/PQIndexConfig;", "loadFromConfig", "cottontaildb-dbms"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ProductQuantizer learnFromData(@NotNull VectorDistance<?> distance, @NotNull List<? extends VectorValue<?>> data, @NotNull PQIndexConfig config) {
            boolean bl;
            int dimensionsPerSubspace;
            int numSubspaces;
            int logicalSize;
            block9: {
                Intrinsics.checkNotNullParameter(distance, (String)"distance");
                Intrinsics.checkNotNullParameter(data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                logicalSize = distance.getType().getLogicalSize();
                Integer n = config.getNumSubspaces();
                numSubspaces = n != null ? n.intValue() : this.defaultNumberOfSubspaces(logicalSize);
                dimensionsPerSubspace = logicalSize / numSubspaces;
                Iterable $this$all$iv = data;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        VectorValue it = (VectorValue)element$iv;
                        boolean bl2 = false;
                        if (it.getLogicalSize() == logicalSize) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean $i$a$-require-ProductQuantizer$Companion$learnFromData$52 = false;
                String $i$a$-require-ProductQuantizer$Companion$learnFromData$52 = "Training of product quantizer not possible; dimensionality of training data and distance function don't match.";
                throw new IllegalArgumentException($i$a$-require-ProductQuantizer$Companion$learnFromData$52.toString());
            }
            if (!(logicalSize >= numSubspaces)) {
                boolean $i$a$-require-ProductQuantizer$Companion$learnFromData$62 = false;
                String $i$a$-require-ProductQuantizer$Companion$learnFromData$62 = "Training of product quantizer not possible; logical size of data must be greater or equal to number of subspaces.";
                throw new IllegalArgumentException($i$a$-require-ProductQuantizer$Companion$learnFromData$62.toString());
            }
            if (!(dimensionsPerSubspace * numSubspaces == logicalSize)) {
                boolean $i$a$-require-ProductQuantizer$Companion$learnFromData$72 = false;
                String $i$a$-require-ProductQuantizer$Companion$learnFromData$72 = "Training of product quantizer not possible; vector size of " + logicalSize + " does not allow for equally spaced subspaces.";
                throw new IllegalArgumentException($i$a$-require-ProductQuantizer$Companion$learnFromData$72.toString());
            }
            VectorDistance reshape = distance.copy(dimensionsPerSubspace);
            KMeansClusterer clusterer = new KMeansClusterer(config.getNumCentroids(), reshape, (RandomGenerator)new JDKRandomGenerator((int)config.getSeed()), 0, 8, null);
            PQCodebook[] pQCodebookArray = new PQCodebook[numSubspaces];
            for (int i = 0; i < numSubspaces; ++i) {
                VectorValue[] vectorValueArray;
                void $this$toTypedArray$iv;
                Collection<VectorValue<?>> collection;
                Cluster v;
                Collection<VectorValue> collection2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                int n = i;
                Iterable iterable = data;
                int n2 = n;
                PQCodebook[] pQCodebookArray2 = pQCodebookArray;
                boolean $i$f$map = false;
                void var16_21 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    VectorValue vectorValue = (VectorValue)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(v.slice(n * dimensionsPerSubspace, dimensionsPerSubspace));
                }
                collection2 = (List)destination$iv$iv;
                List subspaceData = collection2;
                $this$map$iv = clusterer.cluster(subspaceData);
                VectorDistance vectorDistance = reshape;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    v = (Cluster)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it.getCenter());
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = collection;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                Intrinsics.checkNotNull((Object)thisCollection$iv.toArray(new VectorValue[0]), (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                VectorDistance vectorDistance2 = vectorDistance;
                pQCodebookArray2[n2] = new PQCodebook(vectorDistance2, vectorValueArray);
            }
            PQCodebook[] codebooks = pQCodebookArray;
            return new ProductQuantizer(codebooks, null);
        }

        @NotNull
        public final ProductQuantizer loadFromConfig(@NotNull VectorDistance<?> distance, @NotNull PQIndexConfig config) {
            Intrinsics.checkNotNullParameter(distance, (String)"distance");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            int logicalSize = distance.getType().getLogicalSize();
            Integer n = config.getNumSubspaces();
            int numSubspaces = n != null ? n.intValue() : this.defaultNumberOfSubspaces(logicalSize);
            int dimensionsPerSubspace = logicalSize / numSubspaces;
            VectorDistance reshaped = distance.copy(dimensionsPerSubspace);
            PQCodebook[] pQCodebookArray = new PQCodebook[numSubspaces];
            for (int i = 0; i < numSubspaces; ++i) {
                int n2 = i;
                int n3 = config.getNumCentroids();
                VectorValue[] vectorValueArray = new VectorValue[n3];
                VectorDistance vectorDistance = reshaped;
                int n4 = n2;
                PQCodebook[] pQCodebookArray2 = pQCodebookArray;
                for (int j = 0; j < n3; ++j) {
                    DoubleVectorValue doubleVectorValue;
                    int n5 = j;
                    Types.Vector vector = distance.getType();
                    if (vector instanceof Types.DoubleVector) {
                        doubleVectorValue = DoubleVectorValue.box-impl((double[])DoubleVectorValue.constructor-impl((double[])config.getCentroids().get(n2 * config.getNumCentroids() + n5)));
                    } else if (vector instanceof Types.FloatVector) {
                        doubleVectorValue = FloatVectorValue.box-impl((float[])FloatVectorValue.constructor-impl((double[])config.getCentroids().get(n2 * config.getNumCentroids() + n5)));
                    } else if (vector instanceof Types.LongVector) {
                        doubleVectorValue = LongVectorValue.box-impl((long[])LongVectorValue.constructor-impl((List)ArraysKt.toList((double[])config.getCentroids().get(n2 * config.getNumCentroids() + n5))));
                    } else if (vector instanceof Types.IntVector) {
                        doubleVectorValue = IntVectorValue.box-impl((int[])IntVectorValue.constructor-impl((List)ArraysKt.toList((double[])config.getCentroids().get(n2 * config.getNumCentroids() + n5))));
                    } else {
                        throw new IllegalArgumentException("Reconstruction of product quantizer not possible; type " + distance.getType() + " not supported.");
                    }
                    vectorValueArray[n5] = (VectorValue)doubleVectorValue;
                }
                VectorValue[] vectorValueArray2 = vectorValueArray;
                VectorDistance vectorDistance2 = vectorDistance;
                pQCodebookArray2[n4] = new PQCodebook(vectorDistance2, vectorValueArray2);
            }
            PQCodebook[] codebooks = pQCodebookArray;
            return new ProductQuantizer(codebooks, null);
        }

        public final int defaultNumberOfSubspaces(int d) {
            int subspaces;
            int maximum = d <= 8 ? 2 : (d <= 64 ? 8 : (d <= 256 ? 16 : (d <= 1024 ? 32 : (d <= 4096 ? 64 : 128))));
            int candidate = subspaces = 1;
            while (subspaces < maximum && subspaces < 127) {
                if (d % subspaces == 0) {
                    candidate = subspaces;
                }
                ++subspaces;
            }
            return candidate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0010\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0013\u001a\u00020\u000e2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0006R\u001d\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/vitrivr/cottontail/dbms/index/pq/ProductQuantizer$PQCodebook;", "", "distance", "Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "centroids", "", "Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "(Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;[Lorg/vitrivr/cottontail/core/values/types/VectorValue;)V", "getCentroids", "()[Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "[Lorg/vitrivr/cottontail/core/values/types/VectorValue;", "getDistance", "()Lorg/vitrivr/cottontail/core/queries/functions/math/distance/binary/VectorDistance;", "numberOfCentroids", "", "getNumberOfCentroids", "()I", "subspaceSize", "getSubspaceSize", "quantize", "subvector", "cottontaildb-dbms"})
    private static final class PQCodebook {
        @NotNull
        private final VectorDistance<?> distance;
        @NotNull
        private final VectorValue<?>[] centroids;

        public PQCodebook(@NotNull VectorDistance<?> distance, @NotNull VectorValue<?>[] centroids) {
            boolean bl;
            block2: {
                Intrinsics.checkNotNullParameter(distance, (String)"distance");
                Intrinsics.checkNotNullParameter(centroids, (String)"centroids");
                this.distance = distance;
                this.centroids = centroids;
                VectorValue<?>[] $this$all$iv = this.centroids;
                boolean $i$f$all = false;
                int n = $this$all$iv.length;
                for (int i = 0; i < n; ++i) {
                    VectorValue<?> element$iv;
                    VectorValue<?> it = element$iv = $this$all$iv[i];
                    boolean bl2 = false;
                    if (it.getLogicalSize() == this.distance.getType().getLogicalSize()) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            if (!bl) {
                boolean bl3 = false;
                String string = "Dimensionality of centroids and distance function do not match for PQ codebook.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final VectorDistance<?> getDistance() {
            return this.distance;
        }

        @NotNull
        public final VectorValue<?>[] getCentroids() {
            return this.centroids;
        }

        public final int getSubspaceSize() {
            return this.centroids[0].getLogicalSize();
        }

        public final int getNumberOfCentroids() {
            return this.centroids.length;
        }

        public final int quantize(@NotNull VectorValue<?> subvector) {
            Intrinsics.checkNotNullParameter(subvector, (String)"subvector");
            int mahIndex = 0;
            double mah = Double.POSITIVE_INFINITY;
            VectorValue<?>[] vectorValueArray = this.centroids;
            int n = vectorValueArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = i;
                VectorValue<?> c = vectorValueArray[i];
                Value[] valueArray = new Value[]{(Value)c, (Value)subvector};
                Value value = this.distance.invoke(valueArray);
                Intrinsics.checkNotNull((Object)value);
                double dist = ((DoubleValue)value).unbox-impl();
                if (!(dist < mah)) continue;
                mah = dist;
                mahIndex = i2;
            }
            return mahIndex;
        }
    }
}

