/*
 * Decompiled with CFR 0.152.
 */
package org.vitrivr.cottontail.dbms.index.va;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vitrivr.cottontail.core.basics.Cursor;
import org.vitrivr.cottontail.core.basics.Record;
import org.vitrivr.cottontail.core.database.ColumnDef;
import org.vitrivr.cottontail.core.database.Name;
import org.vitrivr.cottontail.core.queries.functions.FunctionGenerator;
import org.vitrivr.cottontail.core.queries.functions.Signature;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.EuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.ManhattanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.MinkowskiDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.SquaredEuclideanDistance;
import org.vitrivr.cottontail.core.queries.functions.math.distance.binary.VectorDistance;
import org.vitrivr.cottontail.core.queries.planning.cost.Cost;
import org.vitrivr.cottontail.core.queries.predicates.Predicate;
import org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate;
import org.vitrivr.cottontail.core.queries.sort.SortOrder;
import org.vitrivr.cottontail.core.recordset.StandaloneRecord;
import org.vitrivr.cottontail.core.values.DoubleValue;
import org.vitrivr.cottontail.core.values.types.RealVectorValue;
import org.vitrivr.cottontail.core.values.types.Types;
import org.vitrivr.cottontail.core.values.types.Value;
import org.vitrivr.cottontail.core.values.types.VectorValue;
import org.vitrivr.cottontail.dbms.catalogue.ExtensionsKt;
import org.vitrivr.cottontail.dbms.column.ColumnTx;
import org.vitrivr.cottontail.dbms.entity.DefaultEntity;
import org.vitrivr.cottontail.dbms.entity.EntityTx;
import org.vitrivr.cottontail.dbms.exceptions.DatabaseException;
import org.vitrivr.cottontail.dbms.execution.operators.sort.RecordComparator;
import org.vitrivr.cottontail.dbms.execution.transactions.TransactionContext;
import org.vitrivr.cottontail.dbms.index.AbstractHDIndex;
import org.vitrivr.cottontail.dbms.index.AbstractIndex;
import org.vitrivr.cottontail.dbms.index.IndexConfig;
import org.vitrivr.cottontail.dbms.index.IndexDescriptor;
import org.vitrivr.cottontail.dbms.index.IndexState;
import org.vitrivr.cottontail.dbms.index.IndexTx;
import org.vitrivr.cottontail.dbms.index.IndexType;
import org.vitrivr.cottontail.dbms.index.va.VAFIndexConfig;
import org.vitrivr.cottontail.dbms.index.va.bounds.Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L1Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L2Bounds;
import org.vitrivr.cottontail.dbms.index.va.bounds.L2SBounds;
import org.vitrivr.cottontail.dbms.index.va.signature.VAFMarks;
import org.vitrivr.cottontail.dbms.index.va.signature.VAFSignature;
import org.vitrivr.cottontail.dbms.operations.Operation;
import org.vitrivr.cottontail.dbms.statistics.columns.DoubleVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.FloatVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.IntVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.LongVectorValueStatistics;
import org.vitrivr.cottontail.dbms.statistics.columns.ValueStatistics;
import org.vitrivr.cottontail.utilities.selection.HeapSelection;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "parent", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "(Lorg/vitrivr/cottontail/core/database/Name$IndexName;Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;)V", "supportsIncrementalUpdate", "", "getSupportsIncrementalUpdate", "()Z", "supportsPartitioning", "getSupportsPartitioning", "type", "Lorg/vitrivr/cottontail/dbms/index/IndexType;", "getType", "()Lorg/vitrivr/cottontail/dbms/index/IndexType;", "close", "", "newTx", "Lorg/vitrivr/cottontail/dbms/index/IndexTx;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "Companion", "Tx", "cottontaildb-dbms"})
public final class VAFIndex
extends AbstractHDIndex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIncrementalUpdate;
    private final boolean supportsPartitioning;
    @NotNull
    private static final Logger LOGGER;

    public VAFIndex(@NotNull Name.IndexName name, @NotNull DefaultEntity parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(name, parent);
        this.supportsPartitioning = true;
    }

    @Override
    @NotNull
    public IndexType getType() {
        return IndexType.VAF;
    }

    @Override
    public boolean getSupportsIncrementalUpdate() {
        return this.supportsIncrementalUpdate;
    }

    @Override
    public boolean getSupportsPartitioning() {
        return this.supportsPartitioning;
    }

    @Override
    @NotNull
    public IndexTx newTx(@NotNull TransactionContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return new Tx(context2);
    }

    @Override
    public void close() {
    }

    static {
        Logger logger = LoggerFactory.getLogger(VAFIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(VAFIndex::class.java)");
        LOGGER = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Companion;", "Lorg/vitrivr/cottontail/dbms/index/IndexDescriptor;", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;", "()V", "LOGGER", "Lorg/slf4j/Logger;", "buildConfig", "Lorg/vitrivr/cottontail/dbms/index/IndexConfig;", "parameters", "", "", "configBinding", "Ljetbrains/exodus/bindings/ComparableBinding;", "deinitialize", "", "name", "Lorg/vitrivr/cottontail/core/database/Name$IndexName;", "entity", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity$Tx;", "Lorg/vitrivr/cottontail/dbms/entity/DefaultEntity;", "initialize", "open", "cottontaildb-dbms"})
    public static final class Companion
    implements IndexDescriptor<VAFIndex> {
        private Companion() {
        }

        @Override
        @NotNull
        public VAFIndex open(@NotNull Name.IndexName name, @NotNull DefaultEntity entity) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            return new VAFIndex(name, entity);
        }

        @Override
        public boolean initialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                Store store = entity.getDbo().getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(name), StoreConfig.WITHOUT_DUPLICATES, entity.getContext().getXodusTx(), true);
                bl = store != null;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to initialize VAF index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        public boolean deinitialize(@NotNull Name.IndexName name, @NotNull DefaultEntity.Tx entity) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            try {
                entity.getDbo().getCatalogue().getEnvironment$cottontaildb_dbms().removeStore(ExtensionsKt.storeName(name), entity.getContext().getXodusTx());
                bl = true;
            }
            catch (Throwable e) {
                LOGGER.error("Failed to de-initialize VAF index " + name + " due to an exception: " + e.getMessage() + '.');
                bl = false;
            }
            return bl;
        }

        @Override
        @NotNull
        public IndexConfig<VAFIndex> buildConfig(@NotNull Map<String, String> parameters) {
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Object object = parameters.get("marks_per_dimension");
            return new VAFIndexConfig(object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 10, null, 2, null);
        }

        @Override
        @NotNull
        public ComparableBinding configBinding() {
            return VAFIndexConfig.Binding.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00f8\u0001\u0002\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\b\u0010 \u001a\u00020!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0016H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020,H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020-H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001f\u0010\f\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006."}, d2={"Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex$Tx;", "Lorg/vitrivr/cottontail/dbms/index/AbstractHDIndex;", "context", "Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;", "(Lorg/vitrivr/cottontail/dbms/index/va/VAFIndex;Lorg/vitrivr/cottontail/dbms/execution/transactions/TransactionContext;)V", "config", "Lorg/vitrivr/cottontail/dbms/index/va/VAFIndexConfig;", "getConfig", "()Lorg/vitrivr/cottontail/dbms/index/va/VAFIndexConfig;", "dataStore", "Ljetbrains/exodus/env/Store;", "marks", "Lorg/vitrivr/cottontail/dbms/index/va/signature/VAFMarks;", "getMarks-Ay1-6BM", "()[[D", "supportedDistances", "", "Lorg/vitrivr/cottontail/core/queries/functions/Signature$Closed;", "getSupportedDistances", "()Ljava/util/Set;", "clear", "", "columnsFor", "", "Lorg/vitrivr/cottontail/core/database/ColumnDef;", "predicate", "Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;", "costFor", "Lorg/vitrivr/cottontail/core/queries/planning/cost/Cost;", "costFor-7eHliGg", "(Lorg/vitrivr/cottontail/core/queries/predicates/Predicate;)[F", "count", "", "filter", "Lorg/vitrivr/cottontail/core/basics/Cursor;", "Lorg/vitrivr/cottontail/core/basics/Record;", "partition", "Lkotlin/ranges/LongRange;", "rebuild", "tryApply", "", "operation", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$DeleteOperation;", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$InsertOperation;", "Lorg/vitrivr/cottontail/dbms/operations/Operation$DataManagementOperation$UpdateOperation;", "cottontaildb-dbms"})
    private final class Tx
    extends AbstractHDIndex.Tx {
        @NotNull
        private final Set<Signature.Closed<?>> supportedDistances;
        @NotNull
        private Store dataStore;

        /*
         * WARNING - void declaration
         */
        public Tx(TransactionContext context2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(VAFIndex.this, context2);
            FunctionGenerator[] functionGeneratorArray = new FunctionGenerator[]{(FunctionGenerator)ManhattanDistance.Companion, (FunctionGenerator)EuclideanDistance.Companion, (FunctionGenerator)SquaredEuclideanDistance.Companion};
            functionGeneratorArray = CollectionsKt.listOf((Object[])functionGeneratorArray);
            Tx tx = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FunctionGenerator functionGenerator = (FunctionGenerator)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Types[] typesArray = new Types[]{this.getColumn().getType(), this.getColumn().getType()};
                collection.add(new Signature.Closed(it.getSignature().getName(), typesArray, (Types)Types.Double.INSTANCE));
            }
            tx.supportedDistances = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            functionGeneratorArray = VAFIndex.this.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(VAFIndex.this.getName()), StoreConfig.USE_EXISTING, this.getContext().getXodusTx(), false);
            if (functionGeneratorArray == null) {
                throw new DatabaseException.DataCorruptionException("Data store for index " + VAFIndex.this.getName() + " is missing.");
            }
            this.dataStore = functionGeneratorArray;
        }

        @NotNull
        public VAFIndexConfig getConfig() {
            IndexConfig<?> indexConfig = super.getConfig();
            Intrinsics.checkNotNull(indexConfig, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.index.va.VAFIndexConfig");
            return (VAFIndexConfig)indexConfig;
        }

        @Override
        @NotNull
        protected Set<Signature.Closed<?>> getSupportedDistances() {
            return this.supportedDistances;
        }

        private final double[][] getMarks-Ay1-6BM() {
            return this.getConfig().getMarks-Ay1-6BM();
        }

        @Override
        @NotNull
        public float[] costFor-7eHliGg(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate)) {
                return Cost.Companion.getINVALID-7CRCzCo();
            }
            if (!Intrinsics.areEqual((Object)((ProximityPredicate)predicate).getColumn(), this.getColumns()[0])) {
                return Cost.Companion.getINVALID-7CRCzCo();
            }
            if (!(((ProximityPredicate)predicate).getDistance() instanceof MinkowskiDistance)) {
                return Cost.Companion.getINVALID-7CRCzCo();
            }
            return Cost.times-7eHliGg((float[])Cost.plus-wQ19W7k((float[])Cost.plus-wQ19W7k((float[])Cost.times-7eHliGg((float[])Cost.Companion.getDISK_ACCESS_READ-7CRCzCo(), (Number)Float.valueOf(0.9f + 0.1f * (float)this.getColumns()[0].getType().getPhysicalSize())), (float[])Cost.times-7eHliGg((float[])Cost.plus-wQ19W7k((float[])Cost.times-7eHliGg((float[])Cost.Companion.getMEMORY_ACCESS-7CRCzCo(), (Number)Float.valueOf(2.0f)), (float[])Cost.Companion.getFLOP-7CRCzCo()), (Number)Float.valueOf(0.9f))), (float[])Cost.times-7eHliGg((float[])predicate.getCost-7CRCzCo(), (Number)Float.valueOf(0.1f))), (Number)this.count());
        }

        @Override
        @NotNull
        public List<ColumnDef<?>> columnsFor(@NotNull Predicate predicate) {
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            if (!(predicate instanceof ProximityPredicate)) {
                boolean bl = false;
                String string = "VAFIndex can only process proximity predicates.";
                throw new IllegalArgumentException(string.toString());
            }
            Object[] objectArray = new ColumnDef[]{((ProximityPredicate)predicate).getDistanceColumn(), this.getColumn()};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rebuild() {
            Lock lock2 = this.getTxLatch();
            VAFIndex vAFIndex = VAFIndex.this;
            lock2.lock();
            try {
                Pair pair;
                double[] dArray;
                int n;
                double[] dArray2;
                int n2;
                boolean bl = false;
                LOGGER.debug("Rebuilding VAF index {}", (Object)vAFIndex.getName());
                VAFIndexConfig config = this.getConfig();
                ColumnDef<?> indexedColumn = this.getColumns()[0];
                int dimension = indexedColumn.getType().getLogicalSize();
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(vAFIndex.getParent());
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx entityTx = (EntityTx)tx;
                org.vitrivr.cottontail.dbms.general.Tx tx2 = this.getContext().getTx(entityTx.columnForName(this.getColumns()[0].getName()));
                Intrinsics.checkNotNull((Object)tx2, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.column.ColumnTx<*>");
                ColumnTx columnTx = (ColumnTx)tx2;
                ValueStatistics stat = columnTx.statistics();
                if (stat instanceof FloatVectorValueStatistics) {
                    n2 = 0;
                    dArray2 = new double[dimension];
                    while (n2 < dimension) {
                        n = n2++;
                        dArray2[n] = ((FloatVectorValueStatistics)stat).getMin-JdBqzJc()[n];
                    }
                    double[] dArray3 = dArray2;
                    n2 = 0;
                    dArray2 = new double[dimension];
                    dArray = dArray3;
                    while (n2 < dimension) {
                        n = n2++;
                        dArray2[n] = ((FloatVectorValueStatistics)stat).getMax-JdBqzJc()[n];
                    }
                    pair = TuplesKt.to((Object)dArray, (Object)dArray2);
                } else if (stat instanceof DoubleVectorValueStatistics) {
                    n2 = 0;
                    dArray2 = new double[dimension];
                    while (n2 < dimension) {
                        n = n2++;
                        dArray2[n] = ((DoubleVectorValueStatistics)stat).getMin-aM0kQ94()[n];
                    }
                    double[] dArray4 = dArray2;
                    n2 = 0;
                    dArray2 = new double[dimension];
                    dArray = dArray4;
                    while (n2 < dimension) {
                        n = n2++;
                        dArray2[n] = ((DoubleVectorValueStatistics)stat).getMax-aM0kQ94()[n];
                    }
                    pair = TuplesKt.to((Object)dArray, (Object)dArray2);
                } else if (stat instanceof IntVectorValueStatistics) {
                    n2 = 0;
                    dArray2 = new double[dimension];
                    while (n2 < dimension) {
                        n = n2++;
                        dArray2[n] = ((IntVectorValueStatistics)stat).getMin-NP4WLaU()[n];
                    }
                    double[] dArray5 = dArray2;
                    n2 = 0;
                    dArray2 = new double[dimension];
                    dArray = dArray5;
                    while (n2 < dimension) {
                        n = n2++;
                        dArray2[n] = ((IntVectorValueStatistics)stat).getMax-NP4WLaU()[n];
                    }
                    pair = TuplesKt.to((Object)dArray, (Object)dArray2);
                } else if (stat instanceof LongVectorValueStatistics) {
                    n2 = 0;
                    dArray2 = new double[dimension];
                    while (n2 < dimension) {
                        n = n2++;
                        dArray2[n] = ((LongVectorValueStatistics)stat).getMin-KCB4rAk()[n];
                    }
                    double[] dArray6 = dArray2;
                    n2 = 0;
                    dArray2 = new double[dimension];
                    dArray = dArray6;
                    while (n2 < dimension) {
                        n = n2++;
                        dArray2[n] = ((LongVectorValueStatistics)stat).getMax-KCB4rAk()[n];
                    }
                    pair = TuplesKt.to((Object)dArray, (Object)dArray2);
                } else {
                    throw new DatabaseException("Column type not supported for VAF index.", null, 2, null);
                }
                Pair pair2 = pair;
                double[] minimum = (double[])pair2.component1();
                double[] maximum = (double[])pair2.component2();
                double[][] newMarks = VAFMarks.Companion.getEquidistantMarks-7LLru9A(minimum, maximum, config.getMarksPerDimension());
                this.clear();
                ColumnDef[] columnDefArray = new ColumnDef[]{indexedColumn};
                org.vitrivr.cottontail.core.basics.Cursor cursor2 = entityTx.cursor(columnDefArray);
                Iterator $this$forEach$iv = (Iterator)cursor2;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv;
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    Record r = (Record)element$iv;
                    boolean bl2 = false;
                    Value value = r.get(0);
                    if (!(value instanceof RealVectorValue)) continue;
                    this.dataStore.put(this.getContext().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(r.getTupleId()), VAFSignature.Binding.INSTANCE.valueToEntry-s1HmYNQ(VAFMarks.getSignature-lsqBzE4(newMarks, (RealVectorValue)value)));
                }
                cursor2.close();
                this.updateState(IndexState.CLEAN, VAFIndexConfig.copy-Drwwnpc$default(config, 0, newMarks, 1, null));
                LOGGER.debug("Rebuilding VAF index {} completed!", (Object)vAFIndex.getName());
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long count() {
            long l;
            Lock lock2 = this.getTxLatch();
            lock2.lock();
            try {
                boolean bl = false;
                l = this.dataStore.count(this.getContext().getXodusTx());
            }
            finally {
                lock2.unlock();
            }
            return l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Lock lock2 = this.getTxLatch();
            VAFIndex vAFIndex = VAFIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                vAFIndex.getCatalogue().getEnvironment$cottontaildb_dbms().truncateStore(ExtensionsKt.storeName(vAFIndex.getName()), this.getContext().getXodusTx());
                Store store = vAFIndex.getCatalogue().getEnvironment$cottontaildb_dbms().openStore(ExtensionsKt.storeName(vAFIndex.getName()), StoreConfig.USE_EXISTING, this.getContext().getXodusTx(), false);
                if (store == null) {
                    throw new DatabaseException.DataCorruptionException("Data store for index " + vAFIndex.getName() + " is missing.");
                }
                this.dataStore = store;
                AbstractIndex.Tx.updateState$default(this, IndexState.STALE, null, 2, null);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock2.unlock();
            }
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.InsertOperation operation) {
            Value value;
            block5: {
                int n;
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                value = operation.getInserts().get(this.getColumn());
                if (!(value instanceof RealVectorValue)) {
                    boolean $i$a$-require-VAFIndex$Tx$tryApply$22 = false;
                    String $i$a$-require-VAFIndex$Tx$tryApply$22 = "Only real vector values can be stored in a VAFIndex. This is a programmer's error!";
                    throw new IllegalArgumentException($i$a$-require-VAFIndex$Tx$tryApply$22.toString());
                }
                IntRange intRange = ((RealVectorValue)value).getIndices();
                int i = intRange.getFirst();
                if (i > (n = intRange.getLast())) break block5;
                while (true) {
                    block7: {
                        block6: {
                            double d = ((RealVectorValue)value).get(i).getValue().doubleValue();
                            double[][] dArray = this.getMarks-Ay1-6BM();
                            Intrinsics.checkNotNull((Object)dArray);
                            if (d < VAFMarks.getMinimum-impl(dArray)[i]) break block6;
                            double d2 = ((RealVectorValue)value).get(i).getValue().doubleValue();
                            double[][] dArray2 = this.getMarks-Ay1-6BM();
                            Intrinsics.checkNotNull((Object)dArray2);
                            if (!(d2 > VAFMarks.getMaximum-impl(dArray2)[i])) break block7;
                        }
                        this.dataStore.put(this.getContext().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(operation.getTupleId()), VAFSignature.Binding.INSTANCE.valueToEntry-s1HmYNQ(VAFSignature.Companion.invalid-lsqBzE4(((RealVectorValue)value).getLogicalSize())));
                        return false;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            Transaction transaction = this.getContext().getXodusTx();
            ByteIterable byteIterable = (ByteIterable)ExtensionsKt.toKey(operation.getTupleId());
            double[][] dArray = this.getMarks-Ay1-6BM();
            Intrinsics.checkNotNull((Object)dArray);
            return this.dataStore.add(transaction, byteIterable, VAFSignature.Binding.INSTANCE.valueToEntry-s1HmYNQ(VAFMarks.getSignature-lsqBzE4(dArray, (RealVectorValue)value)));
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.UpdateOperation operation) {
            Value value;
            block5: {
                int n;
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                Pair<Value, Value> pair = operation.getUpdates().get(this.getColumn());
                Object object = value = pair != null ? (Value)pair.getSecond() : null;
                if (!(value instanceof RealVectorValue)) {
                    boolean $i$a$-require-VAFIndex$Tx$tryApply$32 = false;
                    String $i$a$-require-VAFIndex$Tx$tryApply$32 = "Only real vector values can be stored in a VAFIndex. This is a programmer's error!";
                    throw new IllegalArgumentException($i$a$-require-VAFIndex$Tx$tryApply$32.toString());
                }
                IntRange intRange = ((RealVectorValue)value).getIndices();
                int i = intRange.getFirst();
                if (i > (n = intRange.getLast())) break block5;
                while (true) {
                    block7: {
                        block6: {
                            double d = ((RealVectorValue)value).get(i).getValue().doubleValue();
                            double[][] dArray = this.getMarks-Ay1-6BM();
                            Intrinsics.checkNotNull((Object)dArray);
                            if (d < VAFMarks.getMinimum-impl(dArray)[i]) break block6;
                            double d2 = ((RealVectorValue)value).get(i).getValue().doubleValue();
                            double[][] dArray2 = this.getMarks-Ay1-6BM();
                            Intrinsics.checkNotNull((Object)dArray2);
                            if (!(d2 > VAFMarks.getMaximum-impl(dArray2)[i])) break block7;
                        }
                        this.dataStore.put(this.getContext().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(operation.getTupleId()), VAFSignature.Binding.INSTANCE.valueToEntry-s1HmYNQ(VAFSignature.Companion.invalid-lsqBzE4(((RealVectorValue)value).getLogicalSize())));
                        return false;
                    }
                    if (i == n) break;
                    ++i;
                }
            }
            Transaction transaction = this.getContext().getXodusTx();
            ByteIterable byteIterable = (ByteIterable)ExtensionsKt.toKey(operation.getTupleId());
            double[][] dArray = this.getMarks-Ay1-6BM();
            Intrinsics.checkNotNull((Object)dArray);
            return this.dataStore.put(transaction, byteIterable, VAFSignature.Binding.INSTANCE.valueToEntry-s1HmYNQ(VAFMarks.getSignature-lsqBzE4(dArray, (RealVectorValue)value)));
        }

        @Override
        public boolean tryApply(@NotNull Operation.DataManagementOperation.DeleteOperation operation) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            return this.dataStore.delete(this.getContext().getXodusTx(), (ByteIterable)ExtensionsKt.toKey(operation.getTupleId()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Record> filter(@NotNull Predicate predicate) {
            org.vitrivr.cottontail.core.basics.Cursor<Record> cursor2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Lock lock2 = this.getTxLatch();
            VAFIndex vAFIndex = VAFIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                org.vitrivr.cottontail.dbms.general.Tx tx = this.getContext().getTx(vAFIndex.getParent());
                Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                EntityTx entityTx = (EntityTx)tx;
                cursor2 = this.filter(predicate, new LongRange(entityTx.smallestTupleId(), entityTx.largestTupleId()));
            }
            finally {
                lock2.unlock();
            }
            return cursor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public org.vitrivr.cottontail.core.basics.Cursor<Record> filter(@NotNull Predicate predicate, @NotNull LongRange partition) {
            org.vitrivr.cottontail.core.basics.Cursor<Record> cursor2;
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
            Lock lock2 = this.getTxLatch();
            VAFIndex vAFIndex = VAFIndex.this;
            lock2.lock();
            try {
                boolean bl = false;
                cursor2 = new org.vitrivr.cottontail.core.basics.Cursor<Record>(predicate, this, vAFIndex, partition){
                    @NotNull
                    private final ProximityPredicate predicate;
                    @NotNull
                    private final RealVectorValue<?> query;
                    @NotNull
                    private final Bounds bounds;
                    @NotNull
                    private final EntityTx entityTx;
                    @NotNull
                    private HeapSelection<Record> selection;
                    @NotNull
                    private final double[][] marks;
                    private long position;
                    final /* synthetic */ Predicate $predicate;
                    final /* synthetic */ Tx this$0;
                    final /* synthetic */ LongRange $partition;
                    {
                        Bounds bounds;
                        HeapSelection<T> heapSelection;
                        this.$predicate = $predicate;
                        this.this$0 = $receiver;
                        this.$partition = $partition;
                        Intrinsics.checkNotNull((Object)$predicate, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.queries.predicates.ProximityPredicate");
                        this.predicate = (ProximityPredicate)$predicate;
                        org.vitrivr.cottontail.dbms.general.Tx tx = $receiver.getContext().getTx($receiver2.getParent());
                        Intrinsics.checkNotNull((Object)tx, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.dbms.entity.EntityTx");
                        this.entityTx = (EntityTx)tx;
                        ProximityPredicate proximityPredicate = this.predicate;
                        if (proximityPredicate instanceof ProximityPredicate.NNS) {
                            heapSelection = new HeapSelection<T>(this.predicate.getK(), new RecordComparator.SingleNonNullColumnComparator(this.predicate.getDistanceColumn(), SortOrder.ASCENDING));
                        } else if (proximityPredicate instanceof ProximityPredicate.FNS) {
                            heapSelection = new HeapSelection<T>(this.predicate.getK(), new RecordComparator.SingleNonNullColumnComparator(this.predicate.getDistanceColumn(), SortOrder.ASCENDING));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        this.selection = heapSelection;
                        double[][] dArray = Tx.access$getMarks-Ay1-6BM($receiver);
                        if (dArray == null) {
                            throw new IllegalStateException("VAFMarks could not be obtained. This is a programmer's error!");
                        }
                        this.marks = dArray;
                        this.position = -1L;
                        Value value = this.predicate.getQuery().getValue();
                        if (!(value instanceof RealVectorValue)) {
                            boolean bl = false;
                            Value value2 = value;
                            String string = "Bound value for query vector has wrong type (found = " + (value2 != null ? value2.getType() : null) + ").";
                            throw new IllegalStateException(string.toString());
                        }
                        this.query = (RealVectorValue)value;
                        VectorDistance vectorDistance = this.predicate.getDistance();
                        if (vectorDistance instanceof ManhattanDistance) {
                            bounds = new L1Bounds(this.query, this.marks, null);
                        } else if (vectorDistance instanceof EuclideanDistance) {
                            bounds = new L2Bounds(this.query, this.marks, null);
                        } else if (vectorDistance instanceof SquaredEuclideanDistance) {
                            bounds = new L2SBounds(this.query, this.marks, null);
                        } else {
                            throw new IllegalArgumentException("The " + this.predicate.getDistance() + " distance kernel is not supported by VAFIndex.");
                        }
                        this.bounds = bounds;
                    }

                    public boolean moveNext() {
                        if (this.selection.getAdded() == 0L) {
                            this.prepare();
                        }
                        ++this.position;
                        return this.position < this.selection.getSize();
                    }

                    public long key() {
                        return this.selection.get(this.position).getTupleId();
                    }

                    @NotNull
                    public Record value() {
                        return this.selection.get(this.position);
                    }

                    public void close() {
                    }

                    private final void prepare() {
                        Transaction subTx = this.this$0.getContext().getXodusTx().getReadonlySnapshot();
                        Cursor cursor2 = Tx.access$getDataStore$p(this.this$0).openCursor(subTx);
                        cursor2.getSearchKey((ByteIterable)ExtensionsKt.toKey(this.$partition.getFirst()));
                        ColumnDef<?>[] columns = this.this$0.getColumns();
                        Collection $this$toTypedArray$iv = this.this$0.columnsFor(this.$predicate);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        ColumnDef[] columnDefArray = thisCollection$iv.toArray(new ColumnDef[0]);
                        Intrinsics.checkNotNull((Object)columnDefArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        ColumnDef[] produces = columnDefArray;
                        long tupleId = 0L;
                        double threshold = Double.MAX_VALUE;
                        while (cursor2.getNext() && (tupleId = LongBinding.compressedEntryToLong((ByteIterable)cursor2.getKey())) <= this.$partition.getLast()) {
                            double d;
                            ByteIterable byteIterable = cursor2.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"cursor.value");
                            byte[] signature = VAFSignature.Binding.INSTANCE.entryToValue-lsqBzE4(byteIterable);
                            if (this.selection.getAdded() >= this.predicate.getK() && !this.bounds.isVASSACandidate-tU6kMXU(signature, threshold)) continue;
                            Value value = this.entityTx.read(tupleId, columns).get(0);
                            Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type org.vitrivr.cottontail.core.values.types.VectorValue<*>");
                            VectorValue value2 = (VectorValue)value;
                            Value[] valueArray = new Value[]{(Value)this.query, (Value)value2};
                            Value value3 = this.predicate.getDistance().invoke(valueArray);
                            Intrinsics.checkNotNull((Object)value3);
                            double distance = ((DoubleValue)value3).unbox-impl();
                            valueArray = this.predicate;
                            if (valueArray instanceof ProximityPredicate.NNS) {
                                d = Math.min(threshold, distance);
                            } else if (valueArray instanceof ProximityPredicate.FNS) {
                                d = Math.max(threshold, distance);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            threshold = d;
                            valueArray = new Value[]{DoubleValue.box-impl((double)distance), (Value)value2};
                            this.selection.offer((Record)new StandaloneRecord(tupleId, produces, valueArray));
                        }
                        VAFIndex.access$getLOGGER$cp().debug("VAF scan: Read " + this.selection.getAdded() + " and skipped over " + (1.0 - (double)this.selection.getAdded() / (double)this.this$0.count()) * (double)100 + "% of entries.");
                        cursor2.close();
                        subTx.abort();
                    }

                    public boolean hasNext() {
                        return Cursor.DefaultImpls.hasNext((org.vitrivr.cottontail.core.basics.Cursor)this);
                    }

                    @NotNull
                    public Record next() {
                        return (Record)Cursor.DefaultImpls.next((org.vitrivr.cottontail.core.basics.Cursor)this);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
            finally {
                lock2.unlock();
            }
            return (org.vitrivr.cottontail.core.basics.Cursor)cursor2;
        }

        public static final /* synthetic */ double[][] access$getMarks-Ay1-6BM(Tx $this) {
            return $this.getMarks-Ay1-6BM();
        }

        public static final /* synthetic */ Store access$getDataStore$p(Tx $this) {
            return $this.dataStore;
        }
    }
}

